package io.meiro.sdk.audience

import okhttp3.HttpUrl
import okhttp3.HttpUrl.Companion.toHttpUrl

internal object MeiroAudienceUrlCreator {

    /**
     * Builds the audience request URL in a format.
     *
     * https://cdp.{CLIENT_INSTANCE_NAME}.meiro.io/wbs?attribute=ps_meiro_user_id&value={USER_ID}(&attribute1=value1&attribute2=value2)
     */
    fun buildUrl(
        userId: String,
        instance: String,
        segment: Int?,
        parameters: Map<String, String>,
    ): HttpUrl {

        return "https://cdp.$instance.meiro.io/wbs".toHttpUrl().newBuilder()
            .apply {
                addQueryParameter("attribute", "ps_meiro_user_id")
                addQueryParameter("value", userId)
                if (segment != null) {
                    addQueryParameter("segment", segment.toString())
                }
                parameters.forEach { (key, value) ->
                    addQueryParameter(key, value)
                }
            }
            .build()
    }
}
