package io.meiro.sdk

import android.util.Log

/**
 * Logger interface for Meiro SDK. Implement this interface to provide custom logging and pass it
 * to [MeiroSdk.init] method.
 */
interface MeiroLogger {

    fun log(message: String, exception: Throwable? = null)
}

internal class MeiroAndroidLogger : MeiroLogger {

    override fun log(message: String, exception: Throwable?) {
        Log.d("MeiroSDK", message, exception)
    }
}
