package io.meiro.sdk.offline;

import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class MeiroEventsDatabase_Impl extends MeiroEventsDatabase {
  private volatile EventDao _eventDao;

  @Override
  @NonNull
  protected SupportSQLiteOpenHelper createOpenHelper(@NonNull final DatabaseConfiguration config) {
    final SupportSQLiteOpenHelper.Callback _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(1) {
      @Override
      public void createAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS `DbEvent` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `type` TEXT NOT NULL, `timestamp` INTEGER NOT NULL, `version` TEXT NOT NULL, `propertiesSerialized` TEXT NOT NULL, `appInfoId` TEXT, `appInfoName` TEXT NOT NULL, `appInfoVersion` TEXT NOT NULL, `appInfoLanguage` TEXT, `appInfoAdId` TEXT, `osInfoType` TEXT NOT NULL, `osInfoVersion` TEXT NOT NULL, `deviceInfoManufacturer` TEXT NOT NULL, `deviceInfoModel` TEXT NOT NULL, `firebaseInfoProjectId` TEXT, `firebaseInfoToken` TEXT, `userInfoUserId` TEXT NOT NULL, `userInfoSessionId` TEXT NOT NULL)");
        db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
        db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '3a319ba771533b717b48797e1b0279bc')");
      }

      @Override
      public void dropAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS `DbEvent`");
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onDestructiveMigration(db);
          }
        }
      }

      @Override
      public void onCreate(@NonNull final SupportSQLiteDatabase db) {
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onCreate(db);
          }
        }
      }

      @Override
      public void onOpen(@NonNull final SupportSQLiteDatabase db) {
        mDatabase = db;
        internalInitInvalidationTracker(db);
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onOpen(db);
          }
        }
      }

      @Override
      public void onPreMigrate(@NonNull final SupportSQLiteDatabase db) {
        DBUtil.dropFtsSyncTriggers(db);
      }

      @Override
      public void onPostMigrate(@NonNull final SupportSQLiteDatabase db) {
      }

      @Override
      @NonNull
      public RoomOpenHelper.ValidationResult onValidateSchema(
          @NonNull final SupportSQLiteDatabase db) {
        final HashMap<String, TableInfo.Column> _columnsDbEvent = new HashMap<String, TableInfo.Column>(18);
        _columnsDbEvent.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("type", new TableInfo.Column("type", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("version", new TableInfo.Column("version", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("propertiesSerialized", new TableInfo.Column("propertiesSerialized", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("appInfoId", new TableInfo.Column("appInfoId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("appInfoName", new TableInfo.Column("appInfoName", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("appInfoVersion", new TableInfo.Column("appInfoVersion", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("appInfoLanguage", new TableInfo.Column("appInfoLanguage", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("appInfoAdId", new TableInfo.Column("appInfoAdId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("osInfoType", new TableInfo.Column("osInfoType", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("osInfoVersion", new TableInfo.Column("osInfoVersion", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("deviceInfoManufacturer", new TableInfo.Column("deviceInfoManufacturer", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("deviceInfoModel", new TableInfo.Column("deviceInfoModel", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("firebaseInfoProjectId", new TableInfo.Column("firebaseInfoProjectId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("firebaseInfoToken", new TableInfo.Column("firebaseInfoToken", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("userInfoUserId", new TableInfo.Column("userInfoUserId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDbEvent.put("userInfoSessionId", new TableInfo.Column("userInfoSessionId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysDbEvent = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesDbEvent = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoDbEvent = new TableInfo("DbEvent", _columnsDbEvent, _foreignKeysDbEvent, _indicesDbEvent);
        final TableInfo _existingDbEvent = TableInfo.read(db, "DbEvent");
        if (!_infoDbEvent.equals(_existingDbEvent)) {
          return new RoomOpenHelper.ValidationResult(false, "DbEvent(io.meiro.sdk.offline.DbEvent).\n"
                  + " Expected:\n" + _infoDbEvent + "\n"
                  + " Found:\n" + _existingDbEvent);
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }
    }, "3a319ba771533b717b48797e1b0279bc", "4948c64b40b39595a03ab8a7db3d4fd6");
    final SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder(config.context).name(config.name).callback(_openCallback).build();
    final SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
    return _helper;
  }

  @Override
  @NonNull
  protected InvalidationTracker createInvalidationTracker() {
    final HashMap<String, String> _shadowTablesMap = new HashMap<String, String>(0);
    final HashMap<String, Set<String>> _viewTables = new HashMap<String, Set<String>>(0);
    return new InvalidationTracker(this, _shadowTablesMap, _viewTables, "DbEvent");
  }

  @Override
  public void clearAllTables() {
    super.assertNotMainThread();
    final SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
    try {
      super.beginTransaction();
      _db.execSQL("DELETE FROM `DbEvent`");
      super.setTransactionSuccessful();
    } finally {
      super.endTransaction();
      _db.query("PRAGMA wal_checkpoint(FULL)").close();
      if (!_db.inTransaction()) {
        _db.execSQL("VACUUM");
      }
    }
  }

  @Override
  @NonNull
  protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
    final HashMap<Class<?>, List<Class<?>>> _typeConvertersMap = new HashMap<Class<?>, List<Class<?>>>();
    _typeConvertersMap.put(EventDao.class, EventDao_Impl.getRequiredConverters());
    return _typeConvertersMap;
  }

  @Override
  @NonNull
  public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
    final HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
    return _autoMigrationSpecsSet;
  }

  @Override
  @NonNull
  public List<Migration> getAutoMigrations(
      @NonNull final Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
    final List<Migration> _autoMigrations = new ArrayList<Migration>();
    return _autoMigrations;
  }

  @Override
  public EventDao eventDao() {
    if (_eventDao != null) {
      return _eventDao;
    } else {
      synchronized(this) {
        if(_eventDao == null) {
          _eventDao = new EventDao_Impl(this);
        }
        return _eventDao;
      }
    }
  }
}
