package io.meiro.sdk.fcm

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.os.Bundle
import io.meiro.sdk.MeiroSdk
import io.meiro.sdk.event.EventType

/**
 * This Activity is opened every time a user clicks on a notification. It is used to track the
 * event to the SDK. It is closed immediately.
 */
@Suppress("DEPRECATION")
internal open class MeiroPushNotificationsTrackingActivity : Activity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        intent.getParcelableExtra<NotificationData>(EXTRA_NOTIFICATION_DATA)?.let { notificationData ->
            processPushClick(this, notificationData)
        }
        finish()
    }

    open fun processPushClick(
        context: Context,
        data: NotificationData,
    ) {
        MeiroSdk.impl?.trackEventInternal(EventType.FCM_MESSAGE_CLICK, data.toEventProperties())
        MeiroSdk.impl?.log("Push notification clicked")
    }

    companion object {

        private const val EXTRA_NOTIFICATION_DATA = "notification_data"

        fun getClickIntent(
            context: Context,
            data: NotificationData,
        ): Intent {
            return Intent(context, MeiroPushNotificationsTrackingActivity::class.java)
                .putExtra(EXTRA_NOTIFICATION_DATA, data)
                .addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP or Intent.FLAG_ACTIVITY_CLEAR_TOP)
        }
    }
}
