package io.meiro.sdk.event

import java.time.Instant

internal data class Event(
    val type: EventType,
    val version: String = EventVersion.CURRENT,
    val properties: Map<String, Any>,
    val timestamp: Instant,
    val appInfo: EventAppInfo,
    val osInfo: EventOsInfo,
    val deviceInfo: EventDeviceInfo?,
    val firebaseInfo: EventFirebaseInfo,
    val userInfo: EventUserInfo,
)

internal object EventVersion {

    const val CURRENT = "1.0.0"
}

internal data class EventAppInfo(
    val id: String?,
    val name: String,
    val version: String,
    val language: String?,
    val adId: String?,
)

internal data class EventOsInfo(
    val type: String = "android",
    val version: String,
)

internal data class EventDeviceInfo(
    val manufacturer: String,
    val model: String,
)

internal data class EventFirebaseInfo(
    val projectId: String?,
    val token: String?,
)

internal data class EventUserInfo(
    val userId: String,
    val sessionId: String
)

internal enum class EventType(val id: String) {

    SCREEN_VIEW("screen_view"),
    APP_FOREGROUND("app_foreground"),
    APP_INSTALLED("app_installed"),
    APP_BACKGROUND("app_background"),
    LINK_CLICK("link_click"),
    CUSTOM("event_custom"),
    FCM_TOKEN_REGISTERED("fcm_registration_token_registered"),
    FCM_MESSAGE_RECEIVED("fcm_message_received"),
    FCM_MESSAGE_CLICK("fcm_message_click"),
}
