/*
 * Decompiled with CFR 0.152.
 */
package io.mcarle.konvert.processor.codegen;

import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.google.devtools.ksp.symbol.KSValueParameter;
import com.google.devtools.ksp.symbol.Origin;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.CodeBlocks;
import io.mcarle.konvert.converter.api.ExtensionsKt;
import io.mcarle.konvert.converter.api.TypeConverter;
import io.mcarle.konvert.converter.api.TypeConverterRegistry;
import io.mcarle.konvert.converter.api.config.Configuration;
import io.mcarle.konvert.processor.codegen.PropertyMappingInfo;
import io.mcarle.konvert.processor.exceptions.NotNullOperatorNotEnabledException;
import io.mcarle.konvert.processor.exceptions.PropertyMappingNotExistingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\"\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002JN\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\nJ$\u0010\u001f\u001a\u00020\u00122\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\nH\u0002J6\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\nH\u0002J,\u0010!\u001a\u00020\u00042\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\"\u001a\u00020\u0006H\u0002\u00a8\u0006#"}, d2={"Lio/mcarle/konvert/processor/codegen/MappingCodeGenerator;", "", "()V", "constructorCode", "Lcom/squareup/kotlinpoet/CodeBlock;", "className", "", "constructor", "Lcom/google/devtools/ksp/symbol/KSFunctionDeclaration;", "sourceProperties", "", "Lio/mcarle/konvert/processor/codegen/PropertyMappingInfo;", "constructorParamsCode", "convertValue", "source", "targetTypeRef", "Lcom/google/devtools/ksp/symbol/KSTypeReference;", "ignorable", "", "determinePropertyMappingInfo", "propertyMappings", "ksPropertyDeclaration", "Lcom/google/devtools/ksp/symbol/KSPropertyDeclaration;", "ksValueParameter", "Lcom/google/devtools/ksp/symbol/KSValueParameter;", "generateMappingCode", "Lcom/google/devtools/ksp/symbol/KSType;", "target", "functionParamName", "targetClassImportName", "targetProperties", "noTargetOrAllIgnored", "propertyCode", "propertySettingCode", "targetVarName", "processor"})
@SourceDebugExtension(value={"SMAP\nMappingCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappingCodeGenerator.kt\nio/mcarle/konvert/processor/codegen/MappingCodeGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1603#2,9:213\n1855#2:222\n1856#2:224\n1612#2:225\n1726#2,2:227\n1747#2,3:229\n1728#2:232\n1603#2,9:233\n1855#2:242\n1856#2:244\n1612#2:245\n288#2,2:246\n288#2,2:248\n1#3:223\n1#3:226\n1#3:243\n1#3:250\n*S KotlinDebug\n*F\n+ 1 MappingCodeGenerator.kt\nio/mcarle/konvert/processor/codegen/MappingCodeGenerator\n*L\n78#1:213,9\n78#1:222\n78#1:224\n78#1:225\n133#1:227,2\n134#1:229,3\n133#1:232\n146#1:233,9\n146#1:242\n146#1:244\n146#1:245\n165#1:246,2\n174#1:248,2\n78#1:223\n146#1:243\n*E\n"})
public final class MappingCodeGenerator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final CodeBlock generateMappingCode(@NotNull KSType source, @NotNull KSType target, @NotNull List<PropertyMappingInfo> sourceProperties, @NotNull KSFunctionDeclaration constructor, @Nullable String functionParamName, @Nullable String targetClassImportName, @NotNull List<? extends KSPropertyDeclaration> targetProperties) {
        CodeBlock codeBlock;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(sourceProperties, (String)"sourceProperties");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter(targetProperties, (String)"targetProperties");
        String string = targetClassImportName;
        if (string == null) {
            KSDeclaration kSDeclaration = constructor.getParentDeclaration();
            Object object = kSDeclaration != null ? kSDeclaration.getQualifiedName() : null;
            Intrinsics.checkNotNull((Object)object);
            string = object.asString();
        }
        String typeName = string;
        KSDeclaration kSDeclaration = constructor.getParentDeclaration();
        Intrinsics.checkNotNull((Object)kSDeclaration);
        String className = kSDeclaration.getSimpleName().asString();
        CodeBlock constructorCode = this.constructorCode(typeName, constructor, sourceProperties);
        CodeBlock propertyCode = this.propertyCode(className, functionParamName, sourceProperties, targetProperties);
        if (ExtensionsKt.isNullable((KSType)source)) {
            boolean bl;
            boolean bl2 = bl = functionParamName != null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            String code = "return\u00b7" + functionParamName + "?.let\u00b7{\n\u21e5%L%L\u21e4\n}";
            if (ExtensionsKt.isNullable((KSType)target)) {
                Object[] objectArray = new Object[]{constructorCode, propertyCode};
                codeBlock = CodeBlock.Companion.of(code, objectArray);
                return codeBlock;
            } else {
                if (!io.mcarle.konvert.converter.api.config.ExtensionsKt.getEnforceNotNull((Configuration.Companion)Configuration.Companion)) throw new NotNullOperatorNotEnabledException(source, target);
                Object[] objectArray = new Object[]{constructorCode, propertyCode};
                codeBlock = CodeBlock.Companion.of(code + "!!", objectArray);
            }
            return codeBlock;
        } else {
            Object[] objectArray = new Object[]{constructorCode, propertyCode};
            codeBlock = CodeBlock.Companion.of("return\u00b7%L%L", objectArray);
        }
        return codeBlock;
    }

    private final CodeBlock constructorCode(String className, KSFunctionDeclaration constructor, List<PropertyMappingInfo> sourceProperties) {
        CodeBlock codeBlock;
        if (constructor.getParameters().isEmpty()) {
            codeBlock = CodeBlock.Companion.of(className + "()", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{this.constructorParamsCode(constructor, sourceProperties)};
            codeBlock = CodeBlock.Companion.of(StringsKt.trimIndent((String)("\n" + className + "(\u21e5\n%L\n\u21e4)\n            ")), objectArray);
        }
        return codeBlock;
    }

    /*
     * WARNING - void declaration
     */
    private final CodeBlock constructorParamsCode(KSFunctionDeclaration constructor, List<PropertyMappingInfo> sourceProperties) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = constructor.getParameters();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CodeBlock codeBlock;
            CodeBlock convertedValue;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KSValueParameter ksValueParameter = (KSValueParameter)element$iv$iv;
            boolean bl2 = false;
            Object[] objectArray = new Origin[]{Origin.JAVA, Origin.JAVA_LIB};
            boolean sourceHasParamNames = !CollectionsKt.listOf((Object[])objectArray).contains(constructor.getOrigin());
            boolean valueParamHasDefault = ksValueParameter.getHasDefault() && sourceHasParamNames;
            boolean valueParamIsNullable = ExtensionsKt.isNullable((KSType)ksValueParameter.getType().resolve());
            PropertyMappingInfo sourcePropertyMappingInfo = this.determinePropertyMappingInfo(sourceProperties, ksValueParameter);
            Object object = this.convertValue(sourcePropertyMappingInfo, ksValueParameter.getType(), valueParamHasDefault || valueParamIsNullable);
            if (object == null) {
                object = valueParamHasDefault ? null : (valueParamIsNullable ? CodeBlock.Companion.of("null", new Object[0]) : null);
            }
            if ((convertedValue = object) != null) {
                if (sourceHasParamNames) {
                    Object[] objectArray2 = new Object[]{convertedValue};
                    codeBlock = CodeBlock.Companion.of(sourcePropertyMappingInfo.getTargetName() + "\u00b7=\u00b7%L", objectArray2);
                } else {
                    codeBlock = convertedValue;
                }
            } else {
                codeBlock = null;
            }
            if (codeBlock == null) continue;
            CodeBlock it$iv$iv = codeBlock;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CodeBlocks.joinToCode$default((Collection)((List)destination$iv$iv), (CharSequence)",\n", null, null, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    private final CodeBlock propertyCode(String className, String functionParamName, List<PropertyMappingInfo> sourceProperties, List<? extends KSPropertyDeclaration> targetProperties) {
        Object varName;
        if (this.noTargetOrAllIgnored(sourceProperties, targetProperties)) {
            return CodeBlock.Companion.of("", new Object[0]);
        }
        Object[] objectArray = className;
        if (((CharSequence)objectArray).length() > 0) {
            void it;
            char c = objectArray.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.lowercase((char)it, (Locale)locale));
            Object[] objectArray2 = objectArray;
            int n = 1;
            String string = objectArray2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            v3 = stringBuilder2.append(string).toString();
        } else {
            v3 = varName = objectArray;
        }
        if (Intrinsics.areEqual((Object)varName, (Object)functionParamName)) {
            varName = (String)varName + "0";
        }
        objectArray = new Object[]{this.propertySettingCode(targetProperties, sourceProperties, (String)varName)};
        return CodeBlock.Companion.of(StringsKt.trimIndent((String)("\n.also\u00b7{\u00b7" + (String)varName + "\u00b7->\u21e5\n%L\n\u21e4}\n        ")), objectArray);
    }

    private final boolean noTargetOrAllIgnored(List<PropertyMappingInfo> sourceProperties, List<? extends KSPropertyDeclaration> targetProperties) {
        boolean bl;
        block7: {
            Iterable $this$all$iv = targetProperties;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    block6: {
                        KSPropertyDeclaration targetProperty = (KSPropertyDeclaration)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv = sourceProperties;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                PropertyMappingInfo sourceProperty = (PropertyMappingInfo)element$iv2;
                                boolean bl4 = false;
                                boolean bl5 = sourceProperty.getIgnore() && Intrinsics.areEqual((Object)sourceProperty.getTargetName(), (Object)targetProperty.getSimpleName().asString());
                                if (!bl5) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final CodeBlock propertySettingCode(List<? extends KSPropertyDeclaration> targetProperties, List<PropertyMappingInfo> sourceProperties, String targetVarName) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = targetProperties;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CodeBlock it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KSPropertyDeclaration targetProperty = (KSPropertyDeclaration)element$iv$iv;
            boolean bl2 = false;
            PropertyMappingInfo sourceProperty = this.determinePropertyMappingInfo(sourceProperties, targetProperty);
            CodeBlock convertedValue = this.convertValue(sourceProperty, targetProperty.getType(), true);
            if ((convertedValue != null ? CodeBlock.Companion.of(targetVarName + "." + sourceProperty.getTargetName() + "\u00b7=\u00b7" + convertedValue, new Object[0]) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CodeBlocks.joinToCode$default((Collection)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)6, null);
    }

    private final PropertyMappingInfo determinePropertyMappingInfo(List<PropertyMappingInfo> propertyMappings, KSValueParameter ksValueParameter) {
        Object v1;
        block2: {
            Iterable $this$firstOrNull$iv = propertyMappings;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PropertyMappingInfo it = (PropertyMappingInfo)element$iv;
                boolean bl = false;
                KSName kSName = ksValueParameter.getName();
                if (!Intrinsics.areEqual((Object)it.getTargetName(), (Object)(kSName != null ? kSName.asString() : null))) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        PropertyMappingInfo propertyMappingInfo = v1;
        if (propertyMappingInfo == null) {
            throw new PropertyMappingNotExistingException(ksValueParameter, propertyMappings);
        }
        return propertyMappingInfo;
    }

    private final PropertyMappingInfo determinePropertyMappingInfo(List<PropertyMappingInfo> propertyMappings, KSPropertyDeclaration ksPropertyDeclaration) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = propertyMappings;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PropertyMappingInfo it = (PropertyMappingInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTargetName(), (Object)ksPropertyDeclaration.getSimpleName().asString())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        PropertyMappingInfo propertyMappingInfo = v0;
        if (propertyMappingInfo == null) {
            throw new PropertyMappingNotExistingException(ksPropertyDeclaration, propertyMappings);
        }
        return propertyMappingInfo;
    }

    private final CodeBlock convertValue(PropertyMappingInfo source, KSTypeReference targetTypeRef, boolean ignorable) {
        Object object;
        KSType sourceType;
        KSType targetType;
        block8: {
            block7: {
                targetType = targetTypeRef.resolve();
                if (source.getDeclaration() == null) {
                    if (source.getIgnore() && ignorable) {
                        return null;
                    }
                    if (source.getConstant() != null) {
                        return CodeBlock.Companion.of(source.getConstant(), new Object[0]);
                    }
                    if (source.getExpression() != null) {
                        return CodeBlock.Companion.of(source.getMappingParamName() != null ? source.getMappingParamName() + ".let\u00b7{ " + source.getExpression() + " }" : "let\u00b7{ " + source.getExpression() + " }", new Object[0]);
                    }
                    throw new IllegalStateException("Could not convert value " + source);
                }
                sourceType = source.getDeclaration().getType().resolve();
                object = source.getMappingParamName();
                if (object == null) break block7;
                String it = object;
                boolean bl = false;
                String string = it + ".";
                object = string;
                if (string != null) break block8;
            }
            object = "";
        }
        String paramName = object;
        return (CodeBlock)TypeConverterRegistry.INSTANCE.withAdditionallyEnabledConverters(source.getEnableConverters(), (Function1)new Function1<TypeConverterRegistry, CodeBlock>(paramName, source, sourceType, targetType){
            final /* synthetic */ String $paramName;
            final /* synthetic */ PropertyMappingInfo $source;
            final /* synthetic */ KSType $sourceType;
            final /* synthetic */ KSType $targetType;
            {
                this.$paramName = $paramName;
                this.$source = $source;
                this.$sourceType = $sourceType;
                this.$targetType = $targetType;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CodeBlock invoke(@NotNull TypeConverterRegistry $this$withAdditionallyEnabledConverters) {
                Iterable iterable;
                block5: {
                    block4: {
                        Object v0;
                        block3: {
                            void $this$firstOrNull$iv;
                            Intrinsics.checkNotNullParameter((Object)$this$withAdditionallyEnabledConverters, (String)"$this$withAdditionallyEnabledConverters");
                            iterable = (Iterable)$this$withAdditionallyEnabledConverters;
                            KSType kSType = this.$sourceType;
                            KSType kSType2 = this.$targetType;
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                TypeConverter it = (TypeConverter)element$iv;
                                boolean bl = false;
                                if (!it.matches(kSType, kSType2)) continue;
                                v0 = element$iv;
                                break block3;
                            }
                            v0 = null;
                        }
                        TypeConverter typeConverter = v0;
                        if (typeConverter == null) break block4;
                        String string = this.$source.getSourceName();
                        Intrinsics.checkNotNull((Object)string);
                        iterable = typeConverter.convert(this.$paramName + string, this.$sourceType, this.$targetType);
                        if (iterable != null) break block5;
                    }
                    throw new NoSuchElementException("Could not find converter for " + this.$paramName + this.$source.getSourceName() + " -> " + this.$source.getTargetName() + ": " + this.$sourceType + " -> " + this.$targetType);
                }
                return iterable;
            }
        });
    }
}

