/*
 * Copyright (c) 2021 Matthew Nelson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/
package io.matthewnelson.kmp.tor.manager.internal.ext

import io.matthewnelson.kmp.tor.common.annotation.InternalTorApi
import kotlin.test.Test
import kotlin.test.assertEquals

@OptIn(InternalTorApi::class)
class StringExtUnitTest {

    @Test
    fun givenInfoGetBootstrap_whenParsed_returnsPercentage() {
        val expected = 100
        val string = "NOTICE BOOTSTRAP PROGRESS=$expected TAG=done SUMMARY=\"Done\""
        val actual = string.infoGetBootstrapProgress()
        assertEquals(expected, actual)
    }

    @Test
    fun givenEventNoticeBootstrap_whenParsed_returnsPercentage() {
        val expected = 10
        val string = "Bootstrapped $expected% (conn_done): Connected to a relay"
        val actual = string.eventNoticeBootstrapProgress()
        assertEquals(expected, actual)
    }
}
