(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kmp-tor-kmp-tor-controller-common-js-legacy', 'kmp-tor-kmp-tor-common-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kmp-tor-kmp-tor-controller-common-js-legacy'), require('kmp-tor-kmp-tor-common-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kmp-tor-kmp-tor-manager-common-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kmp-tor-kmp-tor-manager-common-js-legacy'.");
    }if (typeof this['kmp-tor-kmp-tor-controller-common-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'kmp-tor-kmp-tor-manager-common-js-legacy'. Its dependency 'kmp-tor-kmp-tor-controller-common-js-legacy' was not found. Please, check whether 'kmp-tor-kmp-tor-controller-common-js-legacy' is loaded prior to 'kmp-tor-kmp-tor-manager-common-js-legacy'.");
    }if (typeof this['kmp-tor-kmp-tor-common-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'kmp-tor-kmp-tor-manager-common-js-legacy'. Its dependency 'kmp-tor-kmp-tor-common-js-legacy' was not found. Please, check whether 'kmp-tor-kmp-tor-common-js-legacy' is loaded prior to 'kmp-tor-kmp-tor-manager-common-js-legacy'.");
    }root['kmp-tor-kmp-tor-manager-common-js-legacy'] = factory(typeof this['kmp-tor-kmp-tor-manager-common-js-legacy'] === 'undefined' ? {} : this['kmp-tor-kmp-tor-manager-common-js-legacy'], kotlin, this['kmp-tor-kmp-tor-controller-common-js-legacy'], this['kmp-tor-kmp-tor-common-js-legacy']);
  }
}(this, function (_, Kotlin, $module$kmp_tor_kmp_tor_controller_common_js_legacy, $module$kmp_tor_kmp_tor_common_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var TorControlCircuit = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.control.TorControlCircuit;
  var TorControlConfig = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.control.TorControlConfig;
  var TorControlDescriptorPost = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.control.usecase.TorControlDescriptorPost;
  var TorControlDropGuards = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.control.usecase.TorControlDropGuards;
  var TorControlHs = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.control.TorControlHs;
  var TorControlInfoGet = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.control.usecase.TorControlInfoGet;
  var TorControlInfoProtocol = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.control.usecase.TorControlInfoProtocol;
  var TorControlMapAddress = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.control.usecase.TorControlMapAddress;
  var TorControlOnion = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.control.TorControlOnion;
  var TorControlOnionClientAuth = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.control.TorControlOnionClientAuth;
  var TorControlResolve = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.control.usecase.TorControlResolve;
  var TorControlSetEvents = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.control.usecase.TorControlSetEvents;
  var TorControlSignal = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.control.usecase.TorControlSignal;
  var TorControlStream = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.control.TorControlStream;
  var TorControlUseFeature = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.control.usecase.TorControlUseFeature;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var equals = Kotlin.equals;
  var hashCode = Kotlin.hashCode;
  var split = Kotlin.kotlin.text.split_o64adg$;
  var toInt = Kotlin.kotlin.text.toInt_pdl1vz$;
  var Port = $module$kmp_tor_kmp_tor_common_js_legacy.io.matthewnelson.kmp.tor.common.address.Port;
  var Result = Kotlin.kotlin.Result;
  var LinkedHashSet_init = Kotlin.kotlin.collections.LinkedHashSet_init_ww73n8$;
  var Exception = Kotlin.kotlin.Exception;
  var toSet = Kotlin.kotlin.collections.toSet_7wnvza$;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var TorEvent$SealedListener = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.events.TorEvent.SealedListener;
  var TorEvent$Listener = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.events.TorEvent.Listener;
  var throwCCE = Kotlin.throwCCE;
  var trim = Kotlin.kotlin.text.trim_gw00vp$;
  var createFailure = Kotlin.kotlin.createFailure_tcv7n7$;
  var TorControllerException = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.exceptions.TorControllerException;
  var TorControllerException_init = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.exceptions.TorControllerException_init;
  var TorControllerException_init_0 = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.exceptions.TorControllerException_init_pdl1vj$;
  var TorControllerException_init_1 = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.exceptions.TorControllerException_init_wspj0f$;
  var TorControllerException_init_2 = $module$kmp_tor_kmp_tor_controller_common_js_legacy.io.matthewnelson.kmp.tor.controller.common.exceptions.TorControllerException_init_dbl4no$;
  TorManagerEvent$Action$Controller.prototype = Object.create(TorManagerEvent$Action.prototype);
  TorManagerEvent$Action$Controller.prototype.constructor = TorManagerEvent$Action$Controller;
  TorManagerEvent$Action$Restart.prototype = Object.create(TorManagerEvent$Action.prototype);
  TorManagerEvent$Action$Restart.prototype.constructor = TorManagerEvent$Action$Restart;
  TorManagerEvent$Action$Start.prototype = Object.create(TorManagerEvent$Action.prototype);
  TorManagerEvent$Action$Start.prototype.constructor = TorManagerEvent$Action$Start;
  TorManagerEvent$Action$Stop.prototype = Object.create(TorManagerEvent$Action.prototype);
  TorManagerEvent$Action$Stop.prototype.constructor = TorManagerEvent$Action$Stop;
  TorManagerEvent$Listener.prototype = Object.create(TorEvent$Listener.prototype);
  TorManagerEvent$Listener.prototype.constructor = TorManagerEvent$Listener;
  TorManagerException.prototype = Object.create(TorControllerException.prototype);
  TorManagerException.prototype.constructor = TorManagerException;
  InterruptedException.prototype = Object.create(TorManagerException.prototype);
  InterruptedException.prototype.constructor = InterruptedException;
  TorNotStartedException.prototype = Object.create(TorManagerException.prototype);
  TorNotStartedException.prototype.constructor = TorNotStartedException;
  TorNetworkState$Disabled.prototype = Object.create(TorNetworkState.prototype);
  TorNetworkState$Disabled.prototype.constructor = TorNetworkState$Disabled;
  TorNetworkState$Enabled.prototype = Object.create(TorNetworkState.prototype);
  TorNetworkState$Enabled.prototype.constructor = TorNetworkState$Enabled;
  function TorControlManager() {
  }
  TorControlManager.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TorControlManager',
    interfaces: [TorControlUseFeature, TorControlStream, TorControlSignal, TorControlSetEvents, TorControlResolve, TorControlOnionClientAuth, TorControlOnion, TorControlMapAddress, TorControlInfoProtocol, TorControlInfoGet, TorControlHs, TorControlDropGuards, TorControlDescriptorPost, TorControlConfig, TorControlCircuit]
  };
  function TorOperationManager() {
  }
  TorOperationManager.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TorOperationManager',
    interfaces: []
  };
  function TorManagerEvent() {
  }
  function TorManagerEvent$Action() {
    TorManagerEvent$Action$Companion_getInstance();
  }
  function TorManagerEvent$Action$Controller() {
    TorManagerEvent$Action$Controller_instance = this;
    TorManagerEvent$Action.call(this);
  }
  TorManagerEvent$Action$Controller.prototype.toString = function () {
    return TorManagerEvent$Action$Companion_getInstance().CONTROLLER_0;
  };
  TorManagerEvent$Action$Controller.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Controller',
    interfaces: [TorManagerEvent$Action]
  };
  var TorManagerEvent$Action$Controller_instance = null;
  function TorManagerEvent$Action$Controller_getInstance() {
    if (TorManagerEvent$Action$Controller_instance === null) {
      new TorManagerEvent$Action$Controller();
    }return TorManagerEvent$Action$Controller_instance;
  }
  function TorManagerEvent$Action$Restart() {
    TorManagerEvent$Action$Restart_instance = this;
    TorManagerEvent$Action.call(this);
  }
  TorManagerEvent$Action$Restart.prototype.toString = function () {
    return TorManagerEvent$Action$Companion_getInstance().RESTART_0;
  };
  TorManagerEvent$Action$Restart.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Restart',
    interfaces: [TorManagerEvent$Action]
  };
  var TorManagerEvent$Action$Restart_instance = null;
  function TorManagerEvent$Action$Restart_getInstance() {
    if (TorManagerEvent$Action$Restart_instance === null) {
      new TorManagerEvent$Action$Restart();
    }return TorManagerEvent$Action$Restart_instance;
  }
  function TorManagerEvent$Action$Start() {
    TorManagerEvent$Action$Start_instance = this;
    TorManagerEvent$Action.call(this);
  }
  TorManagerEvent$Action$Start.prototype.toString = function () {
    return TorManagerEvent$Action$Companion_getInstance().START_0;
  };
  TorManagerEvent$Action$Start.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Start',
    interfaces: [TorManagerEvent$Action]
  };
  var TorManagerEvent$Action$Start_instance = null;
  function TorManagerEvent$Action$Start_getInstance() {
    if (TorManagerEvent$Action$Start_instance === null) {
      new TorManagerEvent$Action$Start();
    }return TorManagerEvent$Action$Start_instance;
  }
  function TorManagerEvent$Action$Stop() {
    TorManagerEvent$Action$Stop_instance = this;
    TorManagerEvent$Action.call(this);
  }
  TorManagerEvent$Action$Stop.prototype.toString = function () {
    return TorManagerEvent$Action$Companion_getInstance().STOP_0;
  };
  TorManagerEvent$Action$Stop.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Stop',
    interfaces: [TorManagerEvent$Action]
  };
  var TorManagerEvent$Action$Stop_instance = null;
  function TorManagerEvent$Action$Stop_getInstance() {
    if (TorManagerEvent$Action$Stop_instance === null) {
      new TorManagerEvent$Action$Stop();
    }return TorManagerEvent$Action$Stop_instance;
  }
  function TorManagerEvent$Action$Companion() {
    TorManagerEvent$Action$Companion_instance = this;
    this.CONTROLLER_0 = 'Action.Controller';
    this.RESTART_0 = 'Action.Restart';
    this.START_0 = 'Action.Start';
    this.STOP_0 = 'Action.Stop';
  }
  TorManagerEvent$Action$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TorManagerEvent$Action$Companion_instance = null;
  function TorManagerEvent$Action$Companion_getInstance() {
    if (TorManagerEvent$Action$Companion_instance === null) {
      new TorManagerEvent$Action$Companion();
    }return TorManagerEvent$Action$Companion_instance;
  }
  TorManagerEvent$Action.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Action',
    interfaces: [TorManagerEvent]
  };
  function TorManagerEvent$Log() {
  }
  function TorManagerEvent$Log$Debug(value) {
    this.value = value;
  }
  TorManagerEvent$Log$Debug.prototype.toString = function () {
    return 'D/' + this.value;
  };
  TorManagerEvent$Log$Debug.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Debug',
    interfaces: [TorManagerEvent$Log]
  };
  TorManagerEvent$Log$Debug.prototype.unbox = function () {
    return this.value;
  };
  TorManagerEvent$Log$Debug.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  TorManagerEvent$Log$Debug.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  function TorManagerEvent$Log$Error(value) {
    this.value = value;
  }
  TorManagerEvent$Log$Error.prototype.toString = function () {
    return 'E/' + this.value;
  };
  TorManagerEvent$Log$Error.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Error',
    interfaces: [TorManagerEvent$Log]
  };
  TorManagerEvent$Log$Error.prototype.unbox = function () {
    return this.value;
  };
  TorManagerEvent$Log$Error.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  TorManagerEvent$Log$Error.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  function TorManagerEvent$Log$Info(value) {
    this.value = value;
  }
  TorManagerEvent$Log$Info.prototype.toString = function () {
    return 'I/' + this.value;
  };
  TorManagerEvent$Log$Info.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Info',
    interfaces: [TorManagerEvent$Log]
  };
  TorManagerEvent$Log$Info.prototype.unbox = function () {
    return this.value;
  };
  TorManagerEvent$Log$Info.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  TorManagerEvent$Log$Info.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  function TorManagerEvent$Log$Warn(value) {
    TorManagerEvent$Log$Warn$Companion_getInstance();
    this.value = value;
  }
  TorManagerEvent$Log$Warn.prototype.toString = function () {
    return 'W/' + this.value;
  };
  function TorManagerEvent$Log$Warn$Companion() {
    TorManagerEvent$Log$Warn$Companion_instance = this;
    this.WAITING_ON_NETWORK = 'No Network Connectivity. Waiting...';
  }
  TorManagerEvent$Log$Warn$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TorManagerEvent$Log$Warn$Companion_instance = null;
  function TorManagerEvent$Log$Warn$Companion_getInstance() {
    if (TorManagerEvent$Log$Warn$Companion_instance === null) {
      new TorManagerEvent$Log$Warn$Companion();
    }return TorManagerEvent$Log$Warn$Companion_instance;
  }
  TorManagerEvent$Log$Warn.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Warn',
    interfaces: [TorManagerEvent$Log]
  };
  TorManagerEvent$Log$Warn.prototype.unbox = function () {
    return this.value;
  };
  TorManagerEvent$Log$Warn.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  TorManagerEvent$Log$Warn.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  TorManagerEvent$Log.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Log',
    interfaces: [TorManagerEvent]
  };
  function TorManagerEvent$Lifecycle(clazz, hash, event) {
    TorManagerEvent$Lifecycle$Companion_getInstance();
    this.clazz = clazz;
    this.hash = hash;
    this.event = event;
  }
  TorManagerEvent$Lifecycle.prototype.equals = function (other) {
    var tmp$;
    return other != null && Kotlin.isType(other, TorManagerEvent$Lifecycle) && ((tmp$ = other.clazz) != null ? tmp$.equals(this.clazz) : null) && other.hash === this.hash && equals(other.event, this.event);
  };
  TorManagerEvent$Lifecycle.prototype.hashCode = function () {
    var result = 17;
    result = (result * 31 | 0) + this.clazz.hashCode() | 0;
    result = (result * 31 | 0) + this.hash | 0;
    result = (result * 31 | 0) + hashCode(this.event) | 0;
    return result;
  };
  TorManagerEvent$Lifecycle.prototype.toString = function () {
    var tmp$;
    return 'Lifecycle(class=' + ((tmp$ = this.clazz.simpleName) != null ? tmp$ : 'Unknown') + '@' + this.hash + ', event=' + this.event + ')';
  };
  function TorManagerEvent$Lifecycle$Companion() {
    TorManagerEvent$Lifecycle$Companion_instance = this;
    this.ON_CREATE = 'onCreate';
    this.ON_DESTROY = 'onDestroy';
    this.ON_BIND = 'onBind';
    this.ON_START_COMMAND = 'onStartCommand';
    this.ON_TASK_REMOVED = 'onTaskRemoved';
    this.ON_TASK_RETURNED = 'onTaskReturned';
    this.ON_REGISTER = 'onRegister';
    this.ON_UNREGISTER = 'onUnregister';
  }
  TorManagerEvent$Lifecycle$Companion.prototype.invoke_hwpqgh$ = function (any, event) {
    return new TorManagerEvent$Lifecycle(Kotlin.getKClassFromExpression(any), hashCode(any), event);
  };
  TorManagerEvent$Lifecycle$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TorManagerEvent$Lifecycle$Companion_instance = null;
  function TorManagerEvent$Lifecycle$Companion_getInstance() {
    if (TorManagerEvent$Lifecycle$Companion_instance === null) {
      new TorManagerEvent$Lifecycle$Companion();
    }return TorManagerEvent$Lifecycle$Companion_instance;
  }
  TorManagerEvent$Lifecycle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Lifecycle',
    interfaces: [TorManagerEvent]
  };
  function TorManagerEvent$AddressInfo(dns, http, socks, trans) {
    if (dns === void 0)
      dns = null;
    if (http === void 0)
      http = null;
    if (socks === void 0)
      socks = null;
    if (trans === void 0)
      trans = null;
    this.dns = dns;
    this.http = http;
    this.socks = socks;
    this.trans = trans;
    this.isNull = (this.dns == null && this.http == null && this.socks == null && this.trans == null);
  }
  function TorManagerEvent$AddressInfo$Address(address, port) {
    TorManagerEvent$AddressInfo$Address$Companion_getInstance();
    this.address = address;
    this.port = port;
  }
  function TorManagerEvent$AddressInfo$Address$Companion() {
    TorManagerEvent$AddressInfo$Address$Companion_instance = this;
  }
  TorManagerEvent$AddressInfo$Address$Companion.prototype.fromString_61zpoe$ = function (value) {
    var splits = split(value, Kotlin.charArrayOf(58));
    var $receiver = splits.get_za3lpa$(0);
    var tmp$;
    var tmp$_0 = trim(Kotlin.isCharSequence(tmp$ = $receiver) ? tmp$ : throwCCE()).toString();
    var $receiver_0 = splits.get_za3lpa$(1);
    var tmp$_1;
    return new TorManagerEvent$AddressInfo$Address(tmp$_0, new Port(toInt(trim(Kotlin.isCharSequence(tmp$_1 = $receiver_0) ? tmp$_1 : throwCCE()).toString())));
  };
  TorManagerEvent$AddressInfo$Address$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TorManagerEvent$AddressInfo$Address$Companion_instance = null;
  function TorManagerEvent$AddressInfo$Address$Companion_getInstance() {
    if (TorManagerEvent$AddressInfo$Address$Companion_instance === null) {
      new TorManagerEvent$AddressInfo$Address$Companion();
    }return TorManagerEvent$AddressInfo$Address$Companion_instance;
  }
  TorManagerEvent$AddressInfo$Address.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Address',
    interfaces: []
  };
  TorManagerEvent$AddressInfo$Address.prototype.component1 = function () {
    return this.address;
  };
  TorManagerEvent$AddressInfo$Address.prototype.component2 = function () {
    return this.port;
  };
  TorManagerEvent$AddressInfo$Address.prototype.copy_1gb3ha$ = function (address, port) {
    return new TorManagerEvent$AddressInfo$Address(address === void 0 ? this.address : address, port === void 0 ? this.port : port);
  };
  TorManagerEvent$AddressInfo$Address.prototype.toString = function () {
    return 'Address(address=' + Kotlin.toString(this.address) + (', port=' + Kotlin.toString(this.port)) + ')';
  };
  TorManagerEvent$AddressInfo$Address.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.address) | 0;
    result = result * 31 + Kotlin.hashCode(this.port) | 0;
    return result;
  };
  TorManagerEvent$AddressInfo$Address.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.address, other.address) && Kotlin.equals(this.port, other.port)))));
  };
  TorManagerEvent$AddressInfo.prototype.splitDns = function () {
    return this.split_0('DNS', this.dns);
  };
  TorManagerEvent$AddressInfo.prototype.splitHttp = function () {
    return this.split_0('HTTP', this.http);
  };
  TorManagerEvent$AddressInfo.prototype.splitSocks = function () {
    return this.split_0('Socks', this.socks);
  };
  TorManagerEvent$AddressInfo.prototype.splitTrans = function () {
    return this.split_0('Trans', this.trans);
  };
  TorManagerEvent$AddressInfo.prototype.split_0 = function (portName, values) {
    var tmp$;
    if (values == null || values.isEmpty()) {
      return new Result(createFailure(TorManagerException_init_0(portName + ' address was null')));
    }var set = LinkedHashSet_init(values.size);
    tmp$ = values.iterator();
    while (tmp$.hasNext()) {
      var value = tmp$.next();
      try {
        set.add_11rb$(TorManagerEvent$AddressInfo$Address$Companion_getInstance().fromString_61zpoe$(value));
      } catch (e) {
        if (Kotlin.isType(e, Exception)) {
          return new Result(createFailure(TorManagerException_init_1('Failed to split ' + portName + ' address: ' + value, e)));
        } else
          throw e;
      }
    }
    return new Result(toSet(set));
  };
  TorManagerEvent$AddressInfo.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AddressInfo',
    interfaces: [TorManagerEvent]
  };
  TorManagerEvent$AddressInfo.prototype.component1 = function () {
    return this.dns;
  };
  TorManagerEvent$AddressInfo.prototype.component2 = function () {
    return this.http;
  };
  TorManagerEvent$AddressInfo.prototype.component3 = function () {
    return this.socks;
  };
  TorManagerEvent$AddressInfo.prototype.component4 = function () {
    return this.trans;
  };
  TorManagerEvent$AddressInfo.prototype.copy_qz8j78$ = function (dns, http, socks, trans) {
    return new TorManagerEvent$AddressInfo(dns === void 0 ? this.dns : dns, http === void 0 ? this.http : http, socks === void 0 ? this.socks : socks, trans === void 0 ? this.trans : trans);
  };
  TorManagerEvent$AddressInfo.prototype.toString = function () {
    return 'AddressInfo(dns=' + Kotlin.toString(this.dns) + (', http=' + Kotlin.toString(this.http)) + (', socks=' + Kotlin.toString(this.socks)) + (', trans=' + Kotlin.toString(this.trans)) + ')';
  };
  TorManagerEvent$AddressInfo.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.dns) | 0;
    result = result * 31 + Kotlin.hashCode(this.http) | 0;
    result = result * 31 + Kotlin.hashCode(this.socks) | 0;
    result = result * 31 + Kotlin.hashCode(this.trans) | 0;
    return result;
  };
  TorManagerEvent$AddressInfo.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.dns, other.dns) && Kotlin.equals(this.http, other.http) && Kotlin.equals(this.socks, other.socks) && Kotlin.equals(this.trans, other.trans)))));
  };
  function TorManagerEvent$StartUpCompleteForTorInstance() {
    TorManagerEvent$StartUpCompleteForTorInstance_instance = this;
  }
  TorManagerEvent$StartUpCompleteForTorInstance.prototype.toString = function () {
    return 'StartUpCompleteForTorInstance';
  };
  TorManagerEvent$StartUpCompleteForTorInstance.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'StartUpCompleteForTorInstance',
    interfaces: [TorManagerEvent]
  };
  var TorManagerEvent$StartUpCompleteForTorInstance_instance = null;
  function TorManagerEvent$StartUpCompleteForTorInstance_getInstance() {
    if (TorManagerEvent$StartUpCompleteForTorInstance_instance === null) {
      new TorManagerEvent$StartUpCompleteForTorInstance();
    }return TorManagerEvent$StartUpCompleteForTorInstance_instance;
  }
  function TorManagerEvent$State(torState, networkState) {
    this.torState = torState;
    this.networkState = networkState;
  }
  Object.defineProperty(TorManagerEvent$State.prototype, 'isOff', {
    configurable: true,
    get: defineInlineFunction('kmp-tor-kmp-tor-manager-common-js-legacy.io.matthewnelson.kmp.tor.manager.common.event.TorManagerEvent.State.get_isOff', wrapFunction(function () {
      var TorState = _.io.matthewnelson.kmp.tor.manager.common.state.TorState;
      return function () {
        var $receiver = this.torState;
        return Kotlin.isType($receiver, Object.getPrototypeOf(TorState.Off).constructor);
      };
    }))
  });
  Object.defineProperty(TorManagerEvent$State.prototype, 'isOn', {
    configurable: true,
    get: defineInlineFunction('kmp-tor-kmp-tor-manager-common-js-legacy.io.matthewnelson.kmp.tor.manager.common.event.TorManagerEvent.State.get_isOn', wrapFunction(function () {
      var TorState$On = _.io.matthewnelson.kmp.tor.manager.common.state.TorState.On;
      return function () {
        return Kotlin.isType(this.torState, TorState$On);
      };
    }))
  });
  Object.defineProperty(TorManagerEvent$State.prototype, 'isStarting', {
    configurable: true,
    get: defineInlineFunction('kmp-tor-kmp-tor-manager-common-js-legacy.io.matthewnelson.kmp.tor.manager.common.event.TorManagerEvent.State.get_isStarting', wrapFunction(function () {
      var TorState = _.io.matthewnelson.kmp.tor.manager.common.state.TorState;
      return function () {
        var $receiver = this.torState;
        return Kotlin.isType($receiver, Object.getPrototypeOf(TorState.Starting).constructor);
      };
    }))
  });
  Object.defineProperty(TorManagerEvent$State.prototype, 'isStopping', {
    configurable: true,
    get: defineInlineFunction('kmp-tor-kmp-tor-manager-common-js-legacy.io.matthewnelson.kmp.tor.manager.common.event.TorManagerEvent.State.get_isStopping', wrapFunction(function () {
      var TorState = _.io.matthewnelson.kmp.tor.manager.common.state.TorState;
      return function () {
        var $receiver = this.torState;
        return Kotlin.isType($receiver, Object.getPrototypeOf(TorState.Stopping).constructor);
      };
    }))
  });
  Object.defineProperty(TorManagerEvent$State.prototype, 'isNetworkEnabled', {
    configurable: true,
    get: defineInlineFunction('kmp-tor-kmp-tor-manager-common-js-legacy.io.matthewnelson.kmp.tor.manager.common.event.TorManagerEvent.State.get_isNetworkEnabled', wrapFunction(function () {
      var TorNetworkState = _.io.matthewnelson.kmp.tor.manager.common.state.TorNetworkState;
      return function () {
        var $receiver = this.networkState;
        return Kotlin.isType($receiver, Object.getPrototypeOf(TorNetworkState.Enabled).constructor);
      };
    }))
  });
  Object.defineProperty(TorManagerEvent$State.prototype, 'isNetworkDisabled', {
    configurable: true,
    get: defineInlineFunction('kmp-tor-kmp-tor-manager-common-js-legacy.io.matthewnelson.kmp.tor.manager.common.event.TorManagerEvent.State.get_isNetworkDisabled', wrapFunction(function () {
      var TorNetworkState = _.io.matthewnelson.kmp.tor.manager.common.state.TorNetworkState;
      return function () {
        var $receiver = this.networkState;
        return Kotlin.isType($receiver, Object.getPrototypeOf(TorNetworkState.Disabled).constructor);
      };
    }))
  });
  TorManagerEvent$State.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'State',
    interfaces: [TorManagerEvent]
  };
  TorManagerEvent$State.prototype.component1 = function () {
    return this.torState;
  };
  TorManagerEvent$State.prototype.component2 = function () {
    return this.networkState;
  };
  TorManagerEvent$State.prototype.copy_d2j7xk$ = function (torState, networkState) {
    return new TorManagerEvent$State(torState === void 0 ? this.torState : torState, networkState === void 0 ? this.networkState : networkState);
  };
  TorManagerEvent$State.prototype.toString = function () {
    return 'State(torState=' + Kotlin.toString(this.torState) + (', networkState=' + Kotlin.toString(this.networkState)) + ')';
  };
  TorManagerEvent$State.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.torState) | 0;
    result = result * 31 + Kotlin.hashCode(this.networkState) | 0;
    return result;
  };
  TorManagerEvent$State.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.torState, other.torState) && Kotlin.equals(this.networkState, other.networkState)))));
  };
  function TorManagerEvent$SealedListener() {
  }
  TorManagerEvent$SealedListener.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'SealedListener',
    interfaces: [TorEvent$SealedListener]
  };
  function TorManagerEvent$Listener() {
    TorEvent$Listener.call(this);
  }
  TorManagerEvent$Listener.prototype.managerEventActionController = function () {
  };
  TorManagerEvent$Listener.prototype.managerEventActionRestart = function () {
  };
  TorManagerEvent$Listener.prototype.managerEventActionStart = function () {
  };
  TorManagerEvent$Listener.prototype.managerEventActionStop = function () {
  };
  TorManagerEvent$Listener.prototype.managerEventAddressInfo_fpzak4$ = function (info) {
  };
  TorManagerEvent$Listener.prototype.managerEventDebug_61zpoe$ = function (message) {
  };
  TorManagerEvent$Listener.prototype.managerEventError_tcv7n7$ = function (t) {
  };
  TorManagerEvent$Listener.prototype.managerEventInfo_61zpoe$ = function (message) {
  };
  TorManagerEvent$Listener.prototype.managerEventWarn_61zpoe$ = function (message) {
  };
  TorManagerEvent$Listener.prototype.managerEventLifecycle_62yg4c$ = function (lifecycle) {
  };
  TorManagerEvent$Listener.prototype.managerEventStartUpCompleteForTorInstance = function () {
  };
  TorManagerEvent$Listener.prototype.managerEventState_ib5d0b$ = function (state) {
  };
  TorManagerEvent$Listener.prototype.onEvent_dt2fag$ = function (event) {
    if (Kotlin.isType(event, TorManagerEvent$Action$Controller))
      this.managerEventActionController();
    else if (Kotlin.isType(event, TorManagerEvent$Action$Restart))
      this.managerEventActionRestart();
    else if (Kotlin.isType(event, TorManagerEvent$Action$Start))
      this.managerEventActionStart();
    else if (Kotlin.isType(event, TorManagerEvent$Action$Stop))
      this.managerEventActionStop();
    else if (Kotlin.isType(event, TorManagerEvent$AddressInfo))
      this.managerEventAddressInfo_fpzak4$(event);
    else if (Kotlin.isType(event, TorManagerEvent$Log$Debug))
      this.managerEventDebug_61zpoe$(event.value);
    else if (Kotlin.isType(event, TorManagerEvent$Log$Error))
      this.managerEventError_tcv7n7$(event.value);
    else if (Kotlin.isType(event, TorManagerEvent$Log$Info))
      this.managerEventInfo_61zpoe$(event.value);
    else if (Kotlin.isType(event, TorManagerEvent$Log$Warn))
      this.managerEventWarn_61zpoe$(event.value);
    else if (Kotlin.isType(event, TorManagerEvent$Lifecycle))
      this.managerEventLifecycle_62yg4c$(event);
    else if (Kotlin.isType(event, TorManagerEvent$StartUpCompleteForTorInstance))
      this.managerEventStartUpCompleteForTorInstance();
    else if (Kotlin.isType(event, TorManagerEvent$State))
      this.managerEventState_ib5d0b$(event);
  };
  TorManagerEvent$Listener.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Listener',
    interfaces: [TorManagerEvent$SealedListener, TorEvent$Listener]
  };
  TorManagerEvent.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TorManagerEvent',
    interfaces: []
  };
  function InterruptedException() {
    this.name = 'InterruptedException';
  }
  InterruptedException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InterruptedException',
    interfaces: [TorManagerException]
  };
  function InterruptedException_init($this) {
    $this = $this || Object.create(InterruptedException.prototype);
    TorManagerException_init($this);
    InterruptedException.call($this);
    return $this;
  }
  function InterruptedException_init_0(message, $this) {
    $this = $this || Object.create(InterruptedException.prototype);
    TorManagerException_init_0(message, $this);
    InterruptedException.call($this);
    return $this;
  }
  function InterruptedException_init_1(message, cause, $this) {
    $this = $this || Object.create(InterruptedException.prototype);
    TorManagerException_init_1(message, cause, $this);
    InterruptedException.call($this);
    return $this;
  }
  function InterruptedException_init_2(cause, $this) {
    $this = $this || Object.create(InterruptedException.prototype);
    TorManagerException_init_2(cause, $this);
    InterruptedException.call($this);
    return $this;
  }
  function TorManagerException() {
    this.name = 'TorManagerException';
  }
  TorManagerException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TorManagerException',
    interfaces: [TorControllerException]
  };
  function TorManagerException_init($this) {
    $this = $this || Object.create(TorManagerException.prototype);
    TorControllerException_init($this);
    TorManagerException.call($this);
    return $this;
  }
  function TorManagerException_init_0(message, $this) {
    $this = $this || Object.create(TorManagerException.prototype);
    TorControllerException_init_0(message, $this);
    TorManagerException.call($this);
    return $this;
  }
  function TorManagerException_init_1(message, cause, $this) {
    $this = $this || Object.create(TorManagerException.prototype);
    TorControllerException_init_1(message, cause, $this);
    TorManagerException.call($this);
    return $this;
  }
  function TorManagerException_init_2(cause, $this) {
    $this = $this || Object.create(TorManagerException.prototype);
    TorControllerException_init_2(cause, $this);
    TorManagerException.call($this);
    return $this;
  }
  function TorNotStartedException() {
    this.name = 'TorNotStartedException';
  }
  TorNotStartedException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TorNotStartedException',
    interfaces: [TorManagerException]
  };
  function TorNotStartedException_init($this) {
    $this = $this || Object.create(TorNotStartedException.prototype);
    TorManagerException_init($this);
    TorNotStartedException.call($this);
    return $this;
  }
  function TorNotStartedException_init_0(message, $this) {
    $this = $this || Object.create(TorNotStartedException.prototype);
    TorManagerException_init_0(message, $this);
    TorNotStartedException.call($this);
    return $this;
  }
  function TorNotStartedException_init_1(message, cause, $this) {
    $this = $this || Object.create(TorNotStartedException.prototype);
    TorManagerException_init_1(message, cause, $this);
    TorNotStartedException.call($this);
    return $this;
  }
  function TorNotStartedException_init_2(cause, $this) {
    $this = $this || Object.create(TorNotStartedException.prototype);
    TorManagerException_init_2(cause, $this);
    TorNotStartedException.call($this);
    return $this;
  }
  function TorNetworkState() {
  }
  function TorNetworkState$Disabled() {
    TorNetworkState$Disabled_instance = this;
    TorNetworkState.call(this);
    this.DISABLED_0 = 'Network: Disabled';
  }
  TorNetworkState$Disabled.prototype.toString = function () {
    return this.DISABLED_0;
  };
  TorNetworkState$Disabled.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Disabled',
    interfaces: [TorNetworkState]
  };
  var TorNetworkState$Disabled_instance = null;
  function TorNetworkState$Disabled_getInstance() {
    if (TorNetworkState$Disabled_instance === null) {
      new TorNetworkState$Disabled();
    }return TorNetworkState$Disabled_instance;
  }
  function TorNetworkState$Enabled() {
    TorNetworkState$Enabled_instance = this;
    TorNetworkState.call(this);
    this.ENABLED_0 = 'Network: Enabled';
  }
  TorNetworkState$Enabled.prototype.toString = function () {
    return this.ENABLED_0;
  };
  TorNetworkState$Enabled.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Enabled',
    interfaces: [TorNetworkState]
  };
  var TorNetworkState$Enabled_instance = null;
  function TorNetworkState$Enabled_getInstance() {
    if (TorNetworkState$Enabled_instance === null) {
      new TorNetworkState$Enabled();
    }return TorNetworkState$Enabled_instance;
  }
  TorNetworkState.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TorNetworkState',
    interfaces: []
  };
  var isDisabled = defineInlineFunction('kmp-tor-kmp-tor-manager-common-js-legacy.io.matthewnelson.kmp.tor.manager.common.state.isDisabled_dy562$', wrapFunction(function () {
    var TorNetworkState = _.io.matthewnelson.kmp.tor.manager.common.state.TorNetworkState;
    return function ($receiver) {
      return Kotlin.isType($receiver, Object.getPrototypeOf(TorNetworkState.Disabled).constructor);
    };
  }));
  var isEnabled = defineInlineFunction('kmp-tor-kmp-tor-manager-common-js-legacy.io.matthewnelson.kmp.tor.manager.common.state.isEnabled_dy562$', wrapFunction(function () {
    var TorNetworkState = _.io.matthewnelson.kmp.tor.manager.common.state.TorNetworkState;
    return function ($receiver) {
      return Kotlin.isType($receiver, Object.getPrototypeOf(TorNetworkState.Enabled).constructor);
    };
  }));
  function TorState() {
  }
  function TorState$Off() {
    TorState$Off_instance = this;
    this.bootstrap_q8llm2$_0 = 0;
    this.isBootstrapped_61jvv5$_0 = false;
    this.OFF_0 = 'Tor: Off';
  }
  Object.defineProperty(TorState$Off.prototype, 'bootstrap', {
    configurable: true,
    get: function () {
      return this.bootstrap_q8llm2$_0;
    }
  });
  Object.defineProperty(TorState$Off.prototype, 'isBootstrapped', {
    configurable: true,
    get: function () {
      return this.isBootstrapped_61jvv5$_0;
    }
  });
  TorState$Off.prototype.toString = function () {
    return this.OFF_0;
  };
  TorState$Off.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Off',
    interfaces: [TorState]
  };
  var TorState$Off_instance = null;
  function TorState$Off_getInstance() {
    if (TorState$Off_instance === null) {
      new TorState$Off();
    }return TorState$Off_instance;
  }
  function TorState$On(bootstrap) {
    TorState$On$Companion_getInstance();
    this.bootstrap_361quc$_0 = bootstrap;
  }
  Object.defineProperty(TorState$On.prototype, 'bootstrap', {
    get: function () {
      return this.bootstrap_361quc$_0;
    }
  });
  Object.defineProperty(TorState$On.prototype, 'isBootstrapped', {
    configurable: true,
    get: function () {
      return this.bootstrap >= 100;
    }
  });
  TorState$On.prototype.toString = function () {
    return TorState$On$Companion_getInstance().ON_0;
  };
  function TorState$On$Companion() {
    TorState$On$Companion_instance = this;
    this.ON_0 = 'Tor: On';
  }
  TorState$On$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TorState$On$Companion_instance = null;
  function TorState$On$Companion_getInstance() {
    if (TorState$On$Companion_instance === null) {
      new TorState$On$Companion();
    }return TorState$On$Companion_instance;
  }
  TorState$On.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'On',
    interfaces: [TorState]
  };
  TorState$On.prototype.unbox = function () {
    return this.bootstrap;
  };
  TorState$On.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.bootstrap) | 0;
    return result;
  };
  TorState$On.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.bootstrap, other.bootstrap))));
  };
  function TorState$Starting() {
    TorState$Starting_instance = this;
    this.STARTING_0 = 'Tor: Starting';
  }
  Object.defineProperty(TorState$Starting.prototype, 'bootstrap', {
    configurable: true,
    get: function () {
      return TorState$Off_getInstance().bootstrap;
    }
  });
  Object.defineProperty(TorState$Starting.prototype, 'isBootstrapped', {
    configurable: true,
    get: function () {
      return TorState$Off_getInstance().isBootstrapped;
    }
  });
  TorState$Starting.prototype.toString = function () {
    return this.STARTING_0;
  };
  TorState$Starting.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Starting',
    interfaces: [TorState]
  };
  var TorState$Starting_instance = null;
  function TorState$Starting_getInstance() {
    if (TorState$Starting_instance === null) {
      new TorState$Starting();
    }return TorState$Starting_instance;
  }
  function TorState$Stopping() {
    TorState$Stopping_instance = this;
    this.STOPPING_0 = 'Tor: Stopping';
  }
  Object.defineProperty(TorState$Stopping.prototype, 'bootstrap', {
    configurable: true,
    get: function () {
      return TorState$Off_getInstance().bootstrap;
    }
  });
  Object.defineProperty(TorState$Stopping.prototype, 'isBootstrapped', {
    configurable: true,
    get: function () {
      return TorState$Off_getInstance().isBootstrapped;
    }
  });
  TorState$Stopping.prototype.toString = function () {
    return this.STOPPING_0;
  };
  TorState$Stopping.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Stopping',
    interfaces: [TorState]
  };
  var TorState$Stopping_instance = null;
  function TorState$Stopping_getInstance() {
    if (TorState$Stopping_instance === null) {
      new TorState$Stopping();
    }return TorState$Stopping_instance;
  }
  TorState.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TorState',
    interfaces: []
  };
  var isOff = defineInlineFunction('kmp-tor-kmp-tor-manager-common-js-legacy.io.matthewnelson.kmp.tor.manager.common.state.isOff_fuqmjk$', wrapFunction(function () {
    var TorState = _.io.matthewnelson.kmp.tor.manager.common.state.TorState;
    return function ($receiver) {
      return Kotlin.isType($receiver, Object.getPrototypeOf(TorState.Off).constructor);
    };
  }));
  var isOn = defineInlineFunction('kmp-tor-kmp-tor-manager-common-js-legacy.io.matthewnelson.kmp.tor.manager.common.state.isOn_fuqmjk$', wrapFunction(function () {
    var TorState$On = _.io.matthewnelson.kmp.tor.manager.common.state.TorState.On;
    return function ($receiver) {
      return Kotlin.isType($receiver, TorState$On);
    };
  }));
  var isStarting = defineInlineFunction('kmp-tor-kmp-tor-manager-common-js-legacy.io.matthewnelson.kmp.tor.manager.common.state.isStarting_fuqmjk$', wrapFunction(function () {
    var TorState = _.io.matthewnelson.kmp.tor.manager.common.state.TorState;
    return function ($receiver) {
      return Kotlin.isType($receiver, Object.getPrototypeOf(TorState.Starting).constructor);
    };
  }));
  var isStopping = defineInlineFunction('kmp-tor-kmp-tor-manager-common-js-legacy.io.matthewnelson.kmp.tor.manager.common.state.isStopping_fuqmjk$', wrapFunction(function () {
    var TorState = _.io.matthewnelson.kmp.tor.manager.common.state.TorState;
    return function ($receiver) {
      return Kotlin.isType($receiver, Object.getPrototypeOf(TorState.Stopping).constructor);
    };
  }));
  function TorStateManager() {
  }
  TorStateManager.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TorStateManager',
    interfaces: []
  };
  var package$io = _.io || (_.io = {});
  var package$matthewnelson = package$io.matthewnelson || (package$io.matthewnelson = {});
  var package$kmp = package$matthewnelson.kmp || (package$matthewnelson.kmp = {});
  var package$tor = package$kmp.tor || (package$kmp.tor = {});
  var package$manager = package$tor.manager || (package$tor.manager = {});
  var package$common = package$manager.common || (package$manager.common = {});
  package$common.TorControlManager = TorControlManager;
  package$common.TorOperationManager = TorOperationManager;
  Object.defineProperty(TorManagerEvent$Action, 'Controller', {
    get: TorManagerEvent$Action$Controller_getInstance
  });
  Object.defineProperty(TorManagerEvent$Action, 'Restart', {
    get: TorManagerEvent$Action$Restart_getInstance
  });
  Object.defineProperty(TorManagerEvent$Action, 'Start', {
    get: TorManagerEvent$Action$Start_getInstance
  });
  Object.defineProperty(TorManagerEvent$Action, 'Stop', {
    get: TorManagerEvent$Action$Stop_getInstance
  });
  Object.defineProperty(TorManagerEvent$Action, 'Companion', {
    get: TorManagerEvent$Action$Companion_getInstance
  });
  TorManagerEvent.Action = TorManagerEvent$Action;
  TorManagerEvent$Log.Debug = TorManagerEvent$Log$Debug;
  TorManagerEvent$Log.Error = TorManagerEvent$Log$Error;
  TorManagerEvent$Log.Info = TorManagerEvent$Log$Info;
  Object.defineProperty(TorManagerEvent$Log$Warn, 'Companion', {
    get: TorManagerEvent$Log$Warn$Companion_getInstance
  });
  TorManagerEvent$Log.Warn = TorManagerEvent$Log$Warn;
  TorManagerEvent.Log = TorManagerEvent$Log;
  Object.defineProperty(TorManagerEvent$Lifecycle, 'Companion', {
    get: TorManagerEvent$Lifecycle$Companion_getInstance
  });
  TorManagerEvent.Lifecycle = TorManagerEvent$Lifecycle;
  Object.defineProperty(TorManagerEvent$AddressInfo$Address, 'Companion', {
    get: TorManagerEvent$AddressInfo$Address$Companion_getInstance
  });
  TorManagerEvent$AddressInfo.Address = TorManagerEvent$AddressInfo$Address;
  TorManagerEvent.AddressInfo = TorManagerEvent$AddressInfo;
  Object.defineProperty(TorManagerEvent, 'StartUpCompleteForTorInstance', {
    get: TorManagerEvent$StartUpCompleteForTorInstance_getInstance
  });
  var package$state = package$common.state || (package$common.state = {});
  package$state.isOff_fuqmjk$ = isOff;
  $$importsForInline$$['kmp-tor-kmp-tor-manager-common-js-legacy'] = _;
  package$state.isOn_fuqmjk$ = isOn;
  package$state.isStarting_fuqmjk$ = isStarting;
  package$state.isStopping_fuqmjk$ = isStopping;
  package$state.isEnabled_dy562$ = isEnabled;
  package$state.isDisabled_dy562$ = isDisabled;
  TorManagerEvent.State = TorManagerEvent$State;
  TorManagerEvent.SealedListener = TorManagerEvent$SealedListener;
  TorManagerEvent.Listener = TorManagerEvent$Listener;
  var package$event = package$common.event || (package$common.event = {});
  package$event.TorManagerEvent = TorManagerEvent;
  var package$exceptions = package$common.exceptions || (package$common.exceptions = {});
  package$exceptions.InterruptedException_init = InterruptedException_init;
  package$exceptions.InterruptedException_init_pdl1vj$ = InterruptedException_init_0;
  package$exceptions.InterruptedException_init_wspj0f$ = InterruptedException_init_1;
  package$exceptions.InterruptedException_init_dbl4no$ = InterruptedException_init_2;
  package$exceptions.InterruptedException = InterruptedException;
  package$exceptions.TorManagerException_init = TorManagerException_init;
  package$exceptions.TorManagerException_init_pdl1vj$ = TorManagerException_init_0;
  package$exceptions.TorManagerException_init_wspj0f$ = TorManagerException_init_1;
  package$exceptions.TorManagerException_init_dbl4no$ = TorManagerException_init_2;
  package$exceptions.TorManagerException = TorManagerException;
  package$exceptions.TorNotStartedException_init = TorNotStartedException_init;
  package$exceptions.TorNotStartedException_init_pdl1vj$ = TorNotStartedException_init_0;
  package$exceptions.TorNotStartedException_init_wspj0f$ = TorNotStartedException_init_1;
  package$exceptions.TorNotStartedException_init_dbl4no$ = TorNotStartedException_init_2;
  package$exceptions.TorNotStartedException = TorNotStartedException;
  Object.defineProperty(TorNetworkState, 'Disabled', {
    get: TorNetworkState$Disabled_getInstance
  });
  Object.defineProperty(TorNetworkState, 'Enabled', {
    get: TorNetworkState$Enabled_getInstance
  });
  package$state.TorNetworkState = TorNetworkState;
  Object.defineProperty(TorState, 'Off', {
    get: TorState$Off_getInstance
  });
  Object.defineProperty(TorState$On, 'Companion', {
    get: TorState$On$Companion_getInstance
  });
  TorState.On = TorState$On;
  Object.defineProperty(TorState, 'Starting', {
    get: TorState$Starting_getInstance
  });
  Object.defineProperty(TorState, 'Stopping', {
    get: TorState$Stopping_getInstance
  });
  package$state.TorState = TorState;
  package$state.TorStateManager = TorStateManager;
  TorControlManager.prototype.configReset_nf8j41$ = TorControlConfig.prototype.configReset_nf8j41$;
  TorControlManager.prototype.configReset_44tava$ = TorControlConfig.prototype.configReset_44tava$;
  TorControlManager.prototype.configSave_6taknv$ = TorControlConfig.prototype.configSave_6taknv$;
  TorControlManager.prototype.onionAdd_wgj5cg$ = TorControlOnion.prototype.onionAdd_wgj5cg$;
  TorControlManager.prototype.onionAddNew_hizcjk$ = TorControlOnion.prototype.onionAddNew_hizcjk$;
  TorControlManager.prototype.setEvents_cex2gf$ = TorControlSetEvents.prototype.setEvents_cex2gf$;
  Kotlin.defineModule('kmp-tor-kmp-tor-manager-common-js-legacy', _);
  return _;
}));

//# sourceMappingURL=kmp-tor-kmp-tor-manager-common-js-legacy.js.map
