/*
 * Copyright (c) 2021 Matthew Nelson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/
package io.matthewnelson.kmp.tor.controller.common.control.usecase

import io.matthewnelson.kmp.tor.controller.common.config.TorConfig
import io.matthewnelson.kmp.tor.controller.common.control.TorControlConfig

/**
 * "RESETCONF" 1*(SP keyword ["=" String]) CRLF
 *
 * https://torproject.gitlab.io/torspec/control-spec/#resetconf
 *
 * @see [TorControlConfig]
 * */
interface TorControlConfigReset {

    suspend fun configReset(
        setting: TorConfig.Setting<*>,
        setDefault: Boolean = true
    ): Result<Any?>

    suspend fun configReset(
        settings: Set<TorConfig.Setting<*>>,
        setDefault: Boolean = true
    ): Result<Any?>

}
