(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'fs', 'path', 'zlib'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('fs'), require('path'), require('zlib'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kmp-tor-binary-kmp-tor-binary-extract-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kmp-tor-binary-kmp-tor-binary-extract-js-legacy'.");
    }
    if (typeof fs === 'undefined') {
      throw new Error("Error loading module 'kmp-tor-binary-kmp-tor-binary-extract-js-legacy'. Its dependency 'fs' was not found. Please, check whether 'fs' is loaded prior to 'kmp-tor-binary-kmp-tor-binary-extract-js-legacy'.");
    }
    if (typeof path === 'undefined') {
      throw new Error("Error loading module 'kmp-tor-binary-kmp-tor-binary-extract-js-legacy'. Its dependency 'path' was not found. Please, check whether 'path' is loaded prior to 'kmp-tor-binary-kmp-tor-binary-extract-js-legacy'.");
    }
    if (typeof zlib === 'undefined') {
      throw new Error("Error loading module 'kmp-tor-binary-kmp-tor-binary-extract-js-legacy'. Its dependency 'zlib' was not found. Please, check whether 'zlib' is loaded prior to 'kmp-tor-binary-kmp-tor-binary-extract-js-legacy'.");
    }
    root['kmp-tor-binary-kmp-tor-binary-extract-js-legacy'] = factory(typeof this['kmp-tor-binary-kmp-tor-binary-extract-js-legacy'] === 'undefined' ? {} : this['kmp-tor-binary-kmp-tor-binary-extract-js-legacy'], kotlin, fs, path, zlib);
  }
}(this, function (_, Kotlin, $module$fs, $module$path, $module$zlib) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var RuntimeException = Kotlin.kotlin.RuntimeException;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var toBoxedChar = Kotlin.toBoxedChar;
  var Throwable = Error;
  var Unit = Kotlin.kotlin.Unit;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var unboxChar = Kotlin.unboxChar;
  var Pair = Kotlin.kotlin.Pair;
  var equals = Kotlin.equals;
  var NullPointerException = Kotlin.kotlin.NullPointerException;
  var Exception = Kotlin.kotlin.Exception;
  var first = Kotlin.kotlin.text.first_gw00vp$;
  var endsWith = Kotlin.kotlin.text.endsWith_sgbm27$;
  var toString = Kotlin.toString;
  var replace = Kotlin.kotlin.text.replace_r2fvfm$;
  var substringBeforeLast = Kotlin.kotlin.text.substringBeforeLast_j4ogox$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var readFileSync = $module$fs.readFileSync;
  var throwCCE = Kotlin.throwCCE;
  var normalize = $module$path.normalize;
  var lstatSync = $module$fs.lstatSync;
  var existsSync = $module$fs.existsSync;
  var substringAfterLast = Kotlin.kotlin.text.substringAfterLast_j4ogox$;
  var substringBeforeLast_0 = Kotlin.kotlin.text.substringBeforeLast_8cymmc$;
  var realpathSync = $module$fs.realpathSync;
  var chmodSync = $module$fs.chmodSync;
  var rmSync = $module$fs.rmSync;
  var mkdirSync = $module$fs.mkdirSync;
  var gunzipSync = $module$zlib.gunzipSync;
  var writeFileSync = $module$fs.writeFileSync;
  var listOf = Kotlin.kotlin.collections.listOf_i5x0yv$;
  ExtractionException.prototype = Object.create(RuntimeException.prototype);
  ExtractionException.prototype.constructor = ExtractionException;
  TorResource$Geoips.prototype = Object.create(TorResource.prototype);
  TorResource$Geoips.prototype.constructor = TorResource$Geoips;
  TorResourceGeoip.prototype = Object.create(TorResource$Geoips.prototype);
  TorResourceGeoip.prototype.constructor = TorResourceGeoip;
  TorResourceGeoip6.prototype = Object.create(TorResource$Geoips.prototype);
  TorResourceGeoip6.prototype.constructor = TorResourceGeoip6;
  ExtractorDelegateJs.prototype = Object.create(ExtractorDelegate.prototype);
  ExtractorDelegateJs.prototype.constructor = ExtractorDelegateJs;
  TorResource$Binaries.prototype = Object.create(TorResource.prototype);
  TorResource$Binaries.prototype.constructor = TorResource$Binaries;
  TorResourceLinuxX64.prototype = Object.create(TorResource$Binaries.prototype);
  TorResourceLinuxX64.prototype.constructor = TorResourceLinuxX64;
  TorResourceLinuxX86.prototype = Object.create(TorResource$Binaries.prototype);
  TorResourceLinuxX86.prototype.constructor = TorResourceLinuxX86;
  TorResourceMacosX64.prototype = Object.create(TorResource$Binaries.prototype);
  TorResourceMacosX64.prototype.constructor = TorResourceMacosX64;
  TorResourceMacosArm64.prototype = Object.create(TorResource$Binaries.prototype);
  TorResourceMacosArm64.prototype.constructor = TorResourceMacosArm64;
  TorResourceMingwX64.prototype = Object.create(TorResource$Binaries.prototype);
  TorResourceMingwX64.prototype.constructor = TorResourceMingwX64;
  TorResourceMingwX86.prototype = Object.create(TorResource$Binaries.prototype);
  TorResourceMingwX86.prototype.constructor = TorResourceMingwX86;
  function ExtractionException() {
    this.name = 'ExtractionException';
    this.message_ak8x1l$_0 = null;
  }
  Object.defineProperty(ExtractionException.prototype, 'message', {
    configurable: true,
    get: function () {
      return this.message_ak8x1l$_0;
    }
  });
  ExtractionException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ExtractionException',
    interfaces: [RuntimeException]
  };
  function ExtractionException_init(message, $this) {
    $this = $this || Object.create(ExtractionException.prototype);
    ExtractionException_init_0(message, null, $this);
    return $this;
  }
  function ExtractionException_init_0(message, cause, $this) {
    $this = $this || Object.create(ExtractionException.prototype);
    RuntimeException.call($this, message, cause);
    ExtractionException.call($this);
    $this.message_ak8x1l$_0 = message;
    return $this;
  }
  function TorResourceGeoip() {
    TorResourceGeoip_instance = this;
    TorResource$Geoips.call(this);
  }
  Object.defineProperty(TorResourceGeoip.prototype, 'resourcePath', {
    configurable: true,
    get: function () {
      return 'kmptor/geoip.gz';
    }
  });
  Object.defineProperty(TorResourceGeoip.prototype, 'sha256sum', {
    configurable: true,
    get: function () {
      return '8fa0d2bf75a29d346e856eff63b9ed0f7740df578bdcac3b33364f4a88a168e9';
    }
  });
  TorResourceGeoip.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TorResourceGeoip',
    interfaces: [TorResource$Geoips]
  };
  var TorResourceGeoip_instance = null;
  function TorResourceGeoip_getInstance() {
    if (TorResourceGeoip_instance === null) {
      new TorResourceGeoip();
    }
    return TorResourceGeoip_instance;
  }
  function TorResourceGeoip6() {
    TorResourceGeoip6_instance = this;
    TorResource$Geoips.call(this);
  }
  Object.defineProperty(TorResourceGeoip6.prototype, 'resourcePath', {
    configurable: true,
    get: function () {
      return 'kmptor/geoip6.gz';
    }
  });
  Object.defineProperty(TorResourceGeoip6.prototype, 'sha256sum', {
    configurable: true,
    get: function () {
      return 'c9b87ed1a97adb5040a18ffe7117276cd5a112eb27c588eb989f4abe0ec58879';
    }
  });
  TorResourceGeoip6.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TorResourceGeoip6',
    interfaces: [TorResource$Geoips]
  };
  var TorResourceGeoip6_instance = null;
  function TorResourceGeoip6_getInstance() {
    if (TorResourceGeoip6_instance === null) {
      new TorResourceGeoip6();
    }
    return TorResourceGeoip6_instance;
  }
  var mapManifestToDestination = defineInlineFunction('kmp-tor-binary-kmp-tor-binary-extract-js-legacy.io.matthewnelson.kmp.tor.binary.extract.internal.mapManifestToDestination_clzgi8$', wrapFunction(function () {
    var first = Kotlin.kotlin.text.first_gw00vp$;
    var endsWith = Kotlin.kotlin.text.endsWith_sgbm27$;
    var toBoxedChar = Kotlin.toBoxedChar;
    var toString = Kotlin.toString;
    var replace = Kotlin.kotlin.text.replace_r2fvfm$;
    var substringBeforeLast = Kotlin.kotlin.text.substringBeforeLast_j4ogox$;
    var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
    var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
    return function ($receiver, destinationDir, onMappedItem) {
      var separator = first(destinationDir) === 47 ? 47 : 92;
      var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
      var tmp$;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        var tmp$_0 = destination.add_11rb$;
        var sep = endsWith(destinationDir, separator) ? '' : toBoxedChar(separator);
        var mapped = destinationDir + toString(sep) + substringBeforeLast(replace(item, 47, separator), '.gz');
        onMappedItem(item, mapped);
        tmp$_0.call(destination, mapped);
      }
      return destination;
    };
  }));
  var FILE_NAME_SHA256_SUFFIX;
  var FILE_NAME_SHA256_TOR;
  function ExtractorDelegate() {
  }
  Object.defineProperty(ExtractorDelegate.prototype, 'fsSeparator', {
    configurable: true,
    get: function () {
      return toBoxedChar(47);
    }
  });
  ExtractorDelegate.prototype.extract_ya0pjd$ = function (resource, destination, cleanExtraction, provideStream) {
    var tmp$;
    try {
      var destinationNormalized = this.normalize_pdl1vz$(destination);
      var destinationFile = this.toFile_pdl1vz$(destinationNormalized);
      if (this.exists_trkh7z$(destinationFile) && this.isDirectory_trkh7z$(destinationFile)) {
        throw ExtractionException_init('destination for ' + resource.resourcePath + ' extraction cannot be a directory');
      }
      var sha256SumValue = resource.sha256sum;
      var sha256SumFile = this.toFile_pdl1vz$(destinationNormalized + FILE_NAME_SHA256_SUFFIX);
      var isSha256SumValid = this.checkSha256SumFile_0(sha256SumFile, sha256SumValue);
      if (!cleanExtraction && this.exists_trkh7z$(destinationFile) && isSha256SumValid) {
        return;
      }
      try {
        tmp$ = this.gunzip_nqi3in$(provideStream(resource.resourcePath));
      } catch (e) {
        if (Kotlin.isType(e, ExtractionException)) {
          throw e;
        } else if (Kotlin.isType(e, Throwable)) {
          var t_0 = e;
          throw ExtractionException_init_0('Failed to open stream for ' + resource.resourcePath, t_0);
        } else
          throw e;
      }
      var gunzipStream = tmp$;
      try {
        this.write_74fv1b$(destinationFile, gunzipStream);
      } catch (t) {
        if (Kotlin.isType(t, Throwable)) {
          try {
            this.delete_trkh7z$(destinationFile);
          } catch (_) {
            if (!Kotlin.isType(_, Throwable))
              throw _;
          }
          throw t;
        } else
          throw t;
      }
      if (isSha256SumValid)
        return;
      try {
        this.writeText_reudxd$(sha256SumFile, sha256SumValue);
      } catch (t) {
        if (Kotlin.isType(t, Throwable)) {
          try {
            this.delete_trkh7z$(destinationFile);
          } catch (_) {
            if (!Kotlin.isType(_, Throwable))
              throw _;
          }
          try {
            this.delete_trkh7z$(sha256SumFile);
          } catch (_) {
            if (!Kotlin.isType(_, Throwable))
              throw _;
          }
          throw ExtractionException_init_0('Failed to write sha256sum to file ' + sha256SumFile, t);
        } else
          throw t;
      }
    } catch (e) {
      if (Kotlin.isType(e, ExtractionException)) {
        throw e;
      } else if (Kotlin.isType(e, Throwable)) {
        var t_1 = e;
        throw ExtractionException_init_0('Failed to extract ' + resource.resourcePath + ' to ' + destination, t_1);
      } else
        throw e;
    }
  };
  function ExtractorDelegate$extract$lambda(this$ExtractorDelegate, closure$extractResourceTo, closure$resourceDirPath, closure$torFile, closure$shouldExtract) {
    return function (manifestItem, destination) {
      var writeTo = this$ExtractorDelegate.toFile_pdl1vz$(this$ExtractorDelegate.normalize_pdl1vz$(destination));
      closure$extractResourceTo.add_11rb$(new Pair(closure$resourceDirPath + '/' + manifestItem, writeTo));
      if (equals(this$ExtractorDelegate.nameWithoutExtension_trkh7z$(writeTo).toLowerCase(), 'tor')) {
        closure$torFile.v = writeTo;
      }
      if (!this$ExtractorDelegate.exists_trkh7z$(writeTo)) {
        closure$shouldExtract.v = true;
      }
      return Unit;
    };
  }
  ExtractorDelegate.prototype.extract_9xq8ib$ = function (resource, destinationDir, cleanExtraction, provideStream) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    try {
      tmp$ = this.normalize_pdl1vz$(destinationDir);
    } catch (t) {
      if (Kotlin.isType(t, Throwable)) {
        throw ExtractionException_init('Failed to normalize destinationDir: ' + destinationDir);
      } else
        throw t;
    }
    var destinationDirNormalized = tmp$;
    var manifest = resource.resourceManifest;
    var filesWritten = ArrayList_init(manifest.size + 1 | 0);
    var extractionToDir = this.toFile_pdl1vz$(destinationDirNormalized);
    try {
      if (this.exists_trkh7z$(extractionToDir)) {
        if (!this.isDirectory_trkh7z$(extractionToDir) && !this.delete_trkh7z$(extractionToDir)) {
          throw ExtractionException_init('Directory specified (' + destinationDir + ') exists, ' + 'is not a directory, and failed to delete prior to ' + 'extracting resources.');
        }
      } else {
        if (!this.mkdirs_trkh7z$(extractionToDir)) {
          throw ExtractionException_init('Failed to create destinationDir (' + destinationDir + ') to extract ' + resource + ' to.');
        }
      }
      var sha256SumFile = this.toFile_pdl1vz$(this.normalize_pdl1vz$(destinationDirNormalized + String.fromCharCode(unboxChar(this.fsSeparator)) + FILE_NAME_SHA256_TOR));
      filesWritten.add_11rb$(sha256SumFile);
      var sha256SumValue = resource.sha256sum;
      var isSha256SumValid = this.checkSha256SumFile_0(sha256SumFile, sha256SumValue);
      var resourceDirPath = resource.resourceDirPath;
      var extractResourceTo = ArrayList_init(manifest.size);
      var shouldExtract = {v: !isSha256SumValid || cleanExtraction};
      var torFile = {v: null};
      var separator = first(destinationDirNormalized) === 47 ? 47 : 92;
      var destination = ArrayList_init(collectionSizeOrDefault(manifest, 10));
      var tmp$_3;
      tmp$_3 = manifest.iterator();
      while (tmp$_3.hasNext()) {
        var item = tmp$_3.next();
        var tmp$_4 = destination.add_11rb$;
        var sep = endsWith(destinationDirNormalized, separator) ? '' : toBoxedChar(separator);
        var mapped = destinationDirNormalized + toString(sep) + substringBeforeLast(replace(item, 47, separator), '.gz');
        ExtractorDelegate$extract$lambda(this, extractResourceTo, resourceDirPath, torFile, shouldExtract)(item, mapped);
        tmp$_4.call(destination, mapped);
      }
      var tmp$_5;
      tmp$_5 = extractResourceTo.iterator();
      while (tmp$_5.hasNext()) {
        var element = tmp$_5.next();
        filesWritten.add_11rb$(element.second);
        if (shouldExtract.v) {
          var gunzipStream = this.gunzip_nqi3in$(provideStream(element.first));
          this.write_74fv1b$(element.second, gunzipStream);
        }
        this.setExecutable_trkh7z$(element.second);
      }
      if (!isSha256SumValid) {
        this.writeText_reudxd$(sha256SumFile, sha256SumValue);
      }
      tmp$_0 = this.canonicalPath_trkh7z$(torFile.v);
      if (tmp$_0 == null) {
        throw new NullPointerException('Tor binary file was not found after extraction');
      }
      return tmp$_0;
    } catch (e) {
      if (Kotlin.isType(e, ExtractionException)) {
        tmp$_1 = filesWritten.iterator();
        while (tmp$_1.hasNext()) {
          var file = tmp$_1.next();
          try {
            this.delete_trkh7z$(file);
          } catch (_) {
            if (!Kotlin.isType(_, Exception))
              throw _;
          }
        }
        throw e;
      } else if (Kotlin.isType(e, Exception)) {
        tmp$_2 = filesWritten.iterator();
        while (tmp$_2.hasNext()) {
          var file_0 = tmp$_2.next();
          try {
            this.delete_trkh7z$(file_0);
          } catch (_) {
            if (!Kotlin.isType(_, Exception))
              throw _;
          }
        }
        throw ExtractionException_init_0('Failed to extract ' + resource + ' to ' + destinationDir, e);
      } else
        throw e;
    }
  };
  ExtractorDelegate.prototype.resourceNotFound_ldd2zj$ = function (resource, t) {
    return ExtractionException_init_0('Resource not found: ' + resource, t);
  };
  ExtractorDelegate.prototype.checkSha256SumFile_0 = function (file, sha256Sum) {
    var tmp$;
    try {
      if (this.exists_trkh7z$(file)) {
        if (this.isFile_trkh7z$(file)) {
          tmp$ = equals(this.readText_trkh7z$(file), sha256Sum);
        } else {
          tmp$ = false;
        }
      } else {
        tmp$ = false;
      }
    } catch (_) {
      if (Kotlin.isType(_, Throwable)) {
        tmp$ = false;
      } else
        throw _;
    }
    return tmp$;
  };
  ExtractorDelegate.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ExtractorDelegate',
    interfaces: []
  };
  function Extractor() {
    this.delegate_0 = new ExtractorDelegateJs();
  }
  function Extractor$extract$lambda(this$Extractor) {
    return function (resourcePath) {
      var tmp$;
      var modulePath = 'kmp-tor-binary-geoip/' + resourcePath;
      try {
        tmp$ = this$Extractor.resolveResource_0(modulePath);
      } catch (t) {
        if (Kotlin.isType(t, Throwable)) {
          throw this$Extractor.delegate_0.resourceNotFound_ldd2zj$(modulePath, t);
        } else
          throw t;
      }
      var resolvedPath = tmp$;
      return readFileSync(resolvedPath);
    };
  }
  Extractor.prototype.extract_k40kgv$ = function (resource, destination, cleanExtraction) {
    this.delegate_0.extract_ya0pjd$(resource, destination, cleanExtraction, Extractor$extract$lambda(this));
  };
  function Extractor$extract$lambda_0(closure$resource, this$Extractor) {
    return function (resourcePath) {
      var tmp$, tmp$_0, tmp$_1;
      tmp$ = closure$resource;
      if (Kotlin.isType(tmp$, TorResourceLinuxX64))
        tmp$_0 = 'kmp-tor-binary-linuxx64';
      else if (Kotlin.isType(tmp$, TorResourceLinuxX86))
        tmp$_0 = 'kmp-tor-binary-linuxx86';
      else if (Kotlin.isType(tmp$, TorResourceMacosArm64))
        tmp$_0 = 'kmp-tor-binary-macosarm64';
      else if (Kotlin.isType(tmp$, TorResourceMacosX64))
        tmp$_0 = 'kmp-tor-binary-macosx64';
      else if (Kotlin.isType(tmp$, TorResourceMingwX64))
        tmp$_0 = 'kmp-tor-binary-mingwx64';
      else if (Kotlin.isType(tmp$, TorResourceMingwX86))
        tmp$_0 = 'kmp-tor-binary-mingwx86';
      else
        tmp$_0 = Kotlin.noWhenBranchMatched();
      var modulePath = tmp$_0 + ('/' + resourcePath);
      try {
        tmp$_1 = this$Extractor.resolveResource_0(modulePath);
      } catch (t) {
        if (Kotlin.isType(t, Throwable)) {
          throw this$Extractor.delegate_0.resourceNotFound_ldd2zj$(modulePath, t);
        } else
          throw t;
      }
      var resolvedPath = tmp$_1;
      return readFileSync(resolvedPath);
    };
  }
  Extractor.prototype.extract_raz99$ = function (resource, destinationDir, cleanExtraction) {
    return this.delegate_0.extract_9xq8ib$(resource, destinationDir, cleanExtraction, Extractor$extract$lambda_0(resource, this));
  };
  Extractor.prototype.resolveResource_0 = function (path) {
    var tmp$;
    return typeof (tmp$ = require.resolve(path)) === 'string' ? tmp$ : throwCCE();
  };
  Extractor.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Extractor',
    interfaces: []
  };
  function ExtractorDelegateJs() {
    ExtractorDelegateJs$Companion_getInstance();
    ExtractorDelegate.call(this);
  }
  ExtractorDelegateJs.prototype.toFile_pdl1vz$ = function ($receiver) {
    return $receiver;
  };
  ExtractorDelegateJs.prototype.normalize_pdl1vz$ = function ($receiver) {
    return normalize($receiver);
  };
  Object.defineProperty(ExtractorDelegateJs.prototype, 'fsSeparator', {
    configurable: true,
    get: function () {
      try {
        return toBoxedChar(first($module$path.sep));
      } catch (_) {
        if (Kotlin.isType(_, Throwable)) {
          return toBoxedChar(47);
        } else
          throw _;
      }
    }
  });
  ExtractorDelegateJs.prototype.isFile_trkh7z$ = function (file) {
    return lstatSync(file).isFile();
  };
  ExtractorDelegateJs.prototype.isDirectory_trkh7z$ = function (file) {
    return lstatSync(file).isDirectory();
  };
  ExtractorDelegateJs.prototype.exists_trkh7z$ = function (file) {
    return existsSync(file);
  };
  ExtractorDelegateJs.prototype.nameWithoutExtension_trkh7z$ = function (file) {
    return substringBeforeLast_0(substringAfterLast(file, $module$path.sep), 46);
  };
  ExtractorDelegateJs.prototype.canonicalPath_trkh7z$ = function (file) {
    return file != null ? realpathSync(file) : null;
  };
  ExtractorDelegateJs.prototype.setExecutable_trkh7z$ = function (file) {
    try {
      chmodSync(file, ExtractorDelegateJs$Companion_getInstance().S_IXUSR_0);
    } catch (_) {
      if (!Kotlin.isType(_, Throwable))
        throw _;
    }
  };
  ExtractorDelegateJs.prototype.delete_trkh7z$ = function (file) {
    try {
      rmSync(file, new OptionsRm());
    } catch (_) {
      if (!Kotlin.isType(_, Throwable))
        throw _;
    }
    return !this.exists_trkh7z$(file);
  };
  ExtractorDelegateJs.prototype.mkdirs_trkh7z$ = function (file) {
    try {
      mkdirSync(file);
    } catch (_) {
      if (!Kotlin.isType(_, Throwable))
        throw _;
    }
    return this.exists_trkh7z$(file) && this.isDirectory_trkh7z$(file);
  };
  ExtractorDelegateJs.prototype.gunzip_nqi3in$ = function (stream) {
    return gunzipSync(stream);
  };
  ExtractorDelegateJs.prototype.readText_trkh7z$ = function (file) {
    var tmp$;
    return typeof (tmp$ = readFileSync(file, new OptionsReadFile())) === 'string' ? tmp$ : throwCCE();
  };
  ExtractorDelegateJs.prototype.writeText_reudxd$ = function (file, text) {
    writeFileSync(file, text);
  };
  ExtractorDelegateJs.prototype.write_74fv1b$ = function ($receiver, stream) {
    var parentDir = substringBeforeLast($receiver, $module$path.sep);
    if (!this.exists_trkh7z$(parentDir) && !this.mkdirs_trkh7z$(parentDir)) {
      throw ExtractionException_init('Failed to create directory ' + parentDir);
    }
    if (this.exists_trkh7z$($receiver) && !this.delete_trkh7z$($receiver)) {
      throw ExtractionException_init('Failed to delete file ' + $receiver + ' before overwriting it.');
    }
    try {
      writeFileSync($receiver, stream);
    } catch (t) {
      if (Kotlin.isType(t, Throwable)) {
        throw ExtractionException_init_0('Failed to write data to ' + $receiver, t);
      } else
        throw t;
    }
  };
  function ExtractorDelegateJs$Companion() {
    ExtractorDelegateJs$Companion_instance = this;
    this.S_IXUSR_0 = 61696;
  }
  ExtractorDelegateJs$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ExtractorDelegateJs$Companion_instance = null;
  function ExtractorDelegateJs$Companion_getInstance() {
    if (ExtractorDelegateJs$Companion_instance === null) {
      new ExtractorDelegateJs$Companion();
    }
    return ExtractorDelegateJs$Companion_instance;
  }
  ExtractorDelegateJs.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ExtractorDelegateJs',
    interfaces: [ExtractorDelegate]
  };
  function OptionsReadFile(encoding) {
    if (encoding === void 0)
      encoding = 'utf8';
    this.encoding = encoding;
  }
  OptionsReadFile.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OptionsReadFile',
    interfaces: []
  };
  function OptionsRm(force, recursive) {
    if (force === void 0)
      force = true;
    if (recursive === void 0)
      recursive = true;
    this.force = force;
    this.recursive = recursive;
  }
  OptionsRm.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OptionsRm',
    interfaces: []
  };
  function TorResource() {
  }
  function TorResource$Geoips() {
    TorResource.call(this);
  }
  TorResource$Geoips.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Geoips',
    interfaces: [TorResource]
  };
  function TorResource$Binaries() {
    TorResource.call(this);
  }
  TorResource$Binaries.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Binaries',
    interfaces: [TorResource]
  };
  TorResource.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TorResource',
    interfaces: []
  };
  function TorResourceLinuxX64() {
    TorResourceLinuxX64_instance = this;
    TorResource$Binaries.call(this);
  }
  Object.defineProperty(TorResourceLinuxX64.prototype, 'resourceDirPath', {
    configurable: true,
    get: function () {
      return 'kmptor/linux/x64';
    }
  });
  Object.defineProperty(TorResourceLinuxX64.prototype, 'resourceManifest', {
    configurable: true,
    get: function () {
      return listOf(['libcrypto.so.1.1.gz', 'libevent-2.1.so.7.gz', 'libssl.so.1.1.gz', 'libstdc++.so.6.gz', 'tor.gz']);
    }
  });
  Object.defineProperty(TorResourceLinuxX64.prototype, 'sha256sum', {
    configurable: true,
    get: function () {
      return '7ea1e0a19f63d2542b34e1cfe8f8135b278a0eea5a7fd8d25e78e12972834ae2';
    }
  });
  TorResourceLinuxX64.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TorResourceLinuxX64',
    interfaces: [TorResource$Binaries]
  };
  var TorResourceLinuxX64_instance = null;
  function TorResourceLinuxX64_getInstance() {
    if (TorResourceLinuxX64_instance === null) {
      new TorResourceLinuxX64();
    }
    return TorResourceLinuxX64_instance;
  }
  function TorResourceLinuxX86() {
    TorResourceLinuxX86_instance = this;
    TorResource$Binaries.call(this);
  }
  Object.defineProperty(TorResourceLinuxX86.prototype, 'resourceDirPath', {
    configurable: true,
    get: function () {
      return 'kmptor/linux/x86';
    }
  });
  Object.defineProperty(TorResourceLinuxX86.prototype, 'resourceManifest', {
    configurable: true,
    get: function () {
      return listOf(['libcrypto.so.1.1.gz', 'libevent-2.1.so.7.gz', 'libssl.so.1.1.gz', 'libstdc++.so.6.gz', 'tor.gz']);
    }
  });
  Object.defineProperty(TorResourceLinuxX86.prototype, 'sha256sum', {
    configurable: true,
    get: function () {
      return '187d67cd9307c4993563b6b1a960126a1501b710f4af82d58ea442be11bd965d';
    }
  });
  TorResourceLinuxX86.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TorResourceLinuxX86',
    interfaces: [TorResource$Binaries]
  };
  var TorResourceLinuxX86_instance = null;
  function TorResourceLinuxX86_getInstance() {
    if (TorResourceLinuxX86_instance === null) {
      new TorResourceLinuxX86();
    }
    return TorResourceLinuxX86_instance;
  }
  function TorResourceMacosX64() {
    TorResourceMacosX64_instance = this;
    TorResource$Binaries.call(this);
  }
  Object.defineProperty(TorResourceMacosX64.prototype, 'resourceDirPath', {
    configurable: true,
    get: function () {
      return 'kmptor/macos/x64';
    }
  });
  Object.defineProperty(TorResourceMacosX64.prototype, 'resourceManifest', {
    configurable: true,
    get: function () {
      return listOf(['libevent-2.1.7.dylib.gz', 'tor.gz']);
    }
  });
  Object.defineProperty(TorResourceMacosX64.prototype, 'sha256sum', {
    configurable: true,
    get: function () {
      return '7c5687a3916483ee6c402ed77a99c6025c19b1bfdf54cb6e2e00601642451c82';
    }
  });
  TorResourceMacosX64.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TorResourceMacosX64',
    interfaces: [TorResource$Binaries]
  };
  var TorResourceMacosX64_instance = null;
  function TorResourceMacosX64_getInstance() {
    if (TorResourceMacosX64_instance === null) {
      new TorResourceMacosX64();
    }
    return TorResourceMacosX64_instance;
  }
  function TorResourceMacosArm64() {
    TorResourceMacosArm64_instance = this;
    TorResource$Binaries.call(this);
  }
  Object.defineProperty(TorResourceMacosArm64.prototype, 'resourceDirPath', {
    configurable: true,
    get: function () {
      return 'kmptor/macos/arm64';
    }
  });
  Object.defineProperty(TorResourceMacosArm64.prototype, 'resourceManifest', {
    configurable: true,
    get: function () {
      return listOf(['libevent-2.1.7.dylib.gz', 'tor.gz']);
    }
  });
  Object.defineProperty(TorResourceMacosArm64.prototype, 'sha256sum', {
    configurable: true,
    get: function () {
      return '0d9217a47af322d72e9213c1afdd53f4f571ff0483d8053726e56efeec850ff1';
    }
  });
  TorResourceMacosArm64.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TorResourceMacosArm64',
    interfaces: [TorResource$Binaries]
  };
  var TorResourceMacosArm64_instance = null;
  function TorResourceMacosArm64_getInstance() {
    if (TorResourceMacosArm64_instance === null) {
      new TorResourceMacosArm64();
    }
    return TorResourceMacosArm64_instance;
  }
  function TorResourceMingwX64() {
    TorResourceMingwX64_instance = this;
    TorResource$Binaries.call(this);
  }
  Object.defineProperty(TorResourceMingwX64.prototype, 'resourceDirPath', {
    configurable: true,
    get: function () {
      return 'kmptor/mingw/x64';
    }
  });
  Object.defineProperty(TorResourceMingwX64.prototype, 'resourceManifest', {
    configurable: true,
    get: function () {
      return listOf(['tor.exe.gz', 'tor-gencert.exe.gz']);
    }
  });
  Object.defineProperty(TorResourceMingwX64.prototype, 'sha256sum', {
    configurable: true,
    get: function () {
      return 'f228252a094f3fed8d9d08d6b98f1925644cfbbf59fbd08c566bf184027068e4';
    }
  });
  TorResourceMingwX64.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TorResourceMingwX64',
    interfaces: [TorResource$Binaries]
  };
  var TorResourceMingwX64_instance = null;
  function TorResourceMingwX64_getInstance() {
    if (TorResourceMingwX64_instance === null) {
      new TorResourceMingwX64();
    }
    return TorResourceMingwX64_instance;
  }
  function TorResourceMingwX86() {
    TorResourceMingwX86_instance = this;
    TorResource$Binaries.call(this);
  }
  Object.defineProperty(TorResourceMingwX86.prototype, 'resourceDirPath', {
    configurable: true,
    get: function () {
      return 'kmptor/mingw/x86';
    }
  });
  Object.defineProperty(TorResourceMingwX86.prototype, 'resourceManifest', {
    configurable: true,
    get: function () {
      return listOf(['tor.exe.gz', 'tor-gencert.exe.gz']);
    }
  });
  Object.defineProperty(TorResourceMingwX86.prototype, 'sha256sum', {
    configurable: true,
    get: function () {
      return '6c5bb29ef588c6685283b68d616586781ae84bd0ae20ee7eb3aba66351c3a051';
    }
  });
  TorResourceMingwX86.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TorResourceMingwX86',
    interfaces: [TorResource$Binaries]
  };
  var TorResourceMingwX86_instance = null;
  function TorResourceMingwX86_getInstance() {
    if (TorResourceMingwX86_instance === null) {
      new TorResourceMingwX86();
    }
    return TorResourceMingwX86_instance;
  }
  var package$io = _.io || (_.io = {});
  var package$matthewnelson = package$io.matthewnelson || (package$io.matthewnelson = {});
  var package$kmp = package$matthewnelson.kmp || (package$matthewnelson.kmp = {});
  var package$tor = package$kmp.tor || (package$kmp.tor = {});
  var package$binary = package$tor.binary || (package$tor.binary = {});
  var package$extract = package$binary.extract || (package$binary.extract = {});
  package$extract.ExtractionException_init_61zpoe$ = ExtractionException_init;
  package$extract.ExtractionException_init_n892rm$ = ExtractionException_init_0;
  package$extract.ExtractionException = ExtractionException;
  Object.defineProperty(package$extract, 'TorResourceGeoip', {
    get: TorResourceGeoip_getInstance
  });
  Object.defineProperty(package$extract, 'TorResourceGeoip6', {
    get: TorResourceGeoip6_getInstance
  });
  var package$internal = package$extract.internal || (package$extract.internal = {});
  package$internal.mapManifestToDestination_clzgi8$ = mapManifestToDestination;
  Object.defineProperty(package$internal, 'FILE_NAME_SHA256_SUFFIX_8be2vx$', {
    get: function () {
      return FILE_NAME_SHA256_SUFFIX;
    }
  });
  Object.defineProperty(package$internal, 'FILE_NAME_SHA256_TOR_8be2vx$', {
    get: function () {
      return FILE_NAME_SHA256_TOR;
    }
  });
  $$importsForInline$$['kmp-tor-binary-kmp-tor-binary-extract-js-legacy'] = _;
  package$internal.ExtractorDelegate = ExtractorDelegate;
  package$extract.Extractor = Extractor;
  Object.defineProperty(ExtractorDelegateJs, 'Companion', {
    get: ExtractorDelegateJs$Companion_getInstance
  });
  package$internal.ExtractorDelegateJs = ExtractorDelegateJs;
  package$internal.OptionsReadFile = OptionsReadFile;
  package$internal.OptionsRm = OptionsRm;
  TorResource.Geoips = TorResource$Geoips;
  TorResource.Binaries = TorResource$Binaries;
  package$extract.TorResource = TorResource;
  Object.defineProperty(package$extract, 'TorResourceLinuxX64', {
    get: TorResourceLinuxX64_getInstance
  });
  Object.defineProperty(package$extract, 'TorResourceLinuxX86', {
    get: TorResourceLinuxX86_getInstance
  });
  Object.defineProperty(package$extract, 'TorResourceMacosX64', {
    get: TorResourceMacosX64_getInstance
  });
  Object.defineProperty(package$extract, 'TorResourceMacosArm64', {
    get: TorResourceMacosArm64_getInstance
  });
  Object.defineProperty(package$extract, 'TorResourceMingwX64', {
    get: TorResourceMingwX64_getInstance
  });
  Object.defineProperty(package$extract, 'TorResourceMingwX86', {
    get: TorResourceMingwX86_getInstance
  });
  FILE_NAME_SHA256_SUFFIX = '_sha256.txt';
  FILE_NAME_SHA256_TOR = 'tor_sha256.txt';
  Kotlin.defineModule('kmp-tor-binary-kmp-tor-binary-extract-js-legacy', _);
  return _;
}));

//# sourceMappingURL=kmp-tor-binary-kmp-tor-binary-extract-js-legacy.js.map
