/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.test.jupiter;

import io.mats3.MatsFactory;
import io.mats3.MatsInitiator;
import io.mats3.serial.MatsSerializer;
import io.mats3.serial.json.MatsSerializerJson;
import io.mats3.test.MatsTestBrokerInterface;
import io.mats3.test.MatsTestLatch;
import io.mats3.test.jupiter.Extension_Mats;
import io.mats3.test.jupiter.Extension_MatsAnnotatedClass;
import io.mats3.test.jupiter.Extension_MatsEndpoint;
import io.mats3.util.MatsFuturizer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@ExtendWith(value={Extension_MatsRegistration.class, ParameterResolver_MatsEntities.class, FieldProcess_MatsTestAnnotations.class})
public @interface MatsTest {
    public boolean db() default false;

    public Class<? extends SerializerFactory> serializerFactory() default SerializerFactoryJson.class;

    public Class<?>[] matsAnnotatedClasses() default {};

    public static class FieldProcess_MatsTestAnnotations
    implements Extension,
    BeforeEachCallback,
    AfterEachCallback {
        private static final String LOG_PREFIX = "#MATSTEST:MTA# ";
        private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{Extension_Mats.class.getName()});
        private static final Logger log = LoggerFactory.getLogger(FieldProcess_MatsTestAnnotations.class);
        private final List<Extension_MatsEndpoint<?, ?>> _createdTestEndpoints = new ArrayList();

        private static Extension_MatsAnnotatedClass lazyGet(ExtensionContext context) {
            return (Extension_MatsAnnotatedClass)((Object)context.getStore(NAMESPACE).get((Object)FieldProcess_MatsTestAnnotations.class.getName(), Extension_MatsAnnotatedClass.class));
        }

        private static Extension_MatsAnnotatedClass lazyCreate(ExtensionContext context) {
            Extension_MatsAnnotatedClass lazy = FieldProcess_MatsTestAnnotations.lazyGet(context);
            if (lazy == null) {
                lazy = Extension_MatsAnnotatedClass.create();
                context.getStore(NAMESPACE).put((Object)FieldProcess_MatsTestAnnotations.class.getName(), (Object)lazy);
            }
            return lazy;
        }

        public void beforeEach(ExtensionContext context) throws IllegalAccessException {
            for (Object testInstance : context.getRequiredTestInstances().getAllInstances()) {
                Field[] declaredFields;
                Class<?> testClass = testInstance.getClass();
                for (Field declaredField : declaredFields = testClass.getDeclaredFields()) {
                    if (declaredField.isAnnotationPresent(MatsTestEndpoint.class)) {
                        this.injectTestEndpoint(context, testInstance, declaredField);
                        continue;
                    }
                    if (declaredField.isAnnotationPresent(MatsTestAnnotatedClass.class)) {
                        this.injectMatsAnnotatedClass(context, testInstance, declaredField);
                        continue;
                    }
                    log.debug("#MATSTEST:MTA# Field [" + declaredField + "] in test class [" + testClass + "] is not annotated with @MatsTest annotations, so it will not be injected.");
                }
            }
            MatsTest matsTest = context.getRequiredTestClass().getAnnotation(MatsTest.class);
            if (matsTest != null) {
                for (Class<?> matsAnnotatedClass : matsTest.matsAnnotatedClasses()) {
                    FieldProcess_MatsTestAnnotations.lazyCreate(context).withAnnotatedMatsClasses(matsAnnotatedClass);
                }
            }
            if (FieldProcess_MatsTestAnnotations.lazyGet(context) != null) {
                FieldProcess_MatsTestAnnotations.lazyGet(context).beforeEach(context);
            }
        }

        public void afterEach(ExtensionContext context) {
            this._createdTestEndpoints.forEach(extensionMatsEndpoint -> extensionMatsEndpoint.afterEach(context));
            if (FieldProcess_MatsTestAnnotations.lazyGet(context) != null) {
                FieldProcess_MatsTestAnnotations.lazyGet(context).afterEach(context);
            }
        }

        private void injectTestEndpoint(ExtensionContext context, Object testInstance, Field declaredField) throws IllegalAccessException {
            if (!declaredField.trySetAccessible()) {
                throw new IllegalStateException("Could not set accessible on field [" + declaredField + "], in test class [" + declaredField.getDeclaringClass() + "]. We are not able to inject the MatsEndpoint into this class.");
            }
            if (!Extension_MatsEndpoint.class.equals(declaredField.getType())) {
                throw new IllegalStateException("Field [" + declaredField + "] in test class [" + declaredField.getDeclaringClass() + "] is not of type Extension_MatsEndpoint.");
            }
            if (declaredField.get(testInstance) != null) {
                log.debug("#MATSTEST:MTA# Field [" + declaredField + "] in test class [" + declaredField.getDeclaringClass() + "] is already initialized, skipping.");
                return;
            }
            Type[] endpointTypeArguments = ((ParameterizedType)declaredField.getGenericType()).getActualTypeArguments();
            Class replyMsgClass = (Class)endpointTypeArguments[0];
            Class incomingMsgClass = (Class)endpointTypeArguments[1];
            MatsTestEndpoint matsTestEndpoint = declaredField.getAnnotation(MatsTestEndpoint.class);
            Extension_MatsEndpoint extensionMatsEndpoint = Extension_MatsEndpoint.create(matsTestEndpoint.endpointId(), replyMsgClass, incomingMsgClass);
            extensionMatsEndpoint.beforeEach(context);
            this._createdTestEndpoints.add(extensionMatsEndpoint);
            log.info("#MATSTEST:MTA# Injecting MatsEndpoint [" + matsTestEndpoint.endpointId() + "] into field [" + declaredField + "] in test class [" + declaredField.getDeclaringClass() + "].");
            declaredField.set(testInstance, (Object)extensionMatsEndpoint);
        }

        private void injectMatsAnnotatedClass(ExtensionContext context, Object testInstance, Field declaredField) throws IllegalAccessException {
            if (!declaredField.trySetAccessible()) {
                throw new IllegalStateException("Could not set accessible on field [" + declaredField + "] in test class [" + declaredField.getDeclaringClass() + "]. We are not able to register the annotated class [" + declaredField.getType() + "].");
            }
            Object fieldValue = declaredField.get(testInstance);
            if (fieldValue == null) {
                log.info("#MATSTEST:MTA# Registering annotated field [" + declaredField.getName() + "] in test class [" + declaredField.getDeclaringClass() + "] without an instance as an Annotated Class.");
                FieldProcess_MatsTestAnnotations.lazyCreate(context).withAnnotatedMatsClasses(declaredField.getType());
            } else {
                log.info("#MATSTEST:MTA# Registering annotated field [" + declaredField.getName() + "] in test class [" + declaredField.getDeclaringClass() + "] with an instance [" + fieldValue + "] as an Annotated Instance.");
                FieldProcess_MatsTestAnnotations.lazyCreate(context).withAnnotatedMatsInstances(fieldValue);
            }
        }
    }

    public static class ParameterResolver_MatsEntities
    implements ParameterResolver {
        private static final Set<Class<?>> SUPPORTED_TYPES = Set.of(Extension_Mats.class, MatsFactory.class, MatsFuturizer.class, MatsInitiator.class, MatsTestLatch.class, MatsTestBrokerInterface.class, DataSource.class);

        public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
            if (Extension_Mats.findFromContext(extensionContext).isEmpty()) {
                return false;
            }
            return SUPPORTED_TYPES.contains(parameterContext.getParameter().getType());
        }

        public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
            Extension_Mats extensionMats = Extension_Mats.findFromContext(extensionContext).orElseThrow(() -> new IllegalStateException("Could not find Extension_Mats in the test context. This should not happen, as we already verified that it was present in #supportsParameter."));
            if (parameterContext.getParameter().getType().equals(Extension_Mats.class)) {
                return extensionMats;
            }
            if (parameterContext.getParameter().getType().equals(MatsFactory.class)) {
                return extensionMats.getMatsFactory();
            }
            if (parameterContext.getParameter().getType().equals(MatsFuturizer.class)) {
                return extensionMats.getMatsFuturizer();
            }
            if (parameterContext.getParameter().getType().equals(MatsInitiator.class)) {
                return extensionMats.getMatsInitiator();
            }
            if (parameterContext.getParameter().getType().equals(MatsTestLatch.class)) {
                return extensionMats.getMatsTestLatch();
            }
            if (parameterContext.getParameter().getType().equals(MatsTestBrokerInterface.class)) {
                return extensionMats.getMatsTestBrokerInterface();
            }
            if (parameterContext.getParameter().getType().equals(DataSource.class)) {
                return extensionMats.getDataSource();
            }
            throw new IllegalStateException("Could not resolve parameter [" + parameterContext.getParameter() + "].");
        }
    }

    public static class Extension_MatsRegistration
    implements Extension,
    BeforeAllCallback,
    AfterAllCallback {
        public void beforeAll(ExtensionContext context) throws ReflectiveOperationException {
            if (Extension_Mats.findFromContext(context).isPresent()) {
                return;
            }
            MatsTest matsTest = context.getRequiredTestClass().getAnnotation(MatsTest.class);
            if (matsTest == null) {
                return;
            }
            SerializerFactory serializerFactory = matsTest.serializerFactory().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            MatsSerializer matsSerializer = serializerFactory.createSerializer();
            Extension_Mats extensionMats = matsTest.db() ? Extension_Mats.createWithDb(matsSerializer) : Extension_Mats.create(matsSerializer);
            extensionMats.beforeAll(context);
        }

        public void afterAll(ExtensionContext context) {
            Extension_Mats.findFromContext(context).ifPresent(extensionMats -> extensionMats.afterAll(context));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface MatsTestAnnotatedClass {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface MatsTestEndpoint {
        public String endpointId();
    }

    public static class SerializerFactoryJson
    implements SerializerFactory {
        @Override
        public MatsSerializer createSerializer() {
            return MatsSerializerJson.create();
        }
    }

    public static interface SerializerFactory {
        public MatsSerializer createSerializer();
    }
}

