/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.test.jupiter;

import io.mats3.serial.MatsSerializer;
import io.mats3.serial.json.MatsSerializerJson;
import io.mats3.test.TestH2DataSource;
import io.mats3.test.abstractunit.AbstractMatsTest;
import java.util.Optional;
import javax.sql.DataSource;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Extension_Mats
extends AbstractMatsTest
implements BeforeAllCallback,
AfterAllCallback {
    private static final Logger log = LoggerFactory.getLogger(Extension_Mats.class);
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{Extension_Mats.class.getName()});

    protected Extension_Mats(MatsSerializer<?> matsSerializer) {
        super(matsSerializer);
    }

    protected Extension_Mats(MatsSerializer<?> matsSerializer, DataSource dataSource) {
        super(matsSerializer, dataSource);
    }

    public static Extension_Mats create() {
        return new Extension_Mats((MatsSerializer<?>)MatsSerializerJson.create());
    }

    public static Extension_Mats create(MatsSerializer<?> matsSerializer) {
        return new Extension_Mats(matsSerializer);
    }

    public static Extension_Mats createWithDb() {
        return Extension_Mats.createWithDb(MatsSerializerJson.create());
    }

    public static Extension_Mats createWithDb(MatsSerializer<?> matsSerializer) {
        TestH2DataSource testH2DataSource = TestH2DataSource.createStandard();
        return new Extension_Mats(matsSerializer, (DataSource)testH2DataSource);
    }

    public static Optional<Extension_Mats> findFromContext(ExtensionContext extensionContext) {
        return Optional.ofNullable((Extension_Mats)((Object)extensionContext.getRoot().getStore(NAMESPACE).get(Extension_Mats.class, Extension_Mats.class)));
    }

    public void beforeAll(ExtensionContext context) {
        ExtensionContext root;
        if (log.isDebugEnabled()) {
            log.debug("#MATSTEST# beforeAll: Context chain to root: " + this.getContextsToRoot(context));
        }
        if ((root = context.getRoot()).getStore(NAMESPACE).get(Extension_Mats.class, Extension_Mats.class) != null) {
            log.info("#MATSTEST# INIT SKIPPED: beforeAll on Jupiter @Extension " + this.idThis() + " for " + this.id(context) + " - skipping since the root context already has Extension_Mats present.");
            return;
        }
        log.info("#MATSTEST# INIT: beforeAll on Jupiter @Extension " + this.idThis() + " for " + this.id(context) + ", root is " + this.id(root) + " - setting up MQ Broker and JMS MatsFactory.");
        root.getStore(NAMESPACE).put(Extension_Mats.class, (Object)this);
        root.getStore(NAMESPACE).put((Object)(Extension_Mats.class.getName() + ".contextAdder"), (Object)context);
        super.beforeAll();
        log.info("#MATSTEST# -- init done: beforeAll on Jupiter @Extension " + this.idThis() + ", put it in root context " + this.id(root) + ".");
    }

    public void afterAll(ExtensionContext context) {
        ExtensionContext root;
        ExtensionContext contextThatPutItInRoot;
        if (log.isDebugEnabled()) {
            log.debug("#MATSTEST# afterAll: Context chain to root: " + this.getContextsToRoot(context));
        }
        if ((contextThatPutItInRoot = (ExtensionContext)(root = context.getRoot()).getStore(NAMESPACE).get((Object)(Extension_Mats.class.getName() + ".contextAdder"), ExtensionContext.class)) != context) {
            log.info("#MATSTEST# CLEANUP SKIPPED: afterAll on Jupiter @Extension " + this.idThis() + " for " + this.id(context) + " - this level didn't initialize it.");
            return;
        }
        log.info("#MATSTEST# CLEANUP: afterAll on Jupiter @Extension " + this.idThis() + " for " + this.id(context) + ", root is " + this.id(root) + " - taking down JMS MatsFactory and MQ Broker.");
        super.afterAll();
        root.getStore(NAMESPACE).remove(Extension_Mats.class);
        log.info("#MATSTEST# -- cleanup done: afterAll on Jupiter @Extension " + this.idThis() + ".");
    }

    private String getContextsToRoot(ExtensionContext context) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (context != null) {
            if (first) {
                first = false;
            } else {
                sb.append(" -> ");
            }
            sb.append(this.id(context));
            context = context.getParent().orElse(null);
        }
        return sb.toString();
    }
}

