/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.spring;

import io.mats3.MatsEndpoint;
import io.mats3.MatsFactory;
import io.mats3.MatsInitiator;
import io.mats3.MatsStage;
import io.mats3.spring.Dto;
import io.mats3.spring.MatsClassMapping;
import io.mats3.spring.MatsEndpointSetup;
import io.mats3.spring.MatsMapping;
import io.mats3.spring.Sto;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Role;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.SpringVersion;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@Role(value=2)
@Component
public class MatsSpringAnnotationRegistration
implements BeanPostProcessor,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(MatsSpringAnnotationRegistration.class);
    private static final String LOG_PREFIX = "#SPRINGMATS# ";
    private ConfigurableApplicationContext _configurableApplicationContext;
    private ConfigurableListableBeanFactory _configurableListableBeanFactory;
    private final Map<String, MatsFactory> _matsFactories = new HashMap<String, MatsFactory>();
    private final IdentityHashMap<MatsFactory, String> _matsFactoriesToName = new IdentityHashMap();
    private final Set<Class<?>> _classesWithNoMatsMappingAnnotations = ConcurrentHashMap.newKeySet();
    private final List<MatsMappingHolder> _matsMappingMethods = new ArrayList<MatsMappingHolder>();
    private final List<MatsEndpointSetupHolder> _matsStagedMethods = new ArrayList<MatsEndpointSetupHolder>();
    private final List<MatsClassMappingHolder> _matsStagedClasses = new ArrayList<MatsClassMappingHolder>();
    private boolean _contextHasBeenRefreshed;
    private final Map<String, MatsFactory> _cache_MatsFactoryByBeanName = new HashMap<String, MatsFactory>();
    private final Map<String, MatsFactory> _cache_MatsFactoryByQualifierValue = new HashMap<String, MatsFactory>();
    private final Map<Class<? extends Annotation>, Map<Annotation, MatsFactory>> _cache_MatsFactoryByCustomQualifier = new HashMap<Class<? extends Annotation>, Map<Annotation, MatsFactory>>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        log.info((Object)("#SPRINGMATS# ApplicationContextAware.setApplicationContext('" + applicationContext.getClass().getSimpleName() + "'). Spring Version: [" + SpringVersion.getVersion() + "]. ApplicationContext: " + applicationContext));
        if (!(applicationContext instanceof ConfigurableApplicationContext)) {
            throw new IllegalStateException("The ApplicationContext when using Mats' SpringConfig must implement " + ConfigurableApplicationContext.class.getSimpleName() + ", while the provided ApplicationContext is of type [" + applicationContext.getClass().getName() + "], and evidently don't.");
        }
        this._configurableApplicationContext = (ConfigurableApplicationContext)applicationContext;
        this._configurableListableBeanFactory = this._configurableApplicationContext.getBeanFactory();
    }

    private static Class<?> getClassOfBean(Object bean) {
        return ClassUtils.getUserClass((Object)bean);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Method method;
        Class<?> targetClass;
        BeanDefinition beanDefinition;
        try {
            beanDefinition = this._configurableListableBeanFactory.getBeanDefinition(beanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            log.info((Object)(LOG_PREFIX + this.getClass().getSimpleName() + ".postProcessAfterInitialization(bean, \"" + beanName + "\"): Found no bean definition for the given bean name! Test class?! Ignoring."));
            return bean;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(LOG_PREFIX + this.getClass().getSimpleName() + ".postProcessAfterInitialization(bean, \"" + beanName + "\") - bean class:[" + beanDefinition.getBeanClassName() + "], scope:[" + beanDefinition.getScope() + "]"));
        }
        if (bean instanceof MatsFactory) {
            MatsFactory matsFactory = (MatsFactory)bean;
            if (this._contextHasBeenRefreshed) {
                log.info((Object)("#SPRINGMATS# Found a MatsFactory [" + bean + "]. HOWEVER, the context is already refreshed, so we won't invoke matsFactory.holdEndpointsUntilFactoryIsStarted() - but instead invoke matsFactory.start(). This means that any not yet started endpoints will start, and any subsequently registered endpoints will start immediately. The reason why this has happened is most probably due to lazy initialization, where beans are being instantiated \"on demand\" after the  life cycle processing has happened (i.e. we got ContextRefreshedEvent already)."));
                matsFactory.start();
            } else {
                log.info((Object)("#SPRINGMATS# Found a MatsFactory [" + bean + "]. We invoke matsFactory.holdEndpointsUntilFactoryIsStarted(), ensuring that any subsequently registered endpoints is held until we explicitly invoke matsFactory.start() later at ContextRefreshedEvent, so that they do not start processing messages until the entire application is ready for service. We also sets the name to the beanName if not already set."));
                matsFactory.holdEndpointsUntilFactoryIsStarted();
            }
            this._matsFactories.put(beanName, matsFactory);
            this._matsFactoriesToName.put(matsFactory, beanName);
            if ("".equals(matsFactory.getFactoryConfig().getName())) {
                matsFactory.getFactoryConfig().setName(beanName);
            }
        }
        if (this._classesWithNoMatsMappingAnnotations.contains(targetClass = MatsSpringAnnotationRegistration.getClassOfBean(bean))) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("#SPRINGMATS# Already checked bean [" + beanName + "], bean class: [" + bean.getClass().getSimpleName() + "]: No Mats SpringConfig annotations."));
            }
            return bean;
        }
        Map<Method, Set<MatsMapping>> methodsWithMatsMappingAnnotations = this.findRepeatableAnnotatedMethods(targetClass, MatsMapping.class);
        Map<Method, Set<MatsEndpointSetup>> methodsWithMatsStagedAnnotations = this.findRepeatableAnnotatedMethods(targetClass, MatsEndpointSetup.class);
        Set matsEndpointSetupAnnotationsOnClasses = AnnotationUtils.getRepeatableAnnotations(targetClass, MatsClassMapping.class);
        if (methodsWithMatsMappingAnnotations.isEmpty() && methodsWithMatsStagedAnnotations.isEmpty() && matsEndpointSetupAnnotationsOnClasses.isEmpty()) {
            this._classesWithNoMatsMappingAnnotations.add(targetClass);
            if (log.isTraceEnabled()) {
                log.trace((Object)("#SPRINGMATS# No @MatsMapping, @MatsClassMapping or @MatsEndpointSetup annotations found on bean [" + beanName + "], bean class: [" + bean.getClass() + "], bean instance: [" + bean + "]."));
            }
            return bean;
        }
        if (!beanDefinition.isSingleton()) {
            throw new BeanCreationException("The bean [" + beanName + "] is not a singleton (scope: [" + beanDefinition.getScope() + "]), which does not make sense when it comes to beans that have methods annotated with @Mats..-annotations.");
        }
        for (Map.Entry<Method, Set<MatsMapping>> entry : methodsWithMatsMappingAnnotations.entrySet()) {
            method = entry.getKey();
            for (MatsMapping matsMapping : entry.getValue()) {
                log.info((Object)("#SPRINGMATS# Found @MatsMapping on method '" + MatsSpringAnnotationRegistration.simpleMethodDescription(method) + "' :#: Annotation:[" + matsMapping + "] :#: method:[" + method + "]."));
                this._matsMappingMethods.add(new MatsMappingHolder(matsMapping, method, bean));
                if (!this._contextHasBeenRefreshed) continue;
                log.info((Object)"#SPRINGMATS#  \\- ContextRefreshedEvent already run! Process right away!");
                this.processMatsMapping(matsMapping, method, bean);
            }
        }
        for (Map.Entry<Method, Set<Annotation>> entry : methodsWithMatsStagedAnnotations.entrySet()) {
            method = entry.getKey();
            for (MatsEndpointSetup matsEndpointSetup : entry.getValue()) {
                log.info((Object)("#SPRINGMATS# Found @MatsMapping on method '" + MatsSpringAnnotationRegistration.simpleMethodDescription(method) + "' :#: Annotation:[" + matsEndpointSetup + "] :#: method:[" + method + "]."));
                this._matsStagedMethods.add(new MatsEndpointSetupHolder(matsEndpointSetup, method, bean));
                if (!this._contextHasBeenRefreshed) continue;
                log.info((Object)"#SPRINGMATS#  \\- ContextRefreshedEvent already run! Process right away!");
                this.processMatsEndpointSetup(matsEndpointSetup, method, bean);
            }
        }
        for (MatsClassMapping matsClassMapping : matsEndpointSetupAnnotationsOnClasses) {
            log.info((Object)("#SPRINGMATS# Found @MatsClassMapping on bean '" + MatsSpringAnnotationRegistration.classNameWithoutPackage(ClassUtils.getUserClass(targetClass)) + "' :#: Annotation:[" + matsClassMapping + "] :#: class:[" + targetClass + "]."));
            this._matsStagedClasses.add(new MatsClassMappingHolder(matsClassMapping, bean));
            if (!this._contextHasBeenRefreshed) continue;
            log.info((Object)"#SPRINGMATS#  \\- ContextRefreshedEvent already run! Process right away!");
            this.processMatsClassMapping(matsClassMapping, bean);
        }
        return bean;
    }

    private <A extends Annotation> Map<Method, Set<A>> findRepeatableAnnotatedMethods(Class<?> targetClass, Class<A> repeatableAnnotationClass) {
        return MethodIntrospector.selectMethods(targetClass, method -> {
            Set matsMappingAnnotations = AnnotationUtils.getRepeatableAnnotations((AnnotatedElement)method, (Class)repeatableAnnotationClass);
            return !matsMappingAnnotations.isEmpty() ? matsMappingAnnotations : null;
        });
    }

    @EventListener
    public void onContextRefreshedEvent(ContextRefreshedEvent e) {
        log.info((Object)"#SPRINGMATS# ContextRefreshedEvent: Registering all SpringConfig-defined Mats Endpoints, then running MatsFactory.start() on all MatsFactories in the Spring Context to start all registered Mats Endpoints.");
        this._configurableListableBeanFactory.getBeansOfType(MatsFactory.class);
        this._matsMappingMethods.forEach(h -> this.processMatsMapping(h.matsMapping, h.method, h.bean));
        this._matsStagedMethods.forEach(h -> this.processMatsEndpointSetup(h.matsEndpointSetup, h.method, h.bean));
        this._matsStagedClasses.forEach(h -> this.processMatsClassMapping(h.matsClassMapping, h.bean));
        this._contextHasBeenRefreshed = true;
        log.info((Object)"#SPRINGMATS# Invoking matsFactory.start() on all MatsFactories in Spring Context to start registered endpoints.");
        this._matsFactories.forEach((name, factory) -> {
            log.info((Object)("#SPRINGMATS#   \\- MatsFactory '" + name + "'.start()"));
            factory.start();
        });
    }

    @EventListener
    public void onContextClosedEvent(ContextClosedEvent e) {
        log.info((Object)"#SPRINGMATS# ContextClosedEvent: Running MatsFactory.stop() on all MatsFactories in the Spring Context to stop all registered MATS Endpoints and clean out the JmsMatsJmsSessionHandler.");
        this._matsFactories.forEach((name, factory) -> {
            log.info((Object)("#SPRINGMATS#   \\- MatsFactory '" + name + "'.stop()"));
            factory.stop(30000);
        });
        this._contextHasBeenRefreshed = false;
        this._matsMappingMethods.clear();
        this._matsStagedMethods.clear();
        this._matsStagedClasses.clear();
    }

    private void processMatsMapping(MatsMapping matsMapping, Method method, Object bean) {
        String typeEndpoint;
        MatsEndpoint matsEndpoint;
        if (log.isDebugEnabled()) {
            log.debug((Object)("#SPRINGMATS# Processing @MatsMapping method '" + MatsSpringAnnotationRegistration.simpleMethodDescription(method) + "':#: Annotation:[" + matsMapping + "]"));
        }
        if (matsMapping.endpointId().equals("")) {
            throw new MatsSpringConfigException("The " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsMapping, method) + " is missing endpointId (or 'value')");
        }
        method.setAccessible(true);
        Transactional transactionalAnnotation = (Transactional)AnnotationUtils.findAnnotation((Method)method, Transactional.class);
        if (transactionalAnnotation != null) {
            throw new MatsSpringConfigException("The " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsMapping, method) + " shall not be annotated with @Transactional, as Mats does its own transaction management, method:" + method + ", @Transactional:" + transactionalAnnotation);
        }
        Parameter[] params = method.getParameters();
        int paramsLength = params.length;
        int dtoParam = -1;
        int stoParam = -1;
        int processContextParam = -1;
        if (paramsLength == 0) {
            throw new MatsSpringConfigException("The " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsMapping, method) + " must have at least one parameter: The DTO class.");
        }
        if (paramsLength == 1) {
            if (params[0].getType().equals(MatsEndpoint.ProcessContext.class)) {
                throw new MatsSpringConfigException("The " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsMapping, method) + " must have one parameter that is not the ProcessContext: The DTO class");
            }
            dtoParam = 0;
        } else {
            int i;
            for (i = 0; i < paramsLength; ++i) {
                if (!params[i].getType().equals(MatsEndpoint.ProcessContext.class)) continue;
                processContextParam = i;
                break;
            }
            if (processContextParam != -1 && paramsLength == 2) {
                dtoParam = processContextParam ^ 1;
            } else {
                for (i = 0; i < paramsLength; ++i) {
                    if (params[i].getAnnotation(Dto.class) != null) {
                        dtoParam = i;
                    }
                    if (params[i].getAnnotation(Sto.class) == null) continue;
                    stoParam = i;
                }
                if (dtoParam == -1) {
                    throw new MatsSpringConfigException("The " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsMapping, method) + " consists of several parameters, one of which needs to be annotated with @Dto");
                }
            }
        }
        String descriptionOfAnnotation = MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsMapping, method);
        MatsFactory matsFactoryToUse = this.getMatsFactoryToUse(descriptionOfAnnotation, method, matsMapping.matsFactoryCustomQualifierType(), matsMapping.matsFactoryQualifierValue(), matsMapping.matsFactoryBeanName());
        int concurrency = this.getConcurrencyToUse(descriptionOfAnnotation, matsMapping.concurrency());
        Class<?> replyType = method.getReturnType();
        boolean subscription = matsMapping.subscription();
        if (subscription && !replyType.getName().equals("void")) {
            throw new MatsSpringConfigException("The " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsMapping, method) + " have specified subscription=true, but have a non-void return type. Only Terminators can be subscription based, i.e. \"SubscriptionTerminator\".");
        }
        Class<?> dtoType = params[dtoParam].getType();
        Class<Void> stoType = stoParam == -1 ? Void.TYPE : params[stoParam].getType();
        int dtoParamF = dtoParam;
        int processContextParamF = processContextParam;
        int stoParamF = stoParam;
        Object[] templateArgsArray = this.defaultArgsArray(method);
        String origin = MatsSpringAnnotationRegistration.originForMethod(matsMapping, method);
        if (replyType.getName().equals("void")) {
            if (subscription) {
                matsEndpoint = matsFactoryToUse.subscriptionTerminator(matsMapping.endpointId(), stoType, dtoType, (processContext, state, incomingDto) -> MatsSpringAnnotationRegistration.invokeMatsLambdaMethod(matsMapping, method, bean, templateArgsArray, processContextParamF, processContext, dtoParamF, incomingDto, stoParamF, state));
                typeEndpoint = "Subscription Terminator";
            } else {
                matsEndpoint = matsFactoryToUse.terminator(matsMapping.endpointId(), stoType, dtoType, (processContext, state, incomingDto) -> MatsSpringAnnotationRegistration.invokeMatsLambdaMethod(matsMapping, method, bean, templateArgsArray, processContextParamF, processContext, dtoParamF, incomingDto, stoParamF, state));
                typeEndpoint = "Terminator";
            }
        } else if (stoParamF != -1) {
            typeEndpoint = "SingleStage w/State";
            matsEndpoint = matsFactoryToUse.staged(matsMapping.endpointId(), replyType, stoType);
            MatsStage matsStage = matsEndpoint.lastStage(dtoType, (processContext, state, incomingDto) -> {
                Object reply = MatsSpringAnnotationRegistration.invokeMatsLambdaMethod(matsMapping, method, bean, templateArgsArray, processContextParamF, processContext, dtoParamF, incomingDto, stoParamF, state);
                return MatsSpringAnnotationRegistration.helperCast(reply);
            });
        } else {
            typeEndpoint = "SingleStage";
            matsEndpoint = matsFactoryToUse.single(matsMapping.endpointId(), replyType, dtoType, (processContext, incomingDto) -> {
                Object reply = MatsSpringAnnotationRegistration.invokeMatsLambdaMethod(matsMapping, method, bean, templateArgsArray, processContextParamF, processContext, dtoParamF, incomingDto, -1, null);
                return MatsSpringAnnotationRegistration.helperCast(reply);
            });
        }
        matsEndpoint.getEndpointConfig().setOrigin(origin);
        ((MatsStage)matsEndpoint.getStages().get(0)).getStageConfig().setOrigin(origin);
        if (concurrency > 0) {
            matsEndpoint.getEndpointConfig().setConcurrency(concurrency);
        }
        if (log.isInfoEnabled()) {
            Object procCtxParamDesc = processContextParam != -1 ? "param#" + processContextParam : "<not present>";
            String stoParamDesc = stoParam != -1 ? "param#" + stoParam + ":" + stoType.getSimpleName() : "<not present>";
            String dtoParamDesc = "param#" + dtoParam + ":" + dtoType.getSimpleName();
            log.info((Object)("#SPRINGMATS# Processed " + typeEndpoint + " Mats Spring endpoint by " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsMapping, method) + " :: ReplyType:[" + replyType.getSimpleName() + "], ProcessContext:[" + (String)procCtxParamDesc + "], STO:[" + stoParamDesc + "], DTO:[" + dtoParamDesc + "], Concurrency:[" + (concurrency != -1 ? Integer.toString(concurrency) : "~default~") + "]"));
        }
    }

    private void processMatsEndpointSetup(MatsEndpointSetup matsEndpointSetup, Method method, Object bean) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("#SPRINGMATS# Processing @MatsEndpointSetup method '" + MatsSpringAnnotationRegistration.simpleMethodDescription(method) + "':#: Annotation:[" + matsEndpointSetup + "]"));
        }
        if (matsEndpointSetup.endpointId().equals("")) {
            throw new MatsSpringConfigException("The " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsEndpointSetup, method) + " is missing endpointId (or 'value')");
        }
        method.setAccessible(true);
        Parameter[] params = method.getParameters();
        int paramsLength = params.length;
        int endpointParam = -1;
        int configParam = -1;
        if (paramsLength == 0) {
            throw new IllegalStateException("The " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsEndpointSetup, method) + " must have at least one parameter: A MatsEndpoint.");
        }
        if (paramsLength == 1) {
            if (!params[0].getType().equals(MatsEndpoint.class)) {
                throw new IllegalStateException("The " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsEndpointSetup, method) + " must have one parameter of type MatsEndpoint.");
            }
            endpointParam = 0;
        } else {
            for (int i = 0; i < paramsLength; ++i) {
                if (params[i].getType().equals(MatsEndpoint.class)) {
                    endpointParam = i;
                }
                if (!params[i].getType().equals(MatsEndpoint.EndpointConfig.class)) continue;
                configParam = i;
            }
            if (endpointParam == -1) {
                throw new IllegalStateException("The " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsEndpointSetup, method) + " consists of several parameters, one of which needs to be the MatsEndpoint.");
            }
        }
        MatsFactory matsFactoryToUse = this.getMatsFactoryToUse(MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsEndpointSetup, method), method, matsEndpointSetup.matsFactoryCustomQualifierType(), matsEndpointSetup.matsFactoryQualifierValue(), matsEndpointSetup.matsFactoryBeanName());
        MatsEndpoint endpoint = matsFactoryToUse.staged(matsEndpointSetup.endpointId(), matsEndpointSetup.reply(), matsEndpointSetup.state());
        endpoint.getEndpointConfig().setOrigin(MatsSpringAnnotationRegistration.originForMethod(matsEndpointSetup, method));
        Object[] args = new Object[paramsLength];
        args[endpointParam] = endpoint;
        if (configParam != -1) {
            args[configParam] = endpoint.getEndpointConfig();
        }
        try {
            method.invoke(bean, args);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new MatsSpringConfigException("Problem with invoking " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsEndpointSetup, method) + ".", e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new MatsSpringConfigException("Got InvocationTargetException when invoking " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsEndpointSetup, method) + ".", e);
        }
        endpoint.finishSetup();
        log.info((Object)("#SPRINGMATS# Processed Mats Endpoint Configuration by " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsEndpointSetup, method) + " :: MatsEndpoint:[param#" + endpointParam + "], EndpointConfig:[param#" + configParam + "]"));
    }

    private void processMatsClassMapping(MatsClassMapping matsClassMapping, Object bean) {
        MatsEndpoint ep;
        if (log.isDebugEnabled()) {
            log.debug((Object)("#SPRINGMATS# Processing @MatsClassMapping bean '" + MatsSpringAnnotationRegistration.classNameWithoutPackage(bean) + "':#: Annotation:[" + matsClassMapping + "]"));
        }
        Class<?> matsClass = MatsSpringAnnotationRegistration.getClassOfBean(bean);
        Map stages = MethodIntrospector.selectMethods(matsClass, method -> (MatsClassMapping.Stage)AnnotationUtils.findAnnotation((Method)method, MatsClassMapping.Stage.class));
        TreeMap<Integer, Method> stagesByOrdinal = new TreeMap<Integer, Method>();
        stages.forEach((method, stageAnnotation) -> {
            int ordinal = stageAnnotation.ordinal();
            if (ordinal < 0) {
                throw new MatsSpringConfigException("On @MatsClassMapping endpoint at class '" + MatsSpringAnnotationRegistration.classNameWithoutPackage(bean) + "', the Stage ordinal is negative (" + ordinal + ") on @Stage annotation of method '" + MatsSpringAnnotationRegistration.simpleMethodDescription(method) + "' - all ordinals must be >=0 and unique within this endpoint (The ordinal defines the order of stages of this endpoint). @Stage annotation:[" + stageAnnotation + "]");
            }
            if (stagesByOrdinal.containsKey(ordinal)) {
                Method prevMethod = (Method)stagesByOrdinal.get(ordinal);
                throw new MatsSpringConfigException("The Stage with ordinal [" + ordinal + "] of @MatsClassMapping endpoint at class '" + MatsSpringAnnotationRegistration.classNameWithoutPackage(bean) + "' is duplicated on another Stage of the same endpoint. All Stages of an endpoint must have ordinal set, and must be unique within the endpoint (The ordinal defines the order of stages of this endpoint).\n  - This method:     '" + MatsSpringAnnotationRegistration.simpleMethodDescription(method) + "' with @Stage annotation: [" + stageAnnotation + "]\n  - Previous method: '" + MatsSpringAnnotationRegistration.simpleMethodDescription(prevMethod) + "' with @Stage annotation:[" + stages.get(prevMethod) + "]");
            }
            stagesByOrdinal.put(ordinal, (Method)method);
        });
        if (!stagesByOrdinal.containsKey(0)) {
            throw new MatsSpringConfigException("The @MatsClassMapping endpoint at class '" + MatsSpringAnnotationRegistration.classNameWithoutPackage(bean) + "' is missing initial stage: No method is annotated with '@Stage(Stage.INITIAL)' (i.e. ordinal=0)");
        }
        int lastOrdinal = (Integer)stagesByOrdinal.lastKey();
        for (Map.Entry entry : stagesByOrdinal.entrySet()) {
            int ordinal2 = (Integer)entry.getKey();
            Method method2 = (Method)entry.getValue();
            if (ordinal2 == lastOrdinal || method2.getReturnType() == Void.TYPE) continue;
            throw new MatsSpringConfigException("The Stage with ordinal [" + ordinal2 + "] of @MatsClassMapping endpoint at class '" + MatsSpringAnnotationRegistration.classNameWithoutPackage(bean) + "' has a return type '" + MatsSpringAnnotationRegistration.classNameWithoutPackage(method2.getReturnType()) + "' (not void), but it is not the last stage. Only the last stage shall have a return type, which is the return type for the endpoint. Method: '" + MatsSpringAnnotationRegistration.simpleMethodDescription(method2) + "'");
        }
        Method lastStageMethod = (Method)stagesByOrdinal.get(stagesByOrdinal.lastKey());
        Class<Void> replyClass = lastStageMethod.getReturnType() == Void.class ? Void.TYPE : lastStageMethod.getReturnType();
        Method initialStageMethod = (Method)stagesByOrdinal.get(stagesByOrdinal.firstKey());
        int dtoParamIdxOfInitial = this.findDtoParamIndexForMatsClassMappingLambdaMethod(initialStageMethod);
        if (dtoParamIdxOfInitial == -1) {
            throw new MatsSpringConfigException("The Initial Stage of @MatsClassMapping endpoint at class '" + MatsSpringAnnotationRegistration.classNameWithoutPackage(bean) + "' does not have a incoming DTO (message) parameter. Either it must be the sole parameter, or it must be marked by annotation @Dto. Method: [" + initialStageMethod + "]");
        }
        Class<?> requestClass = initialStageMethod.getParameters()[dtoParamIdxOfInitial].getType();
        String descriptionOfAnnotation = "@MatsClassMapping-annotated bean '" + MatsSpringAnnotationRegistration.classNameWithoutPackage(bean) + "'";
        MatsFactory matsFactoryToUse = this.getMatsFactoryToUse(descriptionOfAnnotation, matsClass, matsClassMapping.matsFactoryCustomQualifierType(), matsClassMapping.matsFactoryQualifierValue(), matsClassMapping.matsFactoryBeanName());
        int concurrencyForEndpoint = this.getConcurrencyToUse(descriptionOfAnnotation, matsClassMapping.concurrency());
        log.info((Object)("#SPRINGMATS# The " + descriptionOfAnnotation + "' has " + stages.size() + " Stage" + (stages.size() > 1 ? "s" : "") + ", request DTO [" + MatsSpringAnnotationRegistration.classNameWithoutPackage(requestClass) + "], and reply DTO [" + MatsSpringAnnotationRegistration.classNameWithoutPackage(replyClass) + "]."));
        try {
            matsClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MatsSpringConfigException("The class [" + matsClass.getSimpleName() + "] does not have a no-args constructor, which is required for @MatsClassMapping. (The reason is that some serialization mechanisms (GSON) employ 'Objenesis' for instantiation if a no-args constructor is missing, and any declaration initialized fields will then not be initialized, as Java rely on constructor invocation to do that).");
        }
        Object freshInstantiatedStateObject = matsFactoryToUse.getFactoryConfig().instantiateNewObject(matsClass);
        Field[] processContextField_hack = new Field[1];
        LinkedHashMap templateFields = new LinkedHashMap();
        ReflectionUtils.doWithFields(matsClass, field -> {
            String name = field.getName();
            Class<MatsEndpoint.ProcessContext> clazz = field.getType();
            if (Modifier.isStatic(field.getModifiers())) {
                log.info((Object)("#SPRINGMATS#  - Field [" + name + "] is static: Should not be injected, ProcessContext nor state field, so ignore it."));
                return;
            }
            if (clazz.isAssignableFrom(MatsEndpoint.ProcessContext.class)) {
                ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                Class<Void> processContextReplyType = genericType.getActualTypeArguments()[0];
                log.info((Object)("#SPRINGMATS#  - Field [" + name + "] is Mats' ProcessContext<" + processContextReplyType.getClass().getSimpleName() + "> - reply type parameter is [" + processContextReplyType + "]"));
                if (processContextReplyType == Void.class) {
                    processContextReplyType = Void.TYPE;
                }
                if (processContextField_hack[0] != null) {
                    throw new MatsSpringConfigException("The @MatsClassMapping endpoint at class '" + MatsSpringAnnotationRegistration.classNameWithoutPackage(bean) + "' evidently has more than one ProcessContext field. Only one is allowed.\n  - This field:     [" + field + "]\n  - Previous field: [" + processContextField_hack[0] + "]");
                }
                if (processContextReplyType != replyClass) {
                    throw new MatsSpringConfigException("The @MatsClassMapping endpoint at class '" + MatsSpringAnnotationRegistration.classNameWithoutPackage(bean) + "' has a ProcessContext field where the reply type does not match the resolved reply type from the last Stage. ProcessContext Field: [" + field + "]\n  - Type from field:   ProcessContext<" + processContextReplyType + ">\n  - Reply type resolved from Stages: [" + replyClass + "]");
                }
                processContextField_hack[0] = field;
                return;
            }
            if (clazz.isPrimitive()) {
                log.info((Object)("#SPRINGMATS#  - Field [" + name + "] is primitive: Assuming state field, ignoring. (Type: " + clazz + ")."));
                return;
            }
            field.setAccessible(true);
            Object value = field.get(bean);
            if (value == null) {
                log.info((Object)("#SPRINGMATS#  - Field [" + name + "] of Spring bean is null: Assuming state field, ignoring. (Type: [" + field.getGenericType() + "])"));
                return;
            }
            if (field.get(freshInstantiatedStateObject) != null) {
                log.info((Object)("#SPRINGMATS#  - Field [" + name + "] is non-null both in Spring bean AND in newly instantiated instance: Assuming declaration-initialized state field, ignoring. (Type: [" + field.getGenericType() + "])"));
                return;
            }
            log.info((Object)("#SPRINGMATS#  - Field [" + name + "] of Spring bean is non-null: Assuming Spring Dependency Injection has set it - storing as template. (Type:[" + field.getGenericType() + "], Value:[" + value + "])"));
            if (!Modifier.isTransient(field.getModifiers())) {
                throw new MatsSpringConfigException("Missing 'transient' modifier on injected field [" + name + "] of class [" + MatsSpringAnnotationRegistration.classNameWithoutPackage(bean) + "].");
            }
            templateFields.put(field, value);
        });
        Field processContextField = processContextField_hack[0];
        if (processContextField != null) {
            processContextField.setAccessible(true);
        }
        try {
            ep = matsFactoryToUse.staged(matsClassMapping.endpointId(), replyClass, matsClass);
        }
        catch (RuntimeException e) {
            throw new MatsSpringConfigException("Could not create endpoint for @MatsClassMapping endpoint at class '" + MatsSpringAnnotationRegistration.classNameWithoutPackage(bean) + "' - you'll have to diligently read the cause message and stacktrace!", e);
        }
        ep.getEndpointConfig().setOrigin("@MatsClassMapping " + matsClass.getSimpleName() + ";" + matsClass.getName());
        if (concurrencyForEndpoint > 0) {
            ep.getEndpointConfig().setConcurrency(concurrencyForEndpoint);
        }
        stagesByOrdinal.forEach((ordinal, method) -> {
            MatsClassMapping.Stage stageAnnotation = (MatsClassMapping.Stage)stages.get(method);
            int concurrencyForStage = this.getConcurrencyToUse(descriptionOfAnnotation + " @Stage(" + ordinal + "):" + method.getName() + "(..)", stageAnnotation.concurrency());
            int dtoParamIdx = this.findDtoParamIndexForMatsClassMappingLambdaMethod((Method)method);
            Parameter[] parameters = method.getParameters();
            Class<Void> incomingClass = dtoParamIdx == -1 ? Void.class : parameters[dtoParamIdx].getType();
            int tempPcParamIdx = -1;
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].getType() != MatsEndpoint.ProcessContext.class) continue;
                tempPcParamIdx = i;
                break;
            }
            int processContextParamIdx = tempPcParamIdx;
            log.info((Object)("#SPRINGMATS#   -> Stage '" + ordinal + "': '" + MatsSpringAnnotationRegistration.simpleMethodDescription(method) + ", DTO paramIdx:" + dtoParamIdx + ", DTO class:" + MatsSpringAnnotationRegistration.classNameWithoutPackage(incomingClass) + " - ProcessContext paramIdx:" + processContextParamIdx + ", Concurrency:[" + (concurrencyForEndpoint != -1 ? Integer.toString(concurrencyForEndpoint) : "~default~") + "]"));
            Object[] defaultArgsArray = this.defaultArgsArray((Method)method);
            method.setAccessible(true);
            MatsStage stage = ep.stage(incomingClass, (originalProcessContext, state, incomingDto) -> {
                final Consumer<MatsEndpoint.ProcessContext> setFields = processContext -> {
                    for (Map.Entry entry : templateFields.entrySet()) {
                        Field templateField = (Field)entry.getKey();
                        try {
                            templateField.set(state, entry.getValue());
                        }
                        catch (IllegalAccessException e) {
                            throw new MatsSpringInvocationTargetException("Didn't manage to set \"template field\" '" + templateField.getName() + "' assumed coming from Spring Dependency Injection into the @MatsClassMapping combined state/@Service class '" + MatsSpringAnnotationRegistration.classNameWithoutPackage(matsClass) + "' upon invocation of Mats Stage.", e);
                        }
                    }
                    if (processContextField != null) {
                        try {
                            processContextField.set(state, processContext);
                        }
                        catch (IllegalAccessException e) {
                            throw new MatsSpringInvocationTargetException("Didn't manage to set the ProcessContext '" + processContextField.getName() + "' into  the @MatsClassMapping combined state/@Service class '" + MatsSpringAnnotationRegistration.classNameWithoutPackage(matsClass) + "' upon invocation of Mats Stage.", e);
                        }
                    }
                };
                final Runnable clearFields = () -> {
                    for (Map.Entry entry : templateFields.entrySet()) {
                        Field templateField = (Field)entry.getKey();
                        try {
                            templateField.set(state, null);
                        }
                        catch (IllegalAccessException e) {
                            throw new MatsSpringInvocationTargetException("Didn't manage to null \"template field\" '" + templateField.getName() + "'.", e);
                        }
                    }
                    if (processContextField != null) {
                        try {
                            processContextField.set(state, null);
                        }
                        catch (IllegalAccessException e) {
                            throw new MatsSpringInvocationTargetException("Didn't manage to null the ProcessContext '" + processContextField.getName() + "'.", e);
                        }
                    }
                };
                MatsEndpoint.ProcessContextWrapper<Object> wrappedProcessContext = new MatsEndpoint.ProcessContextWrapper<Object>((MatsEndpoint.ProcessContext)MatsSpringAnnotationRegistration.helperCast(originalProcessContext)){

                    public MatsInitiator.MessageReference request(String endpointId, Object requestDto) {
                        clearFields.run();
                        MatsInitiator.MessageReference ref = super.request(endpointId, requestDto);
                        setFields.accept(this);
                        return ref;
                    }

                    public MatsInitiator.MessageReference reply(Object replyDto) {
                        clearFields.run();
                        MatsInitiator.MessageReference ref = super.reply(replyDto);
                        setFields.accept(this);
                        return ref;
                    }

                    public MatsInitiator.MessageReference next(Object nextDto) {
                        clearFields.run();
                        MatsInitiator.MessageReference ref = super.next(nextDto);
                        setFields.accept(this);
                        return ref;
                    }
                };
                setFields.accept((MatsEndpoint.ProcessContext)wrappedProcessContext);
                Object o = MatsSpringAnnotationRegistration.invokeMatsLambdaMethod(matsClassMapping, method, state, defaultArgsArray, processContextParamIdx, wrappedProcessContext, dtoParamIdx, incomingDto, -1, null);
                clearFields.run();
                if (method == lastStageMethod && replyClass != Void.TYPE) {
                    originalProcessContext.reply(MatsSpringAnnotationRegistration.helperCast(o));
                }
            });
            stage.getStageConfig().setOrigin("@Stage(" + stageAnnotation.ordinal() + ") " + method.getDeclaringClass().getSimpleName() + "." + method.getName() + "(..);" + method.getDeclaringClass().getName());
            if (concurrencyForStage > 0) {
                stage.getStageConfig().setConcurrency(concurrencyForStage);
            }
        });
        ep.finishSetup();
        log.info((Object)("#SPRINGMATS# Processed Mats Class Mapped Endpoint by @MatsClassMapping-annotated bean '" + MatsSpringAnnotationRegistration.classNameWithoutPackage(bean) + "'."));
    }

    private int findDtoParamIndexForMatsClassMappingLambdaMethod(Method method) {
        Parameter[] parameters = method.getParameters();
        int dtoParamPos = -1;
        if (parameters.length == 1) {
            return parameters[0].getType() == MatsEndpoint.ProcessContext.class ? -1 : 0;
        }
        if (parameters.length == 2) {
            if (parameters[0].getType() == MatsEndpoint.ProcessContext.class) {
                return parameters[1].getType() == MatsEndpoint.ProcessContext.class ? -1 : 1;
            }
            if (parameters[1].getType() == MatsEndpoint.ProcessContext.class) {
                return parameters[0].getType() == MatsEndpoint.ProcessContext.class ? -1 : 0;
            }
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].getAnnotation(Dto.class) == null) continue;
            if (dtoParamPos != -1) {
                throw new MatsSpringConfigException("More than one parameter of method '" + MatsSpringAnnotationRegistration.simpleMethodDescription(method) + "' is annotated with @Dto");
            }
            dtoParamPos = i;
        }
        return dtoParamPos;
    }

    Object[] defaultArgsArray(Method method) {
        Parameter[] parameters = method.getParameters();
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Comparable<Boolean> defaultArg = null;
            if (parameters[i].getType() == Boolean.TYPE) {
                defaultArg = false;
            } else if (parameters[i].getType() == Byte.TYPE) {
                defaultArg = (byte)0;
            } else if (parameters[i].getType() == Short.TYPE) {
                defaultArg = (short)0;
            } else if (parameters[i].getType() == Integer.TYPE) {
                defaultArg = 0;
            } else if (parameters[i].getType() == Long.TYPE) {
                defaultArg = 0L;
            } else if (parameters[i].getType() == Float.TYPE) {
                defaultArg = Float.valueOf(0.0f);
            } else if (parameters[i].getType() == Double.TYPE) {
                defaultArg = 0.0;
            }
            args[i] = defaultArg;
        }
        return args;
    }

    private static Object invokeMatsLambdaMethod(Annotation matsAnnotation, Method method, Object bean, Object[] templateDefaultArgsArray, int processContextParamIdx, MatsEndpoint.ProcessContext<?> processContext, int dtoParamIdx, Object dto, int stoParamIdx, Object sto) throws MatsEndpoint.MatsRefuseMessageException {
        Object[] args = (Object[])templateDefaultArgsArray.clone();
        if (processContextParamIdx != -1) {
            args[processContextParamIdx] = processContext;
        }
        if (dtoParamIdx != -1) {
            args[dtoParamIdx] = dto;
        }
        if (stoParamIdx != -1) {
            args[stoParamIdx] = sto;
        }
        try {
            return method.invoke(bean, args);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new MatsEndpoint.MatsRefuseMessageException("Problem with invoking " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsAnnotation, method) + ".", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof MatsEndpoint.MatsRefuseMessageException) {
                throw (MatsEndpoint.MatsRefuseMessageException)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new MatsSpringInvocationTargetException("Got InvocationTargetException when invoking " + MatsSpringAnnotationRegistration.simpleAnnotationAndMethodDescription(matsAnnotation, method) + ".", e);
        }
    }

    private static <R> R helperCast(Object objectToCast) {
        return (R)objectToCast;
    }

    private int getConcurrencyToUse(String forWhat, String concurrencySpecifier) {
        int concurrency;
        if ("".equals(concurrencySpecifier)) {
            return -1;
        }
        try {
            concurrency = Integer.parseInt(concurrencySpecifier);
        }
        catch (NumberFormatException e) {
            throw new MatsSpringConfigException("Not a valid integer: The concurrency specifier [" + concurrencySpecifier + "] for [" + forWhat + "] is not an integer.");
        }
        if (concurrency < 0) {
            throw new MatsSpringConfigException("Negative concurrency: The concurrency specifier [" + concurrencySpecifier + "] for [" + forWhat + "] is negative - not allowed.");
        }
        return concurrency;
    }

    private MatsFactory getMatsFactoryToUse(String forWhat, AnnotatedElement annotatedElement, Class<? extends Annotation> aeCustomQualifierType, String aeQualifierValue, String aeBeanName) {
        MatsFactory matsFactory;
        Annotation[] annotations;
        ArrayList<MatsFactory> specifiedMatsFactories = new ArrayList<MatsFactory>();
        int numberOfQualifications = 0;
        for (Annotation annotation : annotations = AnnotationUtils.getAnnotations((AnnotatedElement)annotatedElement)) {
            if (annotation.annotationType() == Qualifier.class) {
                Qualifier qualifier = (Qualifier)annotation;
                specifiedMatsFactories.add(this.getMatsFactoryByQualifierValue(forWhat, qualifier.value()));
                ++numberOfQualifications;
                continue;
            }
            boolean annotationMetaPresent = AnnotationUtils.isAnnotationMetaPresent(annotation.annotationType(), Qualifier.class);
            if (!annotationMetaPresent) continue;
            specifiedMatsFactories.add(this.getMatsFactoryByCustomQualifier(forWhat, annotation.annotationType(), annotation));
            ++numberOfQualifications;
        }
        if (aeCustomQualifierType != Annotation.class) {
            specifiedMatsFactories.add(this.getMatsFactoryByCustomQualifier(forWhat, aeCustomQualifierType, null));
            ++numberOfQualifications;
        }
        if (!"".equals(aeQualifierValue)) {
            specifiedMatsFactories.add(this.getMatsFactoryByQualifierValue(forWhat, aeQualifierValue));
            ++numberOfQualifications;
        }
        if (!"".equals(aeBeanName)) {
            specifiedMatsFactories.add(this.getMatsFactoryByBeanName(forWhat, aeBeanName));
            ++numberOfQualifications;
        }
        if (numberOfQualifications > 1) {
            throw new BeanCreationException("When trying to get specific MatsFactory for " + forWhat + " based on @Mats..-annotation properties; and @Qualifier-annotations and custom qualifier annotations on the @Mats..-annotated method, we found that there was more than one qualification style present. Check your specifications on the element [" + annotatedElement + "].");
        }
        if (specifiedMatsFactories.size() > 1) {
            throw new BeanCreationException("When trying to get specific MatsFactory for " + forWhat + " based on @Mats..-annotation properties; and @Qualifier-annotations and custom qualifier annotations on the @Mats..-annotated method, we ended up with more than one MatsFactory. Check your specifications on the element [" + annotatedElement + "].");
        }
        MatsFactory matsFactory2 = matsFactory = specifiedMatsFactories.size() == 1 ? (MatsFactory)specifiedMatsFactories.get(0) : this.getMatsFactoryUnspecified(forWhat);
        if (log.isDebugEnabled()) {
            log.debug((Object)("#SPRINGMATS# .. using MatsFactory [" + this._matsFactoriesToName.get(matsFactory) + "]: [" + matsFactory + "]."));
        }
        return matsFactory;
    }

    private MatsFactory getMatsFactoryUnspecified(String forWhat) {
        try {
            return (MatsFactory)this._configurableApplicationContext.getBean(MatsFactory.class);
        }
        catch (NoUniqueBeanDefinitionException e) {
            throw new BeanCreationException("When trying to perform Spring-based MATS Endpoint creation for " + forWhat + ", " + this.getClass().getSimpleName() + " found that there was MULTIPLE MatsFactories available in the Spring ApplicationContext - You must specify which one to use: Using props on the @Mats..-annotation itself (read its JavaDoc); or further annotate the @Mats..-annotated method with a @Qualifier(value), which either matches the same @Qualifier(value)-annotation on a MatsFactory bean, or where the 'value' matches the bean name of a MatsFactory; or annotate both the @Mats..-annotated method and the MatsFactory @Bean factory method with the same custom annotation which is meta-annotated with @Qualifier; or mark one (and only one) of the MatsFactories as @Primary", (Throwable)e);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new BeanCreationException("When trying to perform Spring-based MATS Endpoint creation for " + forWhat + ", " + this.getClass().getSimpleName() + " found that there is NO MatsFactory available in the Spring ApplicationContext", (Throwable)e);
        }
    }

    private MatsFactory getMatsFactoryByBeanName(String forWhat, String beanName) {
        MatsFactory matsFactory = this._cache_MatsFactoryByBeanName.get(beanName);
        if (matsFactory != null) {
            return matsFactory;
        }
        try {
            Object bean = this._configurableApplicationContext.getBean(beanName);
            if (!(bean instanceof MatsFactory)) {
                throw new BeanCreationException("When trying to perform Spring-based MATS Endpoint creation for " + forWhat + ", " + this.getClass().getSimpleName() + " found that the @Mats..-annotation specified Spring bean '" + beanName + "' is not of type MatsFactory");
            }
            this._cache_MatsFactoryByBeanName.put(beanName, (MatsFactory)bean);
            return (MatsFactory)bean;
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new BeanCreationException("When trying to perform Spring-based MATS Endpoint creation for " + forWhat + ", " + this.getClass().getSimpleName() + " found that there is no MatsFactory with the name '" + beanName + "' available in the Spring ApplicationContext", (Throwable)e);
        }
    }

    private MatsFactory getMatsFactoryByQualifierValue(String forWhat, String qualifierValue) {
        MatsFactory matsFactory = this._cache_MatsFactoryByQualifierValue.get(qualifierValue);
        if (matsFactory != null) {
            return matsFactory;
        }
        try {
            matsFactory = (MatsFactory)BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)this._configurableListableBeanFactory, MatsFactory.class, (String)qualifierValue);
            this._cache_MatsFactoryByQualifierValue.put(qualifierValue, matsFactory);
            return matsFactory;
        }
        catch (NoUniqueBeanDefinitionException e) {
            throw new BeanCreationException("When trying to perform Spring-based MATS Endpoint creation for " + forWhat + ", " + this.getClass().getSimpleName() + " found that there was MULTIPLE MatsFactories available in the Spring ApplicationContext with the qualifier value '" + qualifierValue + "', this is probably not what you want.", (Throwable)e);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new BeanCreationException("When trying to perform Spring-based MATS Endpoint creation for " + forWhat + ", " + this.getClass().getSimpleName() + " found that there is NO MatsFactory with the qualifier value '" + qualifierValue + "' available in the Spring ApplicationContext", (Throwable)e);
        }
    }

    private MatsFactory getMatsFactoryByCustomQualifier(String forWhat, Class<? extends Annotation> customQualifierType, Annotation customQualifier) {
        String qualifierString;
        String[] beanDefinitionNames;
        MatsFactory matsFactory2;
        Map<Annotation, MatsFactory> subCacheMap = this._cache_MatsFactoryByCustomQualifier.get(customQualifierType);
        if (subCacheMap != null && (matsFactory2 = subCacheMap.get(customQualifier)) != null) {
            log.debug((Object)("Found cached MatsFactory with CustomAnnotationType [" + customQualifierType + "], custom annotation instance [" + customQualifier + "]."));
            return matsFactory2;
        }
        String[] beanNamesWithCustomQualifierClass = this._configurableListableBeanFactory.getBeanNamesForAnnotation(customQualifierType);
        Set annotatedBeanNames = Arrays.stream(beanNamesWithCustomQualifierClass).filter(beanName -> {
            Annotation annotationOnBean = this._configurableListableBeanFactory.findAnnotationOnBean(beanName, customQualifierType);
            return customQualifier == null || customQualifier.equals(annotationOnBean);
        }).collect(Collectors.toSet());
        for (String beanDefinitionName : beanDefinitionNames = this._configurableListableBeanFactory.getBeanDefinitionNames()) {
            Annotation[] annotations;
            MethodMetadata factoryMethodMetadata;
            BeanDefinition beanDefinition = this._configurableListableBeanFactory.getBeanDefinition(beanDefinitionName);
            if (!(beanDefinition instanceof AnnotatedBeanDefinition) || (factoryMethodMetadata = ((AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata()) == null) continue;
            if (!(factoryMethodMetadata instanceof StandardMethodMetadata)) {
                log.warn((Object)("#SPRINGMATS# AnnotatedBeanDefinition.getFactoryMethodMetadata() returned a MethodMetadata which is not of type StandardMethodMetadata - therefore cannot run getIntrospectedMethod() on it to find annotations on the factory method. AnnotatedBeanDefinition: [" + beanDefinition + "], MethodMetadata: [" + factoryMethodMetadata + "]"));
                continue;
            }
            StandardMethodMetadata factoryMethodMetadata_Standard = (StandardMethodMetadata)factoryMethodMetadata;
            Method introspectedMethod = factoryMethodMetadata_Standard.getIntrospectedMethod();
            for (Annotation annotation : annotations = introspectedMethod.getAnnotations()) {
                if ((customQualifier != null || annotation.annotationType() != customQualifierType) && !annotation.equals(customQualifier)) continue;
                annotatedBeanNames.add(beanDefinitionName);
            }
        }
        List matsFactories = annotatedBeanNames.stream().map(beanName -> this._configurableListableBeanFactory.getBean(beanName)).filter(bean -> bean instanceof MatsFactory).map(matsFactory -> (MatsFactory)matsFactory).collect(Collectors.toList());
        String string = qualifierString = customQualifier != null ? customQualifier.toString() : customQualifierType.getSimpleName();
        if (matsFactories.size() > 1) {
            throw new BeanCreationException("When trying to perform Spring-based MATS Endpoint creation for " + forWhat + ", " + this.getClass().getSimpleName() + " found that there was MULTIPLE (" + matsFactories.size() + ") MatsFactories available in the Spring ApplicationContext with the custom qualifier annotation '" + qualifierString + "', this is probably not what you want.");
        }
        if (matsFactories.isEmpty()) {
            throw new BeanCreationException("When trying to perform Spring-based MATS Endpoint creation for " + forWhat + ", " + this.getClass().getSimpleName() + " found that there is NO MatsFactory with the custom qualifier annotation '" + qualifierString + "' available in the Spring ApplicationContext");
        }
        this._cache_MatsFactoryByCustomQualifier.computeIfAbsent(customQualifierType, $ -> new HashMap()).put(customQualifier, (MatsFactory)matsFactories.get(0));
        return (MatsFactory)matsFactories.get(0);
    }

    private static String originForMethod(Annotation annotation, Method method) {
        return "@" + annotation.annotationType().getSimpleName() + " " + method.getDeclaringClass().getSimpleName() + "." + method.getName() + "(..);" + method.getDeclaringClass().getName();
    }

    private static String classNameWithoutPackage(Object object) {
        if (object == null) {
            return "<null instance>";
        }
        return MatsSpringAnnotationRegistration.classNameWithoutPackage(object.getClass()) + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    private static String classNameWithoutPackage(Class<?> clazz) {
        if (clazz == null) {
            return "<null class>";
        }
        if (clazz == Void.TYPE) {
            return "void";
        }
        if (clazz.isPrimitive()) {
            return clazz.toString();
        }
        String typeName = ClassUtils.getUserClass(clazz).getTypeName();
        String packageName = clazz.getPackage().getName();
        return typeName.replace(packageName + ".", "");
    }

    private static String simpleMethodDescription(Method method) {
        return method.getReturnType().getSimpleName() + " " + MatsSpringAnnotationRegistration.classNameWithoutPackage(method.getDeclaringClass()) + "." + method.getName() + "(..)";
    }

    private static String simpleAnnotationAndMethodDescription(Annotation annotation, Method method) {
        return "@" + annotation.annotationType().getSimpleName() + "-annotated method '" + MatsSpringAnnotationRegistration.simpleMethodDescription(method) + "'";
    }

    public static class MatsSpringInvocationTargetException
    extends RuntimeException {
        public MatsSpringInvocationTargetException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class MatsSpringConfigException
    extends RuntimeException {
        public MatsSpringConfigException(String message, Throwable cause) {
            super(message, cause);
        }

        public MatsSpringConfigException(String message) {
            super(message);
        }
    }

    private static class MatsClassMappingHolder {
        private final MatsClassMapping matsClassMapping;
        private final Object bean;

        public MatsClassMappingHolder(MatsClassMapping matsClassMapping, Object bean) {
            this.matsClassMapping = matsClassMapping;
            this.bean = bean;
        }
    }

    private static class MatsEndpointSetupHolder {
        private final MatsEndpointSetup matsEndpointSetup;
        private final Method method;
        private final Object bean;

        public MatsEndpointSetupHolder(MatsEndpointSetup matsEndpointSetup, Method method, Object bean) {
            this.matsEndpointSetup = matsEndpointSetup;
            this.method = method;
            this.bean = bean;
        }
    }

    private static class MatsMappingHolder {
        private final MatsMapping matsMapping;
        private final Method method;
        private final Object bean;

        public MatsMappingHolder(MatsMapping matsMapping, Method method, Object bean) {
            this.matsMapping = matsMapping;
            this.method = method;
            this.bean = bean;
        }
    }
}

