/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.spring.jms.factories;

import io.mats3.MatsFactory;
import io.mats3.impl.jms.JmsMatsFactory;
import io.mats3.impl.jms.JmsMatsJmsSessionHandler;
import io.mats3.impl.jms.JmsMatsJmsSessionHandler_Pooling;
import io.mats3.impl.jms.JmsMatsTransactionManager;
import io.mats3.impl.jms.JmsMatsTransactionManager_Jms;
import io.mats3.serial.MatsSerializer;
import io.mats3.spring.jms.factories.SpringJmsMatsFactoryWrapper;
import io.mats3.spring.jms.tx.JmsMatsTransactionManager_JmsAndSpringManagedSqlTx;
import javax.jms.ConnectionFactory;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringJmsMatsFactoryProducer {
    private static final Logger log = LoggerFactory.getLogger(SpringJmsMatsFactoryProducer.class);
    private static final String LOG_PREFIX = "#SPRINGJMATS# ";

    public static SpringJmsMatsFactoryWrapper createSpringDataSourceTxMatsFactory(String appName, String appVersion, MatsSerializer<?> matsSerializer, ConnectionFactory jmsConnectionFactory, DataSource sqlDataSource) {
        log.info("#SPRINGJMATS# createSpringDataSourceTxMatsFactory(" + appName + ", " + appVersion + ", " + matsSerializer + ", " + jmsConnectionFactory + ", " + sqlDataSource + ")");
        JmsMatsTransactionManager_JmsAndSpringManagedSqlTx springSqlTxMgr = JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.create(sqlDataSource);
        return SpringJmsMatsFactoryProducer.createJmsMatsFactory(appName, appVersion, matsSerializer, jmsConnectionFactory, (JmsMatsTransactionManager)springSqlTxMgr);
    }

    public static SpringJmsMatsFactoryWrapper createSpringPlatformTransactionManagerTxMatsFactory(String appName, String appVersion, MatsSerializer<?> matsSerializer, ConnectionFactory jmsConnectionFactory, PlatformTransactionManager platformTransactionManager) {
        log.info("#SPRINGJMATS# createSpringPlatformTransactionManagerTxMatsFactory(" + appName + ", " + appVersion + ", " + matsSerializer + ", " + jmsConnectionFactory + ", " + platformTransactionManager + ")");
        JmsMatsTransactionManager_JmsAndSpringManagedSqlTx springSqlTxMgr = JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.create(platformTransactionManager);
        return SpringJmsMatsFactoryProducer.createJmsMatsFactory(appName, appVersion, matsSerializer, jmsConnectionFactory, (JmsMatsTransactionManager)springSqlTxMgr);
    }

    public static SpringJmsMatsFactoryWrapper createJmsTxOnlyMatsFactory(String appName, String appVersion, MatsSerializer<?> matsSerializer, ConnectionFactory jmsConnectionFactory) {
        log.info("#SPRINGJMATS# createJmsTxOnlyMatsFactory(" + appName + ", " + appVersion + ", " + matsSerializer + ", " + jmsConnectionFactory + ")");
        JmsMatsTransactionManager jmsOnlyTxMgr = JmsMatsTransactionManager_Jms.create();
        return SpringJmsMatsFactoryProducer.createJmsMatsFactory(appName, appVersion, matsSerializer, jmsConnectionFactory, jmsOnlyTxMgr);
    }

    private static SpringJmsMatsFactoryWrapper createJmsMatsFactory(String appName, String appVersion, MatsSerializer<?> matsSerializer, ConnectionFactory jmsConnectionFactory, JmsMatsTransactionManager txMgr) {
        JmsMatsJmsSessionHandler_Pooling jmsSessionHandler = JmsMatsJmsSessionHandler_Pooling.create((ConnectionFactory)jmsConnectionFactory);
        JmsMatsFactory matsFactory = JmsMatsFactory.createMatsFactory((String)appName, (String)appVersion, (JmsMatsJmsSessionHandler)jmsSessionHandler, (JmsMatsTransactionManager)txMgr, matsSerializer);
        return new SpringJmsMatsFactoryWrapper(jmsConnectionFactory, (MatsFactory)matsFactory);
    }
}

