/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.spring.jms.factories;

import io.mats3.MatsFactory;
import io.mats3.impl.jms.JmsMatsFactory;
import io.mats3.spring.jms.factories.MatsScenario;
import io.mats3.spring.jms.factories.ScenarioConnectionFactoryWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.jms.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class SpringJmsMatsFactoryWrapper
extends MatsFactory.MatsFactoryWrapper {
    public static final String MATS_TEST_BROKER_INTERFACE_CLASSNAME = "io.mats3.test.MatsTestBrokerInterface";
    public static final String LATE_POPULATE_METHOD_NAME = "_latePopulate";
    private static final Logger log = LoggerFactory.getLogger(SpringJmsMatsFactoryWrapper.class);
    private static final String LOG_PREFIX = "#SPRINGJMATS# ";
    private final ConnectionFactory _connectionFactory;
    private final MatsFactory _matsFactory;
    private Class<?> _matsTestBrokerInterfaceClass;
    private Environment _environment;
    private ApplicationContext _applicationContext;

    @Autowired
    public void setEnvironment(Environment environment) {
        this._environment = environment;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    public SpringJmsMatsFactoryWrapper(ConnectionFactory connectionFactory, MatsFactory matsFactory) {
        super(matsFactory);
        try {
            this._matsTestBrokerInterfaceClass = Class.forName(MATS_TEST_BROKER_INTERFACE_CLASSNAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this._connectionFactory = connectionFactory;
        if (!(matsFactory.unwrapFully() instanceof JmsMatsFactory)) {
            throw new IllegalArgumentException("The supplied matsFactory may be a MatsFactoryWrapper, but it must resolve to a JmsMatsFactory when invoking matsFactory.unwrapFully() - this doesn't [" + matsFactory + "].");
        }
        this._matsFactory = matsFactory;
    }

    @PostConstruct
    public void postConstruct() {
        log.info(LOG_PREFIX + SpringJmsMatsFactoryWrapper.class.getSimpleName() + " got @PostConstructed.");
        boolean matsTestProfileActive = this._environment.acceptsProfiles(new String[]{"mats-test"});
        this.handleMatsTestBrokerInterfacePopulation(matsTestProfileActive);
        this.handleMatsFactoryConcurrencyForTestAndDevelopment(matsTestProfileActive);
    }

    public void postConstructForFactoryBean(Environment environment, ApplicationContext applicationContext) {
        log.info(LOG_PREFIX + SpringJmsMatsFactoryWrapper.class.getSimpleName() + " got invoked postConstructForFactoryBean(env, appContext).");
        this._environment = environment;
        this._applicationContext = applicationContext;
        boolean matsTestProfileActive = environment.acceptsProfiles(new String[]{"mats-test"});
        this.handleMatsTestBrokerInterfacePopulation(matsTestProfileActive);
        this.handleMatsFactoryConcurrencyForTestAndDevelopment(matsTestProfileActive);
    }

    protected void handleMatsTestBrokerInterfacePopulation(boolean matsTestProfileActive) {
        Object matsTestBrokerInterface;
        if (this._matsTestBrokerInterfaceClass == null) {
            if (matsTestProfileActive) {
                log.warn("#SPRINGJMATS#  \\- Class 'io.mats3.test.MatsTestBrokerInterface' not found on classpath. If you need this tool, you would want to have it on classpath, and have your testing Spring context to contain an \"empty\" such bean (MatsTestBrokerInterface.createForLaterPopulation()) so that I could populate it for you with the JMS ConnectionFactory and necessary properties. (The @MatsTestContext and MatsTestInfrastructureConfiguration will do this for you).");
            } else {
                log.info("#SPRINGJMATS#  \\- Class 'io.mats3.test.MatsTestBrokerInterface' not found on classpath, probably not in a testing scenario.");
            }
            return;
        }
        AutowireCapableBeanFactory autowireCapableBeanFactory = this._applicationContext.getAutowireCapableBeanFactory();
        try {
            matsTestBrokerInterface = autowireCapableBeanFactory.getBean(this._matsTestBrokerInterfaceClass);
        }
        catch (NoSuchBeanDefinitionException e) {
            String msg = " \\- Testing tool 'io.mats3.test.MatsTestBrokerInterface' found on classpath, but not in Spring context. If you need this tool, you would want your testing Spring context to contain an \"empty\" such bean (MatsTestBrokerInterface.createForLaterPopulation()) so that I could populate it for you with the JMS ConnectionFactory and necessary properties. (The @MatsTestContext and MatsTestInfrastructureConfiguration will do this for you).";
            if (matsTestProfileActive) {
                log.warn(LOG_PREFIX + msg);
            } else {
                log.info(LOG_PREFIX + msg);
            }
            return;
        }
        log.info("#SPRINGJMATS#  |- Found 'io.mats3.test.MatsTestBrokerInterface' in Spring Context: " + matsTestBrokerInterface);
        try {
            Method latePopulateMethod = this._matsTestBrokerInterfaceClass.getMethod(LATE_POPULATE_METHOD_NAME, ConnectionFactory.class, MatsFactory.class);
            latePopulateMethod.invoke(matsTestBrokerInterface, this._connectionFactory, this.unwrap());
            if (log.isDebugEnabled()) {
                log.debug("#SPRINGJMATS#  \\- Invoked the _latePopulate on 'io.mats3.test.MatsTestBrokerInterface to make the tool ready.");
            }
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError("Didn't find method '_latePopulate(..)' on Class 'io.mats3.test.MatsTestBrokerInterface!", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError("Couldn't invoke method '_latePopulate(..)' on Class 'io.mats3.test.MatsTestBrokerInterface!", e);
        }
    }

    protected void handleMatsFactoryConcurrencyForTestAndDevelopment(boolean matsTestPofileActive) {
        ScenarioConnectionFactoryWrapper scenarioWrapped;
        MatsScenario matsScenario;
        if (matsTestPofileActive) {
            if (this.getFactoryConfig().isConcurrencyDefault()) {
                log.info("#SPRINGJMATS# We're in Spring Profile 'mats-test', so set concurrency to 2 to avoid dozens of threads and messy logs, and set max delivery attempts to 2.");
                this.getFactoryConfig().setConcurrency(2);
                ((JmsMatsFactory)this.unwrapFully()).setMatsManagedDlqDivert(2);
            } else {
                log.info("#SPRINGJMATS# We're in Spring Profile 'mats-test', but the concurrency of MatsFactory is already set to something non-default (" + this.getFactoryConfig().getConcurrency() + "), so will not mess with that (would have set to 2).");
            }
        } else if (this._connectionFactory instanceof ScenarioConnectionFactoryWrapper && (matsScenario = (scenarioWrapped = (ScenarioConnectionFactoryWrapper)this._connectionFactory).getMatsScenarioUsedToMakeConnectionFactory()) == MatsScenario.LOCALVM) {
            if (this.getFactoryConfig().isConcurrencyDefault()) {
                log.info("#SPRINGJMATS# The supplied ConnectionFactory was created with MatsScenario.LOCALVM, so we assume this is a development situation (or testing where the user forgot to add the Spring active profile 'mats-test' as with @MatsTestProfile), and thus set the concurrency to 2 to avoid dozens of threads and messy logs, and set max delivery attempts to 2.");
                this.getFactoryConfig().setConcurrency(2);
                ((JmsMatsFactory)this.unwrapFully()).setMatsManagedDlqDivert(2);
            } else {
                log.info("#SPRINGJMATS# The supplied ConnectionFactory was created with MatsScenario.LOCALVM, so we assume this is a development situation (or testing where the user forgot to add the Spring active profile 'mats-test' as with @MatsTestProfile), HOWEVER, the concurrency is already set to something non-default (" + this.getFactoryConfig().getConcurrency() + "), so will not mess with that (would have set it to 2).");
            }
        }
    }
}

