/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.spring.jms.factories;

import io.mats3.spring.jms.factories.ConnectionFactoryWithStartStopWrapper;
import io.mats3.spring.jms.factories.MatsScenario;
import io.mats3.util.wrappers.ConnectionFactoryWrapper;
import javax.jms.ConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.env.Environment;

public class ScenarioConnectionFactoryWrapper
extends ConnectionFactoryWrapper
implements EnvironmentAware,
BeanNameAware,
SmartLifecycle {
    private static final Log log = LogFactory.getLog(ScenarioConnectionFactoryWrapper.class);
    private static final String LOG_PREFIX = "#SPRINGJMATS# ";
    protected ConnectionFactoryProvider _regularConnectionFactoryProvider;
    protected ConnectionFactoryProvider _localhostConnectionFactoryProvider;
    protected ConnectionFactoryProvider _localVmConnectionFactoryProvider;
    protected ScenarioDecider _scenarioDecider;
    protected String _beanName;
    protected Environment _environment;
    protected volatile ConnectionFactory _targetConnectionFactory;
    protected volatile MatsScenario _matsScenarioDecision;
    private boolean _started;

    public ScenarioConnectionFactoryWrapper(ConnectionFactoryProvider regular, ConnectionFactoryProvider localhost, ConnectionFactoryProvider localvm, ScenarioDecider scenarioDecider) {
        this._regularConnectionFactoryProvider = regular;
        this._localhostConnectionFactoryProvider = localhost;
        this._localVmConnectionFactoryProvider = localvm;
        this._scenarioDecider = scenarioDecider;
    }

    public void setBeanName(String name) {
        this._beanName = name;
    }

    public void setEnvironment(Environment environment) {
        this._environment = environment;
    }

    public void setWrappee(ConnectionFactory targetConnectionFactory) {
        throw new IllegalStateException("You cannot set a target ConnectionFactory on a " + ((Object)((Object)this)).getClass().getSimpleName() + "; A set of suppliers will have to be provided in the constructor.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionFactory unwrap() {
        if (this._targetConnectionFactory == null) {
            log.info((Object)"#SPRINGJMATS# TargetConnectionFactory is null upon unwrap() - perform lazy-init.");
            ScenarioConnectionFactoryWrapper scenarioConnectionFactoryWrapper = this;
            synchronized (scenarioConnectionFactoryWrapper) {
                if (this._targetConnectionFactory == null) {
                    this.createTargetConnectionFactoryBasedOnScenarioDecider();
                }
            }
        }
        return this._targetConnectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MatsScenario getMatsScenarioUsedToMakeConnectionFactory() {
        if (this._matsScenarioDecision == null) {
            ScenarioConnectionFactoryWrapper scenarioConnectionFactoryWrapper = this;
            synchronized (scenarioConnectionFactoryWrapper) {
                if (this._matsScenarioDecision == null) {
                    this._matsScenarioDecision = this._scenarioDecider.decision(this._environment);
                }
            }
            log.info((Object)("#SPRINGJMATS# Decided MatsScenario: " + this._matsScenarioDecision));
        }
        return this._matsScenarioDecision;
    }

    protected void createTargetConnectionFactoryBasedOnScenarioDecider() {
        ConnectionFactory providedConnectionFactory;
        ConnectionFactoryProvider decidedProvider;
        if (!Thread.holdsLock((Object)this)) {
            throw new AssertionError((Object)"This should only be invoked while holding sync on 'this'.");
        }
        if (this._targetConnectionFactory != null) {
            throw new AssertionError((Object)"The ConnectionFactory is already decided and made, why here again?");
        }
        MatsScenario matsScenarioDecision = this.getMatsScenarioUsedToMakeConnectionFactory();
        switch (matsScenarioDecision) {
            case REGULAR: {
                decidedProvider = this._regularConnectionFactoryProvider;
                break;
            }
            case LOCALHOST: {
                decidedProvider = this._localhostConnectionFactoryProvider;
                break;
            }
            case LOCALVM: {
                decidedProvider = this._localVmConnectionFactoryProvider;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown MatsScenario enum value [" + matsScenarioDecision + "]!"));
            }
        }
        log.info((Object)("#SPRINGJMATS# Creating ConnectionFactory decided by MatsScenario [" + matsScenarioDecision + "] from decided provider [" + decidedProvider + "]."));
        try {
            providedConnectionFactory = decidedProvider.get(this._environment);
        }
        catch (Exception e) {
            throw new CouldNotGetConnectionFactoryFromProviderException("Got problems when getting the ConnectionFactory from ConnectionFactoryProvider [" + decidedProvider + "] from Scenario [" + matsScenarioDecision + "]", e);
        }
        if (providedConnectionFactory instanceof ConnectionFactoryWithStartStopWrapper) {
            log.info((Object)("#SPRINGJMATS# The provided ConnectionFactory from Scenario [" + matsScenarioDecision + "] implements " + ConnectionFactoryWithStartStopWrapper.class.getSimpleName() + ", so invoking start(..) on it."));
            ConnectionFactoryWithStartStopWrapper startStopWrapper = (ConnectionFactoryWithStartStopWrapper)providedConnectionFactory;
            try {
                ConnectionFactory targetConnectionFactory = startStopWrapper.start(this._beanName);
                if (targetConnectionFactory != null) {
                    startStopWrapper.setWrappee(targetConnectionFactory);
                }
            }
            catch (Exception e) {
                throw new CouldNotStartConnectionFactoryWithStartStopWrapperException("Got problems starting the ConnectionFactoryWithStartStopWrapper [" + startStopWrapper + "] from Scenario [" + matsScenarioDecision + "].", e);
            }
        }
        this._targetConnectionFactory = providedConnectionFactory;
    }

    public int getPhase() {
        return -2000000;
    }

    public boolean isAutoStartup() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        log.info((Object)("#SPRINGJMATS# SmartLifeCycle.start on [" + this._beanName + "]: Creating Target ConnectionFactory based on ScenarioDecider [" + this._scenarioDecider + "]."));
        ScenarioConnectionFactoryWrapper scenarioConnectionFactoryWrapper = this;
        synchronized (scenarioConnectionFactoryWrapper) {
            if (this._targetConnectionFactory == null) {
                this.createTargetConnectionFactoryBasedOnScenarioDecider();
            }
        }
        this._started = true;
    }

    public boolean isRunning() {
        return this._started;
    }

    public void stop() {
        this._started = false;
        if (this._targetConnectionFactory != null && this._targetConnectionFactory instanceof ConnectionFactoryWithStartStopWrapper) {
            try {
                log.info((Object)("#SPRINGJMATS#   \\- The current target ConnectionFactory implements " + ConnectionFactoryWithStartStopWrapper.class.getSimpleName() + ", so invoking stop(..) on it."));
                ((ConnectionFactoryWithStartStopWrapper)this._targetConnectionFactory).stop();
            }
            catch (Exception e) {
                throw new CouldNotStopConnectionFactoryWithStartStopWrapperException("Got problems stopping the current target ConnectionFactoryWithStartStopWrapper [" + this._targetConnectionFactory + "].", e);
            }
        }
    }

    public void stop(Runnable callback) {
        log.info((Object)("#SPRINGJMATS# SmartLifeCycle.stop(callback) on [" + this._beanName + "]."));
        this.stop();
        callback.run();
    }

    protected static class CouldNotStopConnectionFactoryWithStartStopWrapperException
    extends RuntimeException {
        public CouldNotStopConnectionFactoryWithStartStopWrapperException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    protected static class CouldNotStartConnectionFactoryWithStartStopWrapperException
    extends RuntimeException {
        public CouldNotStartConnectionFactoryWithStartStopWrapperException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    protected static class CouldNotGetConnectionFactoryFromProviderException
    extends RuntimeException {
        public CouldNotGetConnectionFactoryFromProviderException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @FunctionalInterface
    public static interface ScenarioDecider {
        public MatsScenario decision(Environment var1);
    }

    @FunctionalInterface
    public static interface ConnectionFactoryProvider {
        public ConnectionFactory get(Environment var1) throws Exception;
    }
}

