/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.spring.jms.factories;

import io.mats3.spring.jms.factories.MatsScenario;
import io.mats3.spring.jms.factories.ScenarioConnectionFactoryProducer;
import io.mats3.spring.jms.factories.ScenarioConnectionFactoryWrapper;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class ConfigurableScenarioDecider
implements ScenarioConnectionFactoryWrapper.ScenarioDecider {
    private static final Logger log = LoggerFactory.getLogger(ConfigurableScenarioDecider.class);
    private static final String LOG_PREFIX = "#SPRINGJMATS# ";
    protected SpecificScenarioDecider _regular;
    protected SpecificScenarioDecider _localhost;
    protected SpecificScenarioDecider _localVm;
    protected Supplier<MatsScenario> _defaultScenario;

    public static ConfigurableScenarioDecider createDefaultScenarioDecider() {
        return new ConfigurableScenarioDecider(new StandardSpecificScenarioDecider("mats-regular", "production", "staging"), new StandardSpecificScenarioDecider("mats-localhost"), new StandardSpecificScenarioDecider("mats-localvm", "mats-test"), () -> {
            throw new IllegalStateException("No MatsScenario was decided - you must make a decision! Please read JavaDoc at " + ScenarioConnectionFactoryProducer.class.getSimpleName() + " and " + ConfigurableScenarioDecider.class.getSimpleName() + ".");
        });
    }

    public ConfigurableScenarioDecider(SpecificScenarioDecider regular, SpecificScenarioDecider localhost, SpecificScenarioDecider localVm, Supplier<MatsScenario> defaultScenario) {
        this.setRegularDecider(regular);
        this.setLocalhostDecider(localhost);
        this.setLocalVmDecider(localVm);
        this.setDefaultScenario(defaultScenario);
    }

    public ConfigurableScenarioDecider() {
    }

    public ConfigurableScenarioDecider setRegularDecider(SpecificScenarioDecider regular) {
        this._regular = regular;
        return this;
    }

    public ConfigurableScenarioDecider setLocalhostDecider(SpecificScenarioDecider localhost) {
        this._localhost = localhost;
        return this;
    }

    public ConfigurableScenarioDecider setLocalVmDecider(SpecificScenarioDecider localVm) {
        this._localVm = localVm;
        return this;
    }

    public ConfigurableScenarioDecider setDefaultScenario(Supplier<MatsScenario> defaultScenario) {
        this._defaultScenario = defaultScenario;
        return this;
    }

    @Override
    public MatsScenario decision(Environment env) {
        Optional<String> mockProfile;
        String envString = "Active Spring Profiles: " + Arrays.asList(env.getActiveProfiles());
        if (env instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)env;
            MutablePropertySources propertySources = configurableEnvironment.getPropertySources();
            Stream<PropertySource> stream = StreamSupport.stream(propertySources.spliterator(), false);
            envString = envString + ", Spring Environment instanceof ConfigurableEnvironment (" + env.getClass().getSimpleName() + "); PropertySources: " + stream.map(source -> source.getClass().getSimpleName() + "{" + source.getName() + "}").collect(Collectors.joining(", ", "[", "]"));
        } else {
            envString = envString + ", Spring Environment !instanceOf ConfigurableEnvironment, env.toString(): " + env;
        }
        log.info("#SPRINGJMATS# Finding which MatsScenario is active, " + envString);
        int activeScenarios = 0;
        MatsScenario scenario = null;
        String match = this._regular.scenarioActive(env).orElse(null);
        if (match != null) {
            scenario = MatsScenario.REGULAR;
            ++activeScenarios;
            log.info("#SPRINGJMATS#   \\- " + match + ": choosing MatsScenario '" + scenario + "'");
        }
        if ((match = (String)this._localhost.scenarioActive(env).orElse(null)) != null) {
            scenario = MatsScenario.LOCALHOST;
            ++activeScenarios;
            log.info("#SPRINGJMATS#   \\- " + match + ": choosing MatsScenario '" + scenario + "'");
        }
        if ((match = (String)this._localVm.scenarioActive(env).orElse(null)) != null) {
            scenario = MatsScenario.LOCALVM;
            ++activeScenarios;
            log.info("#SPRINGJMATS#   \\- " + match + ": choosing MatsScenario '" + scenario + "'");
        }
        if (scenario == null) {
            log.info("#SPRINGJMATS#   \\- NO Scenario explicitly specified - invoking the default MatsScenario Supplier.");
            scenario = this._defaultScenario.get();
        }
        if (activeScenarios > 1) {
            throw new IllegalStateException("When trying to find which Mats MatsScenario was active, we found that more than one scenario was active - this is not allowed.\n" + envString);
        }
        if (scenario == MatsScenario.REGULAR && (mockProfile = Arrays.stream(env.getActiveProfiles()).filter(profile -> profile.toLowerCase().startsWith("mats-mocks")).findAny()).isPresent()) {
            throw new IllegalStateException("Found that Mats Scenario [" + scenario + "] was active, but at the same time, we found that '" + mockProfile.get() + "' profile was active. This is not allowed.\n" + envString);
        }
        return scenario;
    }

    public static class StandardSpecificScenarioDecider
    implements SpecificScenarioDecider {
        private final String[] _profileOrPropertyNames;

        public StandardSpecificScenarioDecider(String ... profileOrPropertyNames) {
            this._profileOrPropertyNames = profileOrPropertyNames;
        }

        @Override
        public Optional<String> scenarioActive(Environment env) {
            return StandardSpecificScenarioDecider.isProfileOrPropertyPresent(env, this._profileOrPropertyNames);
        }

        public static Optional<String> isProfileOrPropertyPresent(Environment env, String ... profileNames) {
            for (String profileName : profileNames) {
                if (env.containsProperty(profileName)) {
                    return Optional.of("Found Spring Environment Property '" + profileName + "'");
                }
                if (env.containsProperty(profileName.replace('-', '.'))) {
                    return Optional.of("Found Spring Environment Property '" + profileName.replace('-', '.') + "'");
                }
                boolean acceptsProfiles = env.acceptsProfiles(new String[]{profileName});
                if (!acceptsProfiles) continue;
                return Optional.of("Found active Spring Profile '" + profileName + "'");
            }
            return Optional.empty();
        }
    }

    @FunctionalInterface
    public static interface SpecificScenarioDecider {
        public Optional<String> scenarioActive(Environment var1);
    }
}

