/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.spring.jms.tx;

import io.mats3.MatsEndpoint;
import io.mats3.impl.jms.JmsMatsContextLocalCallback;
import io.mats3.impl.jms.JmsMatsException;
import io.mats3.impl.jms.JmsMatsInternalExecutionContext;
import io.mats3.impl.jms.JmsMatsTransactionManager;
import io.mats3.impl.jms.JmsMatsTransactionManager_Jms;
import io.mats3.util.wrappers.DeferredConnectionProxyDataSourceWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.InfrastructureProxy;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class JmsMatsTransactionManager_JmsAndSpringManagedSqlTx
extends JmsMatsTransactionManager_Jms {
    private static final Logger log = LoggerFactory.getLogger(JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.class);
    private final PlatformTransactionManager _platformTransactionManager;
    private final DataSource _dataSource;
    private final Function<JmsMatsTransactionManager.JmsMatsTxContextKey, DefaultTransactionDefinition> _transactionDefinitionFunction;
    private static final String LOG_PREFIX = "#SPRINGJMATS# ";
    public static final String CONTEXT_LOCAL_KEY_CONNECTION_EMPLOYED_STATE_SUPPLIER = "JmsAndSpringManagedSqlTx.connectionEmployedSupplier";

    private JmsMatsTransactionManager_JmsAndSpringManagedSqlTx(PlatformTransactionManager platformTransactionManager, DataSource dataSource, Function<JmsMatsTransactionManager.JmsMatsTxContextKey, DefaultTransactionDefinition> transactionDefinitionFunction) {
        this._platformTransactionManager = platformTransactionManager;
        this._dataSource = dataSource;
        if (!(dataSource instanceof DeferredConnectionProxyDataSourceWrapper_InfrastructureProxy)) {
            log.warn("#SPRINGJMATS# The DataSource provided with the PlatformTransactionManager is not wrapped with our special '" + DeferredConnectionProxyDataSourceWrapper_InfrastructureProxy.class.getSimpleName() + "', which will hinder the SpringJmsMats implementation from knowing whether the SQL Connection was actually employed by the MatsFactory's Endpoints' Stages. You can do this wrapping (before creating the PlatformTransactionManager) by invoking the static method 'wrapLazyConnectionDatasource(dataSource)'. PlatformTransactionManager in question: [" + platformTransactionManager + "], of class [" + platformTransactionManager.getClass().getName() + "]");
        }
        this._transactionDefinitionFunction = transactionDefinitionFunction;
    }

    private JmsMatsTransactionManager_JmsAndSpringManagedSqlTx(DataSource dataSource, Function<JmsMatsTransactionManager.JmsMatsTxContextKey, DefaultTransactionDefinition> transactionDefinitionFunction) {
        if (dataSource instanceof DeferredConnectionProxyDataSourceWrapper_InfrastructureProxy) {
            log.info("#SPRINGJMATS# The DataSource provided is already wrapped with " + DeferredConnectionProxyDataSourceWrapper_InfrastructureProxy.class.getSimpleName() + ", which is okay (we otherwise wrap it ourselves). [" + dataSource + "]");
            this._dataSource = dataSource;
        } else {
            this._dataSource = JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.wrapLazyConnectionDatasource(dataSource);
        }
        this._platformTransactionManager = new DataSourceTransactionManager(this._dataSource);
        log.info("#SPRINGJMATS# Created own DataSourceTransactionManager for the JmsMatsTransactionManager: [" + this._platformTransactionManager + "] with magic wrapped DataSource [" + this._dataSource + "].");
        this._transactionDefinitionFunction = transactionDefinitionFunction;
    }

    public static JmsMatsTransactionManager_JmsAndSpringManagedSqlTx create(DataSource dataSource) {
        log.info("#SPRINGJMATS# create(DataSource) [" + dataSource + "]");
        return new JmsMatsTransactionManager_JmsAndSpringManagedSqlTx(dataSource, JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.getStandardTransactionDefinitionFunctionFor(DataSourceTransactionManager.class));
    }

    public static JmsMatsTransactionManager_JmsAndSpringManagedSqlTx create(DataSource dataSource, Function<JmsMatsTransactionManager.JmsMatsTxContextKey, DefaultTransactionDefinition> transactionDefinitionFunction) {
        log.info("#SPRINGJMATS# create(DataSource, transactionDefinitionFunction) [" + dataSource + "], [" + transactionDefinitionFunction + "]");
        return new JmsMatsTransactionManager_JmsAndSpringManagedSqlTx(dataSource, transactionDefinitionFunction);
    }

    public static JmsMatsTransactionManager_JmsAndSpringManagedSqlTx create(PlatformTransactionManager platformTransactionManager) {
        log.info("#SPRINGJMATS# create(PlatformTransactionManager) [" + platformTransactionManager + "]");
        log.info("#SPRINGJMATS# Introspecting the supplied PlatformTransactionManager to find a method .getDataSource() from where to get the DataSource. [" + platformTransactionManager + "]");
        DataSource dataSource = JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.getDataSourceFromTransactionManager(platformTransactionManager);
        log.info("#SPRINGJMATS# .. found DataSource [" + dataSource + "].");
        return new JmsMatsTransactionManager_JmsAndSpringManagedSqlTx(platformTransactionManager, dataSource, JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.getStandardTransactionDefinitionFunctionFor(platformTransactionManager.getClass()));
    }

    public static JmsMatsTransactionManager_JmsAndSpringManagedSqlTx create(PlatformTransactionManager platformTransactionManager, Function<JmsMatsTransactionManager.JmsMatsTxContextKey, DefaultTransactionDefinition> transactionDefinitionFunction) {
        log.info("#SPRINGJMATS# create(PlatformTransactionManager) [" + platformTransactionManager + "]");
        log.info("#SPRINGJMATS# Introspecting the supplied PlatformTransactionManager to find a method .getDataSource() from where to get the DataSource. [" + platformTransactionManager + "]");
        DataSource dataSource = JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.getDataSourceFromTransactionManager(platformTransactionManager);
        log.info("#SPRINGJMATS# .. found DataSource [" + dataSource + "].");
        return new JmsMatsTransactionManager_JmsAndSpringManagedSqlTx(platformTransactionManager, dataSource, transactionDefinitionFunction);
    }

    public static JmsMatsTransactionManager_JmsAndSpringManagedSqlTx create(PlatformTransactionManager platformTransactionManager, DataSource dataSource) {
        log.info("#SPRINGJMATS# create(PlatformTransactionManager, dataSource) [" + platformTransactionManager + "], [" + dataSource + "]");
        try {
            DataSource dataSourceFromTxMgr = JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.getDataSourceFromTransactionManager(platformTransactionManager);
            log.warn("#SPRINGJMATS# NOTICE: I managed to get the DataSource from the PlatformTransactionManager you provided, and thus I suggest that you instead use the factory methods NOT taking a DataSource, to minimise the chances of supplying the wrong DataSource compared to what is managed by the PlatformTransactionManager.");
            if (dataSourceFromTxMgr != dataSource) {
                log.warn("#SPRINGJMATS# NOTICE VERY MUCH! The DataSource provided in the factory method is NOT the same instance that I got by introspecting the PlatformTransactionManager. This is MOST PROBABLY not what you want, and I was torn whether to throw an Exception here - but you might got your reasons?!");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new JmsMatsTransactionManager_JmsAndSpringManagedSqlTx(platformTransactionManager, dataSource, JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.getStandardTransactionDefinitionFunctionFor(platformTransactionManager.getClass()));
    }

    public static JmsMatsTransactionManager_JmsAndSpringManagedSqlTx create(PlatformTransactionManager platformTransactionManager, DataSource dataSource, Function<JmsMatsTransactionManager.JmsMatsTxContextKey, DefaultTransactionDefinition> transactionDefinitionFunction) {
        log.info("#SPRINGJMATS# create(PlatformTransactionManager, dataSource, transactionDefinitionFunction) [" + platformTransactionManager + "], [" + dataSource + "], [" + transactionDefinitionFunction + "]");
        try {
            DataSource dataSourceFromTxMgr = JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.getDataSourceFromTransactionManager(platformTransactionManager);
            log.warn("#SPRINGJMATS# NOTICE: I managed to get the DataSource from the PlatformTransactionManager you provided, and thus I suggest that you instead use the factory methods NOT taking a DataSource, to minimise the chances of supplying the wrong DataSource compared to what is managed by the PlatformTransactionManager.");
            if (dataSourceFromTxMgr != dataSource) {
                log.warn("#SPRINGJMATS# NOTICE VERY MUCH! The DataSource provided in the factory method is NOT the same instance that I got by introspecting the PlatformTransactionManager. This is MOST PROBABLY not what you want, and I was torn whether to throw an Exception here - but you might got your reasons?!");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new JmsMatsTransactionManager_JmsAndSpringManagedSqlTx(platformTransactionManager, dataSource, transactionDefinitionFunction);
    }

    private static DataSource getDataSourceFromTransactionManager(PlatformTransactionManager platformTransactionManager) {
        try {
            Method getDataSource = platformTransactionManager.getClass().getMethod("getDataSource", new Class[0]);
            getDataSource.setAccessible(true);
            DataSource dataSource = (DataSource)getDataSource.invoke((Object)platformTransactionManager, new Object[0]);
            if (dataSource == null) {
                throw new IllegalArgumentException("When invoking .getDataSource() on the PlatformTransactionManager, we got 'null' return [" + platformTransactionManager + "].");
            }
            return dataSource;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("The supplied PlatformTransactionManager does not have a .getDataSource() method, or got problems invoking it.", e);
        }
    }

    public static Function<JmsMatsTransactionManager.JmsMatsTxContextKey, DefaultTransactionDefinition> getStandardTransactionDefinitionFunctionFor(Class<? extends PlatformTransactionManager> platformTransactionManager) {
        log.info("#SPRINGJMATS# TransactionDefinition Function not provided, thus using default which sets the transaction name, sets Isolation Level to ISOLATION_READ_COMMITTED, and sets Propagation Behavior to PROPAGATION_REQUIRES_NEW (unless HibernateTransactionManager, where setting Isolation Level evidently is not supported).");
        if (platformTransactionManager.getSimpleName().equals("HibernateTransactionManager")) {
            return txContextKey -> {
                DefaultTransactionDefinition transDef = new DefaultTransactionDefinition();
                transDef.setPropagationBehavior(3);
                transDef.setName(txContextKey.toString());
                return transDef;
            };
        }
        return txContextKey -> {
            DefaultTransactionDefinition transDef = new DefaultTransactionDefinition();
            transDef.setIsolationLevel(2);
            transDef.setPropagationBehavior(3);
            transDef.setName(txContextKey.toString());
            return transDef;
        };
    }

    public static DataSource wrapLazyConnectionDatasource(DataSource targetDataSource) {
        log.info("#SPRINGJMATS# Wrapping provided DataSource in a 'magic lazy proxy' which allows both elision of JDBC transaction management if the Connection was never employed, AND allows Mats to know whether an initiation or stage employed the Connection or not. [" + targetDataSource + "]");
        if (targetDataSource instanceof DeferredConnectionProxyDataSourceWrapper_InfrastructureProxy) {
            log.warn("#SPRINGJMATS#   \\-> The DataSource you provided was already wrapped with the 'magic lazy proxy', so why are you trying to wrap it again? Ignoring by simply returning the already-wrapped DataSource you provided (thus not double-wrapping it). [" + targetDataSource + "]");
            return targetDataSource;
        }
        if (targetDataSource instanceof TransactionAwareDataSourceProxy) {
            throw new IllegalStateException("The provided DataSource should not be of type TransactionAwareDataSourceProxy (read its JavaDoc). Give me a 'cleaner' DataSource, preferably a pooled DataSource. [" + targetDataSource + "]");
        }
        if (targetDataSource instanceof LazyConnectionDataSourceProxy) {
            log.info("#SPRINGJMATS#   \\-> NOTICE: The provided DataSource is a LazyConnectionDataSourceProxy, which is unnecessary, but not really a problem.");
        }
        DeferredConnectionProxyDataSourceWrapper_InfrastructureProxy deferredDataSource = new DeferredConnectionProxyDataSourceWrapper_InfrastructureProxy(targetDataSource);
        log.info("#SPRINGJMATS# Wrapped the provided DataSource as [" + deferredDataSource + "].");
        return deferredDataSource;
    }

    public PlatformTransactionManager getPlatformTransactionManager() {
        return this._platformTransactionManager;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public DataSource getDataSourceUnwrapped() {
        if (this._dataSource instanceof InfrastructureProxy) {
            return (DataSource)((InfrastructureProxy)this._dataSource).getWrappedObject();
        }
        return this._dataSource;
    }

    public JmsMatsTransactionManager.TransactionContext getTransactionContext(JmsMatsTransactionManager.JmsMatsTxContextKey txContextKey) {
        DefaultTransactionDefinition defaultTransactionDefinition = this._transactionDefinitionFunction.apply(txContextKey);
        return new TransactionalContext_JmsAndSpringDstm(txContextKey, this._platformTransactionManager, defaultTransactionDefinition, this._dataSource);
    }

    private static class TransactionalContext_JmsAndSpringDstm
    extends JmsMatsTransactionManager_Jms.TransactionalContext_Jms {
        private static final String LOG_PREFIX = "#SPRINGJMATS# ";
        private final PlatformTransactionManager _platformTransactionManager;
        private final DefaultTransactionDefinition _transactionDefinitionForThisContext;
        private final DataSource _dataSource;

        public TransactionalContext_JmsAndSpringDstm(JmsMatsTransactionManager.JmsMatsTxContextKey txContextKey, PlatformTransactionManager platformTransactionManager, DefaultTransactionDefinition transactionDefinitionForThisContext, DataSource dataSource) {
            super(txContextKey);
            this._platformTransactionManager = platformTransactionManager;
            this._transactionDefinitionForThisContext = transactionDefinitionForThisContext;
            this._dataSource = dataSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doTransaction(JmsMatsInternalExecutionContext internalExecutionContext, JmsMatsTransactionManager.ProcessingLambda lambda) throws JmsMatsException.JmsMatsJmsException, MatsEndpoint.MatsRefuseMessageException {
            try {
                super.doTransaction(internalExecutionContext, () -> {
                    TransactionStatus transactionStatus = this._platformTransactionManager.getTransaction((TransactionDefinition)this._transactionDefinitionForThisContext);
                    Supplier<Boolean> connectionEmployedState = () -> true;
                    if (this._dataSource instanceof DeferredConnectionProxyDataSourceWrapper_InfrastructureProxy) {
                        Connection connectionFromDataSourceUtils = DataSourceUtils.getConnection((DataSource)this._dataSource);
                        if (connectionFromDataSourceUtils instanceof DeferredConnectionProxyDataSourceWrapper.DeferredConnectionProxy) {
                            log.debug("#SPRINGJMATS# SQL Connection directly wrapped as DeferredConnectionProxy gotten from DataSourceUtils: [" + connectionFromDataSourceUtils + "]");
                            DeferredConnectionProxyDataSourceWrapper.DeferredConnectionProxy deferredConnectionProxy = (DeferredConnectionProxyDataSourceWrapper.DeferredConnectionProxy)connectionFromDataSourceUtils;
                            connectionEmployedState = () -> ((DeferredConnectionProxyDataSourceWrapper.DeferredConnectionProxy)deferredConnectionProxy).isActualConnectionRetrieved();
                        } else {
                            try {
                                if (connectionFromDataSourceUtils.isWrapperFor(DeferredConnectionProxyDataSourceWrapper.DeferredConnectionProxy.class)) {
                                    DeferredConnectionProxyDataSourceWrapper.DeferredConnectionProxy deferredConnectionProxy = connectionFromDataSourceUtils.unwrap(DeferredConnectionProxyDataSourceWrapper.DeferredConnectionProxy.class);
                                    log.debug("#SPRINGJMATS# SQL Connection gotten from DataSourceUtils isWrapperFor(DeferredConnectionProxy), thus unwrapped to that: [" + deferredConnectionProxy + "], original: [" + connectionFromDataSourceUtils + "]");
                                    connectionEmployedState = () -> ((DeferredConnectionProxyDataSourceWrapper.DeferredConnectionProxy)deferredConnectionProxy).isActualConnectionRetrieved();
                                }
                            }
                            catch (SQLException e) {
                                log.warn("Got SQLException when trying to invoke .isWrapperFor(DeferredConnectionProxy) or .unwrap(DeferredConnectionProxy) on the SQL Connection retrieved by DataSourceUtils.getConnection(_dataSource). This should really not happen. Ignoring (cannot do sql-employ-tracking now) - please notify Mats maintainers about this situation.", (Throwable)e);
                            }
                        }
                    }
                    internalExecutionContext.setSqlTxConnectionSuppliers(() -> DataSourceUtils.getConnection((DataSource)this._dataSource), connectionEmployedState);
                    JmsMatsContextLocalCallback.bindResource((Object)JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.CONTEXT_LOCAL_KEY_CONNECTION_EMPLOYED_STATE_SUPPLIER, connectionEmployedState);
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("#SPRINGJMATS# About to run ProcessingLambda for " + this.stageOrInit(this._txContextKey) + ", within Spring SQL Transactional demarcation.");
                        }
                        lambda.performWithinTransaction();
                    }
                    catch (MatsEndpoint.MatsRefuseMessageException | JmsMatsException.JmsMatsJmsException | Error | RuntimeException e) {
                        log.error("#SPRINGJMATS# ROLLBACK SQL: " + e.getClass().getSimpleName() + " while processing " + this.stageOrInit(this._txContextKey) + " (should only be from user code). Rolling back the SQL Connection.", e);
                        internalExecutionContext.setUserLambdaExceptionLogged();
                        this.commitOrRollbackSqlTransaction(internalExecutionContext, connectionEmployedState, SqlTxAction.ROLLBACK, transactionStatus, e);
                        throw e;
                    }
                    catch (Throwable t) {
                        log.error("#SPRINGJMATS# ROLLBACK SQL: Got an undeclared checked exception " + t.getClass().getSimpleName() + " while processing " + this.stageOrInit(this._txContextKey) + " (should only be 'sneaky throws' of checked exception in user code). Rolling back the SQL Connection.", t);
                        internalExecutionContext.setUserLambdaExceptionLogged();
                        this.commitOrRollbackSqlTransaction(internalExecutionContext, connectionEmployedState, SqlTxAction.ROLLBACK, transactionStatus, t);
                        throw new JmsMatsException.JmsMatsUndeclaredCheckedExceptionRaisedRuntimeException("Got a undeclared checked exception " + t.getClass().getSimpleName() + " while processing " + this.stageOrInit(this._txContextKey) + ".", t);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("#SPRINGJMATS# COMMIT SQL: ProcessingLambda finished, committing SQL Connection.");
                    }
                    try {
                        internalExecutionContext.getJmsSessionHolder().isSessionOk();
                    }
                    catch (JmsMatsException.JmsMatsJmsException e) {
                        log.error("#SPRINGJMATS# ROLLBACK SQL: " + ((Object)((Object)e)).getClass().getSimpleName() + " when checking whether the JMS Session was OK. Rolling back the SQL Connection.", (Throwable)e);
                        this.commitOrRollbackSqlTransaction(internalExecutionContext, connectionEmployedState, SqlTxAction.ROLLBACK, transactionStatus, e);
                        throw e;
                    }
                    this.commitOrRollbackSqlTransaction(internalExecutionContext, connectionEmployedState, SqlTxAction.COMMIT, transactionStatus, null);
                });
            }
            catch (Throwable throwable) {
                Supplier connectionEmployedState = (Supplier)JmsMatsContextLocalCallback.getResource((Object)JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.CONTEXT_LOCAL_KEY_CONNECTION_EMPLOYED_STATE_SUPPLIER);
                if (connectionEmployedState != null && log.isDebugEnabled()) {
                    log.debug("About to exit the SQL Transactional Demarcation - SQL Connection " + ((Boolean)connectionEmployedState.get() != false ? "WAS" : "was NOT") + " employed!");
                }
                JmsMatsContextLocalCallback.unbindResource((Object)JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.CONTEXT_LOCAL_KEY_CONNECTION_EMPLOYED_STATE_SUPPLIER);
                throw throwable;
            }
            Supplier connectionEmployedState = (Supplier)JmsMatsContextLocalCallback.getResource((Object)JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.CONTEXT_LOCAL_KEY_CONNECTION_EMPLOYED_STATE_SUPPLIER);
            if (connectionEmployedState != null && log.isDebugEnabled()) {
                log.debug("About to exit the SQL Transactional Demarcation - SQL Connection " + ((Boolean)connectionEmployedState.get() != false ? "WAS" : "was NOT") + " employed!");
            }
            JmsMatsContextLocalCallback.unbindResource((Object)JmsMatsTransactionManager_JmsAndSpringManagedSqlTx.CONTEXT_LOCAL_KEY_CONNECTION_EMPLOYED_STATE_SUPPLIER);
        }

        private void commitOrRollbackSqlTransaction(JmsMatsInternalExecutionContext internalExecutionContext, Supplier<Boolean> sqlConnectionEmployedSupplier, SqlTxAction sqlTxAction, TransactionStatus transactionStatus, Throwable exceptionThatHappened) {
            if (!sqlConnectionEmployedSupplier.get().booleanValue() && log.isDebugEnabled()) {
                log.debug("#SPRINGJMATS# NOTICE: SQL Connection was NOT requested by stage or initiation (user code), so the following commit/rollback is no-op.");
            }
            long nanosAsStart_DbCommit = System.nanoTime();
            try {
                if (sqlTxAction == SqlTxAction.COMMIT) {
                    if (transactionStatus.isRollbackOnly()) {
                        String msg = "When about to commit the SQL Transaction [" + transactionStatus + "], we found that it was in a 'RollbackOnly' state. This implies that you have performed your own Spring transaction management within the Mats Stage/Initiation, which is not supported. Will now rollback the SQL, and throw out to rollback JMS.";
                        log.error("#SPRINGJMATS# " + msg);
                        sqlTxAction = SqlTxAction.ROLLBACK;
                        this._platformTransactionManager.rollback(transactionStatus);
                        throw new MatsSqlCommitWasRollbackOnlyException(msg);
                    }
                    this._platformTransactionManager.commit(transactionStatus);
                    if (log.isDebugEnabled()) {
                        log.debug("#SPRINGJMATS# Committed SQL Transaction [" + transactionStatus + "].");
                    }
                } else {
                    this._platformTransactionManager.rollback(transactionStatus);
                    if (log.isDebugEnabled()) {
                        log.warn("#SPRINGJMATS# Rolled Back SQL Transaction [" + transactionStatus + "].");
                    }
                }
            }
            catch (TransactionException e) {
                MatsSqlCommitOrRollbackFailedException failedException = new MatsSqlCommitOrRollbackFailedException("Could not [" + sqlTxAction + "] SQL Transaction [" + transactionStatus + "] - for [" + this._txContextKey + "].", e);
                if (exceptionThatHappened != null) {
                    failedException.addSuppressed(exceptionThatHappened);
                }
                throw failedException;
            }
            finally {
                internalExecutionContext.setDbCommitNanos(System.nanoTime() - nanosAsStart_DbCommit);
            }
        }

        static final class MatsSqlCommitOrRollbackFailedException
        extends RuntimeException {
            MatsSqlCommitOrRollbackFailedException(String message, Throwable cause) {
                super(message, cause);
            }
        }

        static final class MatsSqlCommitWasRollbackOnlyException
        extends RuntimeException {
            public MatsSqlCommitWasRollbackOnlyException(String message) {
                super(message);
            }
        }

        private static enum SqlTxAction {
            COMMIT,
            ROLLBACK;

        }
    }

    protected static class DeferredConnectionProxyDataSourceWrapper_InfrastructureProxy
    extends DeferredConnectionProxyDataSourceWrapper
    implements InfrastructureProxy {
        protected DeferredConnectionProxyDataSourceWrapper_InfrastructureProxy(DataSource targetDataSource) {
            super(targetDataSource);
        }

        public Object getWrappedObject() {
            DataSource targetDataSource = this.unwrap();
            if (targetDataSource instanceof InfrastructureProxy) {
                return ((InfrastructureProxy)targetDataSource).getWrappedObject();
            }
            return targetDataSource;
        }
    }
}

