/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.spring.jms.factories;

import io.mats3.spring.jms.factories.ConfigurableScenarioDecider;
import io.mats3.spring.jms.factories.ConnectionFactoryWithStartStopWrapper;
import io.mats3.spring.jms.factories.MatsProfiles;
import io.mats3.spring.jms.factories.MatsScenario;
import io.mats3.spring.jms.factories.ScenarioConnectionFactoryWrapper;
import io.mats3.test.broker.MatsTestBroker;
import javax.jms.ConnectionFactory;

public class ScenarioConnectionFactoryProducer
implements MatsProfiles {
    private ScenarioConnectionFactoryWrapper.ConnectionFactoryProvider _regularConnectionFactoryProvider;
    private ScenarioConnectionFactoryWrapper.ConnectionFactoryProvider _localhostConnectionFactoryProvider;
    private ScenarioConnectionFactoryWrapper.ConnectionFactoryProvider _localVmConnectionFactoryProvider;
    private ScenarioConnectionFactoryWrapper.ScenarioDecider _scenarioDecider;

    public ScenarioConnectionFactoryProducer() {
        this.withLocalhostConnectionFactory(springEnvironment -> new ScenarioLocalhostConnectionFactory());
        this.withLocalVmConnectionFactory(springEnvironment -> new ScenarioLocalVmConnectionFactory());
        this.withScenarioDecider(ConfigurableScenarioDecider.createDefaultScenarioDecider());
    }

    public static ScenarioConnectionFactoryProducer withRegularConnectionFactory(ScenarioConnectionFactoryWrapper.ConnectionFactoryProvider regularConnectionFactoryProvider) {
        ScenarioConnectionFactoryProducer ret = new ScenarioConnectionFactoryProducer();
        ret._regularConnectionFactoryProvider = regularConnectionFactoryProvider;
        return ret;
    }

    public ScenarioConnectionFactoryProducer withLocalhostConnectionFactory(ScenarioConnectionFactoryWrapper.ConnectionFactoryProvider localhostConnectionFactoryProvider) {
        this._localhostConnectionFactoryProvider = localhostConnectionFactoryProvider;
        return this;
    }

    public ScenarioConnectionFactoryProducer withLocalVmConnectionFactory(ScenarioConnectionFactoryWrapper.ConnectionFactoryProvider localVmConnectionFactoryProvider) {
        this._localVmConnectionFactoryProvider = localVmConnectionFactoryProvider;
        return this;
    }

    public ScenarioConnectionFactoryProducer withDefaultScenario(MatsScenario defaultScenario) {
        if (!(this._scenarioDecider instanceof ConfigurableScenarioDecider)) {
            throw new IllegalStateException("The ScenarioDecider in this " + this.getClass().getSimpleName() + " is not of type " + ConfigurableScenarioDecider.class.getSimpleName() + ", implying that you've used the method .scenarioDecider(..) to set a different implementation, thus I do not know how to set the default scenario on it.");
        }
        ((ConfigurableScenarioDecider)this._scenarioDecider).setDefaultScenario(() -> defaultScenario);
        return this;
    }

    public ScenarioConnectionFactoryProducer withScenarioDecider(ScenarioConnectionFactoryWrapper.ScenarioDecider scenarioDecider) {
        this._scenarioDecider = scenarioDecider;
        return this;
    }

    public ScenarioConnectionFactoryWrapper build() {
        return this.createConnectionFactory();
    }

    public ScenarioConnectionFactoryWrapper createConnectionFactory() {
        if (this._regularConnectionFactoryProvider == null) {
            throw new IllegalStateException("You have not provided the regular ConnectionFactory lambda.");
        }
        return new ScenarioConnectionFactoryWrapper(this._regularConnectionFactoryProvider, this._localhostConnectionFactoryProvider, this._localVmConnectionFactoryProvider, this._scenarioDecider);
    }

    private static class ScenarioLocalVmConnectionFactory
    extends ConnectionFactoryWithStartStopWrapper {
        private MatsTestBroker _matsTestBroker;

        private ScenarioLocalVmConnectionFactory() {
        }

        @Override
        public ConnectionFactory start(String beanName) {
            this._matsTestBroker = MatsTestBroker.create();
            return this._matsTestBroker.getConnectionFactory();
        }

        @Override
        public void stop() {
            this._matsTestBroker.close();
        }
    }

    private static class ScenarioLocalhostConnectionFactory
    extends ConnectionFactoryWithStartStopWrapper {
        private MatsTestBroker _matsTestBroker;

        private ScenarioLocalhostConnectionFactory() {
        }

        @Override
        public ConnectionFactory start(String beanName) {
            String previous = System.setProperty("mats.test.brokerurl", "localhost");
            this._matsTestBroker = MatsTestBroker.create();
            if (previous == null) {
                System.clearProperty("mats.test.brokerurl");
            } else {
                System.setProperty("mats.test.brokerurl", previous);
            }
            return this._matsTestBroker.getConnectionFactory();
        }

        @Override
        public void stop() {
            this._matsTestBroker.close();
        }
    }
}

