/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.serial.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.mats3.serial.MatsSerializer;
import io.mats3.serial.MatsTrace;
import io.mats3.serial.json.MatsTraceStringImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class MatsSerializerJson
implements MatsSerializer<String> {
    public static String IDENTIFICATION = "MatsTrace_JSON_v1";
    public static int DEFAULT_COMPRESSION_LEVEL = 1;
    private final int _compressionLevel;
    private final ObjectMapper _objectMapper;
    private final ObjectReader _matsTraceJson_Reader;
    private final ObjectWriter _matsTraceJson_Writer;
    private static final String COMPRESS_DEFLATE = "deflate";
    private static final String COMPRESS_PLAIN = "plain";
    private static final String DECOMPRESSED_SIZE_ATTRIBUTE = ";decompSize=";
    private static final NonblockingStack<Deflater> _deflaterPool = new NonblockingStack();
    private static final NonblockingStack<Inflater> _inflaterPool = new NonblockingStack();

    public static MatsSerializerJson create() {
        return new MatsSerializerJson(DEFAULT_COMPRESSION_LEVEL);
    }

    public static MatsSerializerJson create(int compressionLevel) {
        return new MatsSerializerJson(compressionLevel);
    }

    protected MatsSerializerJson(int compressionLevel) {
        this._compressionLevel = compressionLevel;
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.registerModule((Module)new Jdk8Module());
        this._matsTraceJson_Reader = mapper.readerFor(MatsTraceStringImpl.class);
        this._matsTraceJson_Writer = mapper.writerFor(MatsTraceStringImpl.class);
        this._objectMapper = mapper;
    }

    public boolean handlesMeta(String meta) {
        if (meta == null) {
            return false;
        }
        return meta.startsWith(COMPRESS_DEFLATE) || meta.startsWith(COMPRESS_PLAIN) | meta.startsWith(IDENTIFICATION);
    }

    public MatsTrace<String> createNewMatsTrace(String traceId, String flowId, MatsTrace.KeepMatsTrace keepMatsTrace, boolean nonPersistent, boolean interactive, long ttlMillis, boolean noAudit) {
        return MatsTraceStringImpl.createNew(traceId, flowId, keepMatsTrace, nonPersistent, interactive, ttlMillis, noAudit);
    }

    public MatsSerializer.SerializedMatsTrace serializeMatsTrace(MatsTrace<String> matsTrace) {
        try {
            String meta;
            long nanosTaken_Compression;
            byte[] resultBytes;
            long nanosAtStart_Serialization = System.nanoTime();
            byte[] serializedBytes = this._matsTraceJson_Writer.writeValueAsBytes(matsTrace);
            long now = System.nanoTime();
            long nanosTaken_Serialization = now - nanosAtStart_Serialization;
            long nanosAtStart_Compression = now;
            if (serializedBytes.length > 900) {
                resultBytes = this.compress(serializedBytes);
                nanosTaken_Compression = System.nanoTime() - nanosAtStart_Compression;
                meta = IDENTIFICATION + ':' + COMPRESS_DEFLATE + DECOMPRESSED_SIZE_ATTRIBUTE + serializedBytes.length;
            } else {
                resultBytes = serializedBytes;
                nanosTaken_Compression = 0L;
                meta = IDENTIFICATION + ':' + COMPRESS_PLAIN;
            }
            return new SerializedMatsTraceImpl(resultBytes, meta, serializedBytes.length, nanosTaken_Serialization, nanosTaken_Compression);
        }
        catch (JsonProcessingException e) {
            throw new MatsSerializer.SerializationException("Couldn't serialize MatsTrace, which is crazy!\n" + matsTrace, (Throwable)e);
        }
    }

    public MatsSerializer.DeserializedMatsTrace<String> deserializeMatsTrace(byte[] matsTraceBytes, String meta) {
        return this.deserializeMatsTrace(matsTraceBytes, 0, matsTraceBytes.length, meta);
    }

    public MatsSerializer.DeserializedMatsTrace<String> deserializeMatsTrace(byte[] matsTraceBytes, int offset, int length, String meta) {
        try {
            MatsTrace matsTrace;
            int decompressedBytesLength;
            long decompressionNanos;
            long nanosStartDeserialization;
            long nanosStart = System.nanoTime();
            if (meta.indexOf(58) != -1) {
                meta = meta.substring(meta.indexOf(58) + 1);
            }
            if (meta.startsWith(COMPRESS_DEFLATE)) {
                int bestGuessDecompressedSize = length * 4;
                int decompressedBytesAttributeIndex = meta.indexOf(DECOMPRESSED_SIZE_ATTRIBUTE);
                if (decompressedBytesAttributeIndex != -1) {
                    int start = decompressedBytesAttributeIndex + DECOMPRESSED_SIZE_ATTRIBUTE.length();
                    int end = meta.indexOf(59, start);
                    end = end != -1 ? end : meta.length();
                    String sizeString = meta.substring(start, end);
                    bestGuessDecompressedSize = Integer.parseInt(sizeString);
                }
                byte[] decompressedBytes = this.decompress(matsTraceBytes, offset, length, bestGuessDecompressedSize);
                nanosStartDeserialization = System.nanoTime();
                decompressionNanos = Math.max(1L, nanosStartDeserialization - nanosStart);
                decompressedBytesLength = decompressedBytes.length;
                matsTrace = (MatsTrace)this._matsTraceJson_Reader.readValue(decompressedBytes);
            } else if (meta.startsWith(COMPRESS_PLAIN)) {
                nanosStartDeserialization = nanosStart;
                decompressionNanos = 0L;
                decompressedBytesLength = length;
                matsTrace = (MatsTrace)this._matsTraceJson_Reader.readValue(matsTraceBytes, offset, length);
            } else {
                throw new AssertionError((Object)"Can only deserialize 'plain' and 'deflate'.");
            }
            long deserializationNanos = System.nanoTime() - nanosStartDeserialization;
            return new DeserializedMatsTraceImpl((MatsTrace<String>)matsTrace, matsTraceBytes.length, decompressedBytesLength, deserializationNanos, decompressionNanos);
        }
        catch (IOException e) {
            throw new MatsSerializer.SerializationException("Couldn't deserialize MatsTrace from given JSON, which is crazy!\n" + new String(matsTraceBytes, StandardCharsets.UTF_8), (Throwable)e);
        }
    }

    public String serializeObject(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return this._objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new MatsSerializer.SerializationException("Couldn't serialize Object [" + object + "].", (Throwable)e);
        }
    }

    public int sizeOfSerialized(String s) {
        if (s == null) {
            return 0;
        }
        return s.length();
    }

    public <T> T deserializeObject(String serialized, Class<T> type) {
        if (serialized == null) {
            return null;
        }
        try {
            return (T)this._objectMapper.readValue(serialized, type);
        }
        catch (IOException e) {
            throw new MatsSerializer.SerializationException("Couldn't deserialize JSON into object of type [" + type + "].\n" + serialized, (Throwable)e);
        }
    }

    public <T> T newInstance(Class<T> clazz) {
        Constructor<T> noArgsConstructor;
        try {
            noArgsConstructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new CannotCreateEmptyInstanceException("Missing no-args constructor on class [" + clazz.getName() + "].", e);
        }
        try {
            noArgsConstructor.setAccessible(true);
            return noArgsConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new CannotCreateEmptyInstanceException("Couldn't create new empty instance of class [" + clazz.getName() + "].", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] compress(byte[] data) {
        Deflater deflater = _deflaterPool.pop();
        if (deflater == null) {
            deflater = new Deflater(this._compressionLevel);
        }
        boolean reuseDeflater = false;
        try {
            deflater.setInput(data);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length / 2);
            deflater.finish();
            byte[] buffer = new byte[2048];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new DecompressionException("Shall not throw IOException here.", e);
            }
            reuseDeflater = true;
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            if (reuseDeflater) {
                deflater.reset();
                _deflaterPool.push(deflater);
            } else {
                deflater.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] decompress(byte[] data, int offset, int length, int bestGuessDecompressedSize) {
        Inflater inflater = _inflaterPool.pop();
        if (inflater == null) {
            inflater = new Inflater();
        }
        boolean reuseInflater = false;
        try {
            inflater.setInput(data, offset, length);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(bestGuessDecompressedSize);
            byte[] buffer = new byte[4096];
            while (!inflater.finished()) {
                try {
                    int count = inflater.inflate(buffer);
                    outputStream.write(buffer, 0, count);
                }
                catch (DataFormatException e) {
                    throw new DecompressionException("DataFormatException was bad here.", e);
                }
            }
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new DecompressionException("Shall not throw IOException here.", e);
            }
            reuseInflater = true;
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            if (reuseInflater) {
                inflater.reset();
                _inflaterPool.push(inflater);
            } else {
                inflater.end();
            }
        }
    }

    private static class DecompressionException
    extends MatsSerializer.SerializationException {
        DecompressionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class NonblockingStack<E> {
        AtomicReference<Node<E>> head = new AtomicReference();

        private NonblockingStack() {
        }

        public void push(E item) {
            Node<E> oldHead;
            Node<E> newHead = new Node<E>(item);
            do {
                oldHead = this.head.get();
                newHead.next = oldHead;
            } while (!this.head.compareAndSet(oldHead, newHead));
        }

        public E pop() {
            Node newHead;
            Node<E> oldHead;
            do {
                if ((oldHead = this.head.get()) != null) continue;
                return null;
            } while (!this.head.compareAndSet(oldHead, newHead = oldHead.next));
            return oldHead.item;
        }

        static class Node<E> {
            final E item;
            Node<E> next;

            public Node(E item) {
                this.item = item;
            }
        }
    }

    private static class CannotCreateEmptyInstanceException
    extends MatsSerializer.SerializationException {
        CannotCreateEmptyInstanceException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static final class DeserializedMatsTraceImpl
    implements MatsSerializer.DeserializedMatsTrace<String> {
        private final MatsTrace<String> _matsTrace;
        private final int _sizeIncoming;
        private final int _sizeDecompressed;
        private final long _nanosDeserialization;
        private final long _nanosDecompression;

        public DeserializedMatsTraceImpl(MatsTrace<String> matsTrace, int sizeIncoming, int sizeDecompressed, long nanosDeserialization, long nanosDecompression) {
            this._matsTrace = matsTrace;
            this._sizeIncoming = sizeIncoming;
            this._sizeDecompressed = sizeDecompressed;
            this._nanosDeserialization = nanosDeserialization;
            this._nanosDecompression = nanosDecompression;
        }

        public MatsTrace<String> getMatsTrace() {
            return this._matsTrace;
        }

        public int getSizeIncoming() {
            return this._sizeIncoming;
        }

        public int getSizeDecompressed() {
            return this._sizeDecompressed;
        }

        public long getNanosDeserialization() {
            return this._nanosDeserialization;
        }

        public long getNanosDecompression() {
            return this._nanosDecompression;
        }
    }

    private static class SerializedMatsTraceImpl
    implements MatsSerializer.SerializedMatsTrace {
        private final byte[] _matsTraceBytes;
        private final String _meta;
        private final int _sizeUncompressed;
        private final long _nanosSerialization;
        private final long _nanosCompression;

        public SerializedMatsTraceImpl(byte[] matsTraceBytes, String meta, int sizeUncompressed, long nanosSerialization, long nanosCompression) {
            this._matsTraceBytes = matsTraceBytes;
            this._meta = meta;
            this._sizeUncompressed = sizeUncompressed;
            this._nanosSerialization = nanosSerialization;
            this._nanosCompression = nanosCompression;
        }

        public byte[] getMatsTraceBytes() {
            return this._matsTraceBytes;
        }

        public String getMeta() {
            return this._meta;
        }

        public int getSizeUncompressed() {
            return this._sizeUncompressed;
        }

        public long getNanosSerialization() {
            return this._nanosSerialization;
        }

        public long getNanosCompression() {
            return this._nanosCompression;
        }
    }
}

