/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.intercept.micrometer;

import io.mats3.MatsEndpoint;
import io.mats3.MatsFactory;
import io.mats3.api.intercept.CommonCompletedContext;
import io.mats3.api.intercept.MatsInitiateInterceptor;
import io.mats3.api.intercept.MatsMetricsInterceptor;
import io.mats3.api.intercept.MatsOutgoingMessage;
import io.mats3.api.intercept.MatsStageInterceptor;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatsMicrometerInterceptor
implements MatsMetricsInterceptor,
MatsInitiateInterceptor,
MatsStageInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MatsMicrometerInterceptor.class);
    public static final String LOG_PREFIX = "#MATSMETRICS# ";
    public static final String TIMER_EXEC_TOTAL_NAME = "mats.exec.total";
    public static final String TIMER_EXEC_TOTAL_DESC = "Total time taken to execute init or stage.";
    public static final String TIMER_EXEC_USER_LAMBDA_NAME = "mats.exec.userlambda";
    public static final String TIMER_EXEC_USER_LAMBDA_DESC = "Part of total exec time taken for the actual user lambda itself from start to finish, which thus includes any external IO like e.g. DB or HTTP calls the user code performs, minus any time taken to construct outbound Mats messages. Any use 'ctx.log[Timing]Measurement(..)' within user lambda, to break out e.g. metrics for any potentially expensive IO, is available as 'mats.exec.ops.time.' and 'mats.exec.ops.measure.' metrics.";
    public static final String TIMER_EXEC_OUT_NAME = "mats.exec.out";
    public static final String TIMER_EXEC_OUT_DESC = "Part of total exec time taken to produce and send messages: Produce, serialize and compress all DTOs, STOs and message envelopes, and produce and send all system messages.";
    public static final String QUANTITY_EXEC_OUT_NAME = "mats.exec.out.quantity";
    public static final String QUANTITY_EXEC_OUT_DESC = "Number of outgoing messages from execution.";
    public static final String TIMER_EXEC_DB_COMMIT_NAME = "mats.exec.db.commit";
    public static final String TIMER_EXEC_DB_COMMIT_DESC = "Part of total time taken to commit database.";
    public static final String TIMER_EXEC_MSGSYS_COMMIT_NAME = "mats.exec.msgsys.commit";
    public static final String TIMER_EXEC_MSGSYS_COMMIT_DESC = "Part of total time taken to commit message system.";
    public static final String TIMER_EXEC_OPS_PREFIX = "mats.exec.ops.time.";
    public static final String MEASURE_EXEC_OPS_PREFIX = "mats.exec.ops.measure.";
    public static final String TIMER_IN_TOTAL_NAME = "mats.in.total";
    public static final String TIMER_IN_TOTAL_DESC = "Total time taken to preprocess and deserialize incoming message.";
    public static final String TIMER_OUT_TOTAL_NAME = "mats.out.total";
    public static final String TIMER_OUT_TOTAL_DESC = "Total time taken to produce, serialize and compress DTO, STO and message envelope, and produce and send system message.";
    public static final String TIMER_OUT_MSGSYS_SEND_NAME = "mats.out.msgsys";
    public static final String TIMER_OUT_MSGSYS_SEND_DESC = "From out total, time taken to produce and send message. system message";
    public static final String SIZE_OUT_ENVELOPE_NAME = "mats.out.envelope";
    public static final String SIZE_OUT_ENVELOPE_DESC = "Outgoing mats envelope full size.";
    public static final String SIZE_OUT_WIRE_NAME = "mats.out.wire";
    public static final String SIZE_OUT_WIRE_DESC = "Outgoing mats envelope wire size.";
    private static final int NO_STAGE_INDEX = -1;
    public static final String TAG_APP_NAME = "appName";
    public static final String TAG_APP_VERSION = "appVersion";
    public static final String TAG_EXEC = "exec";
    public static final String TAG_TYPE = "type";
    public static final String TAG_INITIATING_APP_NAME = "initiatingAppName";
    public static final String TAG_INITIATOR_ID = "initiatorId";
    public static final String TAG_STAGE_ID = "stageId";
    public static final String TAG_INIT_OR_STAGE_ID = "initOrStageId";
    public static final String TAG_STAGE_INDEX = "stageIndex";
    public static final String TAG_FROM = "from";
    public static final String TAG_TO = "to";
    public static final String UNIT_BYTES = "bytes";
    public static final int MAX_NUMBER_OF_METRICS = 200;
    private final boolean _includeAllTags;
    private final LazyPopulatedCopyOnWriteMap<ExecutionMetrics.ExecutionMetricsParams, ExecutionMetrics> _executionMetricsCache = new LazyPopulatedCopyOnWriteMap<ExecutionMetrics.ExecutionMetricsParams, ExecutionMetrics>(params -> new ExecutionMetrics(meterRegistry, appName, appVersion, (ExecutionMetrics.ExecutionMetricsParams)params));
    private final LazyPopulatedCopyOnWriteMap<UserMetricsParams, UserMeasurementMetrics> _userMeasurementMetrics = new LazyPopulatedCopyOnWriteMap<UserMetricsParams, UserMeasurementMetrics>(params -> new UserMeasurementMetrics(meterRegistry, appName, appVersion, (UserMetricsParams)params));
    private final LazyPopulatedCopyOnWriteMap<UserMetricsParams, UserTimingMetrics> _userTimingMetrics = new LazyPopulatedCopyOnWriteMap<UserMetricsParams, UserTimingMetrics>(params -> new UserTimingMetrics(meterRegistry, appName, appVersion, (UserMetricsParams)params));
    private final LazyPopulatedCopyOnWriteMap<ReceivedMetrics.ReceivedMetricsParams, ReceivedMetrics> _receivedMetricsCache = new LazyPopulatedCopyOnWriteMap<ReceivedMetrics.ReceivedMetricsParams, ReceivedMetrics>(params -> new ReceivedMetrics(meterRegistry, appName, appVersion, (ReceivedMetrics.ReceivedMetricsParams)params));
    private final LazyPopulatedCopyOnWriteMap<MessageSentMetrics.MessageSentMetricsParams, MessageSentMetrics> _messageMetricsCache = new LazyPopulatedCopyOnWriteMap<MessageSentMetrics.MessageSentMetricsParams, MessageSentMetrics>(params -> new MessageSentMetrics(meterRegistry, appName, appVersion, (MessageSentMetrics.MessageSentMetricsParams)params));

    private MatsMicrometerInterceptor(MeterRegistry meterRegistry, String appName, String appVersion, boolean includeAllTags) {
        this._includeAllTags = includeAllTags;
    }

    public static MatsMicrometerInterceptor install(MatsFactory matsFactory, MeterRegistry meterRegistry, boolean includeAllTags) {
        MatsFactory.FactoryConfig factoryConfig = matsFactory.getFactoryConfig();
        MatsMicrometerInterceptor metrics = new MatsMicrometerInterceptor(meterRegistry, factoryConfig.getAppName(), factoryConfig.getAppVersion(), includeAllTags);
        factoryConfig.installPlugin((MatsFactory.MatsPlugin)metrics);
        return metrics;
    }

    public static MatsMicrometerInterceptor install(MatsFactory matsFactory) {
        return MatsMicrometerInterceptor.install(matsFactory, (MeterRegistry)Metrics.globalRegistry, false);
    }

    public void initiateCompleted(MatsInitiateInterceptor.InitiateCompletedContext ctx) {
        String initiatingAppName = ctx.getInitiator().getParentFactory().getFactoryConfig().getAppName();
        String initiatorName = ctx.getInitiator().getName();
        List outgoingMessages = ctx.getOutgoingMessages();
        String commonInitiatorId = outgoingMessages.isEmpty() ? "_no_outgoing_messages_" : ((MatsOutgoingMessage.MatsSentOutgoingMessage)outgoingMessages.get(0)).getInitiatorId();
        ExecutionMetrics executionMetrics = this._executionMetricsCache.getOrCreate(new ExecutionMetrics.ExecutionMetricsParams("init", initiatingAppName, commonInitiatorId, "", commonInitiatorId, -1));
        if (executionMetrics != null) {
            executionMetrics.registerMeasurements((CommonCompletedContext)ctx);
        }
        this.userTimingsAndMeasurements((CommonCompletedContext)ctx, "init", initiatingAppName, commonInitiatorId, "", commonInitiatorId, -1);
        for (MatsOutgoingMessage.MatsSentOutgoingMessage msg : outgoingMessages) {
            String initiatorId = msg.getInitiatorId();
            MessageSentMetrics messageSentMetrics = this._messageMetricsCache.getOrCreate(new MessageSentMetrics.MessageSentMetricsParams("init", msg.getMessageType().toString(), initiatingAppName, initiatorId, "", initiatorId, -1, msg.getTo()));
            if (messageSentMetrics == null) continue;
            messageSentMetrics.registerMeasurements(msg);
        }
    }

    public void stageReceived(MatsStageInterceptor.StageReceivedContext ctx) {
        MatsEndpoint.ProcessContext processContext = ctx.getProcessContext();
        String initiatingAppName = this._includeAllTags ? processContext.getInitiatingAppName() : "";
        String initiatorId = this._includeAllTags ? processContext.getInitiatorId() : "";
        String stageId = processContext.getStageId();
        int stageIndex = ctx.getStage().getStageConfig().getStageIndex();
        String from = !this._includeAllTags && stageIndex == 0 ? "" : processContext.getFromStageId();
        ReceivedMetrics receivedMetrics = this._receivedMetricsCache.getOrCreate(new ReceivedMetrics.ReceivedMetricsParams(ctx.getIncomingMessageType().toString(), initiatingAppName, initiatorId, from, stageId, stageId, stageIndex));
        if (receivedMetrics != null) {
            receivedMetrics.registerMeasurements(ctx);
        }
    }

    public void stageCompleted(MatsStageInterceptor.StageCompletedContext ctx) {
        int stageIndex;
        String stageId;
        String initiatorId;
        MatsEndpoint.DetachedProcessContext processContext;
        String initiatingAppName = this._includeAllTags ? processContext.getInitiatingAppName() : "";
        ExecutionMetrics executionMetrics = this._executionMetricsCache.getOrCreate(new ExecutionMetrics.ExecutionMetricsParams("stage", initiatingAppName, initiatorId = this._includeAllTags ? processContext.getInitiatorId() : "", stageId = (processContext = ctx.getProcessContext()).getStageId(), stageId, stageIndex = ctx.getStage().getStageConfig().getStageIndex()));
        if (executionMetrics != null) {
            executionMetrics.registerMeasurements((CommonCompletedContext)ctx);
        }
        this.userTimingsAndMeasurements((CommonCompletedContext)ctx, "stage", initiatingAppName, initiatorId, stageId, stageId, stageIndex);
        for (MatsOutgoingMessage.MatsSentOutgoingMessage msg : ctx.getOutgoingMessages()) {
            String to;
            String string = to = !this._includeAllTags && msg.getMessageType() == MatsOutgoingMessage.MessageType.REPLY ? "" : msg.getTo();
            MessageSentMetrics messageSentMetrics = this._messageMetricsCache.getOrCreate(new MessageSentMetrics.MessageSentMetricsParams("stage", msg.getMessageType().toString(), initiatingAppName, initiatorId, stageId, stageId, stageIndex, to));
            if (messageSentMetrics == null) continue;
            messageSentMetrics.registerMeasurements(msg);
        }
    }

    private void userTimingsAndMeasurements(CommonCompletedContext ctx, String executionType, String initiatingAppName, String initiatorId, String stageId, String initOrStageId, int stageIndex) {
        List timings = ctx.getTimingMeasurements();
        for (CommonCompletedContext.MatsTimingMeasurement timing : timings) {
            String metricId = timing.getMetricId();
            String metricDescription = timing.getMetricDescription();
            String[] labelKeyValue = timing.getLabelKeyValue();
            long nanos = timing.getNanos();
            UserTimingMetrics userTimingMetrics = this._userTimingMetrics.getOrCreate(new UserMetricsParams(executionType, initiatingAppName, initiatorId, stageId, initOrStageId, stageIndex, metricId, metricDescription, "", labelKeyValue));
            if (userTimingMetrics == null) continue;
            userTimingMetrics.registerMeasurements(nanos);
        }
        List measurements = ctx.getMeasurements();
        for (CommonCompletedContext.MatsMeasurement measurement : measurements) {
            String metricId = measurement.getMetricId();
            String metricDescription = measurement.getMetricDescription();
            String baseUnit = measurement.getBaseUnit();
            String[] labelKeyValue = measurement.getLabelKeyValue();
            double measure = measurement.getMeasure();
            UserMeasurementMetrics userMeasurementMetrics = this._userMeasurementMetrics.getOrCreate(new UserMetricsParams(executionType, initiatingAppName, initiatorId, stageId, initOrStageId, stageIndex, metricId, metricDescription, baseUnit, labelKeyValue));
            if (userMeasurementMetrics == null) continue;
            userMeasurementMetrics.registerMeasurements(measure);
        }
    }

    static String stageIndexString(int stageIndex) {
        return stageIndex == -1 ? "" : Integer.toString(stageIndex);
    }

    static class MessageSentMetrics {
        private final DistributionSummary _size_Envelope;
        private final DistributionSummary _size_Wire;
        private final Timer _timer_Total;
        private final Timer _timer_MsgSys;

        MessageSentMetrics(MeterRegistry meterRegistry, String appName, String appVersion, MessageSentMetricsParams params) {
            String stageIndexValue = MatsMicrometerInterceptor.stageIndexString(params._stageIndex);
            this._size_Envelope = DistributionSummary.builder((String)MatsMicrometerInterceptor.SIZE_OUT_ENVELOPE_NAME).tag(MatsMicrometerInterceptor.TAG_APP_NAME, appName).tag(MatsMicrometerInterceptor.TAG_APP_VERSION, appVersion).tag(MatsMicrometerInterceptor.TAG_EXEC, params._executionType).tag(MatsMicrometerInterceptor.TAG_TYPE, params._messageType).tag(MatsMicrometerInterceptor.TAG_INITIATING_APP_NAME, params._initiatingAppName).tag(MatsMicrometerInterceptor.TAG_INITIATOR_ID, params._initiatorId).tag(MatsMicrometerInterceptor.TAG_STAGE_ID, params._stageId).tag(MatsMicrometerInterceptor.TAG_INIT_OR_STAGE_ID, params._initOrStageId).tag(MatsMicrometerInterceptor.TAG_STAGE_INDEX, stageIndexValue).tag(MatsMicrometerInterceptor.TAG_TO, params._to).baseUnit(MatsMicrometerInterceptor.UNIT_BYTES).description(MatsMicrometerInterceptor.SIZE_OUT_ENVELOPE_DESC).register(meterRegistry);
            this._size_Wire = DistributionSummary.builder((String)MatsMicrometerInterceptor.SIZE_OUT_WIRE_NAME).tag(MatsMicrometerInterceptor.TAG_APP_NAME, appName).tag(MatsMicrometerInterceptor.TAG_APP_VERSION, appVersion).tag(MatsMicrometerInterceptor.TAG_EXEC, params._executionType).tag(MatsMicrometerInterceptor.TAG_TYPE, params._messageType).tag(MatsMicrometerInterceptor.TAG_INITIATING_APP_NAME, params._initiatingAppName).tag(MatsMicrometerInterceptor.TAG_INITIATOR_ID, params._initiatorId).tag(MatsMicrometerInterceptor.TAG_STAGE_ID, params._stageId).tag(MatsMicrometerInterceptor.TAG_INIT_OR_STAGE_ID, params._initOrStageId).tag(MatsMicrometerInterceptor.TAG_STAGE_INDEX, stageIndexValue).tag(MatsMicrometerInterceptor.TAG_TO, params._to).baseUnit(MatsMicrometerInterceptor.UNIT_BYTES).description(MatsMicrometerInterceptor.SIZE_OUT_WIRE_DESC).register(meterRegistry);
            this._timer_Total = Timer.builder((String)MatsMicrometerInterceptor.TIMER_OUT_TOTAL_NAME).tag(MatsMicrometerInterceptor.TAG_APP_NAME, appName).tag(MatsMicrometerInterceptor.TAG_APP_VERSION, appVersion).tag(MatsMicrometerInterceptor.TAG_EXEC, params._executionType).tag(MatsMicrometerInterceptor.TAG_TYPE, params._messageType).tag(MatsMicrometerInterceptor.TAG_INITIATING_APP_NAME, params._initiatingAppName).tag(MatsMicrometerInterceptor.TAG_INITIATOR_ID, params._initiatorId).tag(MatsMicrometerInterceptor.TAG_STAGE_ID, params._stageId).tag(MatsMicrometerInterceptor.TAG_INIT_OR_STAGE_ID, params._initOrStageId).tag(MatsMicrometerInterceptor.TAG_STAGE_INDEX, stageIndexValue).tag(MatsMicrometerInterceptor.TAG_TO, params._to).description(MatsMicrometerInterceptor.TIMER_OUT_TOTAL_DESC).register(meterRegistry);
            this._timer_MsgSys = Timer.builder((String)MatsMicrometerInterceptor.TIMER_OUT_MSGSYS_SEND_NAME).tag(MatsMicrometerInterceptor.TAG_APP_NAME, appName).tag(MatsMicrometerInterceptor.TAG_APP_VERSION, appVersion).tag(MatsMicrometerInterceptor.TAG_EXEC, params._executionType).tag(MatsMicrometerInterceptor.TAG_TYPE, params._messageType).tag(MatsMicrometerInterceptor.TAG_INITIATING_APP_NAME, params._initiatingAppName).tag(MatsMicrometerInterceptor.TAG_INITIATOR_ID, params._initiatorId).tag(MatsMicrometerInterceptor.TAG_STAGE_ID, params._stageId).tag(MatsMicrometerInterceptor.TAG_INIT_OR_STAGE_ID, params._initOrStageId).tag(MatsMicrometerInterceptor.TAG_STAGE_INDEX, stageIndexValue).tag(MatsMicrometerInterceptor.TAG_TO, params._to).description(MatsMicrometerInterceptor.TIMER_OUT_MSGSYS_SEND_DESC).register(meterRegistry);
        }

        void registerMeasurements(MatsOutgoingMessage.MatsSentOutgoingMessage msg) {
            this._size_Envelope.record((double)msg.getEnvelopeWireSize());
            this._size_Wire.record((double)msg.getEnvelopeWireSize());
            this._timer_Total.record(msg.getEnvelopeProduceNanos() + msg.getEnvelopeSerializationNanos() + msg.getEnvelopeCompressionNanos() + msg.getMessageSystemProduceAndSendNanos(), TimeUnit.NANOSECONDS);
            this._timer_MsgSys.record(msg.getMessageSystemProduceAndSendNanos(), TimeUnit.NANOSECONDS);
        }

        static class MessageSentMetricsParams {
            final String _executionType;
            final String _messageType;
            final String _initiatingAppName;
            final String _initiatorId;
            final String _stageId;
            final String _initOrStageId;
            final int _stageIndex;
            final String _to;
            final int _hashCode;

            MessageSentMetricsParams(String executionType, String messageType, String initiatingAppName, String initiatorId, String stageId, String initOrStageId, int stageIndex, String to) {
                this._executionType = executionType;
                this._messageType = messageType;
                this._initiatingAppName = initiatingAppName;
                this._initiatorId = initiatorId;
                this._stageId = stageId;
                this._initOrStageId = initOrStageId;
                this._stageIndex = stageIndex;
                this._to = to;
                this._hashCode = executionType.hashCode() + messageType.hashCode() + initiatingAppName.hashCode() + initiatorId.hashCode() + initOrStageId.hashCode() + to.hashCode();
            }

            public boolean equals(Object o) {
                MessageSentMetricsParams that = (MessageSentMetricsParams)o;
                return Objects.equals(this._executionType, that._executionType) && Objects.equals(this._messageType, that._messageType) && Objects.equals(this._initiatingAppName, that._initiatingAppName) && Objects.equals(this._initiatorId, that._initiatorId) && Objects.equals(this._initOrStageId, that._initOrStageId) && Objects.equals(this._to, that._to);
            }

            public int hashCode() {
                return this._hashCode;
            }

            public String toString() {
                return "MessageMetricsParams{_executionType='" + this._executionType + "', _messageType='" + this._messageType + "', _initiatingAppName='" + this._initiatingAppName + "', _initiatorId='" + this._initiatorId + "', _initOrStageId='" + this._initOrStageId + "', _stageIndex=" + this._stageIndex + ", _to='" + this._to + "'}";
            }
        }
    }

    static class ReceivedMetrics {
        private final Timer _timer_Total;

        ReceivedMetrics(MeterRegistry meterRegistry, String appName, String appVersion, ReceivedMetricsParams params) {
            this._timer_Total = Timer.builder((String)MatsMicrometerInterceptor.TIMER_IN_TOTAL_NAME).tag(MatsMicrometerInterceptor.TAG_APP_NAME, appName).tag(MatsMicrometerInterceptor.TAG_APP_VERSION, appVersion).tag(MatsMicrometerInterceptor.TAG_EXEC, "stage").tag(MatsMicrometerInterceptor.TAG_TYPE, params._messageType).tag(MatsMicrometerInterceptor.TAG_INITIATING_APP_NAME, params._initiatingAppName).tag(MatsMicrometerInterceptor.TAG_INITIATOR_ID, params._initiatorId).tag(MatsMicrometerInterceptor.TAG_FROM, params._from).tag(MatsMicrometerInterceptor.TAG_STAGE_ID, params._stageId).tag(MatsMicrometerInterceptor.TAG_INIT_OR_STAGE_ID, params._initOrStageId).tag(MatsMicrometerInterceptor.TAG_STAGE_INDEX, MatsMicrometerInterceptor.stageIndexString(params._stageIndex)).description(MatsMicrometerInterceptor.TIMER_IN_TOTAL_DESC).register(meterRegistry);
        }

        void registerMeasurements(MatsStageInterceptor.StageReceivedContext ctx) {
            this._timer_Total.record(ctx.getTotalPreprocessAndDeserializeNanos(), TimeUnit.NANOSECONDS);
        }

        static class ReceivedMetricsParams {
            final String _messageType;
            final String _initiatingAppName;
            final String _initiatorId;
            final String _from;
            final String _stageId;
            final String _initOrStageId;
            final int _stageIndex;
            final int _hashCode;

            public ReceivedMetricsParams(String messageType, String initiatingAppName, String initiatorId, String from, String stageId, String initOrStageId, int stageIndex) {
                this._messageType = messageType;
                this._initiatingAppName = initiatingAppName;
                this._initiatorId = initiatorId;
                this._from = from;
                this._stageId = stageId;
                this._initOrStageId = initOrStageId;
                this._stageIndex = stageIndex;
                this._hashCode = messageType.hashCode() + initiatingAppName.hashCode() + initiatorId.hashCode() + from.hashCode() + initOrStageId.hashCode();
            }

            public boolean equals(Object o) {
                ReceivedMetricsParams that = (ReceivedMetricsParams)o;
                return Objects.equals(this._messageType, that._messageType) && Objects.equals(this._initiatingAppName, that._initiatingAppName) && Objects.equals(this._initiatorId, that._initiatorId) && Objects.equals(this._from, that._from) && Objects.equals(this._initOrStageId, that._initOrStageId);
            }

            public int hashCode() {
                return this._hashCode;
            }

            public String toString() {
                return "ReceivedMetricsParams{_messageType='" + this._messageType + "', _initiatingAppName='" + this._initiatingAppName + "', _initiatorId='" + this._initiatorId + "', _from='" + this._from + "', _initOrStageId='" + this._initOrStageId + "', _stageIndex=" + this._stageIndex + "}";
            }
        }
    }

    static class UserMetricsParams {
        final String _executionType;
        final String _initiatingAppName;
        final String _initiatorId;
        final String _stageId;
        final String _initOrStageId;
        final int _stageIndex;
        final String _metricId;
        final String _metricDescription;
        final String _baseUnit;
        final String[] _labelKeyValue;
        final int _hashCode;

        public UserMetricsParams(String executionType, String initiatingAppName, String initiatorId, String stageId, String initOrStageId, int stageIndex, String metricId, String metricDescription, String baseUnit, String[] labelKeyValue) {
            this._executionType = executionType;
            this._initiatingAppName = initiatingAppName;
            this._initiatorId = initiatorId;
            this._stageId = stageId;
            this._initOrStageId = initOrStageId;
            this._stageIndex = stageIndex;
            this._metricId = metricId;
            this._metricDescription = metricDescription;
            this._baseUnit = baseUnit;
            this._labelKeyValue = labelKeyValue;
            this._hashCode = executionType.hashCode() + initiatingAppName.hashCode() + initiatorId.hashCode() + initOrStageId.hashCode() + metricId.hashCode() + baseUnit.hashCode() + Arrays.hashCode(this._labelKeyValue);
        }

        public boolean equals(Object o) {
            UserMetricsParams that = (UserMetricsParams)o;
            return Objects.equals(this._executionType, that._executionType) && Objects.equals(this._initiatingAppName, that._initiatingAppName) && Objects.equals(this._initiatorId, that._initiatorId) && Objects.equals(this._initOrStageId, that._initOrStageId) && Objects.equals(this._metricId, that._metricId) && Objects.equals(this._baseUnit, that._baseUnit) && Arrays.equals(this._labelKeyValue, that._labelKeyValue);
        }

        public int hashCode() {
            return this._hashCode;
        }

        public String toString() {
            return "UserMetricsParams{_executionType='" + this._executionType + "', _initiatingAppName='" + this._initiatingAppName + "', _initiatorId='" + this._initiatorId + "', _initOrStageId='" + this._initOrStageId + "', _stageIndex=" + this._stageIndex + ", _metricId='" + this._metricId + "', _metricDescription='" + this._metricDescription + "', _baseUnit='" + this._baseUnit + "', _labelKeyValue=" + Arrays.toString(this._labelKeyValue) + "}";
        }
    }

    static class UserTimingMetrics {
        private final Timer _timer;

        UserTimingMetrics(MeterRegistry meterRegistry, String appName, String appVersion, UserMetricsParams params) {
            Timer.Builder builder = Timer.builder((String)(MatsMicrometerInterceptor.TIMER_EXEC_OPS_PREFIX + params._metricId)).tag(MatsMicrometerInterceptor.TAG_APP_NAME, appName).tag(MatsMicrometerInterceptor.TAG_APP_VERSION, appVersion).tag(MatsMicrometerInterceptor.TAG_EXEC, params._executionType).tag(MatsMicrometerInterceptor.TAG_INITIATING_APP_NAME, params._initiatingAppName).tag(MatsMicrometerInterceptor.TAG_INITIATOR_ID, params._initiatorId).tag(MatsMicrometerInterceptor.TAG_STAGE_ID, params._stageId).tag(MatsMicrometerInterceptor.TAG_INIT_OR_STAGE_ID, params._initOrStageId).tag(MatsMicrometerInterceptor.TAG_STAGE_INDEX, MatsMicrometerInterceptor.stageIndexString(params._stageIndex)).description(params._metricDescription);
            String[] labelKeyValue = params._labelKeyValue;
            for (int i = 0; i < labelKeyValue.length; i += 2) {
                String key = labelKeyValue[i];
                String value = labelKeyValue[i + 1];
                builder.tag(key, value);
            }
            this._timer = builder.register(meterRegistry);
        }

        void registerMeasurements(long nanos) {
            this._timer.record(nanos, TimeUnit.NANOSECONDS);
        }
    }

    static class UserMeasurementMetrics {
        private final DistributionSummary _measure;

        UserMeasurementMetrics(MeterRegistry meterRegistry, String appName, String appVersion, UserMetricsParams params) {
            DistributionSummary.Builder builder = DistributionSummary.builder((String)(MatsMicrometerInterceptor.MEASURE_EXEC_OPS_PREFIX + params._metricId)).tag(MatsMicrometerInterceptor.TAG_APP_NAME, appName).tag(MatsMicrometerInterceptor.TAG_APP_VERSION, appVersion).tag(MatsMicrometerInterceptor.TAG_EXEC, params._executionType).tag(MatsMicrometerInterceptor.TAG_INITIATING_APP_NAME, params._initiatingAppName).tag(MatsMicrometerInterceptor.TAG_INITIATOR_ID, params._initiatorId).tag(MatsMicrometerInterceptor.TAG_STAGE_ID, params._stageId).tag(MatsMicrometerInterceptor.TAG_INIT_OR_STAGE_ID, params._initOrStageId).tag(MatsMicrometerInterceptor.TAG_STAGE_INDEX, MatsMicrometerInterceptor.stageIndexString(params._stageIndex)).baseUnit(params._baseUnit).description(params._metricDescription);
            String[] labelKeyValue = params._labelKeyValue;
            for (int i = 0; i < labelKeyValue.length; i += 2) {
                String key = labelKeyValue[i];
                String value = labelKeyValue[i + 1];
                builder.tag(key, value);
            }
            this._measure = builder.register(meterRegistry);
        }

        void registerMeasurements(double measurement) {
            this._measure.record(measurement);
        }
    }

    static class ExecutionMetrics {
        private final Timer _timer_TotalTime;
        private final Timer _timer_UserLambda;
        private final Timer _timer_DbCommit;
        private final Timer _timer_MsgOut;
        private final Timer _timer_MsgCommit;
        DistributionSummary _count_Messages;

        Timer timerAddTagsAndRegister(Timer.Builder builder, MeterRegistry meterRegistry, String appName, String appVersion, ExecutionMetricsParams params) {
            return builder.tag(MatsMicrometerInterceptor.TAG_APP_NAME, appName).tag(MatsMicrometerInterceptor.TAG_APP_VERSION, appVersion).tag(MatsMicrometerInterceptor.TAG_EXEC, params._executionType).tag(MatsMicrometerInterceptor.TAG_INITIATING_APP_NAME, params._initiatingAppName).tag(MatsMicrometerInterceptor.TAG_INITIATOR_ID, params._initiatorId).tag(MatsMicrometerInterceptor.TAG_STAGE_ID, params._stageId).tag(MatsMicrometerInterceptor.TAG_INIT_OR_STAGE_ID, params._initOrStageId).tag(MatsMicrometerInterceptor.TAG_STAGE_INDEX, MatsMicrometerInterceptor.stageIndexString(params._stageIndex)).register(meterRegistry);
        }

        ExecutionMetrics(MeterRegistry meterRegistry, String appName, String appVersion, ExecutionMetricsParams params) {
            this._timer_TotalTime = this.timerAddTagsAndRegister(Timer.builder((String)MatsMicrometerInterceptor.TIMER_EXEC_TOTAL_NAME).description(MatsMicrometerInterceptor.TIMER_EXEC_TOTAL_DESC), meterRegistry, appName, appVersion, params);
            this._timer_UserLambda = this.timerAddTagsAndRegister(Timer.builder((String)MatsMicrometerInterceptor.TIMER_EXEC_USER_LAMBDA_NAME).description(MatsMicrometerInterceptor.TIMER_EXEC_USER_LAMBDA_DESC), meterRegistry, appName, appVersion, params);
            this._timer_DbCommit = this.timerAddTagsAndRegister(Timer.builder((String)MatsMicrometerInterceptor.TIMER_EXEC_DB_COMMIT_NAME).description(MatsMicrometerInterceptor.TIMER_EXEC_DB_COMMIT_DESC), meterRegistry, appName, appVersion, params);
            this._timer_MsgOut = this.timerAddTagsAndRegister(Timer.builder((String)MatsMicrometerInterceptor.TIMER_EXEC_OUT_NAME).description(MatsMicrometerInterceptor.TIMER_EXEC_OUT_DESC), meterRegistry, appName, appVersion, params);
            this._timer_MsgCommit = this.timerAddTagsAndRegister(Timer.builder((String)MatsMicrometerInterceptor.TIMER_EXEC_MSGSYS_COMMIT_NAME).description(MatsMicrometerInterceptor.TIMER_EXEC_MSGSYS_COMMIT_DESC), meterRegistry, appName, appVersion, params);
            this._count_Messages = DistributionSummary.builder((String)MatsMicrometerInterceptor.QUANTITY_EXEC_OUT_NAME).tag(MatsMicrometerInterceptor.TAG_APP_NAME, appName).tag(MatsMicrometerInterceptor.TAG_APP_VERSION, appVersion).tag(MatsMicrometerInterceptor.TAG_EXEC, params._executionType).tag(MatsMicrometerInterceptor.TAG_INITIATING_APP_NAME, params._initiatingAppName).tag(MatsMicrometerInterceptor.TAG_INITIATOR_ID, params._initiatorId).tag(MatsMicrometerInterceptor.TAG_STAGE_ID, params._stageId).tag(MatsMicrometerInterceptor.TAG_INIT_OR_STAGE_ID, params._initOrStageId).tag(MatsMicrometerInterceptor.TAG_STAGE_INDEX, MatsMicrometerInterceptor.stageIndexString(params._stageIndex)).description(MatsMicrometerInterceptor.QUANTITY_EXEC_OUT_DESC).register(meterRegistry);
        }

        void registerMeasurements(CommonCompletedContext ctx) {
            long nanosTaken_SumDtoAndStoSerialNanos = 0L;
            for (MatsOutgoingMessage.MatsSentOutgoingMessage msg : ctx.getOutgoingMessages()) {
                nanosTaken_SumDtoAndStoSerialNanos += msg.getEnvelopeProduceNanos();
            }
            long nanosTaken_UserLambdaAlone = ctx.getUserLambdaNanos() - nanosTaken_SumDtoAndStoSerialNanos;
            long nanosTaken_SumMessageOutHandling = nanosTaken_SumDtoAndStoSerialNanos + ctx.getSumEnvelopeSerializationAndCompressionNanos() + ctx.getSumMessageSystemProductionAndSendNanos();
            this._timer_TotalTime.record(ctx.getTotalExecutionNanos(), TimeUnit.NANOSECONDS);
            this._timer_UserLambda.record(nanosTaken_UserLambdaAlone, TimeUnit.NANOSECONDS);
            this._timer_DbCommit.record(ctx.getDbCommitNanos(), TimeUnit.NANOSECONDS);
            this._timer_MsgOut.record(nanosTaken_SumMessageOutHandling, TimeUnit.NANOSECONDS);
            this._timer_MsgCommit.record(ctx.getMessageSystemCommitNanos(), TimeUnit.NANOSECONDS);
            this._count_Messages.record((double)ctx.getOutgoingMessages().size());
        }

        static class ExecutionMetricsParams {
            final String _executionType;
            final String _initiatingAppName;
            final String _initiatorId;
            final String _stageId;
            final String _initOrStageId;
            final int _stageIndex;
            final int _hashCode;

            ExecutionMetricsParams(String executionType, String initiatingAppName, String initiatorId, String stageId, String initOrStageId, int stageIndex) {
                this._executionType = executionType;
                this._initiatingAppName = initiatingAppName;
                this._initiatorId = initiatorId;
                this._stageId = stageId;
                this._initOrStageId = initOrStageId;
                this._stageIndex = stageIndex;
                this._hashCode = executionType.hashCode() + initiatingAppName.hashCode() + initiatorId.hashCode() + initOrStageId.hashCode();
            }

            public boolean equals(Object o) {
                ExecutionMetricsParams that = (ExecutionMetricsParams)o;
                return Objects.equals(this._executionType, that._executionType) && Objects.equals(this._initiatingAppName, that._initiatingAppName) && Objects.equals(this._initiatorId, that._initiatorId) && Objects.equals(this._initOrStageId, that._initOrStageId);
            }

            public int hashCode() {
                return this._hashCode;
            }

            public String toString() {
                return "ExecutionMetricsParams{_executionType='" + this._executionType + "', _initiatingAppName='" + this._initiatingAppName + "', _initiatorId='" + this._initiatorId + "', _initOrStageId='" + this._initOrStageId + "', _stageIndex=" + this._stageIndex + "}";
            }
        }
    }

    private static class LazyPopulatedCopyOnWriteMap<VP, V> {
        private volatile Map<VP, V> _cache = Collections.emptyMap();
        private final Function<VP, V> _creator;

        public LazyPopulatedCopyOnWriteMap(Function<VP, V> creator) {
            this._creator = creator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private V getOrCreate(VP params) {
            V v = this._cache.get(params);
            if (v != null) {
                return v;
            }
            LazyPopulatedCopyOnWriteMap lazyPopulatedCopyOnWriteMap = this;
            synchronized (lazyPopulatedCopyOnWriteMap) {
                Map<VP, V> oldCache = this._cache;
                V v2 = oldCache.get(params);
                if (v2 != null) {
                    return v2;
                }
                if (oldCache.size() >= 200) {
                    log.warn("#MATSMETRICS# Cardinality explosion avoidance: When about to create metrics object for " + params + ", we found that there already is [200] present, thus won't create it. You should find the offending code (probably using dynamic initiatorIds somewhere) and fix it.");
                    return null;
                }
                HashMap<VP, V> newCache = new HashMap<VP, V>(oldCache);
                log.info("Creating and caching new metric " + params);
                V newV = this._creator.apply(params);
                newCache.put(params, newV);
                this._cache = newCache;
                return newV;
            }
        }
    }

    public static class SuggestedTimingHistogramsMeterFilter
    implements MeterFilter {
        public static double ms(double ms) {
            return ms * 1000000.0;
        }

        public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
            String name = id.getName();
            if (MatsMicrometerInterceptor.TIMER_EXEC_TOTAL_NAME.equals(name) || MatsMicrometerInterceptor.TIMER_EXEC_USER_LAMBDA_NAME.equals(name) || MatsMicrometerInterceptor.TIMER_EXEC_OUT_NAME.equals(name) || name.startsWith(MatsMicrometerInterceptor.TIMER_EXEC_OPS_PREFIX)) {
                return DistributionStatisticConfig.builder().serviceLevelObjectives(new double[]{SuggestedTimingHistogramsMeterFilter.ms(1.5), SuggestedTimingHistogramsMeterFilter.ms(5.0), SuggestedTimingHistogramsMeterFilter.ms(15.0), SuggestedTimingHistogramsMeterFilter.ms(50.0), SuggestedTimingHistogramsMeterFilter.ms(150.0), SuggestedTimingHistogramsMeterFilter.ms(500.0), SuggestedTimingHistogramsMeterFilter.ms(1500.0), SuggestedTimingHistogramsMeterFilter.ms(5000.0), SuggestedTimingHistogramsMeterFilter.ms(15000.0), SuggestedTimingHistogramsMeterFilter.ms(50000.0)}).build().merge(config);
            }
            if (MatsMicrometerInterceptor.TIMER_EXEC_DB_COMMIT_NAME.equals(name) || MatsMicrometerInterceptor.TIMER_EXEC_MSGSYS_COMMIT_NAME.equals(name) || MatsMicrometerInterceptor.TIMER_OUT_TOTAL_NAME.equals(name) || MatsMicrometerInterceptor.TIMER_OUT_MSGSYS_SEND_NAME.equals(name) || MatsMicrometerInterceptor.TIMER_IN_TOTAL_NAME.equals(name)) {
                return DistributionStatisticConfig.builder().serviceLevelObjectives(new double[]{SuggestedTimingHistogramsMeterFilter.ms(0.15), SuggestedTimingHistogramsMeterFilter.ms(0.5), SuggestedTimingHistogramsMeterFilter.ms(1.5), SuggestedTimingHistogramsMeterFilter.ms(5.0), SuggestedTimingHistogramsMeterFilter.ms(15.0), SuggestedTimingHistogramsMeterFilter.ms(50.0), SuggestedTimingHistogramsMeterFilter.ms(150.0), SuggestedTimingHistogramsMeterFilter.ms(500.0), SuggestedTimingHistogramsMeterFilter.ms(1500.0), SuggestedTimingHistogramsMeterFilter.ms(5000.0)}).build().merge(config);
            }
            return config;
        }
    }
}

