/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.springboot;

import io.mateu.mdd.shared.annotations.Private;
import io.mateu.mdd.shared.interfaces.MateuSecurityManager;
import io.mateu.mdd.shared.interfaces.UserPrincipal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SpringbootSecurityMateuSecurityManager
implements MateuSecurityManager {
    public UserPrincipal getPrincipal() {
        final Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return new UserPrincipal(){

            public String getLogin() {
                return authentication.getName();
            }

            public List<String> getRoles() {
                return authentication.getAuthorities().stream().map(a -> a.getAuthority()).collect(Collectors.toList());
            }

            public String getName() {
                return authentication.getName();
            }
        };
    }

    public boolean check(Private annotation) {
        boolean hasRoles;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!authentication.isAuthenticated()) {
            return false;
        }
        boolean hasUsers = annotation.users() != null && annotation.users().length > 0;
        boolean bl = hasRoles = annotation.roles() != null && annotation.roles().length > 0;
        if (hasUsers && Arrays.asList(annotation.users()).contains(authentication.getName())) {
            return true;
        }
        if (hasRoles) {
            for (String role : annotation.roles()) {
                if (!authentication.getAuthorities().stream().map(a -> a.getAuthority()).anyMatch(s -> s.equals(role))) continue;
                return true;
            }
        }
        return !hasUsers && !hasRoles;
    }
}

