/*
 * Decompiled with CFR 0.152.
 */
package org.example.domain.boundaries.financial.entities;

import java.time.LocalDate;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.example.domain.boundaries.financial.entities.FinancialAgent;
import org.example.domain.boundaries.financial.entities.InvoiceLine;
import org.example.domain.boundaries.financial.entities.InvoiceTag;

@Entity
public class Invoice {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id = 0L;
    @Version
    int __version = 0;
    @NotNull
    @ManyToOne
    FinancialAgent recipient;
    LocalDate date;
    LocalDate dueDate;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    List<InvoiceLine> lines;
    double total;
    boolean paid;
    @ManyToMany(mappedBy="invoices")
    List<InvoiceTag> tags;

    protected int get__version() {
        return this.__version;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public FinancialAgent getRecipient() {
        return this.recipient;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public List<InvoiceLine> getLines() {
        return this.lines;
    }

    public double getTotal() {
        return this.total;
    }

    public boolean isPaid() {
        return this.paid;
    }

    public List<InvoiceTag> getTags() {
        return this.tags;
    }

    public void setRecipient(FinancialAgent recipient) {
        this.recipient = recipient;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public void setLines(List<InvoiceLine> lines) {
        this.lines = lines;
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public void setPaid(boolean paid) {
        this.paid = paid;
    }

    public void setTags(List<InvoiceTag> tags) {
        this.tags = tags;
    }

    public void set__version(int __version) {
        this.__version = __version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Invoice)) {
            return false;
        }
        Invoice other = (Invoice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.id == 0L) {
            return false;
        }
        return Long.compare(this.id, other.id) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Invoice;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "" + this.getId();
    }
}

