/*
 * Decompiled with CFR 0.152.
 */
package org.example.domain.boundaries.educational.entities;

import com.google.common.collect.Lists;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import io.mateu.mdd.shared.annotations.DependsOn;
import java.util.Collection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.example.domain.boundaries.educational.entities.Classroom;
import org.example.domain.boundaries.educational.entities.GradeValue;
import org.example.domain.boundaries.educational.entities.Student;
import org.example.domain.boundaries.educational.entities.Subject;
import org.example.domain.boundaries.educational.entities.Teacher;

@Entity
public class Grade {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id = 0L;
    @Version
    int __version = 0;
    @ManyToOne
    @NotNull
    private Teacher teacher;
    @ManyToOne
    @NotNull
    private Subject subject;
    private transient Classroom classroom;
    @ManyToOne
    @NotNull
    private Student student;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private GradeValue value;

    @DependsOn(value="classroom")
    public DataProvider getStudentDataProvider() {
        return new ListDataProvider((Collection)(this.classroom != null ? this.classroom.students : Lists.newArrayList()));
    }

    protected int get__version() {
        return this.__version;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Teacher getTeacher() {
        return this.teacher;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Classroom getClassroom() {
        return this.classroom;
    }

    public Student getStudent() {
        return this.student;
    }

    public GradeValue getValue() {
        return this.value;
    }

    public void setTeacher(Teacher teacher) {
        this.teacher = teacher;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public void setClassroom(Classroom classroom) {
        this.classroom = classroom;
    }

    public void setStudent(Student student) {
        this.student = student;
    }

    public void setValue(GradeValue value) {
        this.value = value;
    }

    public void set__version(int __version) {
        this.__version = __version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Grade)) {
            return false;
        }
        Grade other = (Grade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.id == 0L) {
            return false;
        }
        return Long.compare(this.id, other.id) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Grade;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "" + this.getId();
    }
}

