/*
 * Decompiled with CFR 0.152.
 */
package org.example.domain.boundaries.educational.entities;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import io.mateu.mdd.shared.annotations.Ignored;
import io.mateu.util.persistence.JPAHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Version;
import org.example.domain.boundaries.educational.entities.FinalGrade;
import org.example.domain.boundaries.educational.entities.Semester;
import org.example.domain.boundaries.educational.entities.Subject;
import org.example.domain.boundaries.educational.entities.Teacher;

@JsonIdentityInfo(generator=ObjectIdGenerators.StringIdGenerator.class, property="@id")
@Entity
public class Course {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id = 0L;
    @Version
    int __version = 0;
    String name;
    transient Map<Subject, Teacher> subjectResponsibles;
    @Ignored
    Map<Long, Long> _subjectResponsibles;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="course")
    List<Semester> semesters;
    @OneToMany
    List<FinalGrade> finalGrades;

    @PrePersist
    @PreUpdate
    public void pre() {
        if (this.subjectResponsibles != null) {
            HashMap<Long, Long> m = new HashMap<Long, Long>();
            for (Subject k : this.subjectResponsibles.keySet()) {
                m.put(k.getId(), this.subjectResponsibles.get(k) != null ? Long.valueOf(this.subjectResponsibles.get(k).getId()) : null);
            }
            this._subjectResponsibles = m;
        }
    }

    @PostLoad
    public void postLoad() {
        if (this._subjectResponsibles != null) {
            HashMap<Subject, Teacher> m = new HashMap<Subject, Teacher>();
            for (Long k : this._subjectResponsibles.keySet()) {
                m.put((Subject)JPAHelper.get(Subject.class, (Object)k), this._subjectResponsibles.get(k) != null ? (Teacher)JPAHelper.get(Teacher.class, (Object)this._subjectResponsibles.get(k)) : null);
            }
            this.subjectResponsibles = m;
        }
    }

    protected int get__version() {
        return this.__version;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public Map<Subject, Teacher> getSubjectResponsibles() {
        return this.subjectResponsibles;
    }

    public Map<Long, Long> get_subjectResponsibles() {
        return this._subjectResponsibles;
    }

    public List<Semester> getSemesters() {
        return this.semesters;
    }

    public List<FinalGrade> getFinalGrades() {
        return this.finalGrades;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSubjectResponsibles(Map<Subject, Teacher> subjectResponsibles) {
        this.subjectResponsibles = subjectResponsibles;
    }

    public void set_subjectResponsibles(Map<Long, Long> _subjectResponsibles) {
        this._subjectResponsibles = _subjectResponsibles;
    }

    public void setSemesters(List<Semester> semesters) {
        this.semesters = semesters;
    }

    public void setFinalGrades(List<FinalGrade> finalGrades) {
        this.finalGrades = finalGrades;
    }

    public void set__version(int __version) {
        this.__version = __version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Course)) {
            return false;
        }
        Course other = (Course)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.id == 0L) {
            return false;
        }
        return Long.compare(this.id, other.id) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Course;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "" + this.getName();
    }
}

