/*
 * Decompiled with CFR 0.152.
 */
package org.example.domain.boundaries.common.entities;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.vaadin.icons.VaadinIcons;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.annotations.Output;
import io.mateu.mdd.shared.annotations.TextArea;
import io.mateu.mdd.shared.annotations.VisibleIf;
import io.mateu.util.notification.Notifier;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Version;
import javax.validation.constraints.NotEmpty;
import org.example.domain.boundaries.financial.entities.FinancialAgent;

@JsonIdentityInfo(generator=ObjectIdGenerators.StringIdGenerator.class, property="@id")
@Entity
public abstract class Person {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id = 0L;
    @Version
    int __version = 0;
    @NotEmpty
    String name;
    String nationality;
    @ManyToOne
    FinancialAgent financialAgent;
    LocalDate birthDate;
    @Output
    transient int age;
    @VisibleIf(value="$this.isParentsAuthorizationRequired()")
    boolean parentsAuthorization;

    public int getAge() {
        return (int)(this.birthDate != null ? ChronoUnit.YEARS.between(this.birthDate, LocalDate.now()) : 0L);
    }

    public boolean isParentsAuthorizationRequired() {
        return this.getAge() < 18;
    }

    @Action(icon=VaadinIcons.ENVELOPE, order=10)
    public static void sendEmail(Set<Person> selection, @NotEmpty String subject, @NotEmpty @TextArea String text) {
        Notifier.info((String)("Email sent with subject = \"" + subject + "\" and text = \"" + text + "\" sent to " + selection.stream().map(p -> p.getName()).collect(Collectors.joining(",")) + ""));
    }

    @Action(icon=VaadinIcons.ENVELOPE, order=10)
    public void sendEmail(@NotEmpty String subject, @NotEmpty @TextArea String text) {
        Notifier.info((String)("Email sent with subject = \"" + subject + "\" and text = \"" + text + "\""));
    }

    @Action(icon=VaadinIcons.CLOCK, order=20)
    public String showLastAccess() {
        return LocalDateTime.now().toString();
    }

    protected int get__version() {
        return this.__version;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getNationality() {
        return this.nationality;
    }

    public FinancialAgent getFinancialAgent() {
        return this.financialAgent;
    }

    public LocalDate getBirthDate() {
        return this.birthDate;
    }

    public boolean isParentsAuthorization() {
        return this.parentsAuthorization;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public void setFinancialAgent(FinancialAgent financialAgent) {
        this.financialAgent = financialAgent;
    }

    public void setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public void setParentsAuthorization(boolean parentsAuthorization) {
        this.parentsAuthorization = parentsAuthorization;
    }

    public void set__version(int __version) {
        this.__version = __version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Person)) {
            return false;
        }
        Person other = (Person)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.id == 0L) {
            return false;
        }
        return Long.compare(this.id, other.id) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Person;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "" + this.getName();
    }
}

