/*
 * Decompiled with CFR 0.152.
 */
package org.example.domain.boundaries.financial.entities;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.example.domain.boundaries.common.entities.Person;
import org.example.domain.boundaries.financial.entities.OrderLine;
import org.example.domain.boundaries.financial.entities.OrderStatus;

@Table(name="_order")
@Entity
public class Order {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id = 0L;
    @Version
    int __version = 0;
    @NotNull
    @ManyToOne
    Person person;
    @NotNull
    Date requestDateTime;
    LocalDateTime delivered;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="order", orphanRemoval=true)
    List<OrderLine> lines;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    OrderStatus status = OrderStatus.Pending;

    protected int get__version() {
        return this.__version;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Person getPerson() {
        return this.person;
    }

    public Date getRequestDateTime() {
        return this.requestDateTime;
    }

    public LocalDateTime getDelivered() {
        return this.delivered;
    }

    public List<OrderLine> getLines() {
        return this.lines;
    }

    public OrderStatus getStatus() {
        return this.status;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public void setRequestDateTime(Date requestDateTime) {
        this.requestDateTime = requestDateTime;
    }

    public void setDelivered(LocalDateTime delivered) {
        this.delivered = delivered;
    }

    public void setLines(List<OrderLine> lines) {
        this.lines = lines;
    }

    public void setStatus(OrderStatus status) {
        this.status = status;
    }

    public void set__version(int __version) {
        this.__version = __version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Order)) {
            return false;
        }
        Order other = (Order)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.id == 0L) {
            return false;
        }
        return Long.compare(this.id, other.id) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Order;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "" + this.getId();
    }
}

