/*
 * Decompiled with CFR 0.152.
 */
package org.example.domain.boundaries.educational.entities;

import io.mateu.mdd.shared.annotations.Css;
import io.mateu.mdd.shared.annotations.EnabledIf;
import io.mateu.mdd.shared.annotations.Ignored;
import io.mateu.mdd.shared.annotations.TextArea;
import io.mateu.mdd.shared.annotations.VisibleIf;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.example.domain.boundaries.common.entities.Person;
import org.example.domain.boundaries.educational.entities.Classroom;
import org.example.domain.boundaries.educational.entities.GradeValue;

@Entity
public class Student
extends Person {
    @ManyToOne
    Classroom classroom;
    boolean scholarshipped;
    @VisibleIf(value="$this.scholarshipped")
    String scholarship;
    @NotNull
    GradeValue averageGrade = GradeValue.N;
    @Ignored
    transient String css;
    @Css(value="$this.css")
    transient String classification = "Unknown";
    @EnabledIf(value="$this.classification == 'Could improve'")
    @TextArea
    String commentOnClassification;

    public void setAverageGrade(GradeValue averageGrade) {
        this.averageGrade = averageGrade;
        if (GradeValue.A.equals((Object)averageGrade) || GradeValue.B.equals((Object)averageGrade)) {
            this.classification = "Excellent!";
            this.css = "mdd-green-bgd";
        } else if (GradeValue.C.equals((Object)averageGrade)) {
            this.classification = "Not so good";
            this.css = "mdd-orange-bgd";
        } else {
            this.classification = "Could improve";
            this.css = "mdd-red-bgd";
        }
    }

    public Classroom getClassroom() {
        return this.classroom;
    }

    public boolean isScholarshipped() {
        return this.scholarshipped;
    }

    public String getScholarship() {
        return this.scholarship;
    }

    public GradeValue getAverageGrade() {
        return this.averageGrade;
    }

    public String getCss() {
        return this.css;
    }

    public String getClassification() {
        return this.classification;
    }

    public String getCommentOnClassification() {
        return this.commentOnClassification;
    }

    public void setClassroom(Classroom classroom) {
        this.classroom = classroom;
    }

    public void setScholarshipped(boolean scholarshipped) {
        this.scholarshipped = scholarshipped;
    }

    public void setScholarship(String scholarship) {
        this.scholarship = scholarship;
    }

    public void setCss(String css) {
        this.css = css;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public void setCommentOnClassification(String commentOnClassification) {
        this.commentOnClassification = commentOnClassification;
    }
}

