/*
 * Decompiled with CFR 0.152.
 */
package org.example.application.population;

import java.util.List;
import javax.persistence.EntityManager;
import org.example.domain.boundaries.educational.entities.AcademicPlan;
import org.example.domain.boundaries.educational.entities.Classroom;
import org.example.domain.boundaries.educational.entities.Course;
import org.example.domain.boundaries.educational.entities.FinalGrade;
import org.example.domain.boundaries.educational.entities.PartialGrade;
import org.example.domain.boundaries.educational.entities.Semester;
import org.example.domain.boundaries.educational.entities.Student;
import org.example.domain.boundaries.educational.entities.Subject;
import org.example.domain.boundaries.educational.entities.Teacher;
import org.example.domain.boundaries.financial.entities.Invoice;
import org.example.domain.boundaries.financial.entities.InvoiceTag;
import org.example.domain.boundaries.financial.entities.Order;
import org.example.domain.boundaries.maintenance.entities.Building;
import org.example.domain.boundaries.maintenance.entities.Provider;
import org.example.domain.boundaries.maintenance.entities.Technician;

public class InitialData {
    List<AcademicPlan> plans;
    List<Semester> semesters;
    List<Subject> subjects;
    List<Teacher> teachers;
    List<Student> students;
    List<Classroom> classrooms;
    List<PartialGrade> partials;
    List<FinalGrade> finals;
    List<Order> orders;
    List<Invoice> invoices;
    List<InvoiceTag> invoiceTags;
    List<Building> buildings;
    List<Provider> providers;
    List<Technician> technicians;

    public void persistAll(EntityManager em) throws Throwable {
        this.reverseMapAll();
        this.persistAll(em, this.plans);
        this.persistAll(em, this.semesters);
        this.persistAll(em, this.subjects);
        this.persistAll(em, this.teachers);
        this.persistAll(em, this.students);
        this.persistAll(em, this.classrooms);
        this.persistAll(em, this.partials);
        this.persistAll(em, this.finals);
        this.persistAll(em, this.orders);
        this.persistAll(em, this.invoices);
        this.persistAll(em, this.invoiceTags);
        this.persistAll(em, this.buildings);
        this.persistAll(em, this.providers);
        this.persistAll(em, this.technicians);
    }

    private void reverseMapAll() {
        if (this.classrooms != null) {
            this.classrooms.forEach(c -> {
                if (c.getTutor() != null) {
                    c.getTutor().setTutorOf((Classroom)c);
                }
                c.getStudents().forEach(s -> s.setClassroom((Classroom)c));
            });
        }
        if (this.plans != null) {
            this.plans.forEach(p -> p.getCourses().forEach(c -> c.getSemesters().forEach(s -> s.setCourse((Course)c))));
        }
    }

    private void persistAll(EntityManager em, List l) {
        if (l != null) {
            l.stream().forEach(p -> em.persist(p));
        }
    }

    public List<AcademicPlan> getPlans() {
        return this.plans;
    }

    public List<Semester> getSemesters() {
        return this.semesters;
    }

    public List<Subject> getSubjects() {
        return this.subjects;
    }

    public List<Teacher> getTeachers() {
        return this.teachers;
    }

    public List<Student> getStudents() {
        return this.students;
    }

    public List<Classroom> getClassrooms() {
        return this.classrooms;
    }

    public List<PartialGrade> getPartials() {
        return this.partials;
    }

    public List<FinalGrade> getFinals() {
        return this.finals;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public List<Invoice> getInvoices() {
        return this.invoices;
    }

    public List<InvoiceTag> getInvoiceTags() {
        return this.invoiceTags;
    }

    public List<Building> getBuildings() {
        return this.buildings;
    }

    public List<Provider> getProviders() {
        return this.providers;
    }

    public List<Technician> getTechnicians() {
        return this.technicians;
    }

    public void setPlans(List<AcademicPlan> plans) {
        this.plans = plans;
    }

    public void setSemesters(List<Semester> semesters) {
        this.semesters = semesters;
    }

    public void setSubjects(List<Subject> subjects) {
        this.subjects = subjects;
    }

    public void setTeachers(List<Teacher> teachers) {
        this.teachers = teachers;
    }

    public void setStudents(List<Student> students) {
        this.students = students;
    }

    public void setClassrooms(List<Classroom> classrooms) {
        this.classrooms = classrooms;
    }

    public void setPartials(List<PartialGrade> partials) {
        this.partials = partials;
    }

    public void setFinals(List<FinalGrade> finals) {
        this.finals = finals;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public void setInvoices(List<Invoice> invoices) {
        this.invoices = invoices;
    }

    public void setInvoiceTags(List<InvoiceTag> invoiceTags) {
        this.invoiceTags = invoiceTags;
    }

    public void setBuildings(List<Building> buildings) {
        this.buildings = buildings;
    }

    public void setProviders(List<Provider> providers) {
        this.providers = providers;
    }

    public void setTechnicians(List<Technician> technicians) {
        this.technicians = technicians;
    }
}

