/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.security.fake;

import io.mateu.mdd.shared.interfaces.UserPrincipal;
import io.mateu.security.MateuSecurityManager;
import io.mateu.security.Private;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class FakeMateuSecurityManagerImpl
implements MateuSecurityManager {
    public UserPrincipal validate(HttpSession httpSession, final String login, String password) throws Throwable {
        if (!"admin".equalsIgnoreCase(login)) {
            throw new Exception("Invalid user");
        }
        if (!"1".equalsIgnoreCase(password)) {
            throw new Exception("Invalid password");
        }
        return new UserPrincipal(){

            public String getLogin() {
                return login;
            }

            public List<String> getRoles() {
                return new ArrayList<String>();
            }

            public String getName() {
                return "Mateu";
            }

            public String getEmail() {
                return "test@test.ss";
            }

            public URL getPhoto() {
                return null;
            }
        };
    }

    public String getName(HttpSession httpSession) {
        return "Mateu";
    }

    public UserPrincipal getPrincipal(HttpSession httpSession) {
        return (UserPrincipal)httpSession.getAttribute("__user");
    }

    public void set(HttpSession httpSession, String name) {
    }

    public boolean check(HttpSession httpSession, Private annotation) {
        return true;
    }

    public boolean isProfileAvailable(HttpSession httpSession) {
        return false;
    }

    public String recoverPassword(HttpSession httpSession, String nameOrEmail) throws Throwable {
        if (!"admin".equalsIgnoreCase(nameOrEmail)) {
            throw new Exception("Unknown user");
        }
        return "An email has been sent to you with instructions.";
    }

    public UserPrincipal getUserDataFromGitHubCode(final HttpServletRequest req) {
        return new UserPrincipal(){

            public String getLogin() {
                return req.getParameter("code");
            }

            public List<String> getRoles() {
                return new ArrayList<String>();
            }

            public String getName() {
                return "Mateu";
            }

            public String getEmail() {
                return "test@test.ss";
            }

            public URL getPhoto() {
                return null;
            }
        };
    }

    public UserPrincipal getUserDataFromGoogleCode(final HttpServletRequest req) {
        return new UserPrincipal(){

            public String getLogin() {
                return req.getParameter("code");
            }

            public List<String> getRoles() {
                return new ArrayList<String>();
            }

            public String getName() {
                return "Mateu";
            }

            public String getEmail() {
                return "test@test.ss";
            }

            public URL getPhoto() {
                return null;
            }
        };
    }

    public UserPrincipal getUserDataFromMicrosoftCode(final HttpServletRequest req) {
        return new UserPrincipal(){

            public String getLogin() {
                return req.getParameter("code");
            }

            public List<String> getRoles() {
                return new ArrayList<String>();
            }

            public String getName() {
                return "Mateu";
            }

            public String getEmail() {
                return "test@test.ss";
            }

            public URL getPhoto() {
                return null;
            }
        };
    }

    public String getWelcomeMessage() {
        return System.getProperty("welcome.message", "Welcome!");
    }

    public String getWelcomeInfo() {
        return System.getProperty("welcome.info", "Please login");
    }

    public boolean hasFavicon() {
        return System.getProperty("favIcon") != null;
    }

    public String getFavicon() {
        return System.getProperty("favIcon");
    }

    public String getByeMessage() {
        return System.getProperty("bye.message", "Thanks for visiting us.");
    }

    public String getByeInfo() {
        return System.getProperty("bye.info", "Hope we will see you soon ;)");
    }

    public boolean hasLogo() {
        return System.getProperty("logo") != null;
    }

    public String getLogo() {
        return System.getProperty("logo");
    }

    public boolean isLoginSupported() {
        return !"false".equalsIgnoreCase(System.getProperty("oauthonly"));
    }

    public String getRegistrationUrl() {
        return System.getProperty("registrationUrl");
    }

    public String getForgotternPasswordUrl() {
        return System.getProperty("passwordForgottenUrl");
    }

    public String getGithubClientId() {
        return System.getProperty("oauth.github.client_id");
    }

    public String getGithubClientSecret() {
        return System.getProperty("oauth.github.client_secret");
    }

    public String getGoogleClientId() {
        return System.getProperty("oauth.google.client_id");
    }

    public String getGoogleClientSecret() {
        return System.getProperty("oauth.google.client_secret");
    }

    public String getMicrosoftClientId() {
        return System.getProperty("oauth.microsoft.client_id");
    }

    public String getMicrosoftClientSecret() {
        return System.getProperty("oauth.microsoft.client_secret");
    }
}

