/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.mateu.util.Helper;
import io.mateu.util.persistence.EntitySerializer;
import jakarta.persistence.Entity;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;

public class Serializer {
    private static ObjectMapper mapper = new ObjectMapper();
    private static ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static Map<String, Object> fromJson(String json) throws IOException {
        if (json == null || "".equals(json)) {
            json = "{}";
        }
        return (Map)mapper.readValue(json, Map.class);
    }

    public static <T> T fromJson(String json, Class<T> c) throws Exception {
        if (json == null || "".equals(json)) {
            json = "{}";
        }
        return Serializer.pojoFromJson(json, c);
    }

    public static <T> T pojoFromJson(String json, Class<T> c) throws Exception {
        if (json == null || "".equals(json)) {
            json = "{}";
        }
        return (T)mapper.readValue(json, c);
    }

    public static String toJson(Object o) throws Exception {
        if (o != null && o.getClass().isAnnotationPresent(Entity.class)) {
            return Serializer.entityToJson(o);
        }
        return mapper.writeValueAsString(o);
    }

    private static String entityToJson(Object o) throws Exception {
        return Serializer.toJson(Helper.getImpl(EntitySerializer.class).toMap(o));
    }

    public static Map<String, Object> toMap(Object o) throws Exception {
        if (o == null) {
            return Map.of();
        }
        if (Serializer.isBasic(o)) {
            return Map.of("value", o);
        }
        return Serializer.fromJson(Serializer.toJson(o));
    }

    private static boolean isBasic(Object o) {
        Class<?> type = o.getClass();
        return Integer.TYPE.equals(type) || Integer.class.equals(type) || Double.TYPE.equals(type) || Double.class.equals(type) || Boolean.TYPE.equals(type) || Boolean.class.equals(type) || String.class.equals(type) || Float.TYPE.equals(type) || Float.class.equals(type) || BigDecimal.class.equals(type) || type.isEnum();
    }

    public static <T> T fromMap(Map<String, Object> map, Class<T> c) throws Exception {
        if (map == null) {
            return null;
        }
        String json = Serializer.toJson(map);
        return Serializer.pojoFromJson(json, c);
    }

    private static Map<String, Object> entityToMap(Object o) throws Exception {
        return Helper.getImpl(EntitySerializer.class).toMap(o);
    }

    public static Map<String, Object> fromYaml(String yaml) throws IOException {
        if (yaml == null) {
            yaml = "";
        }
        return (Map)yamlMapper.readValue(yaml, Map.class);
    }

    public static <T> T fromYaml(String yaml, Class<T> c) throws IOException {
        if (yaml == null) {
            yaml = "";
        }
        return (T)yamlMapper.readValue(yaml, c);
    }

    public static String toYaml(Object o) throws IOException {
        return yamlMapper.writeValueAsString(o);
    }

    static {
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        yamlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        yamlMapper.registerModule((Module)new JavaTimeModule());
        yamlMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }
}

