/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Strings;
import io.mateu.mdd.shared.annotations.Attribute;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.persistence.EntitySerializer;
import jakarta.persistence.Entity;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class Serializer {
    private static ObjectMapper mapper = new ObjectMapper();
    private static ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static Map<String, Object> fromJson(String json) throws IOException {
        if (json == null || "".equals(json)) {
            json = "{}";
        }
        return (Map)mapper.readValue(json, Map.class);
    }

    public static <T> T fromJson(String json, Class<T> c) throws Exception {
        if (json == null || "".equals(json)) {
            json = "{}";
        }
        return Serializer.pojoFromJson(json, c);
    }

    public static <T> T pojoFromJson(String json, Class<T> c) throws Exception {
        if (json == null || "".equals(json)) {
            json = "{}";
        }
        return (T)mapper.readValue(json, c);
    }

    public static String toJson(Object o) throws Exception {
        if (o != null && o.getClass().isAnnotationPresent(Entity.class)) {
            return Serializer.entityToJson(o);
        }
        return mapper.writeValueAsString(o);
    }

    private static String entityToJson(Object o) throws Exception {
        return Serializer.toJson(Helper.getImpl(EntitySerializer.class).toMap(o));
    }

    public static Map<String, Object> toMap(Object o) throws Exception {
        if (o == null) {
            return Map.of();
        }
        if (Serializer.isBasic(o)) {
            return Map.of("value", o);
        }
        Map<String, Object> data = Serializer.fromJson(Serializer.toJson(o));
        Serializer.applyAttributeNames(data, o);
        return data;
    }

    private static void applyAttributeNames(Map<String, Object> data, Object o) throws Exception {
        if (o == null) {
            return;
        }
        for (Map.Entry<String, Object> e : data.entrySet()) {
            if (e.getValue() == null || !(e.getValue() instanceof Map)) continue;
            Serializer.applyAttributeNames((Map)e.getValue(), ReflectionHelper.getValue(e.getKey(), o));
        }
        for (FieldInterfaced f : ReflectionHelper.getAllFields(o.getClass())) {
            if (!data.containsKey(f.getName()) || !f.isAnnotationPresent(Attribute.class) || Strings.isNullOrEmpty((String)((Attribute)f.getAnnotation(Attribute.class)).value())) continue;
            Object v = data.get(f.getName());
            data.remove(f.getName());
            data.put(((Attribute)f.getAnnotation(Attribute.class)).value(), v);
        }
    }

    private static boolean isBasic(Object o) {
        Class<?> type = o.getClass();
        return Integer.TYPE.equals(type) || Integer.class.equals(type) || Double.TYPE.equals(type) || Double.class.equals(type) || Boolean.TYPE.equals(type) || Boolean.class.equals(type) || String.class.equals(type) || Float.TYPE.equals(type) || Float.class.equals(type) || BigDecimal.class.equals(type) || type.isEnum();
    }

    public static <T> T fromMap(Map<String, Object> map, Class<T> c) throws Exception {
        if (map == null) {
            return null;
        }
        String json = Serializer.toJson(map);
        return Serializer.pojoFromJson(json, c);
    }

    private static Map<String, Object> entityToMap(Object o) throws Exception {
        return Helper.getImpl(EntitySerializer.class).toMap(o);
    }

    public static Map<String, Object> fromYaml(String yaml) throws IOException {
        if (yaml == null) {
            yaml = "";
        }
        return (Map)yamlMapper.readValue(yaml, Map.class);
    }

    public static <T> T fromYaml(String yaml, Class<T> c) throws IOException {
        if (yaml == null) {
            yaml = "";
        }
        return (T)yamlMapper.readValue(yaml, c);
    }

    public static String toYaml(Object o) throws IOException {
        return yamlMapper.writeValueAsString(o);
    }

    public static Element toXml(Object o) {
        return Serializer.toXml(o, new ArrayList());
    }

    public static String toString(Element o) {
        return new XMLOutputter().outputString(o);
    }

    public static Element toXml(Object o, List visited) {
        if (o == null) {
            return null;
        }
        if (!visited.contains(o)) {
            visited.add(o);
        }
        Element e = new Element(o.getClass().getSimpleName());
        e.setAttribute("className", o.getClass().getName());
        for (FieldInterfaced f : ReflectionHelper.getAllFields(o.getClass())) {
            try {
                Object i = ReflectionHelper.getValue(f, o);
                if (i == null) continue;
                if (ReflectionHelper.isBasico(i)) {
                    e.setAttribute(f.getName(), "" + i);
                    continue;
                }
                e.addContent((Content)Serializer.toXml(i, visited));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return e;
    }

    public static Object fromXml(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        try {
            Document doc = new SAXBuilder().build((Reader)new StringReader(s));
            Element root = doc.getRootElement();
            HashMap o = null;
            if (root.getAttribute("className") != null && !Strings.isNullOrEmpty((String)root.getAttributeValue("className"))) {
                o = ReflectionHelper.newInstance(Class.forName(root.getAttributeValue("className")));
                for (FieldInterfaced f : ReflectionHelper.getAllFields(o.getClass())) {
                    try {
                        String sv = root.getAttributeValue(f.getId());
                        if (sv == null || !ReflectionHelper.isBasico(f.getType())) continue;
                        ReflectionHelper.setValue(f, o, ReflectionHelper.newInstance(f.getType(), (Object)sv));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            } else {
                o = new HashMap();
            }
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        yamlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        yamlMapper.registerModule((Module)new JavaTimeModule());
        yamlMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }
}

