/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.reflection;

import io.mateu.mdd.shared.annotations.GenericClass;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class FieldInterfacedFromField
implements FieldInterfaced {
    private final Field f;
    private final FieldInterfaced ff;
    private List<Annotation> extraAnnotations = new ArrayList<Annotation>();

    public FieldInterfacedFromField(FieldInterfaced f, Annotation a) {
        this(f);
        this.extraAnnotations.add(a);
    }

    public Field getField() {
        return this.f;
    }

    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this.ff != null ? this.ff.getDeclaredAnnotationsByType(annotationClass) : this.f.getDeclaredAnnotationsByType(annotationClass);
    }

    public FieldInterfacedFromField(FieldInterfaced f) {
        this.ff = f;
        this.f = f.getField();
    }

    public FieldInterfacedFromField(Field f) {
        this.ff = null;
        this.f = f;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        if (this.extraAnnotations.size() > 0) {
            for (Annotation a : this.extraAnnotations) {
                if (!annotationClass.isAssignableFrom(a.getClass())) continue;
                return true;
            }
        }
        return this.ff != null ? this.ff.isAnnotationPresent(annotationClass) : this.f.isAnnotationPresent(annotationClass);
    }

    public Class<?> getType() {
        return this.ff != null ? this.ff.getType() : this.f.getType();
    }

    public AnnotatedType getAnnotatedType() {
        return this.ff != null ? this.ff.getAnnotatedType() : this.f.getAnnotatedType();
    }

    public Class<?> getGenericClass() {
        if (this.ff != null) {
            return this.ff.getGenericClass();
        }
        if (this.f.isAnnotationPresent(GenericClass.class)) {
            return this.f.getAnnotation(GenericClass.class).clazz();
        }
        if (this.f.getGenericType() != null && this.f.getGenericType() instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)this.f.getGenericType();
            if (genericType != null && genericType.getActualTypeArguments().length > 0) {
                Type ata0 = genericType.getActualTypeArguments()[0];
                if (ata0 instanceof Class) {
                    Class genericClass = (Class)ata0;
                    return genericClass;
                }
                return null;
            }
            return null;
        }
        if (this.f.getGenericType() != null) {
            return (Class)this.f.getGenericType();
        }
        return null;
    }

    public Class<?> getDeclaringClass() {
        return this.ff != null ? this.ff.getDeclaringClass() : this.f.getDeclaringClass();
    }

    public Type getGenericType() {
        return this.ff != null ? this.ff.getGenericType() : this.f.getGenericType();
    }

    public String getName() {
        return this.ff != null ? this.ff.getName() : this.f.getName();
    }

    public String getId() {
        return this.ff != null ? this.ff.getId() : this.f.getName();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (this.extraAnnotations.size() > 0) {
            for (Annotation a : this.extraAnnotations) {
                if (!a.getClass().equals(annotationClass)) continue;
                return (T)a;
            }
        }
        return (T)(this.ff != null ? this.ff.getAnnotation(annotationClass) : this.f.getAnnotation(annotationClass));
    }

    public Object getValue(Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ReflectionHelper.getValue(this, o);
    }

    public void setValue(Object o, Object v) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ReflectionHelper.setValue(this, o, v);
    }

    public int getModifiers() {
        return this.f.getModifiers();
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.ff != null ? this.ff.getDeclaredAnnotations() : this.f.getDeclaredAnnotations();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return (this.getField().getDeclaringClass().getName() + "/" + this.getField().getName()).hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.hashCode() == obj.hashCode();
    }
}

