/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.util;

import io.mateu.util.asciiart.Painter;
import io.mateu.util.beanutils.MiURLConverter;
import io.mateu.util.exceptions.MoreThanOneImplementationFound;
import io.mateu.util.exceptions.NoImplementationFound;
import java.net.URL;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedHelper {
    private static final Logger log = LoggerFactory.getLogger(SharedHelper.class);
    public static boolean propertiesLoaded = false;

    public static void loadProperties() {
        if (!propertiesLoaded) {
            Painter.paint("Hello");
            Painter.paint("MATEU");
            log.info("Registrando converters beanutils...");
            ConvertUtils.register((Converter)new MiURLConverter(), URL.class);
            propertiesLoaded = true;
        } else {
            log.info("Properties already loaded");
        }
    }

    public static <T> T getImpl(Class<T> anInterface) throws Exception {
        List<T> impls = SharedHelper.getImpls(anInterface);
        if (impls.size() == 0) {
            throw new NoImplementationFound(anInterface);
        }
        if (impls.size() > 1) {
            throw new MoreThanOneImplementationFound(anInterface, impls);
        }
        return impls.get(0);
    }

    public static <T> List<T> getImpls(Class<T> anInterface) {
        return ServiceLoader.load(anInterface).stream().map(p -> p.get()).collect(Collectors.toList());
    }
}

