/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.ui.cruds;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.mateu.mdd.core.app.MDDOpenCRUDAction;
import io.mateu.mdd.core.interfaces.Crud;
import io.mateu.mdd.core.interfaces.RpcCrudViewExtended;
import io.mateu.mdd.shared.annotations.Ignored;
import io.mateu.mdd.shared.annotations.MainSearchFilter;
import io.mateu.mdd.shared.annotations.NotInList;
import io.mateu.mdd.shared.annotations.Output;
import io.mateu.mdd.shared.annotations.Password;
import io.mateu.mdd.shared.annotations.SearchFilter;
import io.mateu.mdd.shared.annotations.Sum;
import io.mateu.mdd.shared.annotations.UseCheckboxes;
import io.mateu.mdd.shared.annotations.WeekDays;
import io.mateu.mdd.shared.data.FareValue;
import io.mateu.mdd.shared.data.Status;
import io.mateu.mdd.shared.data.SumData;
import io.mateu.mdd.shared.interfaces.IResource;
import io.mateu.mdd.shared.interfaces.SortCriteria;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.ui.cruds.commands.DeleteRowsCommand;
import io.mateu.mdd.ui.cruds.commands.DeleteRowsCommandHandler;
import io.mateu.mdd.ui.cruds.queries.count.CountQuery;
import io.mateu.mdd.ui.cruds.queries.count.CountQueryHandler;
import io.mateu.mdd.ui.cruds.queries.findById.FindByIdQuery;
import io.mateu.mdd.ui.cruds.queries.findById.FindByIdQueryHandler;
import io.mateu.mdd.ui.cruds.queries.rows.RowsQuery;
import io.mateu.mdd.ui.cruds.queries.rows.RowsQueryHandler;
import io.mateu.mdd.ui.cruds.queries.sums.SumsQuery;
import io.mateu.mdd.ui.cruds.queries.sums.SumsQueryHandler;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.data.Pair;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="stereotype")
public class JpaRpcCrudView
implements Crud<Object, Object>,
RpcCrudViewExtended {
    private MDDOpenCRUDAction action;
    private Map<String, String> aliasedColumnNamesByColId = new HashMap<String, String>();
    private List<String> columnNames = new ArrayList<String>();
    private Map<String, FieldInterfaced> fieldsByColumnName = new HashMap<String, FieldInterfaced>();
    private List<String> filterNames = new ArrayList<String>();
    private Map<String, FieldInterfaced> fieldsByFilterName = new HashMap<String, FieldInterfaced>();
    private List<String> columnFields;
    private List<String> visibleColumns;
    private List<FieldInterfaced> filterFields;
    private List<String> aliasedColumnNamesList = new ArrayList<String>();
    private List<String> columnIds;
    private Map<String, FieldInterfaced> fieldsByAliasedColumnName;
    private Map<String, FieldInterfaced> fieldsByColId = new HashMap<String, FieldInterfaced>();
    private Map<String, String> alias = new HashMap<String, String>();
    private Map<String, String> aliasedColumnNames = new HashMap<String, String>();
    private List<FieldInterfaced> sumFields;
    private List<SumData> sums;
    String selectColumnsForCount;
    String selectColumnsForList;
    CountQueryHandler countQueryHandler;
    RowsQueryHandler rowsQueryHandler;
    SumsQueryHandler sumsQueryHandler;

    public JpaRpcCrudView() {
    }

    public JpaRpcCrudView(MDDOpenCRUDAction action) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        this.action = action;
        this.columnFields = this.getSelectFields(action.getEntityClass(), action.getColumns(), this.columnNames, this.fieldsByColumnName);
        List<String> list = this.visibleColumns = Strings.isNullOrEmpty((String)action.getColumns()) ? null : Arrays.stream(action.getColumns().split(",")).toList();
        if (this.visibleColumns == null || this.visibleColumns.size() == 0) {
            this.visibleColumns = this.columnFields.stream().skip(1L).collect(Collectors.toList());
        }
        this.filterFields = this.getFilterFields();
        this.createAliases(action.getEntityClass(), this.columnNames, this.fieldsByColumnName, this.alias, this.aliasedColumnNames, this.aliasedColumnNamesList);
        this.sumFields = this.fieldsByColumnName.values().stream().filter(f -> f.isAnnotationPresent(Sum.class)).collect(Collectors.toList());
        Object ql = "count(x)";
        for (FieldInterfaced f2 : this.sumFields) {
            if (!"".equals(ql)) {
                ql = (String)ql + ", ";
            }
            ql = (String)ql + " sum(x." + f2.getName() + ") ";
        }
        this.selectColumnsForCount = ql;
        this.selectColumnsForList = this.buildFieldsPart(this.columnFields);
        this.columnIds = new ArrayList<String>();
        int pos = 0;
        for (String n2 : this.columnNames) {
            String colId = "col" + pos++;
            this.columnIds.add(colId);
            this.aliasedColumnNamesByColId.put(colId, this.aliasedColumnNames.get(n2));
            if (pos <= 1) continue;
            this.fieldsByColId.put(colId, this.fieldsByColumnName.get(n2));
        }
        this.fieldsByAliasedColumnName = new HashMap<String, FieldInterfaced>();
        this.columnNames.stream().forEach(n -> this.fieldsByAliasedColumnName.put(this.aliasedColumnNames.get(n), this.fieldsByColumnName.get(n)));
        this.countQueryHandler = (CountQueryHandler)ReflectionHelper.newInstance(CountQueryHandler.class);
        this.rowsQueryHandler = (RowsQueryHandler)ReflectionHelper.newInstance(RowsQueryHandler.class);
        this.sumsQueryHandler = (SumsQueryHandler)ReflectionHelper.newInstance(SumsQueryHandler.class);
    }

    public List fetchRows(Object filters, List<SortCriteria> sortOrders, int offset, int limit) throws Throwable {
        return this.rowsQueryHandler.run(new RowsQuery(this.action, filters, sortOrders, offset, limit, this.aliasedColumnNamesByColId, this.action.getQueryFilters(), this.action.getExtraFilters(), this.selectColumnsForCount, this.selectColumnsForList, this.alias, this.aliasedColumnNames, this.aliasedColumnNamesList, this.columnNames, this.filterFields));
    }

    public int fetchCount(Object filters) throws Throwable {
        this.sums = this.sumsQueryHandler.run(new SumsQuery(this.action, filters, null, 0, 0, this.aliasedColumnNamesByColId, this.action.getQueryFilters(), this.action.getExtraFilters(), this.selectColumnsForCount, this.selectColumnsForList, this.alias, this.aliasedColumnNames, this.aliasedColumnNamesList, this.columnNames, this.filterFields, this.sumFields));
        return this.countQueryHandler.run(new CountQuery(this.action, filters, null, 0, 0, this.aliasedColumnNamesByColId, this.action.getQueryFilters(), this.action.getExtraFilters(), this.selectColumnsForCount, this.selectColumnsForList, this.alias, this.aliasedColumnNames, this.aliasedColumnNamesList, this.columnNames, this.filterFields));
    }

    public Class getSearchFormClass() {
        return this.action.getEntityClass();
    }

    public Class getRowClass() {
        return HashMap.class;
    }

    public boolean isAddEnabled() {
        return this.action.isCanAdd();
    }

    public boolean isEditHandled() {
        return !this.action.isReadOnly();
    }

    public Map<FieldInterfaced, String> getColumnIdsPerField() {
        return this.fieldsByColId.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public Map<FieldInterfaced, String> getColumnCaptionsPerField() {
        return this.columnNames.stream().filter(n -> n.contains(".")).map(n -> new Pair(n, (Object)this.fieldsByColumnName.get(n))).map(p -> new Pair((Object)Helper.capitalize((String)((String)p.getKey())), p.getValue())).collect(Collectors.toMap(p -> (FieldInterfaced)p.getValue(), p -> (String)p.getKey()));
    }

    public boolean isDeleteEnabled() {
        return this.action.isCanDelete();
    }

    private void createAliases(Class sourceType, List<String> paths, Map<String, FieldInterfaced> fieldsByPath, Map<String, String> alias, Map<String, String> aliasedColumnNames, List<String> aliasedColumnNamesList) {
        for (String path : paths) {
            FieldInterfaced f = fieldsByPath.get(path);
            String p = path;
            FieldInterfaced fx = f;
            Class type = sourceType;
            FieldInterfaced f0 = null;
            Object pathAcumulado = "x";
            while (!Strings.isNullOrEmpty((String)p)) {
                String s = p;
                if (p.contains(".")) {
                    p = p.substring(p.indexOf(".") + 1);
                    s = s.substring(0, s.indexOf("."));
                } else {
                    p = null;
                }
                if (!"".equals(pathAcumulado)) {
                    pathAcumulado = (String)pathAcumulado + ".";
                }
                pathAcumulado = (String)pathAcumulado + s;
                fx = ReflectionHelper.getFieldByName((Class)type, (String)s);
                if (fx == null || !(type = fx.getType()).isAnnotationPresent(Entity.class) || fx.isAnnotationPresent(NotNull.class) || fx.isAnnotationPresent(NotNull.class)) continue;
                if (!alias.containsKey(pathAcumulado)) {
                    alias.put((String)pathAcumulado, "x" + alias.size());
                }
                pathAcumulado = alias.get(pathAcumulado);
                f0 = fx;
            }
            aliasedColumnNames.put(path, (String)pathAcumulado);
            aliasedColumnNamesList.add((String)pathAcumulado);
        }
    }

    public List<String> getSelectFields(Class targetType, String useColumns, List<String> columnNames, Map<String, FieldInterfaced> fieldsByColumnName) {
        List<FieldInterfaced> cols = this.getColumnFields(targetType, false, useColumns, columnNames, fieldsByColumnName);
        FieldInterfaced idField = null;
        for (FieldInterfaced f : ReflectionHelper.getAllFields((Class)targetType)) {
            if (!f.isAnnotationPresent(Id.class)) continue;
            idField = f;
        }
        if (idField != null) {
            columnNames.add(0, idField.getName());
        }
        return columnNames;
    }

    public List<FieldInterfaced> getColumnFields(Class objectType, boolean forGrid, String fieldsFilter, List<String> columNames, Map<String, FieldInterfaced> fieldsByColumnName) {
        List<Object> explicitColumns = null;
        if (Strings.isNullOrEmpty((String)fieldsFilter)) {
            explicitColumns = ReflectionHelper.getAllFields((Class)objectType).stream().peek(f -> {
                if (columNames != null && fieldsByColumnName != null) {
                    String n = f.getName();
                    columNames.add(n);
                    fieldsByColumnName.put(n, (FieldInterfaced)f);
                }
            }).filter(f -> f != null).collect(Collectors.toList());
        } else {
            List<Object> fns = Lists.newArrayList((Object[])fieldsFilter.split(","));
            fns = fns.stream().map(n -> {
                n = n.trim();
                if ((n = n.replaceAll("\\(.*\\)", "")).contains(" ")) {
                    n = n.substring(0, n.indexOf(" "));
                }
                n = n.replaceAll(" ", "");
                return n;
            }).collect(Collectors.toList());
            explicitColumns = fns.stream().map(n -> {
                FieldInterfaced f = ReflectionHelper.getFieldByName((Class)objectType, (String)n);
                if (columNames != null && fieldsByColumnName != null) {
                    columNames.add((String)n);
                    fieldsByColumnName.put((String)n, f);
                }
                return f;
            }).filter(f -> f != null).collect(Collectors.toList());
        }
        if (explicitColumns.size() > 0) {
            return explicitColumns;
        }
        List<FieldInterfaced> cols = ReflectionHelper.getAllFields((Class)objectType).stream().filter(f -> !"_proxied".equalsIgnoreCase(f.getName()) && !"_possibleValues".equalsIgnoreCase(f.getName()) && !"_binder".equalsIgnoreCase(f.getName()) && !"_field".equalsIgnoreCase(f.getName()) && !Modifier.isTransient(f.getModifiers()) && !f.isAnnotationPresent(Transient.class) && !f.isAnnotationPresent(NotInList.class) && !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && !f.isAnnotationPresent(Password.class) && (!Collection.class.isAssignableFrom(f.getType()) || forGrid && f.isAnnotationPresent(UseCheckboxes.class) && ((UseCheckboxes)f.getAnnotation(UseCheckboxes.class)).editableInline()) && !Map.class.isAssignableFrom(f.getType()) && !f.isAnnotationPresent(GeneratedValue.class) && (ReflectionHelper.isBasico((Class)f.getType()) || BigDecimal.class.equals((Object)f.getType()) || f.getType().isEnum() || f.getType().isAnnotationPresent(Entity.class) || Date.class.equals((Object)f.getType()) || FareValue.class.equals((Object)f.getType()) || Status.class.equals((Object)f.getType()) || f.isAnnotationPresent(WeekDays.class) || forGrid && f.isAnnotationPresent(UseCheckboxes.class) && ((UseCheckboxes)f.getAnnotation(UseCheckboxes.class)).editableInline() || Runnable.class.isAssignableFrom(f.getType()))).filter(f -> f != null).collect(Collectors.toList());
        if (columNames != null && fieldsByColumnName != null) {
            cols.forEach(f -> {
                columNames.add(f.getName());
                fieldsByColumnName.put(f.getName(), (FieldInterfaced)f);
            });
        }
        return cols;
    }

    public List<FieldInterfaced> getFilterFields() {
        return this.getFilterFields(this.action.getEntityClass());
    }

    public Class getEntityClass() {
        return this.action.getEntityClass();
    }

    public List<FieldInterfaced> getFilterFields(Class filtersType) {
        if (Strings.isNullOrEmpty((String)this.action.getFilters())) {
            List<Object> filterFields = ReflectionHelper.getAllFields((Class)filtersType).stream().filter(f -> !f.isAnnotationPresent(Password.class) && !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && (f.isAnnotationPresent(SearchFilter.class) || f.isAnnotationPresent(MainSearchFilter.class))).collect(Collectors.toList());
            if (filterFields.size() == 0) {
                filterFields = ReflectionHelper.getAllFields((Class)filtersType).stream().filter(f -> !f.isAnnotationPresent(Password.class) && !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && !f.isAnnotationPresent(Output.class) && !IResource.class.isAssignableFrom(f.getType()) && (String.class.equals((Object)f.getType()) || LocalDate.class.equals((Object)f.getType()) || LocalDateTime.class.equals((Object)f.getType()) || LocalTime.class.equals((Object)f.getType()) || java.util.Date.class.equals((Object)f.getType()) || Boolean.TYPE.equals(f.getType()) || Boolean.class.equals((Object)f.getType()) || f.getType().isEnum() || f.isAnnotationPresent(ManyToOne.class) || f.getType().isAnnotationPresent(Entity.class))).collect(Collectors.toList());
            }
            filterFields.forEach(f -> {
                this.filterNames.add(f.getName());
                this.fieldsByFilterName.put(f.getName(), (FieldInterfaced)f);
            });
            return filterFields;
        }
        ArrayList fns = Lists.newArrayList((Object[])this.action.getFilters().replaceAll(" ", "").split(","));
        List<FieldInterfaced> filterFields = fns.stream().map(n -> {
            FieldInterfaced f = ReflectionHelper.getFieldByName((Class)filtersType, (String)n);
            if (f != null) {
                this.filterNames.add((String)n);
                this.fieldsByFilterName.put((String)n, f);
            }
            return f;
        }).filter(f -> f != null).collect(Collectors.toList());
        return filterFields;
    }

    private String buildFieldsPart(List<String> columnFieldNames) {
        Object s = "";
        int pos = 0;
        for (String columnName : columnFieldNames) {
            if (!"".equals(s)) {
                s = (String)s + ", ";
            }
            String colId = this.aliasedColumnNames.get(columnName);
            s = (String)s + colId + " as col" + pos++;
        }
        return s;
    }

    public List<FieldInterfaced> getColumnFields() {
        return this.visibleColumns.stream().map(fn -> this.fieldsByColumnName.get(fn)).collect(Collectors.toList());
    }

    public void delete(Set<Object> selection) throws Throwable {
        ((DeleteRowsCommandHandler)ReflectionHelper.newInstance(DeleteRowsCommandHandler.class)).run(DeleteRowsCommand.builder().rows(selection).entityClass(this.action.getEntityClass()).build());
    }

    public String getCaption() {
        return this.action.getCaption();
    }

    public Object getDetail(Object id) throws Throwable {
        return ((FindByIdQueryHandler)ReflectionHelper.newInstance(FindByIdQueryHandler.class)).run(FindByIdQuery.builder().id(this.getId(id)).entityClass(this.action.getEntityClass()).build());
    }

    private Object getId(Object row) {
        if (row instanceof Map) {
            return ((Map)row).get("col0");
        }
        return ReflectionHelper.getId((Object)row);
    }

    public Object getNewRecordForm() throws Throwable {
        return ReflectionHelper.newInstance((Class)this.getEntityClass());
    }

    public MDDOpenCRUDAction getAction() {
        return this.action;
    }

    public Map<String, String> getAliasedColumnNamesByColId() {
        return this.aliasedColumnNamesByColId;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public Map<String, FieldInterfaced> getFieldsByColumnName() {
        return this.fieldsByColumnName;
    }

    public List<String> getFilterNames() {
        return this.filterNames;
    }

    public Map<String, FieldInterfaced> getFieldsByFilterName() {
        return this.fieldsByFilterName;
    }

    public List<String> getVisibleColumns() {
        return this.visibleColumns;
    }

    public List<String> getAliasedColumnNamesList() {
        return this.aliasedColumnNamesList;
    }

    public List<String> getColumnIds() {
        return this.columnIds;
    }

    public Map<String, FieldInterfaced> getFieldsByAliasedColumnName() {
        return this.fieldsByAliasedColumnName;
    }

    public Map<String, FieldInterfaced> getFieldsByColId() {
        return this.fieldsByColId;
    }

    public Map<String, String> getAlias() {
        return this.alias;
    }

    public Map<String, String> getAliasedColumnNames() {
        return this.aliasedColumnNames;
    }

    public List<FieldInterfaced> getSumFields() {
        return this.sumFields;
    }

    public List<SumData> getSums() {
        return this.sums;
    }

    public String getSelectColumnsForCount() {
        return this.selectColumnsForCount;
    }

    public String getSelectColumnsForList() {
        return this.selectColumnsForList;
    }

    public CountQueryHandler getCountQueryHandler() {
        return this.countQueryHandler;
    }

    public RowsQueryHandler getRowsQueryHandler() {
        return this.rowsQueryHandler;
    }

    public SumsQueryHandler getSumsQueryHandler() {
        return this.sumsQueryHandler;
    }

    public void setAction(MDDOpenCRUDAction action) {
        this.action = action;
    }

    public void setAliasedColumnNamesByColId(Map<String, String> aliasedColumnNamesByColId) {
        this.aliasedColumnNamesByColId = aliasedColumnNamesByColId;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public void setFieldsByColumnName(Map<String, FieldInterfaced> fieldsByColumnName) {
        this.fieldsByColumnName = fieldsByColumnName;
    }

    public void setFilterNames(List<String> filterNames) {
        this.filterNames = filterNames;
    }

    public void setFieldsByFilterName(Map<String, FieldInterfaced> fieldsByFilterName) {
        this.fieldsByFilterName = fieldsByFilterName;
    }

    public void setColumnFields(List<String> columnFields) {
        this.columnFields = columnFields;
    }

    public void setVisibleColumns(List<String> visibleColumns) {
        this.visibleColumns = visibleColumns;
    }

    public void setFilterFields(List<FieldInterfaced> filterFields) {
        this.filterFields = filterFields;
    }

    public void setAliasedColumnNamesList(List<String> aliasedColumnNamesList) {
        this.aliasedColumnNamesList = aliasedColumnNamesList;
    }

    public void setColumnIds(List<String> columnIds) {
        this.columnIds = columnIds;
    }

    public void setFieldsByAliasedColumnName(Map<String, FieldInterfaced> fieldsByAliasedColumnName) {
        this.fieldsByAliasedColumnName = fieldsByAliasedColumnName;
    }

    public void setFieldsByColId(Map<String, FieldInterfaced> fieldsByColId) {
        this.fieldsByColId = fieldsByColId;
    }

    public void setAlias(Map<String, String> alias) {
        this.alias = alias;
    }

    public void setAliasedColumnNames(Map<String, String> aliasedColumnNames) {
        this.aliasedColumnNames = aliasedColumnNames;
    }

    public void setSumFields(List<FieldInterfaced> sumFields) {
        this.sumFields = sumFields;
    }

    public void setSums(List<SumData> sums) {
        this.sums = sums;
    }

    public void setSelectColumnsForCount(String selectColumnsForCount) {
        this.selectColumnsForCount = selectColumnsForCount;
    }

    public void setSelectColumnsForList(String selectColumnsForList) {
        this.selectColumnsForList = selectColumnsForList;
    }

    public void setCountQueryHandler(CountQueryHandler countQueryHandler) {
        this.countQueryHandler = countQueryHandler;
    }

    public void setRowsQueryHandler(RowsQueryHandler rowsQueryHandler) {
        this.rowsQueryHandler = rowsQueryHandler;
    }

    public void setSumsQueryHandler(SumsQueryHandler sumsQueryHandler) {
        this.sumsQueryHandler = sumsQueryHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JpaRpcCrudView)) {
            return false;
        }
        JpaRpcCrudView other = (JpaRpcCrudView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MDDOpenCRUDAction this$action = this.getAction();
        MDDOpenCRUDAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        Map<String, String> this$aliasedColumnNamesByColId = this.getAliasedColumnNamesByColId();
        Map<String, String> other$aliasedColumnNamesByColId = other.getAliasedColumnNamesByColId();
        if (this$aliasedColumnNamesByColId == null ? other$aliasedColumnNamesByColId != null : !((Object)this$aliasedColumnNamesByColId).equals(other$aliasedColumnNamesByColId)) {
            return false;
        }
        List<String> this$columnNames = this.getColumnNames();
        List<String> other$columnNames = other.getColumnNames();
        if (this$columnNames == null ? other$columnNames != null : !((Object)this$columnNames).equals(other$columnNames)) {
            return false;
        }
        Map<String, FieldInterfaced> this$fieldsByColumnName = this.getFieldsByColumnName();
        Map<String, FieldInterfaced> other$fieldsByColumnName = other.getFieldsByColumnName();
        if (this$fieldsByColumnName == null ? other$fieldsByColumnName != null : !((Object)this$fieldsByColumnName).equals(other$fieldsByColumnName)) {
            return false;
        }
        List<String> this$filterNames = this.getFilterNames();
        List<String> other$filterNames = other.getFilterNames();
        if (this$filterNames == null ? other$filterNames != null : !((Object)this$filterNames).equals(other$filterNames)) {
            return false;
        }
        Map<String, FieldInterfaced> this$fieldsByFilterName = this.getFieldsByFilterName();
        Map<String, FieldInterfaced> other$fieldsByFilterName = other.getFieldsByFilterName();
        if (this$fieldsByFilterName == null ? other$fieldsByFilterName != null : !((Object)this$fieldsByFilterName).equals(other$fieldsByFilterName)) {
            return false;
        }
        List<FieldInterfaced> this$columnFields = this.getColumnFields();
        List<FieldInterfaced> other$columnFields = other.getColumnFields();
        if (this$columnFields == null ? other$columnFields != null : !((Object)this$columnFields).equals(other$columnFields)) {
            return false;
        }
        List<String> this$visibleColumns = this.getVisibleColumns();
        List<String> other$visibleColumns = other.getVisibleColumns();
        if (this$visibleColumns == null ? other$visibleColumns != null : !((Object)this$visibleColumns).equals(other$visibleColumns)) {
            return false;
        }
        List<FieldInterfaced> this$filterFields = this.getFilterFields();
        List<FieldInterfaced> other$filterFields = other.getFilterFields();
        if (this$filterFields == null ? other$filterFields != null : !((Object)this$filterFields).equals(other$filterFields)) {
            return false;
        }
        List<String> this$aliasedColumnNamesList = this.getAliasedColumnNamesList();
        List<String> other$aliasedColumnNamesList = other.getAliasedColumnNamesList();
        if (this$aliasedColumnNamesList == null ? other$aliasedColumnNamesList != null : !((Object)this$aliasedColumnNamesList).equals(other$aliasedColumnNamesList)) {
            return false;
        }
        List<String> this$columnIds = this.getColumnIds();
        List<String> other$columnIds = other.getColumnIds();
        if (this$columnIds == null ? other$columnIds != null : !((Object)this$columnIds).equals(other$columnIds)) {
            return false;
        }
        Map<String, FieldInterfaced> this$fieldsByAliasedColumnName = this.getFieldsByAliasedColumnName();
        Map<String, FieldInterfaced> other$fieldsByAliasedColumnName = other.getFieldsByAliasedColumnName();
        if (this$fieldsByAliasedColumnName == null ? other$fieldsByAliasedColumnName != null : !((Object)this$fieldsByAliasedColumnName).equals(other$fieldsByAliasedColumnName)) {
            return false;
        }
        Map<String, FieldInterfaced> this$fieldsByColId = this.getFieldsByColId();
        Map<String, FieldInterfaced> other$fieldsByColId = other.getFieldsByColId();
        if (this$fieldsByColId == null ? other$fieldsByColId != null : !((Object)this$fieldsByColId).equals(other$fieldsByColId)) {
            return false;
        }
        Map<String, String> this$alias = this.getAlias();
        Map<String, String> other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !((Object)this$alias).equals(other$alias)) {
            return false;
        }
        Map<String, String> this$aliasedColumnNames = this.getAliasedColumnNames();
        Map<String, String> other$aliasedColumnNames = other.getAliasedColumnNames();
        if (this$aliasedColumnNames == null ? other$aliasedColumnNames != null : !((Object)this$aliasedColumnNames).equals(other$aliasedColumnNames)) {
            return false;
        }
        List<FieldInterfaced> this$sumFields = this.getSumFields();
        List<FieldInterfaced> other$sumFields = other.getSumFields();
        if (this$sumFields == null ? other$sumFields != null : !((Object)this$sumFields).equals(other$sumFields)) {
            return false;
        }
        List<SumData> this$sums = this.getSums();
        List<SumData> other$sums = other.getSums();
        if (this$sums == null ? other$sums != null : !((Object)this$sums).equals(other$sums)) {
            return false;
        }
        String this$selectColumnsForCount = this.getSelectColumnsForCount();
        String other$selectColumnsForCount = other.getSelectColumnsForCount();
        if (this$selectColumnsForCount == null ? other$selectColumnsForCount != null : !this$selectColumnsForCount.equals(other$selectColumnsForCount)) {
            return false;
        }
        String this$selectColumnsForList = this.getSelectColumnsForList();
        String other$selectColumnsForList = other.getSelectColumnsForList();
        if (this$selectColumnsForList == null ? other$selectColumnsForList != null : !this$selectColumnsForList.equals(other$selectColumnsForList)) {
            return false;
        }
        CountQueryHandler this$countQueryHandler = this.getCountQueryHandler();
        CountQueryHandler other$countQueryHandler = other.getCountQueryHandler();
        if (this$countQueryHandler == null ? other$countQueryHandler != null : !this$countQueryHandler.equals(other$countQueryHandler)) {
            return false;
        }
        RowsQueryHandler this$rowsQueryHandler = this.getRowsQueryHandler();
        RowsQueryHandler other$rowsQueryHandler = other.getRowsQueryHandler();
        if (this$rowsQueryHandler == null ? other$rowsQueryHandler != null : !this$rowsQueryHandler.equals(other$rowsQueryHandler)) {
            return false;
        }
        SumsQueryHandler this$sumsQueryHandler = this.getSumsQueryHandler();
        SumsQueryHandler other$sumsQueryHandler = other.getSumsQueryHandler();
        return !(this$sumsQueryHandler == null ? other$sumsQueryHandler != null : !this$sumsQueryHandler.equals(other$sumsQueryHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JpaRpcCrudView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MDDOpenCRUDAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        Map<String, String> $aliasedColumnNamesByColId = this.getAliasedColumnNamesByColId();
        result = result * 59 + ($aliasedColumnNamesByColId == null ? 43 : ((Object)$aliasedColumnNamesByColId).hashCode());
        List<String> $columnNames = this.getColumnNames();
        result = result * 59 + ($columnNames == null ? 43 : ((Object)$columnNames).hashCode());
        Map<String, FieldInterfaced> $fieldsByColumnName = this.getFieldsByColumnName();
        result = result * 59 + ($fieldsByColumnName == null ? 43 : ((Object)$fieldsByColumnName).hashCode());
        List<String> $filterNames = this.getFilterNames();
        result = result * 59 + ($filterNames == null ? 43 : ((Object)$filterNames).hashCode());
        Map<String, FieldInterfaced> $fieldsByFilterName = this.getFieldsByFilterName();
        result = result * 59 + ($fieldsByFilterName == null ? 43 : ((Object)$fieldsByFilterName).hashCode());
        List<FieldInterfaced> $columnFields = this.getColumnFields();
        result = result * 59 + ($columnFields == null ? 43 : ((Object)$columnFields).hashCode());
        List<String> $visibleColumns = this.getVisibleColumns();
        result = result * 59 + ($visibleColumns == null ? 43 : ((Object)$visibleColumns).hashCode());
        List<FieldInterfaced> $filterFields = this.getFilterFields();
        result = result * 59 + ($filterFields == null ? 43 : ((Object)$filterFields).hashCode());
        List<String> $aliasedColumnNamesList = this.getAliasedColumnNamesList();
        result = result * 59 + ($aliasedColumnNamesList == null ? 43 : ((Object)$aliasedColumnNamesList).hashCode());
        List<String> $columnIds = this.getColumnIds();
        result = result * 59 + ($columnIds == null ? 43 : ((Object)$columnIds).hashCode());
        Map<String, FieldInterfaced> $fieldsByAliasedColumnName = this.getFieldsByAliasedColumnName();
        result = result * 59 + ($fieldsByAliasedColumnName == null ? 43 : ((Object)$fieldsByAliasedColumnName).hashCode());
        Map<String, FieldInterfaced> $fieldsByColId = this.getFieldsByColId();
        result = result * 59 + ($fieldsByColId == null ? 43 : ((Object)$fieldsByColId).hashCode());
        Map<String, String> $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : ((Object)$alias).hashCode());
        Map<String, String> $aliasedColumnNames = this.getAliasedColumnNames();
        result = result * 59 + ($aliasedColumnNames == null ? 43 : ((Object)$aliasedColumnNames).hashCode());
        List<FieldInterfaced> $sumFields = this.getSumFields();
        result = result * 59 + ($sumFields == null ? 43 : ((Object)$sumFields).hashCode());
        List<SumData> $sums = this.getSums();
        result = result * 59 + ($sums == null ? 43 : ((Object)$sums).hashCode());
        String $selectColumnsForCount = this.getSelectColumnsForCount();
        result = result * 59 + ($selectColumnsForCount == null ? 43 : $selectColumnsForCount.hashCode());
        String $selectColumnsForList = this.getSelectColumnsForList();
        result = result * 59 + ($selectColumnsForList == null ? 43 : $selectColumnsForList.hashCode());
        CountQueryHandler $countQueryHandler = this.getCountQueryHandler();
        result = result * 59 + ($countQueryHandler == null ? 43 : $countQueryHandler.hashCode());
        RowsQueryHandler $rowsQueryHandler = this.getRowsQueryHandler();
        result = result * 59 + ($rowsQueryHandler == null ? 43 : $rowsQueryHandler.hashCode());
        SumsQueryHandler $sumsQueryHandler = this.getSumsQueryHandler();
        result = result * 59 + ($sumsQueryHandler == null ? 43 : $sumsQueryHandler.hashCode());
        return result;
    }

    public String toString() {
        return "JpaRpcCrudView(action=" + this.getAction() + ", aliasedColumnNamesByColId=" + this.getAliasedColumnNamesByColId() + ", columnNames=" + this.getColumnNames() + ", fieldsByColumnName=" + this.getFieldsByColumnName() + ", filterNames=" + this.getFilterNames() + ", fieldsByFilterName=" + this.getFieldsByFilterName() + ", columnFields=" + this.getColumnFields() + ", visibleColumns=" + this.getVisibleColumns() + ", filterFields=" + this.getFilterFields() + ", aliasedColumnNamesList=" + this.getAliasedColumnNamesList() + ", columnIds=" + this.getColumnIds() + ", fieldsByAliasedColumnName=" + this.getFieldsByAliasedColumnName() + ", fieldsByColId=" + this.getFieldsByColId() + ", alias=" + this.getAlias() + ", aliasedColumnNames=" + this.getAliasedColumnNames() + ", sumFields=" + this.getSumFields() + ", sums=" + this.getSums() + ", selectColumnsForCount=" + this.getSelectColumnsForCount() + ", selectColumnsForList=" + this.getSelectColumnsForList() + ", countQueryHandler=" + this.getCountQueryHandler() + ", rowsQueryHandler=" + this.getRowsQueryHandler() + ", sumsQueryHandler=" + this.getSumsQueryHandler() + ")";
    }
}

