/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.json;

import com.google.auto.service.AutoService;
import io.mateu.mdd.shared.data.ExternalReference;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.persistence.EntitySerializer;
import jakarta.persistence.CascadeType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@AutoService(value={EntitySerializer.class})
public class MateuEntitySerializer
implements EntitySerializer {
    public Map<String, Object> toMap(Object entity) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (FieldInterfaced field : ReflectionHelper.getAllTransferrableFields(entity.getClass())) {
            this.addToData(data, field, entity);
        }
        return data;
    }

    private void addToData(Map<String, Object> data, FieldInterfaced field, Object entity) throws Exception {
        if (field.isAnnotationPresent(OneToMany.class)) {
            this.addOneToMany(data, field, entity);
            return;
        }
        if (field.isAnnotationPresent(ManyToOne.class)) {
            this.addManyToOne(data, field, entity);
            return;
        }
        data.put(field.getId(), ReflectionHelper.getValue((FieldInterfaced)field, (Object)entity));
    }

    private void addManyToOne(Map<String, Object> data, FieldInterfaced field, Object entity) throws Exception {
        Object value = ReflectionHelper.getValue((FieldInterfaced)field, (Object)entity);
        if (value == null) {
            return;
        }
        data.put(field.getId(), new ExternalReference(ReflectionHelper.getId((Object)value), value.toString()));
    }

    private void addOneToMany(Map<String, Object> data, FieldInterfaced field, Object entity) throws Exception {
        Collection list = (Collection)ReflectionHelper.getValue((FieldInterfaced)field, (Object)entity);
        if (list == null) {
            return;
        }
        if (Arrays.stream(((OneToMany)field.getAnnotation(OneToMany.class)).cascade()).filter(c -> c.equals((Object)CascadeType.ALL)).count() > 0L) {
            ArrayList items = new ArrayList();
            list.forEach(value -> {
                try {
                    items.add(this.toMap(value));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            data.put(field.getId(), items);
        } else {
            ArrayList refs = new ArrayList();
            list.forEach(value -> refs.add(new ExternalReference(ReflectionHelper.getId((Object)value), value.toString())));
            data.put(field.getId(), refs);
        }
    }
}

