/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.ui.cruds.queries;

import com.google.common.base.Strings;
import io.mateu.mdd.shared.annotations.Ignored;
import io.mateu.mdd.shared.annotations.LiteralSearchFilter;
import io.mateu.mdd.shared.annotations.MainSearchFilter;
import io.mateu.mdd.shared.annotations.Order;
import io.mateu.mdd.shared.annotations.SearchFilter;
import io.mateu.mdd.shared.annotations.UseIdToSelect;
import io.mateu.mdd.shared.interfaces.SortCriteria;
import io.mateu.mdd.shared.interfaces.SortType;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.ui.cruds.queries.Query;
import io.mateu.reflection.ReflectionHelper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Version;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHelper {
    private static final Logger log = LoggerFactory.getLogger(QueryHelper.class);

    public jakarta.persistence.Query buildJpaQuery(Query query, EntityManager em, String selectedColumns, Object filters, List<SortCriteria> sortOrders, String groupClause, int offset, int limit, boolean addOrderClause) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class entityClass = query.getAction().getEntityClass();
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        String w = "";
        w = this.buildWhereClause(query, filters, entityClass, parameterValues);
        String jpql = "select " + selectedColumns + " from " + entityClass.getName() + " x ";
        for (String string : query.getAlias().keySet()) {
            jpql = jpql + " left join " + string + " " + query.getAlias().get(string);
        }
        if (!"".equals(w)) {
            jpql = jpql + " where " + w;
        }
        if (!Strings.isNullOrEmpty((String)groupClause)) {
            jpql = jpql + " " + groupClause + " ";
        }
        if (addOrderClause) {
            Object oc = "";
            if (sortOrders != null) {
                for (SortCriteria sortCriteria : sortOrders) {
                    if (SortType.None.equals((Object)sortCriteria.getOrder())) continue;
                    if (!"".equals(oc)) {
                        oc = (String)oc + ", ";
                    }
                    oc = (String)oc + sortCriteria.getColumn() + " " + (SortType.Descending.equals((Object)sortCriteria.getOrder()) ? "desc" : "asc");
                }
            }
            ArrayList<FieldInterfaced> arrayList = new ArrayList<FieldInterfaced>();
            for (FieldInterfaced f2 : ReflectionHelper.getAllFields((Class)entityClass)) {
                if (!f2.isAnnotationPresent(Order.class)) continue;
                arrayList.add(f2);
            }
            Collections.sort(arrayList, Comparator.comparingInt(f -> ((Order)f.getAnnotation(Order.class)).priority()));
            for (FieldInterfaced f2 : arrayList) {
                if (!"".equals(oc)) {
                    oc = (String)oc + ", ";
                }
                oc = (String)oc + query.getAliasedColumnNames().get(f2.getName()) + " " + (((Order)f2.getAnnotation(Order.class)).desc() ? "desc" : "asc");
            }
            if ("".equals(oc) && query.getColumnNames().size() > 1) {
                oc = (String)oc + query.getAliasedColumnNames().get(query.getColumnNames().get(1)) + " desc";
            }
            if (!"".equals(oc)) {
                jpql = jpql + " order by " + (String)oc;
            }
        }
        log.info(jpql);
        jakarta.persistence.Query q = em.createQuery(jpql).setFirstResult(offset).setMaxResults(limit);
        for (String string : parameterValues.keySet()) {
            q.setParameter(string, parameterValues.get(string));
        }
        return q;
    }

    private String buildWhereClause(Query query, Object filters, Class entityClass, Map<String, Object> parameterValues) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object ql = "";
        try {
            this.updateExtraFilters();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!Strings.isNullOrEmpty((String)query.getQueryFilters())) {
            if (!"".equals(ql)) {
                ql = (String)ql + " and ";
            }
            ql = (String)ql + query.getQueryFilters();
        }
        if (query.getExtraFilters() != null && !Strings.isNullOrEmpty((String)query.getExtraFilters().getQl())) {
            if (!"".equals(ql)) {
                ql = (String)ql + " and ";
            }
            ql = (String)ql + query.getExtraFilters().getQl();
            if (query.getExtraFilters().getParameters() != null) {
                parameterValues.putAll(query.getExtraFilters().getParameters());
            }
        }
        if (filters == null) {
            return ql;
        }
        List<Object> allFields = query.getFilterFields();
        allFields = allFields.stream().filter(f -> !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && (!f.isAnnotationPresent(Id.class) || !f.isAnnotationPresent(GeneratedValue.class) || f.isAnnotationPresent(MainSearchFilter.class) || f.isAnnotationPresent(SearchFilter.class))).collect(Collectors.toList());
        for (FieldInterfaced fieldInterfaced : allFields) {
            Object v = ReflectionHelper.getValue((FieldInterfaced)fieldInterfaced, (Object)filters);
            if (v == null) continue;
            FieldInterfaced ef = ReflectionHelper.getFieldByName((Class)entityClass, (String)fieldInterfaced.getName());
            if (ef != null && ef.getType().isAnnotationPresent(UseIdToSelect.class)) {
                boolean anadir = !String.class.equals(v.getClass()) || !Strings.isNullOrEmpty((String)((String)v));
                if (!anadir) continue;
                FieldInterfaced idf = ReflectionHelper.getIdField((Class)entityClass);
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                ql = (String)ql + " x." + fieldInterfaced.getName() + "." + idf.getName() + " = :" + fieldInterfaced.getName() + " ";
                parameterValues.put(fieldInterfaced.getName(), v);
                continue;
            }
            if (String.class.equals(v.getClass())) {
                String s = (String)v;
                if (Strings.isNullOrEmpty((String)s)) continue;
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                ql = (String)ql + " lower(x." + fieldInterfaced.getName() + (fieldInterfaced.isAnnotationPresent(LiteralSearchFilter.class) ? ".es" : "") + ") like :" + fieldInterfaced.getName() + " ";
                parameterValues.put(fieldInterfaced.getName(), "%" + ((String)v).toLowerCase() + "%");
                continue;
            }
            if (Boolean.class.equals(v.getClass()) || Boolean.TYPE.equals(v.getClass())) {
                boolean b = (Boolean)v;
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                if (!b) {
                    ql = (String)ql + " not ";
                }
                ql = (String)ql + " x." + fieldInterfaced.getName() + " ";
                if (!b) continue;
                ql = (String)ql + " = true ";
                continue;
            }
            if (Integer.class.equals(v.getClass()) || Integer.TYPE.equals(v.getClass()) || Long.class.equals(v.getClass()) || Long.TYPE.equals(v.getClass()) || Double.class.equals(v.getClass()) || Double.TYPE.equals(v.getClass())) {
                String fname = fieldInterfaced.getName();
                if (fname.endsWith("From")) {
                    fname = fname.substring(0, fname.lastIndexOf("From"));
                }
                if (fname.endsWith("To")) {
                    fname = fname.substring(0, fname.lastIndexOf("To"));
                }
                if (fname.endsWith("Value")) {
                    fname = fname.substring(0, fname.lastIndexOf("Value"));
                }
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                ql = (String)ql + " x." + fname + " " + (fieldInterfaced.getName().endsWith("From") ? ">=" : (fieldInterfaced.getName().endsWith("To") ? "<=" : "=")) + " :" + fieldInterfaced.getName() + " ";
                parameterValues.put(fieldInterfaced.getName(), v);
                continue;
            }
            if (LocalDate.class.equals(v.getClass()) || LocalDateTime.class.equals(v.getClass()) || Date.class.equals(v.getClass())) {
                String fname = fieldInterfaced.getName();
                if (fname.endsWith("From")) {
                    fname = fname.substring(0, fname.lastIndexOf("From"));
                }
                if (fname.endsWith("To")) {
                    fname = fname.substring(0, fname.lastIndexOf("To"));
                }
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                ql = (String)ql + " x." + fname + " " + (fieldInterfaced.getName().endsWith("From") ? ">=" : "<=") + " :" + fieldInterfaced.getName() + " ";
                parameterValues.put(fieldInterfaced.getName(), v);
                continue;
            }
            if (v instanceof Map && fieldInterfaced.isAnnotationPresent(ManyToOne.class)) {
                v = ((Map)v).get("value");
                FieldInterfaced idField = ReflectionHelper.getIdField((Class)fieldInterfaced.getType());
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                ql = (String)ql + " x." + fieldInterfaced.getName() + "." + idField.getId() + " = :" + fieldInterfaced.getName() + "_" + idField.getId() + " ";
                parameterValues.put(fieldInterfaced.getName() + "_" + idField.getId(), v);
                continue;
            }
            if (!"".equals(ql)) {
                ql = (String)ql + " and ";
            }
            ql = (String)ql + " x." + fieldInterfaced.getName() + " = :" + fieldInterfaced.getName() + " ";
            parameterValues.put(fieldInterfaced.getName(), v);
        }
        return ql;
    }

    public void updateExtraFilters() throws Exception {
    }

    private int getColumnIndex(Query query, String columnId) {
        int i = query.getAliasedColumnNamesList().indexOf(columnId);
        if (i < 0 && columnId.startsWith("col")) {
            i = Integer.parseInt(columnId.substring("col".length()));
        }
        return i;
    }
}

