/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.ui.cruds.queries.rows;

import io.mateu.mdd.ui.cruds.queries.QueryHelper;
import io.mateu.mdd.ui.cruds.queries.rows.RowsQuery;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Flux;

@Service
public class RowsQueryHandler {
    private static final Logger log = LoggerFactory.getLogger(RowsQueryHandler.class);
    @PersistenceContext
    private EntityManager em;

    @Transactional
    public Flux run(RowsQuery query) {
        try {
            Query q = new QueryHelper().buildJpaQuery(query, this.em, query.getSelectColumnsForList(), query.getFilters(), query.getSortOrders(), null, query.getOffset(), query.getLimit(), true);
            return Flux.fromStream(q.getResultList().stream().map(raw -> this.toMap(query, (Object[])raw)));
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    private Map toMap(RowsQuery query, Object[] values) {
        HashMap<CallSite, Object> map = new HashMap<CallSite, Object>();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                map.put((CallSite)((Object)("col" + i)), values[i]);
            }
        }
        return map;
    }
}

