/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.ui.cruds.queries.count;

import io.mateu.mdd.ui.cruds.queries.QueryHelper;
import io.mateu.mdd.ui.cruds.queries.count.CountQuery;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CountQueryHandler {
    private static final Logger log = LoggerFactory.getLogger(CountQueryHandler.class);
    @PersistenceContext
    private EntityManager em;

    @Transactional
    public int run(CountQuery query) {
        int[] count = new int[]{0};
        try {
            Query q = new QueryHelper().buildJpaQuery(query, this.em, query.getSelectColumnsForCount(), query.getFilters(), null, null, 0, 1000, false);
            log.debug(q.toString());
            Object r = q.getSingleResult();
            if (r instanceof Long) {
                count[0] = ((Long)r).intValue();
            } else if (r instanceof Object[]) {
                Object[] v = (Object[])r;
                count[0] = ((Long)v[0]).intValue();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return count[0];
    }
}

