/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.ui.cruds;

import com.google.common.base.Strings;
import com.vaadin.data.provider.QuerySortOrder;
import com.vaadin.shared.data.sort.SortDirection;
import io.mateu.mdd.core.app.MDDOpenCRUDAction;
import io.mateu.mdd.core.views.ExtraFilters;
import io.mateu.mdd.shared.annotations.Ignored;
import io.mateu.mdd.shared.annotations.LiteralSearchFilter;
import io.mateu.mdd.shared.annotations.MainSearchFilter;
import io.mateu.mdd.shared.annotations.Order;
import io.mateu.mdd.shared.annotations.SearchFilter;
import io.mateu.mdd.shared.annotations.UseIdToSelect;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.interfaces.AuditRecord;
import io.mateu.util.notification.Notifier;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Query;
import javax.persistence.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JpaCrudQuery {
    private static final Logger log = LoggerFactory.getLogger(JpaCrudQuery.class);
    protected MDDOpenCRUDAction action;
    protected Object filters;
    protected List<QuerySortOrder> sortOrders;
    private int offset;
    private int limit;
    protected Map<String, String> aliasedColumnNamesByColId;
    private String queryFilters;
    private ExtraFilters extraFilters;
    protected String selectColumnsForCount;
    protected String selectColumnsForList;
    private Map<String, String> alias;
    private Map<String, String> aliasedColumnNames;
    private List<String> columnNames;
    protected List<String> aliasedColumnNamesList;
    private List<FieldInterfaced> filterFields;

    protected Query buildQuery(EntityManager em, String selectedColumns, Object filters, List<QuerySortOrder> sortOrders, String groupClause, int offset, int limit, boolean addOrderClause) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        String w = "";
        w = this.buildWhereClause(filters, this.action.getEntityClass(), parameterValues);
        String jpql = "select " + selectedColumns + " from " + this.action.getEntityClass().getName() + " x ";
        for (String string : this.alias.keySet()) {
            jpql = jpql + " left join " + string + " " + this.alias.get(string);
        }
        if (!"".equals(w)) {
            jpql = jpql + " where " + w;
        }
        if (!Strings.isNullOrEmpty((String)groupClause)) {
            jpql = jpql + " " + groupClause + " ";
        }
        if (addOrderClause) {
            Object oc = "";
            if (sortOrders != null) {
                for (QuerySortOrder querySortOrder : sortOrders) {
                    if (!"".equals(oc)) {
                        oc = (String)oc + ", ";
                    }
                    oc = (String)oc + "col" + this.getColumnIndex(this.aliasedColumnNamesByColId.entrySet().stream().filter(e -> ((String)e.getValue()).equals(querySortOrder.getSorted())).map(e -> (String)e.getKey()).findFirst().get()) + " " + (SortDirection.DESCENDING.equals((Object)querySortOrder.getDirection()) ? "desc" : "asc");
                }
            }
            ArrayList<FieldInterfaced> arrayList = new ArrayList<FieldInterfaced>();
            for (FieldInterfaced f : ReflectionHelper.getAllFields((Class)this.action.getEntityClass())) {
                if (!f.isAnnotationPresent(Order.class)) continue;
                arrayList.add(f);
            }
            Collections.sort(arrayList, (f1, f2) -> ((Order)f1.getAnnotation(Order.class)).priority() - ((Order)f2.getAnnotation(Order.class)).priority());
            for (FieldInterfaced f : arrayList) {
                if (!"".equals(oc)) {
                    oc = (String)oc + ", ";
                }
                oc = (String)oc + this.aliasedColumnNames.get(f.getName()) + " " + (((Order)f.getAnnotation(Order.class)).desc() ? "desc" : "asc");
            }
            if ("".equals(oc) && ReflectionHelper.getFieldByName((Class)this.action.getEntityClass(), (String)"audit") != null && AuditRecord.class.isAssignableFrom(ReflectionHelper.getFieldByName((Class)this.action.getEntityClass(), (String)"audit").getType())) {
                oc = (String)oc + "x.audit.modified desc";
            }
            if ("".equals(oc) && this.columnNames.size() > 1) {
                oc = (String)oc + this.aliasedColumnNames.get(this.columnNames.get(1)) + " desc";
            }
            if (!"".equals(oc)) {
                jpql = jpql + " order by " + (String)oc;
            }
        }
        Query q = em.createQuery(jpql).setFirstResult(offset).setMaxResults(limit);
        for (String string : parameterValues.keySet()) {
            q.setParameter(string, parameterValues.get(string));
        }
        log.info(jpql);
        return q;
    }

    private String buildWhereClause(Object filters, Class entityClass, Map<String, Object> parameterValues) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object ql = "";
        try {
            this.updateExtraFilters();
        }
        catch (Exception e) {
            Notifier.alert((Throwable)e);
        }
        if (!Strings.isNullOrEmpty((String)this.queryFilters)) {
            if (!"".equals(ql)) {
                ql = (String)ql + " and ";
            }
            ql = (String)ql + this.queryFilters;
        }
        if (this.extraFilters != null && !Strings.isNullOrEmpty((String)this.extraFilters.getQl())) {
            if (!"".equals(ql)) {
                ql = (String)ql + " and ";
            }
            ql = (String)ql + this.extraFilters.getQl();
            if (this.extraFilters.getParameters() != null) {
                parameterValues.putAll(this.extraFilters.getParameters());
            }
        }
        if (filters == null) {
            return ql;
        }
        List<Object> allFields = this.filterFields;
        allFields = allFields.stream().filter(f -> !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && (!f.isAnnotationPresent(Id.class) || !f.isAnnotationPresent(GeneratedValue.class) || f.isAnnotationPresent(MainSearchFilter.class) || f.isAnnotationPresent(SearchFilter.class))).collect(Collectors.toList());
        for (FieldInterfaced fieldInterfaced : allFields) {
            Object v = ReflectionHelper.getValue((FieldInterfaced)fieldInterfaced, (Object)filters);
            if (v == null) continue;
            FieldInterfaced ef = ReflectionHelper.getFieldByName((Class)entityClass, (String)fieldInterfaced.getName());
            if (ef != null && ef.getType().isAnnotationPresent(UseIdToSelect.class)) {
                boolean anadir = !String.class.equals(v.getClass()) || !Strings.isNullOrEmpty((String)((String)v));
                if (!anadir) continue;
                FieldInterfaced idf = ReflectionHelper.getIdField((Class)entityClass);
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                ql = (String)ql + " x." + fieldInterfaced.getName() + "." + idf.getName() + " = :" + fieldInterfaced.getName() + " ";
                parameterValues.put(fieldInterfaced.getName(), v);
                continue;
            }
            if (String.class.equals(v.getClass())) {
                String s = (String)v;
                if (Strings.isNullOrEmpty((String)s)) continue;
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                ql = (String)ql + " lower(x." + fieldInterfaced.getName() + (fieldInterfaced.isAnnotationPresent(LiteralSearchFilter.class) ? ".es" : "") + ") like :" + fieldInterfaced.getName() + " ";
                parameterValues.put(fieldInterfaced.getName(), "%" + ((String)v).toLowerCase() + "%");
                continue;
            }
            if (Boolean.class.equals(v.getClass()) || Boolean.TYPE.equals(v.getClass())) {
                boolean b = (Boolean)v;
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                if (!b) {
                    ql = (String)ql + " not ";
                }
                ql = (String)ql + " x." + fieldInterfaced.getName() + " ";
                if (!b) continue;
                ql = (String)ql + " = true ";
                continue;
            }
            if (Integer.class.equals(v.getClass()) || Integer.TYPE.equals(v.getClass()) || Long.class.equals(v.getClass()) || Long.TYPE.equals(v.getClass()) || Double.class.equals(v.getClass()) || Double.TYPE.equals(v.getClass())) {
                String fname = fieldInterfaced.getName();
                if (fname.endsWith("From")) {
                    fname = fname.substring(0, fname.lastIndexOf("From"));
                }
                if (fname.endsWith("To")) {
                    fname = fname.substring(0, fname.lastIndexOf("To"));
                }
                if (fname.endsWith("Value")) {
                    fname = fname.substring(0, fname.lastIndexOf("Value"));
                }
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                ql = (String)ql + " x." + fname + " " + (fieldInterfaced.getName().endsWith("From") ? ">=" : (fieldInterfaced.getName().endsWith("To") ? "<=" : "=")) + " :" + fieldInterfaced.getName() + " ";
                parameterValues.put(fieldInterfaced.getName(), v);
                continue;
            }
            if (LocalDate.class.equals(v.getClass()) || LocalDateTime.class.equals(v.getClass()) || Date.class.equals(v.getClass())) {
                String fname = fieldInterfaced.getName();
                if (fname.endsWith("From")) {
                    fname = fname.substring(0, fname.lastIndexOf("From"));
                }
                if (fname.endsWith("To")) {
                    fname = fname.substring(0, fname.lastIndexOf("To"));
                }
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                ql = (String)ql + " x." + fname + " " + (fieldInterfaced.getName().endsWith("From") ? ">=" : "<=") + " :" + fieldInterfaced.getName() + " ";
                parameterValues.put(fieldInterfaced.getName(), v);
                continue;
            }
            if (!"".equals(ql)) {
                ql = (String)ql + " and ";
            }
            ql = (String)ql + " x." + fieldInterfaced.getName() + " = :" + fieldInterfaced.getName() + " ";
            parameterValues.put(fieldInterfaced.getName(), v);
        }
        return ql;
    }

    public void updateExtraFilters() throws Exception {
    }

    private String buildFieldsPart(List<String> columnFieldNames) {
        Object s = "";
        int pos = 0;
        for (String columnName : columnFieldNames) {
            if (!"".equals(s)) {
                s = (String)s + ", ";
            }
            String colId = this.aliasedColumnNames.get(columnName);
            s = (String)s + colId + " as col" + pos++;
        }
        return s;
    }

    private int getColumnIndex(String columnId) {
        int i = this.aliasedColumnNamesList.indexOf(columnId);
        if (i < 0 && columnId.startsWith("col")) {
            i = Integer.parseInt(columnId.substring("col".length()));
        }
        return i;
    }

    public JpaCrudQuery(MDDOpenCRUDAction action, Object filters, List<QuerySortOrder> sortOrders, int offset, int limit, Map<String, String> aliasedColumnNamesByColId, String queryFilters, ExtraFilters extraFilters, String selectColumnsForCount, String selectColumnsForList, Map<String, String> alias, Map<String, String> aliasedColumnNames, List<String> columnNames, List<String> aliasedColumnNamesList, List<FieldInterfaced> filterFields) {
        this.action = action;
        this.filters = filters;
        this.sortOrders = sortOrders;
        this.offset = offset;
        this.limit = limit;
        this.aliasedColumnNamesByColId = aliasedColumnNamesByColId;
        this.queryFilters = queryFilters;
        this.extraFilters = extraFilters;
        this.selectColumnsForCount = selectColumnsForCount;
        this.selectColumnsForList = selectColumnsForList;
        this.alias = alias;
        this.aliasedColumnNames = aliasedColumnNames;
        this.columnNames = columnNames;
        this.aliasedColumnNamesList = aliasedColumnNamesList;
        this.filterFields = filterFields;
    }
}

