/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.ui.cruds;

import com.vaadin.data.provider.QuerySortOrder;
import io.mateu.mdd.core.app.MDDOpenCRUDAction;
import io.mateu.mdd.core.views.ExtraFilters;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.ui.cruds.JpaCrudQuery;
import io.mateu.util.persistence.JPAHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaCrudRowsQuery
extends JpaCrudQuery {
    private static final Logger log = LoggerFactory.getLogger(JpaCrudRowsQuery.class);
    private int offset;
    private int limit;

    JpaCrudRowsQuery(MDDOpenCRUDAction action, Object filters, List<QuerySortOrder> sortOrders, int offset, int limit, Map<String, String> aliasedColumnNamesByColId, String queryFilters, ExtraFilters extraFilters, String selectColumnsForCount, String selectColumnsForList, Map<String, String> alias, Map<String, String> aliasedColumnNames, List<String> columnNames, List<String> aliasedColumnNamesList, List<FieldInterfaced> filterFields) {
        super(action, filters, sortOrders, offset, limit, aliasedColumnNamesByColId, queryFilters, extraFilters, selectColumnsForCount, selectColumnsForList, alias, aliasedColumnNames, columnNames, aliasedColumnNamesList, filterFields);
        this.offset = offset;
        this.limit = limit;
    }

    public List run() {
        ArrayList l = new ArrayList();
        try {
            JPAHelper.notransact(em -> {
                ArrayList<QuerySortOrder> mappedSortOrders = new ArrayList<QuerySortOrder>();
                if (this.sortOrders != null) {
                    for (QuerySortOrder sortOrder : this.sortOrders) {
                        mappedSortOrders.add(new QuerySortOrder((String)this.aliasedColumnNamesByColId.get(sortOrder.getSorted()), sortOrder.getDirection()));
                    }
                }
                Query q = this.buildQuery(em, this.selectColumnsForList, this.filters, mappedSortOrders, null, this.offset, this.limit, true);
                l.addAll(q.getResultList().stream().map(raw -> this.toMap((Object[])raw)).collect(Collectors.toList()));
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return l;
    }

    private Map toMap(Object[] values) {
        HashMap map = new HashMap();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                map.put(this.aliasedColumnNamesList.get(i), values[i]);
            }
        }
        return map;
    }
}

