/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.ui.cruds;

import com.google.common.base.Strings;
import com.vaadin.data.provider.QuerySortOrder;
import io.mateu.mdd.core.app.MDDOpenCRUDAction;
import io.mateu.mdd.core.views.ExtraFilters;
import io.mateu.mdd.shared.annotations.Sum;
import io.mateu.mdd.shared.data.SumData;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.ui.cruds.JpaCrudQuery;
import io.mateu.util.Helper;
import io.mateu.util.persistence.JPAHelper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaCrudSumsQuery
extends JpaCrudQuery {
    private static final Logger log = LoggerFactory.getLogger(JpaCrudSumsQuery.class);
    private List<FieldInterfaced> sumFields;

    JpaCrudSumsQuery(MDDOpenCRUDAction action, Object filters, List<QuerySortOrder> sortOrders, int offset, int limit, Map<String, String> aliasedColumnNamesByColId, String queryFilters, ExtraFilters extraFilters, String selectColumnsForCount, String selectColumnsForList, Map<String, String> alias, Map<String, String> aliasedColumnNames, List<String> columnNames, List<String> aliasedColumnNamesList, List<FieldInterfaced> filterFields, List<FieldInterfaced> sumFields) {
        super(action, filters, sortOrders, offset, limit, aliasedColumnNamesByColId, queryFilters, extraFilters, selectColumnsForCount, selectColumnsForList, alias, aliasedColumnNames, columnNames, aliasedColumnNamesList, filterFields);
        this.sumFields = sumFields;
    }

    public List<SumData> run() {
        ArrayList<SumData> sums = new ArrayList<SumData>();
        try {
            JPAHelper.notransact(em -> {
                Query q = this.buildQuery(em, this.selectColumnsForCount, this.filters, null, null, 0, 1000, false);
                log.debug(q.toString());
                Object r = q.getSingleResult();
                if (r instanceof Object[]) {
                    Object[] v = (Object[])r;
                    DecimalFormat nf = new DecimalFormat("#,###,###,###,###,###,###.00");
                    int pos = 1;
                    for (FieldInterfaced f : this.sumFields) {
                        Object x;
                        Object caption = Helper.capitalize((String)f.getName());
                        if (!((String)caption).startsWith("Total")) {
                            caption = "Total " + (String)caption;
                        }
                        if (!Strings.isNullOrEmpty((String)((Sum)f.getAnnotation(Sum.class)).caption())) {
                            caption = ((Sum)f.getAnnotation(Sum.class)).caption();
                        }
                        if ((x = v[pos++]) != null && x instanceof Double) {
                            x = (double)Math.round(100.0 * (Double)x) / 100.0;
                            x = nf.format(x);
                        }
                        sums.add(new SumData((String)caption, (String)(x != null ? "" + x : "---"), ""));
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return sums;
    }
}

