/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.ui.cruds;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.vaadin.data.provider.QuerySortOrder;
import io.mateu.mdd.core.app.MDDOpenCRUDAction;
import io.mateu.mdd.core.interfaces.RpcCrudView;
import io.mateu.mdd.core.interfaces.RpcCrudViewExtended;
import io.mateu.mdd.shared.annotations.Ignored;
import io.mateu.mdd.shared.annotations.ListColumn;
import io.mateu.mdd.shared.annotations.MainSearchFilter;
import io.mateu.mdd.shared.annotations.NotInList;
import io.mateu.mdd.shared.annotations.Output;
import io.mateu.mdd.shared.annotations.Password;
import io.mateu.mdd.shared.annotations.SearchFilter;
import io.mateu.mdd.shared.annotations.Sum;
import io.mateu.mdd.shared.annotations.UseCheckboxes;
import io.mateu.mdd.shared.annotations.WeekDays;
import io.mateu.mdd.shared.data.FareValue;
import io.mateu.mdd.shared.data.Status;
import io.mateu.mdd.shared.data.SumData;
import io.mateu.mdd.shared.interfaces.IResource;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.ui.cruds.JpaCrudCountQuery;
import io.mateu.mdd.ui.cruds.JpaCrudRowsQuery;
import io.mateu.mdd.ui.cruds.JpaCrudSumsQuery;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.persistence.JPAHelper;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;

public class JpaRpcCrudView
implements RpcCrudView<Object, Object, Object>,
RpcCrudViewExtended {
    private final MDDOpenCRUDAction action;
    private final Map<String, String> aliasedColumnNamesByColId = new HashMap<String, String>();
    private final List<String> columnNames = new ArrayList<String>();
    private final Map<String, FieldInterfaced> fieldsByColumnName = new HashMap<String, FieldInterfaced>();
    private final List<String> filterNames = new ArrayList<String>();
    private final Map<String, FieldInterfaced> fieldsByFilterName = new HashMap<String, FieldInterfaced>();
    private List<String> columnFields;
    private List<String> visibleColumns;
    private List<FieldInterfaced> filterFields;
    private final List<String> aliasedColumnNamesList = new ArrayList<String>();
    private final List<String> columnIds;
    private final Map<String, FieldInterfaced> fieldsByAliasedColumnName;
    private final Map<String, FieldInterfaced> fieldsByColId = new HashMap<String, FieldInterfaced>();
    private final Map<String, String> alias = new HashMap<String, String>();
    private final Map<String, String> aliasedColumnNames = new HashMap<String, String>();
    private final List<FieldInterfaced> sumFields;
    private List<SumData> sums;
    String selectColumnsForCount;
    String selectColumnsForList;

    public JpaRpcCrudView(MDDOpenCRUDAction action) {
        this.action = action;
        this.columnFields = this.getSelectFields(action.getEntityClass(), action.getColumns(), this.columnNames, this.fieldsByColumnName);
        List<String> list = this.visibleColumns = Strings.isNullOrEmpty((String)action.getColumns()) ? null : Arrays.stream(action.getColumns().split(",")).toList();
        if (this.visibleColumns == null || this.visibleColumns.size() == 0) {
            this.visibleColumns = this.columnFields.stream().skip(1L).collect(Collectors.toList());
        }
        this.filterFields = this.getFilterFields();
        this.createAliases(action.getEntityClass(), this.columnNames, this.fieldsByColumnName, this.alias, this.aliasedColumnNames, this.aliasedColumnNamesList);
        this.sumFields = this.fieldsByColumnName.values().stream().filter(f -> f.isAnnotationPresent(Sum.class)).collect(Collectors.toList());
        Object ql = "count(x)";
        for (FieldInterfaced f2 : this.sumFields) {
            if (!"".equals(ql)) {
                ql = (String)ql + ", ";
            }
            ql = (String)ql + " sum(x." + f2.getName() + ") ";
        }
        this.selectColumnsForCount = ql;
        this.selectColumnsForList = this.buildFieldsPart(this.columnFields);
        this.columnIds = new ArrayList<String>();
        int pos = 0;
        for (String n2 : this.columnNames) {
            String colId = "col" + pos++;
            this.columnIds.add(colId);
            this.aliasedColumnNamesByColId.put(colId, this.aliasedColumnNames.get(n2));
            if (pos <= 1) continue;
            this.fieldsByColId.put(colId, this.fieldsByColumnName.get(n2));
        }
        this.fieldsByAliasedColumnName = new HashMap<String, FieldInterfaced>();
        this.columnNames.stream().forEach(n -> this.fieldsByAliasedColumnName.put(this.aliasedColumnNames.get(n), this.fieldsByColumnName.get(n)));
    }

    public List rpc(Object filters, List<QuerySortOrder> sortOrders, int offset, int limit) throws Throwable {
        return new JpaCrudRowsQuery(this.action, filters, null, offset, limit, this.aliasedColumnNamesByColId, this.action.getQueryFilters(), this.action.getExtraFilters(), this.selectColumnsForCount, this.selectColumnsForList, this.alias, this.aliasedColumnNames, this.aliasedColumnNamesList, this.columnNames, this.filterFields).run();
    }

    public int gatherCount(Object filters) throws Throwable {
        this.sums = new JpaCrudSumsQuery(this.action, filters, null, 0, 0, this.aliasedColumnNamesByColId, this.action.getQueryFilters(), this.action.getExtraFilters(), this.selectColumnsForCount, this.selectColumnsForList, this.alias, this.aliasedColumnNames, this.aliasedColumnNamesList, this.columnNames, this.filterFields, this.sumFields).run();
        return new JpaCrudCountQuery(this.action, filters, null, 0, 0, this.aliasedColumnNamesByColId, this.action.getQueryFilters(), this.action.getExtraFilters(), this.selectColumnsForCount, this.selectColumnsForList, this.alias, this.aliasedColumnNames, this.aliasedColumnNamesList, this.columnNames, this.filterFields).run();
    }

    public Class getSearchFormClass() {
        return this.action.getEntityClass();
    }

    public Class getRowClass() {
        return this.action.getEntityClass();
    }

    public Class getEditorClass() {
        return this.action.getEntityClass();
    }

    public boolean isAddEnabled() {
        return this.action.isCanAdd();
    }

    public boolean isEditHandled() {
        return !this.action.isReadOnly();
    }

    public boolean isDeleteEnabled() {
        return this.action.isCanDelete();
    }

    private void createAliases(Class sourceType, List<String> paths, Map<String, FieldInterfaced> fieldsByPath, Map<String, String> alias, Map<String, String> aliasedColumnNames, List<String> aliasedColumnNamesList) {
        for (String path : paths) {
            FieldInterfaced f = fieldsByPath.get(path);
            String p = path;
            FieldInterfaced fx = f;
            Class type = sourceType;
            FieldInterfaced f0 = null;
            Object pathAcumulado = "x";
            while (!Strings.isNullOrEmpty((String)p)) {
                String s = p;
                if (p.contains(".")) {
                    p = p.substring(p.indexOf(".") + 1);
                    s = s.substring(0, s.indexOf("."));
                } else {
                    p = null;
                }
                if (!"".equals(pathAcumulado)) {
                    pathAcumulado = (String)pathAcumulado + ".";
                }
                pathAcumulado = (String)pathAcumulado + s;
                fx = ReflectionHelper.getFieldByName((Class)type, (String)s);
                if (fx == null || !(type = fx.getType()).isAnnotationPresent(Entity.class) || fx.isAnnotationPresent(NotNull.class) || fx.isAnnotationPresent(NotNull.class)) continue;
                if (!alias.containsKey(pathAcumulado)) {
                    alias.put((String)pathAcumulado, "x" + alias.size());
                }
                pathAcumulado = alias.get(pathAcumulado);
                f0 = fx;
            }
            aliasedColumnNames.put(path, (String)pathAcumulado);
            aliasedColumnNamesList.add((String)pathAcumulado);
        }
    }

    public List<String> getSelectFields(Class targetType, String useColumns, List<String> columnNames, Map<String, FieldInterfaced> fieldsByColumnName) {
        List<FieldInterfaced> cols = this.getColumnFields(targetType, false, useColumns, columnNames, fieldsByColumnName);
        FieldInterfaced idField = null;
        for (FieldInterfaced f : ReflectionHelper.getAllFields((Class)targetType)) {
            if (!f.isAnnotationPresent(Id.class)) continue;
            idField = f;
        }
        if (idField != null) {
            columnNames.add(0, idField.getName());
        }
        return columnNames;
    }

    public List<FieldInterfaced> getColumnFields(Class objectType, boolean forGrid, String fieldsFilter, List<String> columNames, Map<String, FieldInterfaced> fieldsByColumnName) {
        List<Object> explicitColumns = null;
        if (Strings.isNullOrEmpty((String)fieldsFilter)) {
            explicitColumns = ReflectionHelper.getAllFields((Class)objectType).stream().filter(f -> f.isAnnotationPresent(ListColumn.class)).peek(f -> {
                if (columNames != null && fieldsByColumnName != null) {
                    String n = f.getName();
                    columNames.add(n);
                    fieldsByColumnName.put(n, (FieldInterfaced)f);
                }
            }).filter(f -> f != null).collect(Collectors.toList());
        } else {
            List<Object> fns = Lists.newArrayList((Object[])fieldsFilter.split(","));
            fns = fns.stream().map(n -> {
                n = n.trim();
                if ((n = n.replaceAll("\\(.*\\)", "")).contains(" ")) {
                    n = n.substring(0, n.indexOf(" "));
                }
                n = n.replaceAll(" ", "");
                return n;
            }).collect(Collectors.toList());
            explicitColumns = fns.stream().map(n -> {
                FieldInterfaced f = ReflectionHelper.getFieldByName((Class)objectType, (String)n);
                if (columNames != null && fieldsByColumnName != null) {
                    columNames.add((String)n);
                    fieldsByColumnName.put((String)n, f);
                }
                return f;
            }).filter(f -> f != null).collect(Collectors.toList());
        }
        if (explicitColumns.size() > 0) {
            return explicitColumns;
        }
        List<FieldInterfaced> cols = ReflectionHelper.getAllFields((Class)objectType).stream().filter(f -> !"_proxied".equalsIgnoreCase(f.getName()) && !"_possibleValues".equalsIgnoreCase(f.getName()) && !"_binder".equalsIgnoreCase(f.getName()) && !"_field".equalsIgnoreCase(f.getName()) && !Modifier.isTransient(f.getModifiers()) && !f.isAnnotationPresent(Transient.class) && !f.isAnnotationPresent(NotInList.class) && !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && !f.isAnnotationPresent(Password.class) && (!Collection.class.isAssignableFrom(f.getType()) || forGrid && f.isAnnotationPresent(UseCheckboxes.class) && ((UseCheckboxes)f.getAnnotation(UseCheckboxes.class)).editableInline()) && !Map.class.isAssignableFrom(f.getType()) && !f.isAnnotationPresent(GeneratedValue.class) && (ReflectionHelper.isBasico((Class)f.getType()) || BigDecimal.class.equals((Object)f.getType()) || f.getType().isEnum() || f.getType().isAnnotationPresent(Entity.class) || Date.class.equals((Object)f.getType()) || FareValue.class.equals((Object)f.getType()) || Status.class.equals((Object)f.getType()) || f.isAnnotationPresent(WeekDays.class) || forGrid && f.isAnnotationPresent(UseCheckboxes.class) && ((UseCheckboxes)f.getAnnotation(UseCheckboxes.class)).editableInline() || Runnable.class.isAssignableFrom(f.getType()))).filter(f -> f != null).collect(Collectors.toList());
        if (columNames != null && fieldsByColumnName != null) {
            cols.forEach(f -> {
                columNames.add(f.getName());
                fieldsByColumnName.put(f.getName(), (FieldInterfaced)f);
            });
        }
        return cols;
    }

    public List<FieldInterfaced> getFilterFields() {
        return this.getFilterFields(this.action.getEntityClass());
    }

    public List<FieldInterfaced> getFilterFields(Class filtersType) {
        if (Strings.isNullOrEmpty((String)this.action.getFilters())) {
            List<Object> filterFields = ReflectionHelper.getAllFields((Class)filtersType).stream().filter(f -> !f.isAnnotationPresent(Password.class) && !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && (f.isAnnotationPresent(SearchFilter.class) || f.isAnnotationPresent(MainSearchFilter.class))).collect(Collectors.toList());
            if (filterFields.size() == 0) {
                filterFields = ReflectionHelper.getAllFields((Class)filtersType).stream().filter(f -> !f.isAnnotationPresent(Password.class) && !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && !f.isAnnotationPresent(Output.class) && !IResource.class.isAssignableFrom(f.getType()) && (String.class.equals((Object)f.getType()) || LocalDate.class.equals((Object)f.getType()) || LocalDateTime.class.equals((Object)f.getType()) || LocalTime.class.equals((Object)f.getType()) || java.util.Date.class.equals((Object)f.getType()) || Boolean.TYPE.equals(f.getType()) || Boolean.class.equals((Object)f.getType()) || f.getType().isEnum() || f.isAnnotationPresent(ManyToOne.class) || f.getType().isAnnotationPresent(Entity.class))).collect(Collectors.toList());
            }
            filterFields.forEach(f -> {
                this.filterNames.add(f.getName());
                this.fieldsByFilterName.put(f.getName(), (FieldInterfaced)f);
            });
            return filterFields;
        }
        ArrayList fns = Lists.newArrayList((Object[])this.action.getFilters().replaceAll(" ", "").split(","));
        List<FieldInterfaced> filterFields = fns.stream().map(n -> {
            FieldInterfaced f = ReflectionHelper.getFieldByName((Class)filtersType, (String)n);
            if (f != null) {
                this.filterNames.add((String)n);
                this.fieldsByFilterName.put((String)n, f);
            }
            return f;
        }).filter(f -> f != null).collect(Collectors.toList());
        return filterFields;
    }

    private String buildFieldsPart(List<String> columnFieldNames) {
        Object s = "";
        int pos = 0;
        for (String columnName : columnFieldNames) {
            if (!"".equals(s)) {
                s = (String)s + ", ";
            }
            String colId = this.aliasedColumnNames.get(columnName);
            s = (String)s + colId + " as col" + pos++;
        }
        return s;
    }

    public List<String> getColumnFields() {
        return this.visibleColumns;
    }

    public void delete(Set<Object> selection) throws Throwable {
        JPAHelper.transact(em -> {
            for (Object o : selection) {
                Map m = (Map)o;
                Object e = em.find(this.action.getEntityClass(), m.get("id"));
                em.remove(e);
            }
        });
    }

    public String getCaption() {
        return this.action.getCaption();
    }
}

