/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.model.authentication;

import com.Ostermiller.util.RandPass;
import com.google.common.base.Strings;
import com.vaadin.ui.Component;
import io.mateu.mdd.core.model.authentication.Audit;
import io.mateu.mdd.core.model.authentication.Permission;
import io.mateu.mdd.core.model.authentication.USER_STATUS;
import io.mateu.mdd.core.model.authentication.UserCreatedEvent;
import io.mateu.mdd.core.model.common.Resource;
import io.mateu.mdd.core.model.config.Template;
import io.mateu.mdd.shared.AppConfigLocator;
import io.mateu.mdd.shared.IAppConfig;
import io.mateu.mdd.shared.VaadinHelper;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.annotations.FieldGroup;
import io.mateu.mdd.shared.annotations.Help;
import io.mateu.mdd.shared.annotations.Ignored;
import io.mateu.mdd.shared.annotations.KPI;
import io.mateu.mdd.shared.annotations.ListColumn;
import io.mateu.mdd.shared.annotations.NotInList;
import io.mateu.mdd.shared.annotations.Output;
import io.mateu.mdd.shared.annotations.Section;
import io.mateu.mdd.shared.annotations.TextArea;
import io.mateu.mdd.shared.interfaces.UserPrincipal;
import io.mateu.util.Helper;
import io.mateu.util.eventBus.Event;
import io.mateu.util.eventBus.EventBus;
import io.mateu.util.interfaces.EditorViewStyler;
import io.mateu.util.mail.EmailHelper;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PostPersist;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Table(name="_USER")
@Entity
public class User
implements EditorViewStyler,
UserPrincipal {
    private static final Logger log = LoggerFactory.getLogger(User.class);
    @Embedded
    @KPI
    private Audit audit = new Audit();
    @Section(value="Data")
    @FieldGroup(value="Main")
    @Id
    @ListColumn(value="Login")
    @NotNull
    private String login;
    @ListColumn(value="Name")
    @NotNull
    private String name;
    @Output
    private boolean oauth;
    @FieldGroup(value="Info")
    @ListColumn(value="Email")
    @NotNull
    private String email;
    @Ignored
    private String password;
    @ListColumn(value="Status")
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private USER_STATUS status;
    private LocalDate expiryDate;
    @FieldGroup(value="Photo")
    @NotInList
    @ManyToOne(cascade={CascadeType.ALL})
    private Resource avatar;
    @FieldGroup(value="Comments")
    @TextArea
    private String comments;
    @Section(value="Auth")
    @OneToMany
    private List<Permission> permissions = new ArrayList<Permission>();
    @KPI
    private LocalDateTime lastLogin;
    @KPI
    private int failedLogins;
    @Output
    private String passwordResetKey;
    @Output
    private LocalDateTime passwordResetExpiryDateTime;

    public void setPassword(String password) {
        this.password = password != null ? Helper.md5((String)password.toLowerCase().trim()) : null;
    }

    public boolean checkPassword(String password) {
        return password != null && (Helper.md5((String)password.toLowerCase().trim()).equals(this.password) || "true".equals(System.getProperty("plainpasswordvalid")) && password.toLowerCase().trim().equals(this.password.toLowerCase().trim()));
    }

    public void setLogin(String login) {
        this.login = login != null ? login.toLowerCase().trim() : null;
    }

    public void prePersist() {
        if (this.password == null) {
            this.resetPassword();
        }
    }

    public void resetPassword() {
        String password = new RandPass().getPass(6).toLowerCase().trim();
        log.debug("resetting password for " + this.getLogin());
        this.setPassword(password);
    }

    @Action(saveAfter=true)
    public String sendWelcomeEmail(EntityManager em) throws Throwable {
        if (Strings.isNullOrEmpty((String)this.getEmail())) {
            throw new Exception("Missing email for user " + this.login);
        }
        if (USER_STATUS.INACTIVE.equals((Object)this.getStatus())) {
            throw new Exception("Deactivated user");
        }
        if (this.isOauth()) {
            throw new Exception("This users is from OAuth");
        }
        this.setPasswordResetKey(UUID.randomUUID().toString());
        this.setPasswordResetExpiryDateTime(LocalDateTime.now().plusHours(4L));
        IAppConfig app = ((AppConfigLocator)Helper.getImpl(AppConfigLocator.class)).get();
        EmailHelper.sendEmail((String)this.getEmail(), (String)("Welcome to " + app.getName()), (String)("<p>Hi " + this.getName() + ",</p><p>welcome to " + app.getName() + ".</p><p>Please go to " + app.getBaseUrl() + "resetpassword/" + this.getPasswordResetKey() + " for setting your password.</p><p>Best regards,</p><p>" + app.getName() + " team.</p>"), (boolean)true);
        return "An email with instructions has been sent to " + this.getEmail();
    }

    @Action(saveAfter=true)
    public String sendForgottenPasswordEmail(EntityManager em) throws Throwable {
        if (Strings.isNullOrEmpty((String)this.getEmail())) {
            throw new Exception("Missing email for user " + this.login);
        }
        if (USER_STATUS.INACTIVE.equals((Object)this.getStatus())) {
            throw new Exception("Deactivated user");
        }
        if (this.isOauth()) {
            throw new Exception("This users is from OAuth");
        }
        this.setPasswordResetKey(UUID.randomUUID().toString());
        this.setPasswordResetExpiryDateTime(LocalDateTime.now().plusHours(4L));
        IAppConfig app = ((AppConfigLocator)Helper.getImpl(AppConfigLocator.class)).get();
        EmailHelper.sendEmail((String)this.getEmail(), (String)"Password reset instructions", (String)("<p>" + app.getBaseUrl() + VaadinHelper.getAdaptedUIRootPath() + "resetpassword/" + this.getPasswordResetKey() + "</p>"), (boolean)true);
        return "An email with instructions has been sent to " + this.getEmail();
    }

    @PostPersist
    public void post() {
        EventBus.publish((Event)new UserCreatedEvent(this.login));
    }

    public void sendWelcomeEmail() throws Throwable {
        if (Strings.isNullOrEmpty((String)this.getEmail())) {
            throw new Exception("Missing email for user " + this.login);
        }
        if (USER_STATUS.INACTIVE.equals((Object)this.getStatus())) {
            throw new Exception("Deactivated user");
        }
        if (this.isOauth()) {
            EmailHelper.sendEmail((String)this.getEmail(), (String)("Welcome " + this.getName()), (String)"<p>Thanks for joining us ;)<p>", (boolean)false);
        } else if (this.getPassword() == null) {
            this.setPasswordResetKey(UUID.randomUUID().toString());
            this.setPasswordResetExpiryDateTime(LocalDateTime.now().plusHours(4L));
            IAppConfig app = ((AppConfigLocator)Helper.getImpl(AppConfigLocator.class)).get();
            EmailHelper.sendEmail((String)this.getEmail(), (String)("Welcome " + this.getName()), (String)("<p>To set your password please go to " + app.getBaseUrl() + "resetpassword/" + this.getPasswordResetKey() + "</p>"), (boolean)true);
        } else {
            EmailHelper.sendEmail((String)this.getEmail(), (String)("Welcome " + this.getName()), (String)"<p>You should already know your password.</p>", (boolean)true);
        }
    }

    public String toString() {
        return this.getLogin();
    }

    @Action
    public void sendEmail(@Help(value="If blank the postscript will be sent as the email body") Template template, @Help(value="If blank, the subject from the templaet will be used") String subject, @TextArea String postscript) throws Throwable {
        if (template != null) {
            Map data = Helper.getGeneralData();
            data.put("postscript", postscript);
            data.put("username", this.getName());
            data.put("useremail", this.getEmail());
            EmailHelper.sendEmail((String)this.getEmail(), (String)(!Strings.isNullOrEmpty((String)subject) ? subject : template.getSubject()), (String)Helper.freemark((String)template.getFreemarker(), (Map)data), (boolean)false);
        } else {
            EmailHelper.sendEmail((String)this.getEmail(), (String)subject, (String)postscript, (boolean)false);
        }
    }

    @Action
    public static void sendEmail(@Help(value="If blank the postscript will be sent as the email body") Template template, @Help(value="If blank, the subject from the templaet will be used") String subject, @TextArea String postscript, Set<User> selectedUsers) throws Throwable {
        for (User u : selectedUsers) {
            if (template != null) {
                Map data = Helper.getGeneralData();
                data.put("postscript", postscript);
                data.put("username", u.getName());
                data.put("useremail", u.getEmail());
                EmailHelper.sendEmail((String)u.getEmail(), (String)(!Strings.isNullOrEmpty((String)subject) ? subject : template.getSubject()), (String)Helper.freemark((String)template.getFreemarker(), (Map)data), (boolean)false);
                continue;
            }
            EmailHelper.sendEmail((String)u.getEmail(), (String)subject, (String)postscript, (boolean)false);
        }
    }

    public boolean hasPermission(long permissionId) {
        Permission p;
        boolean granted = false;
        Iterator<Permission> iterator = this.permissions.iterator();
        while (iterator.hasNext() && !(granted = (p = iterator.next()).getId() == 1L || p.getId() == permissionId)) {
        }
        return granted;
    }

    public void apply(Component editorViewComponent) {
        editorViewComponent.removeStyleNames(new String[]{"mdd-red-fgd", "mdd-blue-fgd"});
        if (USER_STATUS.INACTIVE.equals((Object)this.getStatus()) || USER_STATUS.EXPIRED.equals((Object)this.getStatus())) {
            editorViewComponent.addStyleName("mdd-red-fgd");
        } else if (USER_STATUS.BLOCKED.equals((Object)this.getStatus())) {
            editorViewComponent.addStyleName("mdd-blue-fgd");
        }
    }

    public List<String> getRoles() {
        return this.getPermissions().stream().map(p -> "" + p.getId()).collect(Collectors.toList());
    }

    public URL getPhoto() {
        try {
            return this.avatar != null ? new URL(this.avatar.toFileLocator().getUrl()) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Audit getAudit() {
        return this.audit;
    }

    @NotNull
    public String getLogin() {
        return this.login;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isOauth() {
        return this.oauth;
    }

    @NotNull
    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    @NotNull
    public USER_STATUS getStatus() {
        return this.status;
    }

    public LocalDate getExpiryDate() {
        return this.expiryDate;
    }

    public Resource getAvatar() {
        return this.avatar;
    }

    public String getComments() {
        return this.comments;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public LocalDateTime getLastLogin() {
        return this.lastLogin;
    }

    public int getFailedLogins() {
        return this.failedLogins;
    }

    public String getPasswordResetKey() {
        return this.passwordResetKey;
    }

    public LocalDateTime getPasswordResetExpiryDateTime() {
        return this.passwordResetExpiryDateTime;
    }

    public void setAudit(Audit audit) {
        this.audit = audit;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public void setOauth(boolean oauth) {
        this.oauth = oauth;
    }

    public void setEmail(@NotNull String email) {
        this.email = email;
    }

    public void setStatus(@NotNull USER_STATUS status) {
        this.status = status;
    }

    public void setExpiryDate(LocalDate expiryDate) {
        this.expiryDate = expiryDate;
    }

    public void setAvatar(Resource avatar) {
        this.avatar = avatar;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    public void setLastLogin(LocalDateTime lastLogin) {
        this.lastLogin = lastLogin;
    }

    public void setFailedLogins(int failedLogins) {
        this.failedLogins = failedLogins;
    }

    public void setPasswordResetKey(String passwordResetKey) {
        this.passwordResetKey = passwordResetKey;
    }

    public void setPasswordResetExpiryDateTime(LocalDateTime passwordResetExpiryDateTime) {
        this.passwordResetExpiryDateTime = passwordResetExpiryDateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$login = this.getLogin();
        String other$login = other.getLogin();
        return !(this$login == null ? other$login != null : !this$login.equals(other$login));
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $login = this.getLogin();
        result = result * 59 + ($login == null ? 43 : $login.hashCode());
        return result;
    }
}

