/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.model.authentication;

import io.mateu.mdd.core.model.authentication.User;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.interfaces.UserPrincipal;
import io.mateu.util.interfaces.AuditRecord;
import io.mateu.util.persistence.JPAHelper;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.persistence.Embeddable;
import javax.persistence.ManyToOne;

@Embeddable
public class Audit
implements AuditRecord {
    @ManyToOne
    private User createdBy;
    private LocalDateTime created = LocalDateTime.now();
    @ManyToOne
    private User modifiedBy;
    private LocalDateTime modified;

    public Audit() {
    }

    public Audit(User u) {
        this.createdBy = u;
        this.modifiedBy = u;
        this.created = LocalDateTime.now();
        this.modified = LocalDateTime.now();
    }

    public String toString() {
        DateTimeFormatter f = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String s = "";
        String s1 = "";
        if (this.getCreatedBy() != null) {
            s1 = s1 + "by " + this.getCreatedBy().getLogin();
        }
        if (this.getCreated() != null) {
            s1 = s1 + ("".equals(s1) ? "" : " ") + this.getCreated().format(f);
        }
        String s2 = "";
        if (this.getModifiedBy() != null) {
            s2 = s2 + "by " + this.getModifiedBy().getLogin();
        }
        if (this.getModified() != null) {
            s2 = s2 + ("".equals(s1) ? "" : " ") + this.getModified().format(f);
        }
        if (!"".equals(s1)) {
            s = s + "Created " + s1;
        }
        if (!"".equals(s2)) {
            s = "".equals(s) ? s + "Modified " : s + ", modified ";
            s = s + s2;
        }
        return s;
    }

    public void touch() throws Throwable {
        UserPrincipal p = MDDUIAccessor.getCurrentUser();
        if (p != null) {
            User u = (User)JPAHelper.find(User.class, (Object)p.getLogin());
            this.setModifiedBy(u);
            if (this.getCreatedBy() == null) {
                this.setCreatedBy(u);
            }
        }
        if (this.getCreated() == null) {
            this.setCreated(LocalDateTime.now());
        }
        this.setModified(LocalDateTime.now());
    }

    public User getCreatedBy() {
        return this.createdBy;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public User getModifiedBy() {
        return this.modifiedBy;
    }

    public LocalDateTime getModified() {
        return this.modified;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public void setModifiedBy(User modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public void setModified(LocalDateTime modified) {
        this.modified = modified;
    }
}

