/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.model.population;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import io.mateu.mdd.core.model.authentication.AdminUser;
import io.mateu.mdd.core.model.authentication.Permission;
import io.mateu.mdd.core.model.authentication.USER_STATUS;
import io.mateu.mdd.core.model.common.Resource;
import io.mateu.mdd.core.model.config.AppConfig;
import io.mateu.mdd.core.model.config.TemplateUseCase;
import io.mateu.mdd.shared.AppConfigLocator;
import io.mateu.util.Helper;
import io.mateu.util.interfaces.IPopulator;
import io.mateu.util.persistence.JPAHelper;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Populator
implements IPopulator {
    private static final Logger log = LoggerFactory.getLogger(Populator.class);
    public static final String USER_ADMIN = "admin";

    public static void main(String ... args) throws Throwable {
        new Populator().populate(AppConfig.class);
    }

    public void populate() throws Throwable {
        this.populate(((AppConfigLocator)Helper.getImpl(AppConfigLocator.class)).getAppConfigClass());
    }

    public void populate(Class appConfigClass) throws Throwable {
        log.debug("Populating database...");
        JPAHelper.transact(em -> {
            AppConfig c = (AppConfig)appConfigClass.newInstance();
            c.setId(1L);
            c.setXslfoForList(Resources.toString((URL)Resources.getResource((Class)appConfigClass, (String)"/xsl/listing.xsl"), (Charset)Charsets.UTF_8));
            c.setXslfoForObject(Resources.toString((URL)Resources.getResource((Class)appConfigClass, (String)"/xsl/object.xsl"), (Charset)Charsets.UTF_8));
            em.persist((Object)c);
            TemplateUseCase tuc = new TemplateUseCase();
            tuc.setName("User");
            em.persist((Object)tuc);
            Permission p = new Permission();
            p.setId(1L);
            p.setName("Super admin");
            em.persist((Object)p);
            AdminUser u = new AdminUser();
            u.setLogin(USER_ADMIN);
            u.setName("Admin");
            u.setEmail("miguelperezclom@gmail.com");
            u.setStatus(USER_STATUS.ACTIVE);
            u.getPermissions().add(p);
            Resource f = new Resource();
            u.setAvatar(f);
            f.setName("foto-perfil-ejemplo.png");
            f.setBytes(ByteStreams.toByteArray((InputStream)Populator.class.getResourceAsStream("/images/" + f.getName())));
            em.persist((Object)f);
            em.persist((Object)u);
            u.setPassword("1");
            u = new AdminUser();
            u.setLogin("system");
            u.setName("System");
            u.setEmail("miguelperezclom@gmail.com");
            u.setStatus(USER_STATUS.ACTIVE);
            u.getPermissions().add(p);
            em.persist((Object)u);
            u.setPassword("1");
            u = new AdminUser();
            u.setLogin("importer");
            u.setName("Importing User");
            u.setEmail("miguelperezclom@gmail.com");
            u.setStatus(USER_STATUS.ACTIVE);
            u.getPermissions().add(p);
            em.persist((Object)u);
            u.setPassword("1");
        });
        Populator.createViews();
        log.debug("Database populated.");
    }

    private static void createViews() throws Throwable {
        JPAHelper.transact(em -> {
            String s;
            InputStream r = Populator.class.getResourceAsStream("/sql/vistas.sql");
            if (r != null && (s = Helper.leerFichero((InputStream)r)) != null) {
                for (String t : s.split(";")) {
                    t = t.trim();
                    String sql = "";
                    for (String l : t.split("\n")) {
                        String lx = l.trim();
                        if (Strings.isNullOrEmpty((String)lx) || lx.startsWith("--") || lx.startsWith("#") || lx.startsWith("//")) continue;
                        try {
                            if ("".equals(sql)) {
                                sql = sql + "\n";
                            }
                            sql = sql + l;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (Strings.isNullOrEmpty((String)sql)) continue;
                    try {
                        log.debug("executing sql:" + sql);
                        em.createNativeQuery(sql).executeUpdate();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }
}

