/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.model.common;

import io.mateu.mdd.core.model.common.Resource;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.annotations.HtmlCol;
import io.mateu.mdd.shared.annotations.Output;
import io.mateu.util.Helper;
import io.mateu.util.interfaces.IIcon;
import io.mateu.util.persistence.JPAHelper;
import java.io.InputStream;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.validation.constraints.NotNull;

@Entity
public class Icon
implements IIcon {
    @Id
    private String id;
    @Output
    @HtmlCol
    private transient String html;

    public String getHtml() {
        return this.toString();
    }

    public String toString() {
        return "<i class='fas fa-" + this.id + "'></i>";
    }

    public static void createDefaultSet() {
        try {
            Icon.rebuild(Helper.leerFichero((InputStream)Icon.class.getResourceAsStream("/icons/fontawesome.css")));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Action
    public static void load(@NotNull Resource file) throws Throwable {
        String css = new String(file.getBytes());
        Icon.rebuild(css);
    }

    private static void rebuild(String css) throws Throwable {
        if (css != null) {
            JPAHelper.transact(em -> {
                for (String l : css.split("\n")) {
                    if (!l.contains(":before")) continue;
                    try {
                        System.out.println(l);
                        String id = l.substring(l.indexOf("-") + 1, l.indexOf(":"));
                        System.out.println("id=" + id);
                        Icon i = (Icon)em.find(Icon.class, (Object)id);
                        if (i != null) continue;
                        i = new Icon();
                        i.setId(id);
                        em.persist((Object)i);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Icon)) {
            return false;
        }
        Icon other = (Icon)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Icon;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

