/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.model.config;

import com.google.common.base.Strings;
import com.vaadin.server.ExternalResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Link;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import io.mateu.mdd.core.model.common.Resource;
import io.mateu.mdd.core.model.config.DummyDate;
import io.mateu.mdd.core.model.config.LinksList;
import io.mateu.mdd.shared.IAppConfig;
import io.mateu.mdd.shared.VaadinHelper;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.annotations.FieldGroup;
import io.mateu.mdd.shared.annotations.NotInEditor;
import io.mateu.mdd.shared.annotations.Password;
import io.mateu.mdd.shared.annotations.Section;
import io.mateu.mdd.shared.annotations.TextArea;
import io.mateu.util.Helper;
import io.mateu.util.interfaces.IPopulator;
import io.mateu.util.mail.EmailHelper;
import io.mateu.util.notification.Notifier;
import io.mateu.util.persistence.JPAHelper;
import io.mateu.util.persistence.JPATransaction;
import java.io.Serializable;
import java.net.URI;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.mail.Authenticator;
import javax.mail.internet.InternetAddress;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.HtmlEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class AppConfig
implements IAppConfig {
    private static final Logger log = LoggerFactory.getLogger(AppConfig.class);
    @Section(value="General")
    @Id
    @NotInEditor
    private long id;
    private String name;
    private String businessName;
    @ManyToOne(cascade={CascadeType.ALL})
    private Resource logo;
    @Section(value="Email")
    @FieldGroup(value="Setup")
    private String adminEmailSmtpHost;
    private int adminEmailSmtpPort;
    private boolean adminEmailStartTLS;
    private boolean adminEmailSSLOnConnect;
    @FieldGroup(value="Admin credentials")
    private String adminEmailUser;
    @Password
    private String adminEmailPassword;
    private String adminEmailFrom;
    private String adminEmailCC;
    @FieldGroup(value="Admin check")
    @Transient
    private Button check = new Button("Test", (Button.ClickListener & Serializable)e -> {
        try {
            HtmlEmail email = new HtmlEmail();
            email.setHostName(this.adminEmailSmtpHost);
            email.setSmtpPort(this.adminEmailSmtpPort);
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.adminEmailUser, this.adminEmailPassword));
            email.setSSLOnConnect(this.adminEmailSSLOnConnect);
            email.setStartTLSEnabled(this.adminEmailStartTLS);
            email.setFrom(this.adminEmailFrom);
            if (!Strings.isNullOrEmpty((String)this.adminEmailCC)) {
                email.getCcAddresses().add(new InternetAddress(this.adminEmailCC));
            }
            email.setSubject("Test email");
            email.setHtmlMsg("This is a test email");
            email.addTo(!Strings.isNullOrEmpty((String)System.getProperty("allemailsto")) ? System.getProperty("allemailsto") : "miguelperezcolom@gmail.com");
            EmailHelper.send((Email)email);
            Notifier.info((String)"Email sent OK");
        }
        catch (Exception ex) {
            Notifier.alert((Throwable)ex);
        }
    });
    @Transient
    private VerticalLayout gmailRequiredLinks = new LinksList(new Component[]{new Link("https://myaccount.google.com/lesssecureapps", (com.vaadin.server.Resource)new ExternalResource("https://myaccount.google.com/lesssecureapps")), new Link("https://accounts.google.com/DisplayUnlockCaptcha", (com.vaadin.server.Resource)new ExternalResource("https://accounts.google.com/DisplayUnlockCaptcha"))});
    @FieldGroup(value="Pop3")
    private String pop3Host;
    private String pop3User;
    @Password
    private String pop3Password;
    private String pop3ReboundToEmail;
    @Section(value="Integrations")
    @FieldGroup(value="SMS")
    private boolean clickatellEnabled;
    private String clickatellApiKey;
    @FieldGroup(value="Telegram")
    private boolean telegramEnabled;
    private String telegramBotToken;
    @FieldGroup(value="DeepL")
    private boolean deeplEnabled;
    private String deeplAuthKey;
    @FieldGroup(value="Mapbox")
    private String mapboxKey;
    @Section(value="CMS")
    private String nginxConfigDirectory = "/etc/nginx/conf.d";
    private String nginxReloadCommand = "service nginx reload";
    @Section(value="Templates")
    @TextArea
    private String xslfoForList;
    @TextArea
    private String xslfoForObject;

    public String getLogoUrl() throws Exception {
        return this.logo != null ? this.logo.toFileLocator().getUrl() : null;
    }

    public String getBaseUrl() {
        String u = System.getProperty("baseurl", UI.getCurrent() != null ? this.getBaseUrl(UI.getCurrent()) : "");
        if (u.endsWith(VaadinHelper.getAdaptedUIRootPath())) {
            u = u.substring(0, u.lastIndexOf(VaadinHelper.getAdaptedUIRootPath()));
        }
        return u;
    }

    private String getBaseUrl(UI ui) {
        URI u = ui.getPage().getLocation();
        String s = u.getScheme() + "://" + u.getHost() + (u.getPort() != 80 ? ":" + u.getPort() : "") + "/";
        return s;
    }

    @Action(order=10)
    public void testDeepL() {
    }

    public static AppConfig get(EntityManager em) {
        AppConfig c = (AppConfig)em.find(AppConfig.class, (Object)1L);
        if (c == null) {
            try {
                ((IPopulator)Helper.getImpl(IPopulator.class)).populate();
                c = (AppConfig)em.find(AppConfig.class, (Object)1L);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return c;
    }

    @Action(value="Create dummy dates", order=100)
    public void createDummyDates() throws Throwable {
        JPAHelper.transact((JPATransaction)new JPATransaction(){

            public void run(EntityManager em) throws Throwable {
                LocalDate d = LocalDate.parse("01/01/2000", DateTimeFormatter.ofPattern("dd/MM/yyyy"));
                LocalDate hasta = LocalDate.parse("01/01/2100", DateTimeFormatter.ofPattern("dd/MM/yyyy"));
                while (d.isBefore(hasta)) {
                    em.persist((Object)new DummyDate(d));
                    d = d.plusDays(1L);
                }
            }
        });
    }

    public static void main(String[] args) {
        AppConfig.testPureEmail();
    }

    private static void testPureEmail() {
        try {
            HtmlEmail email = new HtmlEmail();
            email.setHostName("smtp.gmail.com");
            email.setSmtpPort(587);
            email.setAuthenticator((Authenticator)new DefaultAuthenticator("miguelperezcolom@gmail.com", ""));
            email.setSSLOnConnect(false);
            email.setStartTLSEnabled(true);
            email.setFrom("miguelperezcolom@gmail.com");
            email.setSubject("Test email");
            email.setHtmlMsg("This is a test email");
            email.addTo("miguelperezcolom@gmail.com");
            EmailHelper.send((Email)email);
            log.debug("Email sent OK");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getBusinessName() {
        return this.businessName;
    }

    public Resource getLogo() {
        return this.logo;
    }

    public String getAdminEmailSmtpHost() {
        return this.adminEmailSmtpHost;
    }

    public int getAdminEmailSmtpPort() {
        return this.adminEmailSmtpPort;
    }

    public boolean isAdminEmailStartTLS() {
        return this.adminEmailStartTLS;
    }

    public boolean isAdminEmailSSLOnConnect() {
        return this.adminEmailSSLOnConnect;
    }

    public String getAdminEmailUser() {
        return this.adminEmailUser;
    }

    public String getAdminEmailPassword() {
        return this.adminEmailPassword;
    }

    public String getAdminEmailFrom() {
        return this.adminEmailFrom;
    }

    public String getAdminEmailCC() {
        return this.adminEmailCC;
    }

    public Button getCheck() {
        return this.check;
    }

    public VerticalLayout getGmailRequiredLinks() {
        return this.gmailRequiredLinks;
    }

    public String getPop3Host() {
        return this.pop3Host;
    }

    public String getPop3User() {
        return this.pop3User;
    }

    public String getPop3Password() {
        return this.pop3Password;
    }

    public String getPop3ReboundToEmail() {
        return this.pop3ReboundToEmail;
    }

    public boolean isClickatellEnabled() {
        return this.clickatellEnabled;
    }

    public String getClickatellApiKey() {
        return this.clickatellApiKey;
    }

    public boolean isTelegramEnabled() {
        return this.telegramEnabled;
    }

    public String getTelegramBotToken() {
        return this.telegramBotToken;
    }

    public boolean isDeeplEnabled() {
        return this.deeplEnabled;
    }

    public String getDeeplAuthKey() {
        return this.deeplAuthKey;
    }

    public String getMapboxKey() {
        return this.mapboxKey;
    }

    public String getNginxConfigDirectory() {
        return this.nginxConfigDirectory;
    }

    public String getNginxReloadCommand() {
        return this.nginxReloadCommand;
    }

    public String getXslfoForList() {
        return this.xslfoForList;
    }

    public String getXslfoForObject() {
        return this.xslfoForObject;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public void setLogo(Resource logo) {
        this.logo = logo;
    }

    public void setAdminEmailSmtpHost(String adminEmailSmtpHost) {
        this.adminEmailSmtpHost = adminEmailSmtpHost;
    }

    public void setAdminEmailSmtpPort(int adminEmailSmtpPort) {
        this.adminEmailSmtpPort = adminEmailSmtpPort;
    }

    public void setAdminEmailStartTLS(boolean adminEmailStartTLS) {
        this.adminEmailStartTLS = adminEmailStartTLS;
    }

    public void setAdminEmailSSLOnConnect(boolean adminEmailSSLOnConnect) {
        this.adminEmailSSLOnConnect = adminEmailSSLOnConnect;
    }

    public void setAdminEmailUser(String adminEmailUser) {
        this.adminEmailUser = adminEmailUser;
    }

    public void setAdminEmailPassword(String adminEmailPassword) {
        this.adminEmailPassword = adminEmailPassword;
    }

    public void setAdminEmailFrom(String adminEmailFrom) {
        this.adminEmailFrom = adminEmailFrom;
    }

    public void setAdminEmailCC(String adminEmailCC) {
        this.adminEmailCC = adminEmailCC;
    }

    public void setCheck(Button check) {
        this.check = check;
    }

    public void setGmailRequiredLinks(VerticalLayout gmailRequiredLinks) {
        this.gmailRequiredLinks = gmailRequiredLinks;
    }

    public void setPop3Host(String pop3Host) {
        this.pop3Host = pop3Host;
    }

    public void setPop3User(String pop3User) {
        this.pop3User = pop3User;
    }

    public void setPop3Password(String pop3Password) {
        this.pop3Password = pop3Password;
    }

    public void setPop3ReboundToEmail(String pop3ReboundToEmail) {
        this.pop3ReboundToEmail = pop3ReboundToEmail;
    }

    public void setClickatellEnabled(boolean clickatellEnabled) {
        this.clickatellEnabled = clickatellEnabled;
    }

    public void setClickatellApiKey(String clickatellApiKey) {
        this.clickatellApiKey = clickatellApiKey;
    }

    public void setTelegramEnabled(boolean telegramEnabled) {
        this.telegramEnabled = telegramEnabled;
    }

    public void setTelegramBotToken(String telegramBotToken) {
        this.telegramBotToken = telegramBotToken;
    }

    public void setDeeplEnabled(boolean deeplEnabled) {
        this.deeplEnabled = deeplEnabled;
    }

    public void setDeeplAuthKey(String deeplAuthKey) {
        this.deeplAuthKey = deeplAuthKey;
    }

    public void setMapboxKey(String mapboxKey) {
        this.mapboxKey = mapboxKey;
    }

    public void setNginxConfigDirectory(String nginxConfigDirectory) {
        this.nginxConfigDirectory = nginxConfigDirectory;
    }

    public void setNginxReloadCommand(String nginxReloadCommand) {
        this.nginxReloadCommand = nginxReloadCommand;
    }

    public void setXslfoForList(String xslfoForList) {
        this.xslfoForList = xslfoForList;
    }

    public void setXslfoForObject(String xslfoForObject) {
        this.xslfoForObject = xslfoForObject;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppConfig)) {
            return false;
        }
        AppConfig other = (AppConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getId() == other.getId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }
}

