/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.model;

import com.google.common.base.Strings;
import io.mateu.mdd.core.model.authentication.Audit;
import io.mateu.mdd.core.model.authentication.USER_STATUS;
import io.mateu.mdd.core.model.authentication.User;
import io.mateu.mdd.core.model.common.Icon;
import io.mateu.mdd.core.model.common.Resource;
import io.mateu.mdd.core.model.config.AppConfig;
import io.mateu.mdd.core.model.multilanguage.Literal;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.interfaces.IResource;
import io.mateu.mdd.shared.interfaces.UserPrincipal;
import io.mateu.util.Helper;
import io.mateu.util.interfaces.AuditRecord;
import io.mateu.util.interfaces.GeneralRepository;
import io.mateu.util.interfaces.IIcon;
import io.mateu.util.interfaces.IPopulator;
import io.mateu.util.interfaces.Translated;
import io.mateu.util.mail.EmailHelper;
import io.mateu.util.notification.Notifier;
import io.mateu.util.persistence.JPAHelper;
import io.mateu.util.persistence.JPATransaction;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;

public class GeneralRepositoryImpl
implements GeneralRepository {
    public UserPrincipal findUser(String login) {
        try {
            User[] u = new User[]{null};
            JPAHelper.notransact((String)MDDUIAccessor.getApp().getPersistenceUnitName(), em -> {
                u[0] = (User)em.find(User.class, (Object)(login != null ? login : "system"));
            }, (boolean)false);
            return u[0];
        }
        catch (Throwable e) {
            try {
                User[] u = new User[]{null};
                JPAHelper.notransact((String)MDDUIAccessor.getApp().getPersistenceUnitName(), em -> {
                    u[0] = (User)em.find(User.class, (Object)"system");
                }, (boolean)false);
                return u[0];
            }
            catch (Throwable ee) {
                return null;
            }
        }
    }

    public IResource getNewResource() {
        return new Resource();
    }

    public Translated getNewTranslated() {
        return new Literal();
    }

    public UserPrincipal findUserByPasswordResetKey(String key) throws Throwable {
        User[] u = new User[1];
        JPAHelper.notransact((String)MDDUIAccessor.getApp().getPersistenceUnitName(), em -> {
            u[0] = this.findUserByPasswordResetKey(em, key);
        });
        return u[0];
    }

    public void setPassword(String key, String password) throws Throwable {
        JPAHelper.transact(em -> {
            User u = this.findUserByPasswordResetKey(em, key);
            u.setPassword(password);
            u.setPasswordResetKey(null);
            u.setPasswordResetExpiryDateTime(null);
            if (USER_STATUS.BLOCKED.equals((Object)u.getStatus())) {
                u.setStatus(USER_STATUS.ACTIVE);
            }
        });
    }

    public void createUser(final String login, final String email, final String name, final String avatarUrl) throws Throwable {
        JPAHelper.transact((JPATransaction)new JPATransaction(){

            public void run(EntityManager em) throws Throwable {
                User u = (User)em.find(User.class, (Object)login);
                if (u == null) {
                    u = new User();
                    u.setOauth(true);
                    u.setLogin(login);
                    u.setEmail(email != null ? email : "");
                    u.setName(name != null ? name : "");
                    if (!Strings.isNullOrEmpty((String)avatarUrl)) {
                        u.setAvatar(new Resource(new URL(avatarUrl)));
                    }
                    u.setStatus(USER_STATUS.ACTIVE);
                    em.persist((Object)u);
                }
                u.setLastLogin(LocalDateTime.now());
            }
        });
    }

    public void changePassword(String login, String currentPassword, String newPassword) throws Throwable {
        JPAHelper.transact(em -> {
            User u = (User)em.find(User.class, (Object)login);
            if (!u.checkPassword(currentPassword)) {
                throw new Exception("This is not your current password");
            }
            u.setPassword(newPassword);
        });
    }

    public void updateUser(final String login, final String name, final String email, final IResource photo) throws Throwable {
        JPAHelper.transact((JPATransaction)new JPATransaction(){

            public void run(EntityManager em) throws Throwable {
                User u = (User)em.find(User.class, (Object)login);
                u.setName(name);
                u.setEmail(email);
                u.setAvatar((Resource)photo);
            }
        });
    }

    public List<IIcon> findAllIcons() throws Throwable {
        List l = JPAHelper.findAll(Icon.class).stream().sorted((a, b) -> a.getId().compareTo(b.getId())).collect(Collectors.toList());
        return new ArrayList<IIcon>(l);
    }

    public UserPrincipal authenticate(final String login, final String password) throws Throwable {
        final UserPrincipal[] p = new UserPrincipal[1];
        JPAHelper.transact((JPATransaction)new JPATransaction(){

            public void run(EntityManager em) throws Throwable {
                User u;
                if (em.createQuery("select x.login from " + User.class.getName() + " x").getResultList().size() == 0) {
                    ((IPopulator)Helper.getImpl(IPopulator.class)).populate();
                }
                if ((u = (User)em.find(User.class, (Object)login.toLowerCase().trim())) != null) {
                    if (USER_STATUS.BLOCKED.equals((Object)u.getStatus())) {
                        throw new Exception("User " + login + " is blocked due to failed logins.");
                    }
                    if (USER_STATUS.EXPIRED.equals((Object)u.getStatus())) {
                        throw new Exception("User " + login + " has expired.");
                    }
                    if (USER_STATUS.INACTIVE.equals((Object)u.getStatus())) {
                        throw new Exception("User " + login + " is not active.");
                    }
                    if (u.getPassword() == null) {
                        throw new Exception("Missing password for user " + login);
                    }
                    if (!u.checkPassword(password)) {
                        u.setFailedLogins(u.getFailedLogins() + 1);
                        if (u.getFailedLogins() >= 10) {
                            u.setStatus(USER_STATUS.BLOCKED);
                        }
                        JPAHelper.transact(em2 -> em2.merge((Object)u));
                        try {
                            EmailHelper.sendEmail((String)u.getEmail(), (String)"Failed login attempt", (String)"Login failed due to wrong password", (boolean)false);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        if (USER_STATUS.BLOCKED.equals((Object)u.getStatus())) {
                            try {
                                EmailHelper.sendEmail((String)AppConfig.get(em).getAdminEmailUser(), (String)"User blocked due to failed login attempts", (String)("User " + u.getLogin() + " (" + u.getName() + ", " + u.getEmail() + ") was blocked after " + u.getFailedLogins() + " failed passwords."), (boolean)false);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                        throw new Exception("Wrong password. User will be blocked after " + (10 - u.getFailedLogins()) + " attempts");
                    }
                    if (USER_STATUS.INACTIVE.equals((Object)u.getStatus())) {
                        throw new Exception("Deactivated user");
                    }
                    if (u.getFailedLogins() > 0) {
                        u.setFailedLogins(0);
                    }
                    if (u.getLastLogin() != null) {
                        Notifier.info((String)("Last login: " + u.getLastLogin().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"))));
                    }
                } else {
                    throw new Exception("No user with login " + login);
                }
                u.setLastLogin(LocalDateTime.now());
                p[0] = u;
            }
        });
        return p[0];
    }

    public void recoverPassword(String login) throws Throwable {
        JPAHelper.transact(em -> ((User)em.find(User.class, (Object)login)).sendForgottenPasswordEmail(em));
    }

    public AuditRecord getNewAudit() throws Throwable {
        return new Audit((User)JPAHelper.find(User.class, (Object)MDDUIAccessor.getCurrentUserLogin()));
    }

    private User findUserByPasswordResetKey(EntityManager em, String key) throws Exception {
        List l = em.createQuery("select x from " + User.class.getName() + " x where x.passwordResetKey = :k").setParameter("k", (Object)key).getResultList();
        if (l.size() > 0) {
            User u = (User)l.get(0);
            if (USER_STATUS.EXPIRED.equals((Object)u.getStatus())) {
                throw new Exception("User expired. Can not reset password.");
            }
            if (u.getLastLogin() != null && (u.getPasswordResetExpiryDateTime() == null || u.getPasswordResetExpiryDateTime().isBefore(LocalDateTime.now()))) {
                throw new Exception("Password reset key expired. Remember it is only valid for 4 hours. Ask for password reset again");
            }
            return u;
        }
        throw new Exception("Password reset key not found. Perhaps it was already used. Ask for password reset again");
    }
}

