/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.model.multilanguage;

import com.vaadin.icons.VaadinIcons;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.util.data.Data;
import io.mateu.util.interfaces.Translated;
import io.mateu.util.notification.Notifier;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Version;

@Entity
public class Literal
implements Translated {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id = 0L;
    @Version
    int __version = 0;
    private String en;
    private String es;
    private String de;
    private String fr;
    private String it;
    private String ar;
    private String cz;
    private String ru;

    public Literal() {
    }

    public String toString() {
        return this.getEs();
    }

    public Literal(String en, String es) {
        this.en = en;
        this.es = es;
    }

    public Literal(String en, String es, String de, String fr, String it, String ar, String cz, String ru) {
        this.en = en;
        this.es = es;
        this.de = de;
        this.fr = fr;
        this.it = it;
        this.ar = ar;
        this.cz = cz;
        this.ru = ru;
    }

    public void set(Data value) {
        if (value != null) {
            this.setEs((String)value.get("es"));
            this.setEn((String)value.get("en"));
            this.setDe((String)value.get("de"));
            this.setFr((String)value.get("fr"));
            this.setIt((String)value.get("it"));
            this.setAr((String)value.get("ar"));
            this.setCz((String)value.get("cz"));
            this.setRu((String)value.get("ru"));
        } else {
            this.setEs(null);
            this.setEn(null);
            this.setDe(null);
            this.setFr(null);
            this.setIt(null);
            this.setAr(null);
            this.setCz(null);
            this.setRu(null);
        }
    }

    public Data get() {
        Data d = new Data();
        if (this.getEs() != null) {
            d.set("es", (Object)this.getEs());
        }
        if (this.getEn() != null) {
            d.set("en", (Object)this.getEn());
        }
        if (this.getDe() != null) {
            d.set("de", (Object)this.getDe());
        }
        if (this.getFr() != null) {
            d.set("fr", (Object)this.getFr());
        }
        if (this.getIt() != null) {
            d.set("it", (Object)this.getIt());
        }
        if (this.getAr() != null) {
            d.set("ar", (Object)this.getAr());
        }
        if (this.getCz() != null) {
            d.set("cz", (Object)this.getCz());
        }
        if (this.getRu() != null) {
            d.set("ru", (Object)this.getRu());
        }
        return d;
    }

    public String get(String language) {
        Data d = this.get();
        return d.containsKey((Object)language) ? d.getString(language) : d.getString("en");
    }

    public void set(String language, String text) {
        Data d = this.get();
        d.put((Object)language, (Object)text);
        this.set(d);
    }

    @Action(icon=VaadinIcons.CLOUD_UPLOAD)
    public static void translateWithDeepL(Set<Literal> selection) {
        Notifier.alert((String)"DeepL is not configured. Please contact your administrator.");
    }

    protected int get__version() {
        return this.__version;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getEn() {
        return this.en;
    }

    public String getEs() {
        return this.es;
    }

    public String getDe() {
        return this.de;
    }

    public String getFr() {
        return this.fr;
    }

    public String getIt() {
        return this.it;
    }

    public String getAr() {
        return this.ar;
    }

    public String getCz() {
        return this.cz;
    }

    public String getRu() {
        return this.ru;
    }

    public void setEn(String en) {
        this.en = en;
    }

    public void setEs(String es) {
        this.es = es;
    }

    public void setDe(String de) {
        this.de = de;
    }

    public void setFr(String fr) {
        this.fr = fr;
    }

    public void setIt(String it) {
        this.it = it;
    }

    public void setAr(String ar) {
        this.ar = ar;
    }

    public void setCz(String cz) {
        this.cz = cz;
    }

    public void setRu(String ru) {
        this.ru = ru;
    }

    public void set__version(int __version) {
        this.__version = __version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Literal)) {
            return false;
        }
        Literal other = (Literal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.id == 0L) {
            return false;
        }
        return Long.compare(this.id, other.id) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Literal;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

